#ifndef BNXT_HSI_H
#define BNXT_HSI_H

/* hwrm_cmd_hdr (size:128b/16B) */
struct hwrm_cmd_hdr {
	__le16	req_type;
	__le16	cmpl_ring;
	__le16	seq_id;
	__le16	target_id;
	__le64	resp_addr;
	__le64	dma_addr; /* DMA address in case of input/output */
};

/* hwrm_resp_hdr (size:64b/8B) */
struct hwrm_resp_hdr {
	__le16	error_code;
	__le16	req_type;
	__le16	seq_id;
	__le16	resp_len;
};

/* hwrm_short_input (size:128b/16B) */
struct hwrm_short_cmd {
	__le16	req_type;
	__le16	signature;
	#define SHORT_REQ_SIGNATURE_SHORT_CMD 0x4321UL
	#define SHORT_REQ_SIGNATURE_LAST     SHORT_REQ_SIGNATURE_SHORT_CMD
	__le16	target_id;
	#define SHORT_REQ_TARGET_ID_DEFAULT 0x0UL
	#define SHORT_REQ_TARGET_ID_TOOLS   0xfffdUL
	#define SHORT_REQ_TARGET_ID_LAST   SHORT_REQ_TARGET_ID_TOOLS
	__le16	size;
	__le64	req_addr;
};

#define HWRM_MAX_REQ_LEN        (128)
#define HWRM_MAX_RESP_LEN       (704)
#define HWRM_VER_GET            (0x0)
#define HWRM_FUNC_RESET         (0x11UL)
#define HWRM_FW_RESET           (0xc0UL)
#define HWRM_PORT_DSC_DUMP      (0xd9UL)
#define HWRM_NVM_INSTALL_UPDATE (0xfff3UL)
#define HWRM_NVM_DEFRAG         (0xffecUL)
#define HWRM_SELFTEST_RETRIEVE_SERDES_DATA (0x203UL)
#define HWRM_NVM_WRITE          (0xFFFEUL)

#define HWRM_TARGET_ID_BONO 0xFFF8
#define HWRM_TARGET_ID_KONG 0xFFF9
#define HWRM_TARGET_ID_APE 0xFFFA
#define HWRM_TARGET_ID_TOOLS 0xFFFD
enum bnxt_hwrm_chnl {
	BNXT_HWRM_CHNL_CHIMP,
	BNXT_HWRM_CHNL_KONG,
	BNXT_HRWM_CHNL_BONO
};

#define BNXT_GRCPF_REG_COMM0		0x0
#define BNXT_GRCPF_REG_COMM0_TRIGGER	(BNXT_GRCPF_REG_COMM0 + 0x100)
#define BNXT_GRCPF_REG_COMM1		0x200
#define BNXT_GRCPF_REG_COMM1_TRIGGER	(BNXT_GRCPF_REG_COMM1 + 0x100)
#define BNXT_GRCPF_REG_BASE_START	0x400
#define BNXT_GRCPF_REG_BASE_END		(BNXT_GRCPF_REG_BASE_START + 0x3b)
#define BNXT_GRCPF_REG_STATUS		0x500
#define BNXT_GRCPF_REG_END		(BNXT_GRCPF_REG_STATUS + 0x3f)
#define BNXT_GRCPF_REG_FW_HALT		0x576
#define BNXT_GRCPF_REG_COMM2		0x600
#define BNXT_GRCPF_REG_COMM2_TRIGGER	(BNXT_GRCPF_REG_COMM2 + 0x100)
#define BNXT_GRCPF_REG_COMM3		0x800
#define BNXT_GRCPF_REG_COMM3_TRIGGER	(BNXT_GRCPF_REG_COMM3 + 0x100)
#define BNXT_GRCPF_REG_COMM4		0xa00
#define BNXT_GRCPF_REG_COMM4_TRIGGER	(BNXT_GRCPF_REG_COMM4 + 0x100)
#define BNXT_GRCPF_REG_COMM5		0xc00
#define BNXT_GRCPF_REG_COMM5_TRIGGER	(BNXT_GRCPF_REG_COMM5 + 0x100)

#define BNXT_GRCPF_REG_CHIMP_COMM		BNXT_GRCPF_REG_COMM1
#define BNXT_GRCPF_REG_CHIMP_COMM_TRIGGER	BNXT_GRCPF_REG_COMM1_TRIGGER
#define BNXT_GRCPF_REG_BONO_COMM		BNXT_GRCPF_REG_COMM3
#define BNXT_GRCPF_REG_BONO_COMM_TRIGGER	BNXT_GRCPF_REG_COMM3_TRIGGER
#define BNXT_GRCPF_REG_KONG_COMM		BNXT_GRCPF_REG_COMM4
#define BNXT_GRCPF_REG_KONG_COMM_TRIGGER	BNXT_GRCPF_REG_COMM4_TRIGGER

#define DBG_DRV_GRC_WINDOW_NUM		8
#define DGB_DRV_GRC_WINDOW_OFF		0x8000
#define BNXT_GRCPF_REG_DBG_DRV_GRC_WIN	(BNXT_GRCPF_REG_BASE_START + \
					 (DBG_DRV_GRC_WINDOW_NUM - 1) * 4) /* 8th window */

#define BNXT_GRCPF_REG_WINDOW_BASE_OUT		0x400

/* fw_status_reg (size:32b/4B) */
struct fw_status_reg {
	u32	fw_status;
	#define FW_STATUS_REG_CODE_MASK              0xffffUL
	#define FW_STATUS_REG_CODE_SFT               0
	#define FW_STATUS_REG_CODE_READY               0x8000UL
	#define FW_STATUS_REG_CODE_LAST               FW_STATUS_REG_CODE_READY
	#define FW_STATUS_REG_IMAGE_DEGRADED         0x10000UL
	#define FW_STATUS_REG_RECOVERABLE            0x20000UL
	#define FW_STATUS_REG_CRASHDUMP_ONGOING      0x40000UL
	#define FW_STATUS_REG_CRASHDUMP_COMPLETE     0x80000UL
	#define FW_STATUS_REG_SHUTDOWN               0x100000UL
	#define FW_STATUS_REG_CRASHED_NO_MASTER      0x200000UL
	#define FW_STATUS_REG_RECOVERING             0x400000UL
};

/* hcomm_status (size:64b/8B) */
struct hcomm_status {
	u32	sig_ver;
	#define HCOMM_STATUS_VER_MASK      0xffUL
	#define HCOMM_STATUS_VER_SFT       0
	#define HCOMM_STATUS_VER_LATEST      0x1UL
	#define HCOMM_STATUS_VER_LAST       HCOMM_STATUS_VER_LATEST
	#define HCOMM_STATUS_SIGNATURE_MASK 0xffffff00UL
	#define HCOMM_STATUS_SIGNATURE_SFT 8
	#define HCOMM_STATUS_SIGNATURE_VAL   (0x484353UL << 8)
	#define HCOMM_STATUS_SIGNATURE_LAST HCOMM_STATUS_SIGNATURE_VAL
	u32	fw_status_loc;
	#define HCOMM_STATUS_TRUE_ADDR_SPACE_MASK    0x3UL
	#define HCOMM_STATUS_TRUE_ADDR_SPACE_SFT     0
	#define HCOMM_STATUS_FW_STATUS_LOC_ADDR_SPACE_PCIE_CFG  0x0UL
	#define HCOMM_STATUS_FW_STATUS_LOC_ADDR_SPACE_GRC       0x1UL
	#define HCOMM_STATUS_FW_STATUS_LOC_ADDR_SPACE_BAR0      0x2UL
	#define HCOMM_STATUS_FW_STATUS_LOC_ADDR_SPACE_BAR1      0x3UL
	#define HCOMM_STATUS_FW_STATUS_LOC_ADDR_SPACE_LAST     HCOMM_STATUS_FW_STATUS_LOC_ADDR_SPACE_BAR1
	#define HCOMM_STATUS_TRUE_OFFSET_MASK        0xfffffffcUL
	#define HCOMM_STATUS_TRUE_OFFSET_SFT         2
};
#define HCOMM_STATUS_STRUCT_LOC 0x31001F0UL

#define BNXT_FW_HEALTH_REG_TYPE_MASK	3
#define BNXT_FW_HEALTH_REG_TYPE_CFG	0
#define BNXT_FW_HEALTH_REG_TYPE_GRC	1
#define BNXT_FW_HEALTH_REG_TYPE_BAR0	2
#define BNXT_FW_HEALTH_REG_TYPE_BAR1	3

#define BNXT_FW_HEALTH_REG_TYPE(reg)	((reg) & BNXT_FW_HEALTH_REG_TYPE_MASK)
#define BNXT_FW_HEALTH_REG_OFF(reg)	((reg) & ~BNXT_FW_HEALTH_REG_TYPE_MASK)

#define BNXT_FW_HEALTH_WIN_BASE		0x3000
#define BNXT_FW_HEALTH_WIN_MAP_OFF	8

#define BNXT_FW_HEALTH_WIN_OFF(reg)	(BNXT_FW_HEALTH_WIN_BASE +	\
					 ((reg) & BNXT_GRC_OFFSET_MASK))

#define BNXT_FW_STATUS_HEALTH_MSK	0xffff
#define BNXT_FW_STATUS_HEALTHY		0x8000
#define BNXT_FW_STATUS_SHUTDOWN		0x100000
#define BNXT_FW_STATUS_RECOVERING	0x400000

#define BNXT_FW_IS_HEALTHY(sts)		(((sts) & BNXT_FW_STATUS_HEALTH_MSK) ==\
					 BNXT_FW_STATUS_HEALTHY)

#define BNXT_FW_IS_BOOTING(sts)		(((sts) & BNXT_FW_STATUS_HEALTH_MSK) < \
					 BNXT_FW_STATUS_HEALTHY)

#define BNXT_FW_IS_ERR(sts)		(((sts) & BNXT_FW_STATUS_HEALTH_MSK) > \
					 BNXT_FW_STATUS_HEALTHY)

#define BNXT_FW_IS_RECOVERING(sts)	(BNXT_FW_IS_ERR(sts) &&		       \
					 ((sts) & BNXT_FW_STATUS_RECOVERING))

#define BNXT_FW_RETRY			5
#define BNXT_FW_IF_RETRY		10

#define BNXT_GRC_REG_STATUS_P5			0x520

#define BNXT_CAG_REG_LEGACY_INT_STATUS		0x4014
#define BNXT_CAG_REG_BASE			0x300000

#define BNXT_GRC_REG_CHIP_NUM			0x48
#define BNXT_GRC_REG_BASE			0x260000

#define BNXT_GRC_BASE_MASK			0xfffff000
#define BNXT_GRC_OFFSET_MASK			0x00000ffc

#define BNXT_CHIP_TYPE_NITRO_A0(bp) ((bp)->flags & BNXT_FLAG_CHIP_NITRO_A0)
#define BNXT_SUPPORTS_TPA(bp)	(!BNXT_CHIP_TYPE_NITRO_A0(bp) &&	\
				 (!((bp)->flags & BNXT_FLAG_CHIP_P5) ||	\
				  (bp)->max_tpa_v2) && !is_kdump_kernel())

#define BNXT_CHIP_P5_THOR2(bp)			\
	((bp)->chip_num == CHIP_NUM_58818 ||	\
	 (bp)->chip_num == CHIP_NUM_57608)

#define BNXT_CHIP_P5_THOR(bp)			\
	((bp)->chip_num == CHIP_NUM_57508 ||	\
	 (bp)->chip_num == CHIP_NUM_57504 ||	\
	 (bp)->chip_num == CHIP_NUM_57502)

/* Chip class phase 5 */
#define BNXT_CHIP_P5(bp)			\
	(BNXT_CHIP_P5_THOR(bp) || BNXT_CHIP_P5_THOR2(bp))

/* Chip class phase 4.x */
#define BNXT_CHIP_P4(bp)			\
	(BNXT_CHIP_NUM_57X1X((bp)->chip_num) ||	\
	 BNXT_CHIP_NUM_5745X((bp)->chip_num) ||	\
	 BNXT_CHIP_NUM_588XX((bp)->chip_num) ||	\
	 (BNXT_CHIP_NUM_58700((bp)->chip_num) &&	\
	  !BNXT_CHIP_TYPE_NITRO_A0(bp)))

#define BNXT_CHIP_P4_PLUS(bp)			\
	(BNXT_CHIP_P4(bp) || BNXT_CHIP_P5(bp))

/* Chip class phase 3.x */
#define BNXT_CHIP_P3(bp)			\
	(BNXT_CHIP_NUM_57X0X((bp)->chip_num) ||	\
	 BNXT_CHIP_TYPE_NITRO_A0(bp))

#define BNXT_CHIP_THOR		BNXT_CHIP_P5_THOR
#define	BNXT_STINGRAY	BNXT_CHIP_P5
#endif
