// SPDX-License-Identifier: BSD-3-Clause
/* Copyright(c) 2014-2023 Broadcom
 * All rights reserved.
 */

#include "ulp_template_db_enum.h"
#include "ulp_template_db_field.h"
#include "ulp_template_struct.h"
#include "ulp_template_db_tbl.h"

/* Mapper templates for header class list */
struct bnxt_ulp_mapper_tmpl_info ulp_thor_class_tmpl_list[] = {
	/* class_tid: 1, ingress */
	[1] = {
	.device_name = BNXT_ULP_DEVICE_ID_THOR,
	.num_tbls = 41,
	.start_tbl_idx = 0,
	.reject_info = {
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 0,
		.cond_nums = 2 }
	},
	/* class_tid: 2, egress */
	[2] = {
	.device_name = BNXT_ULP_DEVICE_ID_THOR,
	.num_tbls = 27,
	.start_tbl_idx = 41,
	.reject_info = {
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 1578,
		.cond_nums = 2 }
	},
	/* class_tid: 3, ingress */
	[3] = {
	.device_name = BNXT_ULP_DEVICE_ID_THOR,
	.num_tbls = 23,
	.start_tbl_idx = 68,
	.reject_info = {
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_FALSE,
		.cond_start_idx = 3134,
		.cond_nums = 0 }
	},
	/* class_tid: 4, egress */
	[4] = {
	.device_name = BNXT_ULP_DEVICE_ID_THOR,
	.num_tbls = 35,
	.start_tbl_idx = 91,
	.reject_info = {
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_FALSE,
		.cond_start_idx = 3138,
		.cond_nums = 0 }
	}
};

struct bnxt_ulp_mapper_tbl_info ulp_thor_class_tbl_list[] = {
	{ /* class_tid: 1, , table: port_table.rd */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PORT_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.key_start_idx = 0,
	.blob_key_bit_size = 10,
	.key_bit_size = 10,
	.key_num_fields = 1,
	.ident_start_idx = 0,
	.ident_nums = 3
	},
	{ /* class_tid: 1, , table: l2_cntxt_tcam_cache.rd */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 1,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 3,
	.ident_nums = 3
	},
	{ /* class_tid: 1, , table: control.check_f1_f2_flow */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 6,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_OR,
		.cond_start_idx = 2,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: tunnel_cache.f1_f2_rd */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_TUNNEL_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 2,
	.blob_key_bit_size = 19,
	.key_bit_size = 19,
	.key_num_fields = 2,
	.ident_start_idx = 6,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: control.tunnel_cache_check */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 3,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 4,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 1, , table: l2_cntxt_tcam.f1_f2_alloc_l2_cntxt */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_HIGH,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 5,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_IDENT,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.ident_start_idx = 7,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: tunnel_cache.f1_f2_wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_TUNNEL_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 5,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 4,
	.blob_key_bit_size = 19,
	.key_bit_size = 19,
	.key_num_fields = 2,
	.result_start_idx = 0,
	.result_bit_size = 52,
	.result_num_fields = 3
	},
	{ /* class_tid: 1, , table: control.check_f2_flow */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 8,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 5,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: control.dmac_calculation */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 6,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COND_LIST,
		.func_oper_size = 48,
		.func_src1 = BNXT_ULP_FUNC_SRC_KEY_EXT_LIST,
		.func_opr1 = 0,
		.func_dst_opr = BNXT_ULP_RF_IDX_O_DMAC }
	},
	{ /* class_tid: 1, , table: mac_addr_cache.rd */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_MAC_ADDR_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 5,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 10,
		.cond_nums = 1 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 6,
	.blob_key_bit_size = 110,
	.key_bit_size = 110,
	.key_num_fields = 8,
	.ident_start_idx = 8,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: control.mac_addr_cache_miss */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 13,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 1, , table: l2_cntxt_tcam.allocate_l2_context */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_HIGH,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 14,
		.cond_nums = 2 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_IDENT,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.ident_start_idx = 9,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: l2_cntxt_tcam.ingress_entry */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_HIGH,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 16,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.key_start_idx = 14,
	.blob_key_bit_size = 213,
	.key_bit_size = 213,
	.key_num_fields = 21,
	.result_start_idx = 3,
	.result_bit_size = 43,
	.result_num_fields = 6,
	.ident_start_idx = 10,
	.ident_nums = 0
	},
	{ /* class_tid: 1, , table: mac_addr_cache.wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_MAC_ADDR_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 21,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 35,
	.blob_key_bit_size = 110,
	.key_bit_size = 110,
	.key_num_fields = 8,
	.result_start_idx = 9,
	.result_bit_size = 70,
	.result_num_fields = 5
	},
	{ /* class_tid: 1, , table: control.check_f1_flow */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 0,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 23,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: control.tunnel_ipv6_sip_check */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.true_message = "reject ipv6 tunnel flow with tunnel source ip",
	.execute_info = {
		.cond_true_goto  = 1023,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_LIST_OR,
		.cond_start_idx = 0,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: control.l2_only_check */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.true_message = "Reject due to missing Ethertype for L2 flows",
	.execute_info = {
		.cond_true_goto  = 1023,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_LIST_OR,
		.cond_start_idx = 1,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: control.terminating_flow */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 37,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COND_LIST,
		.func_oper_size = 8,
		.func_src1 = BNXT_ULP_FUNC_SRC_KEY_EXT_LIST,
		.func_opr1 = 3,
		.func_dst_opr = BNXT_ULP_RF_IDX_TERM_FLOW }
	},
	{ /* class_tid: 1, , table: proto_header_cache.rd */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROTO_HEADER,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 45,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 43,
	.blob_key_bit_size = 73,
	.key_bit_size = 73,
	.key_num_fields = 3,
	.ident_start_idx = 10,
	.ident_nums = 7
	},
	{ /* class_tid: 1, , table: control.proto_header_cache_miss */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 13,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 45,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: hdr_overlap_cache.overlap_check */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_HDR_OVERLAP,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 46,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.key_start_idx = 46,
	.blob_key_bit_size = 9,
	.key_bit_size = 9,
	.key_num_fields = 2,
	.partial_key_start_idx = 48,
	.partial_key_num_fields = 1,
	.partial_key_bit_size = 64,
	.ident_start_idx = 17,
	.ident_nums = 2
	},
	{ /* class_tid: 1, , table: control.overlap_miss */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 46,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 1, , table: profile_tcam.allocate_wc_profile */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 47,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_IDENT,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.ident_start_idx = 19,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: fkb_select.wc_gen_template */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_WC_FKB,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 47,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_WC_KEY_ID_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 14,
	.result_bit_size = 106,
	.result_num_fields = 106
	},
	{ /* class_tid: 1, , table: hdr_overlap_cache.overlap_wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_HDR_OVERLAP,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 263,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 49,
	.blob_key_bit_size = 9,
	.key_bit_size = 9,
	.key_num_fields = 2,
	.partial_key_start_idx = 51,
	.partial_key_num_fields = 1,
	.partial_key_bit_size = 64,
	.result_start_idx = 120,
	.result_bit_size = 48,
	.result_num_fields = 3
	},
	{ /* class_tid: 1, , table: control.proto_header_rid_alloc */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 263,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 1, , table: fkb_select.em_gen_template_alloc */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_EM_FKB,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 263,
		.cond_nums = 1 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_KEY_ID_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 123,
	.result_bit_size = 106,
	.result_num_fields = 106
	},
	{ /* class_tid: 1, , table: em_key_recipe.alloc_only */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_KEY_RECIPE_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_KEY_RECIPE_TABLE_EM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 264,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_KEY_RECIPE_TBL_OPC_ALLOC_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_RECIPE_ID,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 229,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 1, , table: control.profile_tcam_priority */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 264,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COND_LIST,
		.func_oper_size = 8,
		.func_src1 = BNXT_ULP_FUNC_SRC_KEY_EXT_LIST,
		.func_opr1 = 44,
		.func_dst_opr = BNXT_ULP_RF_IDX_PROF_TCAM_PRIORITY }
	},
	{ /* class_tid: 1, , table: profile_tcam.gen_template */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 280,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_REGFILE,
	.pri_operand  = BNXT_ULP_RF_IDX_PROF_TCAM_PRIORITY,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.key_start_idx = 52,
	.blob_key_bit_size = 94,
	.key_bit_size = 94,
	.key_num_fields = 43,
	.result_start_idx = 229,
	.result_bit_size = 33,
	.result_num_fields = 8,
	.ident_start_idx = 20,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: wm_key_recipe.0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_KEY_RECIPE_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_KEY_RECIPE_TABLE_WM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 535,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_KEY_RECIPE_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_WC_RECIPE_ID,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.key_start_idx = 95,
	.blob_key_bit_size = 0,
	.key_bit_size = 0,
	.key_num_fields = 35,
	.result_start_idx = 237,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 1, , table: proto_header_cache.wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROTO_HEADER,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 957,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 130,
	.blob_key_bit_size = 73,
	.key_bit_size = 73,
	.key_num_fields = 3,
	.result_start_idx = 237,
	.result_bit_size = 106,
	.result_num_fields = 8
	},
	{ /* class_tid: 1, , table: em_flow_conflict_cache.rd */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_EM_FLOW_CONFLICT,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 8,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 957,
		.cond_nums = 3 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 133,
	.blob_key_bit_size = 73,
	.key_bit_size = 73,
	.key_num_fields = 3,
	.ident_start_idx = 21,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: control.em_flow_conflict_cache_miss */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 960,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 1, , table: fkb_select.em_gen_template */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_EM_FKB,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 961,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_KEY_ID_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.result_start_idx = 245,
	.result_bit_size = 106,
	.result_num_fields = 106
	},
	{ /* class_tid: 1, , table: em_key_recipe.0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_KEY_RECIPE_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_KEY_RECIPE_TABLE_EM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1168,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_KEY_RECIPE_TBL_OPC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_RECIPE_ID,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.key_start_idx = 136,
	.blob_key_bit_size = 0,
	.key_bit_size = 0,
	.key_num_fields = 34,
	.result_start_idx = 351,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 1, , table: em_flow_conflict_cache.wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_EM_FLOW_CONFLICT,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 2,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1572,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 170,
	.blob_key_bit_size = 73,
	.key_bit_size = 73,
	.key_num_fields = 3,
	.result_start_idx = 351,
	.result_bit_size = 96,
	.result_num_fields = 2
	},
	{ /* class_tid: 1, , table: control.field_sig_validation */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 3,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 1572,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_EQ,
		.func_src1 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr1 = BNXT_ULP_RF_IDX_FLOW_SIG_ID,
		.func_src2 = BNXT_ULP_FUNC_SRC_COMP_FIELD,
		.func_opr2 = BNXT_ULP_CF_IDX_FLOW_SIG_ID,
		.func_dst_opr = BNXT_ULP_RF_IDX_CC }
	},
	{ /* class_tid: 1, , table: em.ingress_generic_template */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_EM_TABLE,
	.resource_type = TF_MEM_INTERNAL,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 2,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 1574,
		.cond_nums = 3 },
	.tbl_opcode = BNXT_ULP_EM_TBL_OPC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_INSERT_FAIL,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_DYN_KEY,
	.key_recipe_operand = BNXT_ULP_RF_IDX_EM_RECIPE_ID,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_YES,
	.result_start_idx = 353,
	.result_bit_size = 0,
	.result_num_fields = 6
	},
	{ /* class_tid: 1, , table: control.em_add_check */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 1577,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: wm.ingress_generic_template */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_WC_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 0,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1578,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_WC_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_DYN_KEY,
	.key_recipe_operand = BNXT_ULP_RF_IDX_WC_RECIPE_ID,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_APP_PRI,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_YES,
	.result_start_idx = 359,
	.result_bit_size = 38,
	.result_num_fields = 5
	},
	{ /* class_tid: 2, , table: l2_cntxt_tcam_cache.rd */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1580,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 173,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 22,
	.ident_nums = 2
	},
	{ /* class_tid: 2, , table: control.l2_only_check */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.true_message = "Reject due to missing Ethertype for L2 flows",
	.execute_info = {
		.cond_true_goto  = 1023,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_LIST_OR,
		.cond_start_idx = 3,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 2, , table: control.tunnel_ipv6_sip_check */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.true_message = "reject ipv6 tunnel flow with tunnel source ip or source mac",
	.execute_info = {
		.cond_true_goto  = 1023,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_LIST_OR,
		.cond_start_idx = 5,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 2, , table: control.terminating_flow */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1598,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COND_LIST,
		.func_oper_size = 8,
		.func_src1 = BNXT_ULP_FUNC_SRC_KEY_EXT_LIST,
		.func_opr1 = 318,
		.func_dst_opr = BNXT_ULP_RF_IDX_TERM_FLOW }
	},
	{ /* class_tid: 2, , table: proto_header_cache.rd */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROTO_HEADER,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1606,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 174,
	.blob_key_bit_size = 73,
	.key_bit_size = 73,
	.key_num_fields = 3,
	.ident_start_idx = 24,
	.ident_nums = 7
	},
	{ /* class_tid: 2, , table: control.proto_header_cache_miss */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 13,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 1606,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 2, , table: hdr_overlap_cache.overlap_check */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_HDR_OVERLAP,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1607,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.key_start_idx = 177,
	.blob_key_bit_size = 9,
	.key_bit_size = 9,
	.key_num_fields = 2,
	.partial_key_start_idx = 179,
	.partial_key_num_fields = 1,
	.partial_key_bit_size = 64,
	.ident_start_idx = 31,
	.ident_nums = 2
	},
	{ /* class_tid: 2, , table: control.overlap_miss */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 1607,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 2, , table: profile_tcam.allocate_wc_profile */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1608,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_IDENT,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.ident_start_idx = 33,
	.ident_nums = 1
	},
	{ /* class_tid: 2, , table: fkb_select.wc_gen_template */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_WC_FKB,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1608,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_WC_KEY_ID_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 364,
	.result_bit_size = 106,
	.result_num_fields = 106
	},
	{ /* class_tid: 2, , table: hdr_overlap_cache.overlap_wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_HDR_OVERLAP,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1826,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 180,
	.blob_key_bit_size = 9,
	.key_bit_size = 9,
	.key_num_fields = 2,
	.partial_key_start_idx = 182,
	.partial_key_num_fields = 1,
	.partial_key_bit_size = 64,
	.result_start_idx = 470,
	.result_bit_size = 48,
	.result_num_fields = 3
	},
	{ /* class_tid: 2, , table: control.proto_header_rid_alloc */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1826,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 2, , table: fkb_select.em_gen_template_alloc */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_EM_FKB,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 1826,
		.cond_nums = 1 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_KEY_ID_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 473,
	.result_bit_size = 106,
	.result_num_fields = 106
	},
	{ /* class_tid: 2, , table: em_key_recipe.alloc_only */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_KEY_RECIPE_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_KEY_RECIPE_TABLE_EM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1827,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_KEY_RECIPE_TBL_OPC_ALLOC_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_RECIPE_ID,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 579,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 2, , table: control.profile_tcam_priority */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1827,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COND_LIST,
		.func_oper_size = 8,
		.func_src1 = BNXT_ULP_FUNC_SRC_KEY_EXT_LIST,
		.func_opr1 = 360,
		.func_dst_opr = BNXT_ULP_RF_IDX_PROF_TCAM_PRIORITY }
	},
	{ /* class_tid: 2, , table: profile_tcam.gen_template */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1843,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_REGFILE,
	.pri_operand  = BNXT_ULP_RF_IDX_PROF_TCAM_PRIORITY,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.key_start_idx = 183,
	.blob_key_bit_size = 94,
	.key_bit_size = 94,
	.key_num_fields = 43,
	.result_start_idx = 579,
	.result_bit_size = 33,
	.result_num_fields = 8,
	.ident_start_idx = 34,
	.ident_nums = 1
	},
	{ /* class_tid: 2, , table: wm_key_recipe.0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_KEY_RECIPE_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_KEY_RECIPE_TABLE_WM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2096,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_KEY_RECIPE_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_WC_RECIPE_ID,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.key_start_idx = 226,
	.blob_key_bit_size = 0,
	.key_bit_size = 0,
	.key_num_fields = 35,
	.result_start_idx = 587,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 2, , table: proto_header_cache.wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROTO_HEADER,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2522,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 261,
	.blob_key_bit_size = 73,
	.key_bit_size = 73,
	.key_num_fields = 3,
	.result_start_idx = 587,
	.result_bit_size = 106,
	.result_num_fields = 8
	},
	{ /* class_tid: 2, , table: em_flow_conflict_cache.rd */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_EM_FLOW_CONFLICT,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 8,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2522,
		.cond_nums = 3 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 264,
	.blob_key_bit_size = 73,
	.key_bit_size = 73,
	.key_num_fields = 3,
	.ident_start_idx = 35,
	.ident_nums = 1
	},
	{ /* class_tid: 2, , table: control.em_flow_conflict_cache_miss */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2525,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 2, , table: fkb_select.em_gen_template */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_EM_FKB,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2526,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_KEY_ID_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.result_start_idx = 595,
	.result_bit_size = 106,
	.result_num_fields = 106
	},
	{ /* class_tid: 2, , table: em_key_recipe.0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_KEY_RECIPE_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_KEY_RECIPE_TABLE_EM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2730,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_KEY_RECIPE_TBL_OPC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_RECIPE_ID,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.key_start_idx = 267,
	.blob_key_bit_size = 0,
	.key_bit_size = 0,
	.key_num_fields = 34,
	.result_start_idx = 701,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 2, , table: em_flow_conflict_cache.wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_EM_FLOW_CONFLICT,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 2,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3128,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 301,
	.blob_key_bit_size = 73,
	.key_bit_size = 73,
	.key_num_fields = 3,
	.result_start_idx = 701,
	.result_bit_size = 96,
	.result_num_fields = 2
	},
	{ /* class_tid: 2, , table: control.field_sig_validation */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 3,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3128,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_EQ,
		.func_src1 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr1 = BNXT_ULP_RF_IDX_FLOW_SIG_ID,
		.func_src2 = BNXT_ULP_FUNC_SRC_COMP_FIELD,
		.func_opr2 = BNXT_ULP_CF_IDX_FLOW_SIG_ID,
		.func_dst_opr = BNXT_ULP_RF_IDX_CC }
	},
	{ /* class_tid: 2, , table: em.egress_generic_template */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_EM_TABLE,
	.resource_type = TF_MEM_INTERNAL,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 2,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3130,
		.cond_nums = 3 },
	.tbl_opcode = BNXT_ULP_EM_TBL_OPC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_INSERT_FAIL,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_DYN_KEY,
	.key_recipe_operand = BNXT_ULP_RF_IDX_EM_RECIPE_ID,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_YES,
	.result_start_idx = 703,
	.result_bit_size = 0,
	.result_num_fields = 6
	},
	{ /* class_tid: 2, , table: control.em_add_check */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3133,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 2, , table: wm.egress_generic_template */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_WC_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 0,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3134,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_WC_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_DYN_KEY,
	.key_recipe_operand = BNXT_ULP_RF_IDX_WC_RECIPE_ID,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_APP_PRI,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_YES,
	.result_start_idx = 709,
	.result_bit_size = 38,
	.result_num_fields = 5
	},
	{ /* class_tid: 3, , table: int_full_act_record.0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_FULL_ACT_RECORD,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_NORMAL,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3134,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_DEFAULT_AREC_PTR,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.result_start_idx = 714,
	.result_bit_size = 128,
	.result_num_fields = 17
	},
	{ /* class_tid: 3, , table: port_table.ing_wr_0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PORT_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3134,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 304,
	.blob_key_bit_size = 10,
	.key_bit_size = 10,
	.key_num_fields = 1,
	.result_start_idx = 731,
	.result_bit_size = 179,
	.result_num_fields = 8
	},
	{ /* class_tid: 3, , table: l2_cntxt_tcam_cache.ing_rd */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3134,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 305,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 36,
	.ident_nums = 0
	},
	{ /* class_tid: 3, , table: control.ing_0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3134,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 3, , table: l2_cntxt_tcam.ing_0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_LOW,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3135,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.key_start_idx = 306,
	.blob_key_bit_size = 213,
	.key_bit_size = 213,
	.key_num_fields = 21,
	.result_start_idx = 739,
	.result_bit_size = 43,
	.result_num_fields = 6,
	.ident_start_idx = 36,
	.ident_nums = 2
	},
	{ /* class_tid: 3, , table: l2_cntxt_tcam_cache.ing_wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3135,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 327,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.result_start_idx = 745,
	.result_bit_size = 70,
	.result_num_fields = 5
	},
	{ /* class_tid: 3, , table: profile_tcam.prof_func_catch_all */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3135,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 5,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.key_start_idx = 328,
	.blob_key_bit_size = 94,
	.key_bit_size = 94,
	.key_num_fields = 43,
	.result_start_idx = 750,
	.result_bit_size = 33,
	.result_num_fields = 8,
	.ident_start_idx = 38,
	.ident_nums = 0
	},
	{ /* class_tid: 3, , table: parif_def_arec_ptr.ing_0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_IF_TABLE,
	.resource_type = TF_IF_TBL_TYPE_PROF_PARIF_DFLT_ACT_REC_PTR,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3135,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_IF_TBL_OPC_WR_COMP_FIELD,
	.tbl_operand = BNXT_ULP_CF_IDX_PHY_PORT_PARIF,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.result_start_idx = 758,
	.result_bit_size = 32,
	.result_num_fields = 1
	},
	{ /* class_tid: 3, , table: parif_def_err_arec_ptr.ing_0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_IF_TABLE,
	.resource_type = TF_IF_TBL_TYPE_PROF_PARIF_ERR_ACT_REC_PTR,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3135,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_IF_TBL_OPC_WR_COMP_FIELD,
	.tbl_operand = BNXT_ULP_CF_IDX_PHY_PORT_PARIF,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.result_start_idx = 759,
	.result_bit_size = 32,
	.result_num_fields = 1
	},
	{ /* class_tid: 3, , table: int_full_act_record.egr_0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_FULL_ACT_RECORD,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_VFR_CFA_ACTION,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3135,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_MAIN_ACTION_PTR,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.result_start_idx = 760,
	.result_bit_size = 128,
	.result_num_fields = 17,
	.encap_num_fields = 0
	},
	{ /* class_tid: 3, , table: port_table.egr_wr_0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PORT_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3135,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 371,
	.blob_key_bit_size = 10,
	.key_bit_size = 10,
	.key_num_fields = 1,
	.result_start_idx = 777,
	.result_bit_size = 179,
	.result_num_fields = 8
	},
	{ /* class_tid: 3, , table: control.egr_0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 6,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3135,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 3, , table: l2_cntxt_tcam_cache.egr_rd_vfr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3136,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 372,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 38,
	.ident_nums = 0
	},
	{ /* class_tid: 3, , table: control.egr_1 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3136,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 3, , table: l2_cntxt_tcam.drv_func_prof_func_alloc */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_HIGH,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3137,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_IDENT,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.ident_start_idx = 38,
	.ident_nums = 1
	},
	{ /* class_tid: 3, , table: ilt_tbl.egr_vfr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_IF_TABLE,
	.resource_type = TF_IF_TBL_TYPE_ILT,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3137,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_IF_TBL_OPC_WR_COMP_FIELD,
	.tbl_operand = BNXT_ULP_CF_IDX_DRV_FUNC_SVIF,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 785,
	.result_bit_size = 64,
	.result_num_fields = 8
	},
	{ /* class_tid: 3, , table: l2_cntxt_tcam_cache.egr_wr_vfr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 0,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3137,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 373,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.result_start_idx = 793,
	.result_bit_size = 70,
	.result_num_fields = 5
	},
	{ /* class_tid: 3, , table: l2_cntxt_tcam_cache.egr_rd */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3137,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 374,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 39,
	.ident_nums = 0
	},
	{ /* class_tid: 3, , table: control.egr_2 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 3,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3137,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 3, , table: l2_cntxt_tcam.egr_0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_LOW,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3138,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.key_start_idx = 375,
	.blob_key_bit_size = 213,
	.key_bit_size = 213,
	.key_num_fields = 21,
	.result_start_idx = 798,
	.result_bit_size = 43,
	.result_num_fields = 6,
	.ident_start_idx = 39,
	.ident_nums = 2
	},
	{ /* class_tid: 3, , table: l2_cntxt_tcam_cache.egr_wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3138,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 396,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.result_start_idx = 804,
	.result_bit_size = 70,
	.result_num_fields = 5
	},
	{ /* class_tid: 3, , table: parif_def_arec_ptr.egr_0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_IF_TABLE,
	.resource_type = TF_IF_TBL_TYPE_PROF_PARIF_DFLT_ACT_REC_PTR,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3138,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_IF_TBL_OPC_WR_COMP_FIELD,
	.tbl_operand = BNXT_ULP_CF_IDX_DRV_FUNC_PARIF,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.result_start_idx = 809,
	.result_bit_size = 32,
	.result_num_fields = 1
	},
	{ /* class_tid: 3, , table: parif_def_err_arec_ptr.egr_0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_IF_TABLE,
	.resource_type = TF_IF_TBL_TYPE_PROF_PARIF_ERR_ACT_REC_PTR,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 0,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3138,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_IF_TBL_OPC_WR_COMP_FIELD,
	.tbl_operand = BNXT_ULP_CF_IDX_DRV_FUNC_PARIF,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.result_start_idx = 810,
	.result_bit_size = 32,
	.result_num_fields = 1
	},
	{ /* class_tid: 4, , table: profile_tcam_cache.vfr_glb_act_rec_rd */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROFILE_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3138,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 397,
	.blob_key_bit_size = 14,
	.key_bit_size = 14,
	.key_num_fields = 3,
	.ident_start_idx = 41,
	.ident_nums = 0
	},
	{ /* class_tid: 4, , table: control.prof_tcam_cache.vfr_glb_act_rec_rd.0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 6,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3138,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 4, , table: mod_record.vf_2_vfr_egr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_ACT_MODIFY_64B,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_NORMAL,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3139,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_WR_GLB_REGFILE,
	.tbl_operand = BNXT_ULP_GLB_RF_IDX_GLB_MODIFY_PTR,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.result_start_idx = 811,
	.result_bit_size = 0,
	.result_num_fields = 0,
	.encap_num_fields = 20
	},
	{ /* class_tid: 4, , table: int_full_act_record.vf_2_vfr_loopback */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_FULL_ACT_RECORD,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_NORMAL,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3139,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_WR_GLB_REGFILE,
	.tbl_operand = BNXT_ULP_GLB_RF_IDX_GLB_LB_AREC_PTR,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.result_start_idx = 831,
	.result_bit_size = 128,
	.result_num_fields = 17,
	.encap_num_fields = 0
	},
	{ /* class_tid: 4, , table: parif_def_arec_ptr.vf_egr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_IF_TABLE,
	.resource_type = TF_IF_TBL_TYPE_PROF_PARIF_DFLT_ACT_REC_PTR,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3139,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_IF_TBL_OPC_WR_CONST,
	.tbl_operand = ULP_THOR_SYM_LOOPBACK_PARIF,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 848,
	.result_bit_size = 32,
	.result_num_fields = 1
	},
	{ /* class_tid: 4, , table: parif_def_err_arec_ptr.vf_egr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_IF_TABLE,
	.resource_type = TF_IF_TBL_TYPE_PROF_PARIF_ERR_ACT_REC_PTR,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3139,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_IF_TBL_OPC_WR_CONST,
	.tbl_operand = ULP_THOR_SYM_LOOPBACK_PARIF,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 849,
	.result_bit_size = 32,
	.result_num_fields = 1
	},
	{ /* class_tid: 4, , table: profile_tcam_cache.vfr_glb_act_rec_wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROFILE_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3139,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 400,
	.blob_key_bit_size = 14,
	.key_bit_size = 14,
	.key_num_fields = 3,
	.result_start_idx = 850,
	.result_bit_size = 138,
	.result_num_fields = 7
	},
	{ /* class_tid: 4, , table: l2_cntxt_tcam_cache.vf_rd_egr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3139,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 403,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 41,
	.ident_nums = 0
	},
	{ /* class_tid: 4, , table: control.vf_2_vfr.0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 5,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3139,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 4, , table: l2_cntxt_tcam_cache.get_drv_func_prof_func */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3140,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.key_start_idx = 404,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 41,
	.ident_nums = 1
	},
	{ /* class_tid: 4, , table: l2_cntxt_tcam.vf_egr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_LOW,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3140,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.key_start_idx = 405,
	.blob_key_bit_size = 213,
	.key_bit_size = 213,
	.key_num_fields = 21,
	.result_start_idx = 857,
	.result_bit_size = 43,
	.result_num_fields = 6,
	.ident_start_idx = 42,
	.ident_nums = 1
	},
	{ /* class_tid: 4, , table: profile_tcam.prof_func_catch_all */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3140,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 5,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.key_start_idx = 426,
	.blob_key_bit_size = 94,
	.key_bit_size = 94,
	.key_num_fields = 43,
	.result_start_idx = 863,
	.result_bit_size = 33,
	.result_num_fields = 8,
	.ident_start_idx = 43,
	.ident_nums = 0
	},
	{ /* class_tid: 4, , table: l2_cntxt_tcam_cache.vf_egr_wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3140,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 469,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.result_start_idx = 871,
	.result_bit_size = 70,
	.result_num_fields = 5
	},
	{ /* class_tid: 4, , table: int_full_act_record.vf_2_vfr_ing */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_FULL_ACT_RECORD,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_NORMAL,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3140,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_MAIN_ACTION_PTR,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_PUSH_AND_SET_VFR_FLAG,
	.result_start_idx = 876,
	.result_bit_size = 128,
	.result_num_fields = 17
	},
	{ /* class_tid: 4, , table: profile_tcam_cache.vfr_rd */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROFILE_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3140,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 470,
	.blob_key_bit_size = 14,
	.key_bit_size = 14,
	.key_num_fields = 3,
	.ident_start_idx = 43,
	.ident_nums = 0
	},
	{ /* class_tid: 4, , table: control.prof_tcam_cache.vfr.0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 10,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3140,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 4, , table: int_full_act_record.drop_action */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_FULL_ACT_RECORD,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_NORMAL,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3141,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_WR_GLB_REGFILE,
	.tbl_operand = BNXT_ULP_GLB_RF_IDX_GLB_DROP_AREC_PTR,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.result_start_idx = 893,
	.result_bit_size = 128,
	.result_num_fields = 17,
	.encap_num_fields = 0
	},
	{ /* class_tid: 4, , table: l2_cntxt_tcam.vf_2_vfr_ing.0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_HIGH,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3141,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.key_start_idx = 473,
	.blob_key_bit_size = 213,
	.key_bit_size = 213,
	.key_num_fields = 21,
	.result_start_idx = 910,
	.result_bit_size = 43,
	.result_num_fields = 6,
	.ident_start_idx = 43,
	.ident_nums = 0
	},
	{ /* class_tid: 4, , table: l2_cntxt_tcam.vfr_2_vf_ing.0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_HIGH,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3141,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.key_start_idx = 494,
	.blob_key_bit_size = 213,
	.key_bit_size = 213,
	.key_num_fields = 21,
	.result_start_idx = 916,
	.result_bit_size = 43,
	.result_num_fields = 6,
	.ident_start_idx = 43,
	.ident_nums = 0
	},
	{ /* class_tid: 4, , table: fkb_select.vfr_em */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_EM_FKB,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3141,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_WR_GLB_REGFILE,
	.tbl_operand = BNXT_ULP_GLB_RF_IDX_GLB_VFR_EM_KEY_ID_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.result_start_idx = 922,
	.result_bit_size = 106,
	.result_num_fields = 106
	},
	{ /* class_tid: 4, , table: fkb_select.vf_em */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_EM_FKB,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3141,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_WR_GLB_REGFILE,
	.tbl_operand = BNXT_ULP_GLB_RF_IDX_GLB_VFR_EM_KEY_ID_1,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.result_start_idx = 1028,
	.result_bit_size = 106,
	.result_num_fields = 106
	},
	{ /* class_tid: 4, , table: profile_tcam.vf_2_vfr.0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3141,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.key_start_idx = 515,
	.blob_key_bit_size = 94,
	.key_bit_size = 94,
	.key_num_fields = 43,
	.result_start_idx = 1134,
	.result_bit_size = 33,
	.result_num_fields = 8
	},
	{ /* class_tid: 4, , table: profile_tcam.vfr_2_vf.0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3141,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.key_start_idx = 558,
	.blob_key_bit_size = 94,
	.key_bit_size = 94,
	.key_num_fields = 43,
	.result_start_idx = 1142,
	.result_bit_size = 33,
	.result_num_fields = 8
	},
	{ /* class_tid: 4, , table: profile_tcam_cache.vfr_wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROFILE_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3141,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 601,
	.blob_key_bit_size = 14,
	.key_bit_size = 14,
	.key_num_fields = 3,
	.result_start_idx = 1150,
	.result_bit_size = 138,
	.result_num_fields = 7
	},
	{ /* class_tid: 4, , table: ilt_tbl.vfr_ing */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_IF_TABLE,
	.resource_type = TF_IF_TBL_TYPE_ILT,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3141,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_IF_TBL_OPC_WR_COMP_FIELD,
	.tbl_operand = BNXT_ULP_CF_IDX_VF_FUNC_SVIF,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.result_start_idx = 1157,
	.result_bit_size = 64,
	.result_num_fields = 8
	},
	{ /* class_tid: 4, , table: em.vf_2_vfr.0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_EM_TABLE,
	.resource_type = TF_MEM_INTERNAL,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3141,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.key_start_idx = 604,
	.blob_key_bit_size = 0,
	.key_bit_size = 0,
	.key_num_fields = 3,
	.result_start_idx = 1165,
	.result_bit_size = 0,
	.result_num_fields = 6
	},
	{ /* class_tid: 4, , table: l2_cntxt_tcam_cache.rd_egr0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_LOW,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3141,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 607,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 43,
	.ident_nums = 0
	},
	{ /* class_tid: 4, , table: control.0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3141,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 4, , table: ilt_tbl.vfr_egr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_IF_TABLE,
	.resource_type = TF_IF_TBL_TYPE_ILT,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3142,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_IF_TBL_OPC_WR_COMP_FIELD,
	.tbl_operand = BNXT_ULP_CF_IDX_DRV_FUNC_SVIF,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 1171,
	.result_bit_size = 64,
	.result_num_fields = 8
	},
	{ /* class_tid: 4, , table: l2_cntxt_tcam_cache.vfr_wr_egr0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3142,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 608,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.result_start_idx = 1179,
	.result_bit_size = 70,
	.result_num_fields = 5
	},
	{ /* class_tid: 4, , table: ilt_tbl.vf_egr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_IF_TABLE,
	.resource_type = TF_IF_TBL_TYPE_ILT,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3142,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_IF_TBL_OPC_WR_COMP_FIELD,
	.tbl_operand = BNXT_ULP_CF_IDX_VF_FUNC_SVIF,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.result_start_idx = 1184,
	.result_bit_size = 64,
	.result_num_fields = 8
	},
	{ /* class_tid: 4, , table: mod_record.vfr_2_vf_egr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_ACT_MODIFY_64B,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_NORMAL,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3142,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_MODIFY_PTR,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.result_start_idx = 1192,
	.result_bit_size = 0,
	.result_num_fields = 0,
	.encap_num_fields = 20
	},
	{ /* class_tid: 4, , table: int_full_act_record.vfr_egr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_FULL_ACT_RECORD,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_VFR_CFA_ACTION,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3142,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_MAIN_ACTION_PTR,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.result_start_idx = 1212,
	.result_bit_size = 128,
	.result_num_fields = 17
	},
	{ /* class_tid: 4, , table: int_full_act_record.vfr_2_vf.ing0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = TF_TBL_TYPE_FULL_ACT_RECORD,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_NORMAL,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3142,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_MAIN_ACTION_PTR,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.result_start_idx = 1229,
	.result_bit_size = 128,
	.result_num_fields = 17
	},
	{ /* class_tid: 4, , table: em.vfr_2_vf.0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_EM_TABLE,
	.resource_type = TF_MEM_INTERNAL,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 0,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3142,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_YES,
	.key_start_idx = 609,
	.blob_key_bit_size = 0,
	.key_bit_size = 0,
	.key_num_fields = 2,
	.result_start_idx = 1246,
	.result_bit_size = 0,
	.result_num_fields = 6
	}
};

struct bnxt_ulp_mapper_cond_list_info ulp_thor_class_cond_oper_list[] = {
	/* cond_execute: class_tid: 1, control.tunnel_ipv6_sip_check:24*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 24,
		.cond_nums = 3
	},
	/* cond_execute: class_tid: 1, control.l2_only_check:27*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 27,
		.cond_nums = 5
	},
	/* cond_execute: class_tid: 1, control.l2_only_check:27*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 32,
		.cond_nums = 5
	},
	/* cond_execute: class_tid: 2, control.l2_only_check:1580*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 1580,
		.cond_nums = 5
	},
	/* cond_execute: class_tid: 2, control.l2_only_check:1580*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 1585,
		.cond_nums = 5
	},
	/* cond_execute: class_tid: 2, control.tunnel_ipv6_sip_check:1590*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 1590,
		.cond_nums = 4
	},
	/* cond_execute: class_tid: 2, control.tunnel_ipv6_sip_check:1590*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 1594,
		.cond_nums = 4
	}
};

struct bnxt_ulp_mapper_cond_info ulp_thor_class_cond_list[] = {
	/* cond_reject: thor, class_tid: 1 */
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS
	},
	/* cond_execute: class_tid: 1, control.check_f1_f2_flow:2*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F1
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F2
	},
	/* cond_execute: class_tid: 1, control.tunnel_cache_check:4*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 1, control.check_f2_flow:5*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F2
	},
	/* field_cond: class_tid: 1, control.dmac_calculation:6*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, control.dmac_calculation:8*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_PORT_DMAC
	},
	/* field_cond: class_tid: 1, control.dmac_calculation:9*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_PARENT_DMAC
	},
	/* cond_execute: class_tid: 1, mac_addr_cache.rd:10*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_O_DMAC
	},
	/* field_cond: class_tid: 1, mac_addr_cache.rd:11*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, mac_addr_cache.rd:12*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	/* cond_execute: class_tid: 1, control.mac_addr_cache_miss:13*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 1, l2_cntxt_tcam.allocate_l2_context:14*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F1
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F2
	},
	/* field_cond: class_tid: 1, l2_cntxt_tcam.ingress_entry:16*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, l2_cntxt_tcam.ingress_entry:17*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	/* field_cond: class_tid: 1, l2_cntxt_tcam.ingress_entry:18*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	/* field_cond: class_tid: 1, l2_cntxt_tcam.ingress_entry:19*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, l2_cntxt_tcam.ingress_entry:20*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, mac_addr_cache.wr:21*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, mac_addr_cache.wr:22*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	/* cond_execute: class_tid: 1, control.check_f1_flow:23*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F1
	},
	/* cond_execute: class_tid: 1, control.tunnel_ipv6_sip_check:24*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* cond_execute: class_tid: 1, control.l2_only_check:27*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* cond_execute: class_tid: 1, control.l2_only_check:27*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 1, control.terminating_flow:37*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, control.terminating_flow:39*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, control.terminating_flow:41*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, control.terminating_flow:43*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* cond_execute: class_tid: 1, control.proto_header_cache_miss:45*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 1, control.overlap_miss:46*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:47*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_NOT_SET,
	.cond_operand = BNXT_ULP_CF_IDX_CHAIN_ID_METADATA
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:49*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_CHAIN_ID_METADATA
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:50*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_CHAIN_ID_METADATA
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:51*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:52*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:55*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:58*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:62*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:66*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:70*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:74*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:77*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:80*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:83*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:86*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:89*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:92*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:95*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:98*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:101*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:104*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:107*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:110*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:113*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:116*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:118*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:120*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:123*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:126*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:129*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:132*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:136*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:140*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:144*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:148*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:152*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:156*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:160*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:164*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:168*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:172*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:176*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:180*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:184*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:188*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:192*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:196*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:200*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:204*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:208*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:212*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:216*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:220*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:224*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:228*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:232*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:236*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:240*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:244*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:245*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ICMP
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:248*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ICMP
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:251*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:252*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ICMP
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:255*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ICMP
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:258*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:259*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_TCP_FLAGS
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:261*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS
	},
	/* cond_execute: class_tid: 1, fkb_select.em_gen_template_alloc:263*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_TERM_FLOW
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:264*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:266*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:268*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:270*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:272*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:274*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:276*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:278*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:280*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:282*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:284*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:286*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:288*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:290*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:292*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:294*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:296*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:298*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:300*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:302*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:304*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:306*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:308*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:310*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:312*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:314*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:316*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:318*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:320*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:322*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:324*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:326*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:328*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:330*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:332*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:334*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:336*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:338*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:340*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:342*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:344*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_CHAIN_ID_METADATA
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:345*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:347*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:349*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:351*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:353*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_CHAIN_ID_METADATA
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:354*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:356*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:358*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:360*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:362*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:364*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:366*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:368*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:370*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:372*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:374*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:376*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:378*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:380*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:382*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:384*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:386*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:388*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:390*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:392*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:394*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:396*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:398*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:400*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:402*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:404*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:406*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:408*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:410*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:413*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:416*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:419*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:422*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:423*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:424*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:426*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:428*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:430*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:432*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_CHAIN_ID_METADATA
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:433*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:435*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:437*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:439*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:441*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GENEVE
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:443*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GRE
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:445*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR1
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:447*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR2
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:449*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:451*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:453*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GENEVE
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:455*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GRE
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:457*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR1
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:459*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR2
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:461*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:462*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:463*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:464*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:466*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:468*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:470*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:472*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:474*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:476*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:478*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:480*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:482*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:484*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:486*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:488*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:490*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:492*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:493*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:495*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:497*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:498*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:500*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:502*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:504*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:506*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:508*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:510*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:512*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:514*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:516*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:518*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:520*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:522*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:525*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:528*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:529*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:530*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:532*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F2
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:534*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_CHAIN_ID_METADATA
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:535*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_NOT_SET,
	.cond_operand = BNXT_ULP_CF_IDX_CHAIN_ID_METADATA
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:537*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_NOT_SET,
	.cond_operand = BNXT_ULP_CF_IDX_CHAIN_ID_METADATA
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:539*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_CHAIN_ID_METADATA
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:540*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_CHAIN_ID_METADATA
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:541*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_CHAIN_ID_METADATA
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:542*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_CHAIN_ID_METADATA
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:543*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:544*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:545*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:548*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:551*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:554*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:557*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:561*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:565*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:569*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:573*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:577*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:581*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:585*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:589*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:592*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:595*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:598*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:601*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:604*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:607*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:610*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:613*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:616*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:619*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:622*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:625*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:628*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:631*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:634*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:637*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:640*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:643*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:646*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:649*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:652*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:655*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:658*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:661*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:664*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:667*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:670*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:673*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:675*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:677*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:679*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:681*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:684*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:687*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:690*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:693*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:696*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:699*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:702*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:705*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:709*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:713*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:717*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:721*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:725*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:729*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:733*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:737*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:741*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:745*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:749*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:753*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:757*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:761*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:765*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:769*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:772*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:775*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:778*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:781*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:784*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:787*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:790*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:793*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:796*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:799*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:802*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:805*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:808*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:811*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:814*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:817*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:820*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:823*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:826*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:829*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:832*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:835*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:838*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:841*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:843*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:845*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:847*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:849*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:852*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:855*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:858*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:861*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:863*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:865*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:867*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:869*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:872*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:875*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:878*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:881*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:884*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:887*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:890*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:893*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:896*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:899*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:902*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:905*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:908*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:911*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:914*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:917*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:918*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:921*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:924*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:927*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:930*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:931*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:934*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:937*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:940*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:943*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:944*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:947*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:950*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:953*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:956*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* cond_execute: class_tid: 1, em_flow_conflict_cache.rd:957*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_NOT_SET,
	.cond_operand = BNXT_ULP_CF_IDX_WC_MATCH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_TERM_FLOW
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_EM_FOR_TC
	},
	/* cond_execute: class_tid: 1, control.em_flow_conflict_cache_miss:960*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:961*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:962*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:963*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:964*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:968*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:971*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:975*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:979*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:983*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:987*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:990*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:993*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:996*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:999*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1002*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1005*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1008*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1011*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1014*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1017*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1020*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1023*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1026*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1029*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1031*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1033*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1037*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1041*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1044*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1047*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1051*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1055*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1059*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1063*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1067*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1071*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1075*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1079*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1082*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1085*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1088*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1091*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1094*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1097*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1100*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1103*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1106*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1109*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1112*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1115*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1118*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1121*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1124*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1127*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1130*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1133*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1136*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1139*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1142*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1145*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1148*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1151*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1154*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1157*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1160*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1163*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1164*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_TCP_FLAGS
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1166*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1168*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1169*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1170*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1171*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1172*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1173*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1174*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1178*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1182*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1185*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1188*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1192*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1196*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1200*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1204*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1208*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1212*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1216*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1220*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1223*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1226*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1229*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1232*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1235*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1238*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1241*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1244*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1247*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1250*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1253*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1256*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1259*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1262*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1265*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1268*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1271*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1274*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1277*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1280*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1283*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1286*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1289*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1292*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1295*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1298*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1301*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1304*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1306*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1308*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1310*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1312*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1316*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1320*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1324*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1328*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1331*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1334*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1337*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1340*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1344*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1348*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1352*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1356*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1360*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1364*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1368*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1372*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1376*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1380*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1384*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1388*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1392*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1396*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1400*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1404*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1407*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1410*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1413*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1416*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1419*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1422*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1425*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1428*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1431*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1434*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1437*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1440*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1443*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1446*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1449*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1452*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1455*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1458*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1461*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1464*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1467*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1470*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1473*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1476*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1479*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1482*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1485*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1488*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1491*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1494*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1497*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1500*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1503*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1506*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1509*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1512*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1515*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1518*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1521*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1524*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1527*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1530*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1533*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1536*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1539*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1542*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1545*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1548*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1551*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1554*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1557*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1560*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1563*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1566*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1569*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* cond_execute: class_tid: 1, control.field_sig_validation:1572*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_CC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_FLOW_SIG_ID
	},
	/* cond_execute: class_tid: 1, em.ingress_generic_template:1574*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_NOT_SET,
	.cond_operand = BNXT_ULP_CF_IDX_WC_MATCH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_TERM_FLOW
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_EM_FOR_TC
	},
	/* cond_execute: class_tid: 1, control.em_add_check:1577*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_EM_INSERT_FAIL
	},
	/* cond_reject: thor, class_tid: 2 */
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS
	},
	/* cond_execute: class_tid: 2, control.l2_only_check:1580*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* cond_execute: class_tid: 2, control.l2_only_check:1580*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* cond_execute: class_tid: 2, control.tunnel_ipv6_sip_check:1590*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* cond_execute: class_tid: 2, control.tunnel_ipv6_sip_check:1590*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, control.terminating_flow:1598*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, control.terminating_flow:1600*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, control.terminating_flow:1602*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, control.terminating_flow:1604*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* cond_execute: class_tid: 2, control.proto_header_cache_miss:1606*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 2, control.overlap_miss:1607*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1608*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_NOT_SET,
	.cond_operand = BNXT_ULP_CF_IDX_CHAIN_ID_METADATA
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1610*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_CHAIN_ID_METADATA
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1611*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_CHAIN_ID_METADATA
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1612*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1613*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1616*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1619*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1621*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1625*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1629*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1633*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1637*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1640*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1643*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1646*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1649*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1652*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1655*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1658*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1661*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1664*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1667*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1670*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1673*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1676*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1679*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1681*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1683*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1686*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1689*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1692*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1695*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1699*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1703*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1707*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1711*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1715*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1719*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1723*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1727*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1731*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1735*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1739*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1743*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1747*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1751*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1755*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1759*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1763*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1767*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1771*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1775*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1779*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1783*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1787*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1791*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1795*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1799*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1803*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1807*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1808*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ICMP
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1811*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ICMP
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1814*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1815*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ICMP
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1818*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ICMP
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1821*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1822*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_TCP_FLAGS
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1824*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS
	},
	/* cond_execute: class_tid: 2, fkb_select.em_gen_template_alloc:1826*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_TERM_FLOW
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:1827*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:1829*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:1831*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:1833*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:1835*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:1837*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:1839*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:1841*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1843*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1845*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1847*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1849*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1851*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1853*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1855*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1857*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1859*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1861*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1863*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1865*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1867*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1869*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1871*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1873*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1875*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1877*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1879*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1881*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1883*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1885*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1887*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1889*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1891*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1893*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1895*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1897*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1899*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1901*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1903*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1905*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1907*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_CHAIN_ID_METADATA
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1908*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1910*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1912*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1914*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1916*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_CHAIN_ID_METADATA
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1917*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1919*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1921*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1923*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1925*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1927*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1929*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1931*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1933*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1935*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1937*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1939*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1941*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1943*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1945*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1947*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1949*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1951*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1953*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1955*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1957*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1959*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1961*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1963*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1965*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1967*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1969*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1971*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1973*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1976*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1979*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1982*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1985*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1986*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1987*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1989*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1991*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1993*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1995*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_CHAIN_ID_METADATA
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1996*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1998*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2000*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2002*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2004*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GENEVE
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2006*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GRE
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2008*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR1
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2010*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR2
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2012*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2014*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2016*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GENEVE
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2018*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GRE
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2020*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR1
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2022*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR2
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2024*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2025*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2026*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2027*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2029*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2031*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2033*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2035*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2037*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2039*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2041*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2043*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2045*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2047*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2049*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2051*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2053*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2055*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2056*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2058*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2060*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2061*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2063*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2065*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2067*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2069*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2071*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2073*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2075*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2077*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2079*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2081*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2083*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2085*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2088*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2091*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2092*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2093*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2095*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_CHAIN_ID_METADATA
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2096*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_NOT_SET,
	.cond_operand = BNXT_ULP_CF_IDX_CHAIN_ID_METADATA
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2098*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_NOT_SET,
	.cond_operand = BNXT_ULP_CF_IDX_CHAIN_ID_METADATA
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2100*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_CHAIN_ID_METADATA
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2101*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_CHAIN_ID_METADATA
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2102*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_CHAIN_ID_METADATA
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2103*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_CHAIN_ID_METADATA
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2104*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2105*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2106*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2109*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2112*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2115*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2117*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2120*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2122*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2126*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2130*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2134*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2138*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2142*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2146*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2150*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2154*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2157*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2160*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2163*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2166*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2169*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2172*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2175*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2178*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2181*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2184*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2187*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2190*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2193*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2196*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2199*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2202*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2205*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2208*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2211*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2214*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2217*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2220*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2223*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2226*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2229*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2232*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2235*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2238*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2240*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2242*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2244*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2246*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2249*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2252*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2255*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2258*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2261*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2264*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2267*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2270*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2274*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2278*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2282*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2286*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2290*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2294*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2298*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2302*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2306*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2310*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2314*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2318*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2322*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2326*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2330*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2334*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2337*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2340*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2343*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2346*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2349*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2352*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2355*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2358*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2361*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2364*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2367*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2370*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2373*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2376*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2379*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2382*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2385*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2388*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2391*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2394*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2397*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2400*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2403*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2406*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2408*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2410*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2412*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2414*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2417*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2420*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2423*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2426*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2428*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2430*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2432*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2434*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2437*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2440*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2443*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2446*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2449*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2452*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2455*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2458*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2461*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2464*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2467*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2470*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2473*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2476*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2479*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2482*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2483*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2486*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2489*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2492*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2495*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2496*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2499*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2502*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2505*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2508*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2509*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2512*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2515*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2518*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2521*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* cond_execute: class_tid: 2, em_flow_conflict_cache.rd:2522*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_NOT_SET,
	.cond_operand = BNXT_ULP_CF_IDX_WC_MATCH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_TERM_FLOW
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_EM_FOR_TC
	},
	/* cond_execute: class_tid: 2, control.em_flow_conflict_cache_miss:2525*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2526*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2527*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2528*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2529*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2532*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2535*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2539*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2543*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2547*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2551*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2554*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2557*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2560*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2563*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2566*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2569*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2572*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2575*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2578*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2581*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2584*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2587*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2590*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2593*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2595*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2597*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2600*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2603*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2606*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2609*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2613*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2617*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2621*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2625*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2629*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2633*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2637*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2641*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2644*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2647*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2650*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2653*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2656*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2659*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2662*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2665*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2668*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2671*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2674*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2677*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2680*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2683*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2686*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2689*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2692*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2695*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2698*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2701*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2704*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2707*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2710*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2713*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2716*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2719*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2722*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2725*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2726*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_TCP_FLAGS
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2728*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2730*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2731*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2732*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2733*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2734*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2735*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2736*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2739*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2742*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2745*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2748*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2752*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2756*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2760*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2764*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2768*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2772*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2776*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2780*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2783*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2786*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2789*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2792*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2795*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2798*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2801*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2804*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2807*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2810*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2813*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2816*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2819*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2822*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2825*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2828*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2831*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2834*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2837*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2840*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2843*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2846*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2849*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2852*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2855*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2858*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2861*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2864*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2866*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2868*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2870*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2872*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2875*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2878*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2881*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2884*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2887*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2890*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2893*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2896*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2900*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2904*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2908*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2912*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2916*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2920*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2924*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2928*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2932*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2936*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2940*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2944*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2948*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2952*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2956*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2960*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2963*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2966*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2969*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2972*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2975*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2978*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2981*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2984*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2987*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2990*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2993*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2996*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2999*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3002*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3005*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3008*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3011*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3014*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3017*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3020*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3023*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3026*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3029*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3032*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3035*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3038*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3041*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3044*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3047*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3050*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3053*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3056*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3059*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3062*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3065*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3068*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3071*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3074*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3077*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3080*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3083*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3086*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3089*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3092*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3095*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3098*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3101*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3104*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3107*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3110*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3113*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3116*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3119*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3122*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3125*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* cond_execute: class_tid: 2, control.field_sig_validation:3128*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_CC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_FLOW_SIG_ID
	},
	/* cond_execute: class_tid: 2, em.egress_generic_template:3130*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_NOT_SET,
	.cond_operand = BNXT_ULP_CF_IDX_WC_MATCH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_TERM_FLOW
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_EM_FOR_TC
	},
	/* cond_execute: class_tid: 2, control.em_add_check:3133*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_EM_INSERT_FAIL
	},
	/* cond_execute: class_tid: 3, control.ing_0:3134*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 3, control.egr_0:3135*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_IS_SET,
	.cond_operand = BNXT_ULP_CF_IDX_VFR_MODE
	},
	/* cond_execute: class_tid: 3, control.egr_1:3136*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 3, control.egr_2:3137*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 4, control.prof_tcam_cache.vfr_glb_act_rec_rd.0:3138*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 4, control.vf_2_vfr.0:3139*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 4, control.prof_tcam_cache.vfr.0:3140*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 4, control.0:3141*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	}
};

struct bnxt_ulp_mapper_key_info ulp_thor_class_key_info_list[] = {
	/* class_tid: 1, , table: port_table.rd */
	{
	.field_info_mask = {
		.description = "dev.port_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "dev.port_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_DEV_PORT_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_DEV_PORT_ID & 0xff}
		}
	},
	/* class_tid: 1, , table: l2_cntxt_tcam_cache.rd */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	/* class_tid: 1, , table: tunnel_cache.f1_f2_rd */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_TUNNEL_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_TUNNEL_ID & 0xff}
		}
	},
	/* class_tid: 1, , table: tunnel_cache.f1_f2_wr */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_TUNNEL_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_TUNNEL_ID & 0xff}
		}
	},
	/* class_tid: 1, , table: mac_addr_cache.rd */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tun_hdr",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "one_tag",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "one_tag",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "mac_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_O_DMAC >> 8) & 0xff,
		BNXT_ULP_RF_IDX_O_DMAC & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(11 >> 8) & 0xff,
			11 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(12 >> 8) & 0xff,
			12 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 1, , table: l2_cntxt_tcam.ingress_entry */
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(16 >> 8) & 0xff,
			16 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ONES
		},
	.field_info_spec = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_O_DMAC >> 8) & 0xff,
		BNXT_ULP_RF_IDX_O_DMAC & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(17 >> 8) & 0xff,
			17 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(18 >> 8) & 0xff,
			18 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_CONST
		}
	},
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(19 >> 8) & 0xff,
			19 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(20 >> 8) & 0xff,
			20 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_CONST
		}
	},
	{
	.field_info_mask = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		3}
		},
	.field_info_spec = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 1, , table: mac_addr_cache.wr */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tun_hdr",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "one_tag",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "one_tag",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "mac_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_O_DMAC >> 8) & 0xff,
		BNXT_ULP_RF_IDX_O_DMAC & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(21 >> 8) & 0xff,
			21 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(22 >> 8) & 0xff,
			22 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 1, , table: proto_header_cache.rd */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PROFILE_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PROFILE_BITMAP & 0xff}
		}
	},
	/* class_tid: 1, , table: hdr_overlap_cache.overlap_check */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	/* class_tid: 1, , table: hdr_overlap_cache.overlap_check */
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_HDR_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_HDR_BITMAP & 0xff}
		}
	},
	/* class_tid: 1, , table: hdr_overlap_cache.overlap_wr */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	/* class_tid: 1, , table: hdr_overlap_cache.overlap_wr */
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_HDR_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_HDR_BITMAP & 0xff}
		}
	},
	/* class_tid: 1, , table: profile_tcam.gen_template */
	{
	.field_info_mask = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(280 >> 8) & 0xff,
			280 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(52 >> 8) & 0xff,
		52 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(288 >> 8) & 0xff,
			288 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(55 >> 8) & 0xff,
		55 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(296 >> 8) & 0xff,
			296 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(58 >> 8) & 0xff,
		58 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(304 >> 8) & 0xff,
			304 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(61 >> 8) & 0xff,
		61 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(312 >> 8) & 0xff,
			312 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(64 >> 8) & 0xff,
		64 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(320 >> 8) & 0xff,
			320 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(67 >> 8) & 0xff,
		67 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(328 >> 8) & 0xff,
			328 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(70 >> 8) & 0xff,
		70 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(336 >> 8) & 0xff,
			336 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(73 >> 8) & 0xff,
		73 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "ieh",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ieh",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(344 >> 8) & 0xff,
			344 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(76 >> 8) & 0xff,
		76 & 0xff}
		},
	.field_info_spec = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(353 >> 8) & 0xff,
			353 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(80 >> 8) & 0xff,
		80 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(362 >> 8) & 0xff,
			362 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(84 >> 8) & 0xff,
		84 & 0xff}
		},
	.field_info_spec = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(370 >> 8) & 0xff,
			370 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_TYPE_IPV6},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(87 >> 8) & 0xff,
		87 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(378 >> 8) & 0xff,
			378 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(90 >> 8) & 0xff,
		90 & 0xff}
		},
	.field_info_spec = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(386 >> 8) & 0xff,
			386 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(93 >> 8) & 0xff,
		93 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(394 >> 8) & 0xff,
			394 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(96 >> 8) & 0xff,
		96 & 0xff}
		},
	.field_info_spec = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(402 >> 8) & 0xff,
			402 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(99 >> 8) & 0xff,
		99 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(410 >> 8) & 0xff,
			410 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L2_TWO_VTAGS_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(102 >> 8) & 0xff,
		102 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(416 >> 8) & 0xff,
			416 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L2_VTAG_PRESENT_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(103 >> 8) & 0xff,
		103 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(422 >> 8) & 0xff,
			422 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(423 >> 8) & 0xff,
			423 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(424 >> 8) & 0xff,
			424 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(104 >> 8) & 0xff,
		104 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(428 >> 8) & 0xff,
			428 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(105 >> 8) & 0xff,
		105 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(432 >> 8) & 0xff,
			432 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L2_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(106 >> 8) & 0xff,
		106 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_flags",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_flags",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(437 >> 8) & 0xff,
			437 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(108 >> 8) & 0xff,
		108 & 0xff}
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(449 >> 8) & 0xff,
			449 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(113 >> 8) & 0xff,
		113 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(461 >> 8) & 0xff,
			461 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(462 >> 8) & 0xff,
			462 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(463 >> 8) & 0xff,
			463 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TUN_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(464 >> 8) & 0xff,
			464 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(118 >> 8) & 0xff,
		118 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(468 >> 8) & 0xff,
			468 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(119 >> 8) & 0xff,
		119 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(472 >> 8) & 0xff,
			472 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(120 >> 8) & 0xff,
		120 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(476 >> 8) & 0xff,
			476 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(121 >> 8) & 0xff,
		121 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(480 >> 8) & 0xff,
			480 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(122 >> 8) & 0xff,
		122 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(484 >> 8) & 0xff,
			484 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(123 >> 8) & 0xff,
		123 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(488 >> 8) & 0xff,
			488 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(124 >> 8) & 0xff,
		124 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(493 >> 8) & 0xff,
			493 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(126 >> 8) & 0xff,
		126 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(498 >> 8) & 0xff,
			498 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL3_HDR_ISIP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(128 >> 8) & 0xff,
		128 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(502 >> 8) & 0xff,
			502 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(129 >> 8) & 0xff,
		129 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(506 >> 8) & 0xff,
			506 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL3_HDR_TYPE_IPV6},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(130 >> 8) & 0xff,
		130 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(510 >> 8) & 0xff,
			510 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(131 >> 8) & 0xff,
		131 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(514 >> 8) & 0xff,
			514 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(132 >> 8) & 0xff,
		132 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(518 >> 8) & 0xff,
			518 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(133 >> 8) & 0xff,
		133 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(522 >> 8) & 0xff,
			522 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL2_TWO_VTAGS_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(525 >> 8) & 0xff,
			525 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL2_VTAG_PRESENT_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(528 >> 8) & 0xff,
			528 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(529 >> 8) & 0xff,
			529 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(530 >> 8) & 0xff,
			530 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL2_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(134 >> 8) & 0xff,
		134 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hrec_next",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "hrec_next",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		(ULP_THOR_SYM_VF_2_VFR_META_MASK >> 8) & 0xff,
		ULP_THOR_SYM_VF_2_VFR_META_MASK & 0xff}
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(534 >> 8) & 0xff,
			534 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		(ULP_THOR_SYM_CHAIN_META_VAL >> 8) & 0xff,
		ULP_THOR_SYM_CHAIN_META_VAL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type_0",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "pkt_type_0",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type_1",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "pkt_type_1",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 1, , table: wm_key_recipe.0 */
	{
	.field_info_mask = {
		.description = "wc_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "wc_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_WC_PROFILE_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_WC_PROFILE_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_cntxt_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(535 >> 8) & 0xff,
			535 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "l2_cntxt_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(537 >> 8) & 0xff,
			537 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(539 >> 8) & 0xff,
			539 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(540 >> 8) & 0xff,
			540 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "meta",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(541 >> 8) & 0xff,
			541 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "meta",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(542 >> 8) & 0xff,
			542 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr2 = {
		(BNXT_ULP_CF_IDX_CHAIN_ID_METADATA >> 8) & 0xff,
		BNXT_ULP_CF_IDX_CHAIN_ID_METADATA & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "rcyc_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(543 >> 8) & 0xff,
			543 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "rcyc_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(544 >> 8) & 0xff,
			544 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_RECYCLE_CNT >> 8) & 0xff,
		BNXT_ULP_RF_IDX_RECYCLE_CNT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(545 >> 8) & 0xff,
			545 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(548 >> 8) & 0xff,
			548 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(551 >> 8) & 0xff,
			551 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(554 >> 8) & 0xff,
			554 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(557 >> 8) & 0xff,
			557 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(561 >> 8) & 0xff,
			561 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(565 >> 8) & 0xff,
			565 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OI_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OI_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(135 >> 8) & 0xff,
		135 & 0xff}
		},
	.field_info_spec = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(573 >> 8) & 0xff,
			573 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OI_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OI_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(136 >> 8) & 0xff,
		136 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(581 >> 8) & 0xff,
			581 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(585 >> 8) & 0xff,
			585 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(589 >> 8) & 0xff,
			589 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(592 >> 8) & 0xff,
			592 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(595 >> 8) & 0xff,
			595 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_SKIP,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(598 >> 8) & 0xff,
			598 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_SKIP,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(601 >> 8) & 0xff,
			601 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(604 >> 8) & 0xff,
			604 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(607 >> 8) & 0xff,
			607 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(610 >> 8) & 0xff,
			610 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(613 >> 8) & 0xff,
			613 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(137 >> 8) & 0xff,
		137 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(619 >> 8) & 0xff,
			619 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(138 >> 8) & 0xff,
		138 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(625 >> 8) & 0xff,
			625 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(139 >> 8) & 0xff,
		139 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(631 >> 8) & 0xff,
			631 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(140 >> 8) & 0xff,
		140 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(637 >> 8) & 0xff,
			637 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(141 >> 8) & 0xff,
		141 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(643 >> 8) & 0xff,
			643 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(142 >> 8) & 0xff,
		142 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(649 >> 8) & 0xff,
			649 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(143 >> 8) & 0xff,
		143 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(655 >> 8) & 0xff,
			655 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(144 >> 8) & 0xff,
		144 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(661 >> 8) & 0xff,
			661 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(145 >> 8) & 0xff,
		145 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(667 >> 8) & 0xff,
			667 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(146 >> 8) & 0xff,
		146 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(673 >> 8) & 0xff,
			673 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(147 >> 8) & 0xff,
		147 & 0xff}
		},
	.field_info_spec = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(677 >> 8) & 0xff,
			677 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(148 >> 8) & 0xff,
		148 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(681 >> 8) & 0xff,
			681 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(149 >> 8) & 0xff,
		149 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(687 >> 8) & 0xff,
			687 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(150 >> 8) & 0xff,
		150 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(693 >> 8) & 0xff,
			693 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(151 >> 8) & 0xff,
		151 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(699 >> 8) & 0xff,
			699 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(152 >> 8) & 0xff,
		152 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(705 >> 8) & 0xff,
			705 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_IO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_IO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(153 >> 8) & 0xff,
		153 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(713 >> 8) & 0xff,
			713 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_IO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_IO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(154 >> 8) & 0xff,
		154 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(721 >> 8) & 0xff,
			721 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_II_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_II_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(155 >> 8) & 0xff,
		155 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(737 >> 8) & 0xff,
			737 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_II_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_II_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(158 >> 8) & 0xff,
		158 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(753 >> 8) & 0xff,
			753 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(161 >> 8) & 0xff,
		161 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(761 >> 8) & 0xff,
			761 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(162 >> 8) & 0xff,
		162 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(769 >> 8) & 0xff,
			769 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(163 >> 8) & 0xff,
		163 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(775 >> 8) & 0xff,
			775 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(164 >> 8) & 0xff,
		164 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(781 >> 8) & 0xff,
			781 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(165 >> 8) & 0xff,
		165 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(787 >> 8) & 0xff,
			787 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(166 >> 8) & 0xff,
		166 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(793 >> 8) & 0xff,
			793 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(167 >> 8) & 0xff,
		167 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(799 >> 8) & 0xff,
			799 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(168 >> 8) & 0xff,
		168 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(805 >> 8) & 0xff,
			805 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(169 >> 8) & 0xff,
		169 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(811 >> 8) & 0xff,
			811 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(170 >> 8) & 0xff,
		170 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(817 >> 8) & 0xff,
			817 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(171 >> 8) & 0xff,
		171 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(829 >> 8) & 0xff,
			829 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(174 >> 8) & 0xff,
		174 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(841 >> 8) & 0xff,
			841 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(177 >> 8) & 0xff,
		177 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(861 >> 8) & 0xff,
			861 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_IP_PROTO_TCP},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(184 >> 8) & 0xff,
		184 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(881 >> 8) & 0xff,
			881 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(191 >> 8) & 0xff,
		191 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(893 >> 8) & 0xff,
			893 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(194 >> 8) & 0xff,
		194 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(905 >> 8) & 0xff,
			905 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(197 >> 8) & 0xff,
		197 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(918 >> 8) & 0xff,
			918 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(201 >> 8) & 0xff,
		201 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(931 >> 8) & 0xff,
			931 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(205 >> 8) & 0xff,
		205 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(944 >> 8) & 0xff,
			944 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(209 >> 8) & 0xff,
		209 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.flags",
		.field_bit_size = 9,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1_THEN_SRC2_ELSE_SRC3,
		.field_src1 = BNXT_ULP_FIELD_SRC_FIELD_BIT,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4.flags",
		.field_bit_size = 9,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1_THEN_SRC2_ELSE_SRC3,
		.field_src1 = BNXT_ULP_FIELD_SRC_FIELD_BIT,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 1, , table: proto_header_cache.wr */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PROFILE_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PROFILE_BITMAP & 0xff}
		}
	},
	/* class_tid: 1, , table: em_flow_conflict_cache.rd */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PROFILE_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PROFILE_BITMAP & 0xff}
		}
	},
	/* class_tid: 1, , table: em_key_recipe.0 */
	{
	.field_info_mask = {
		.description = "em_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "em_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_EM_PROFILE_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_EM_PROFILE_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_cntxt_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1168 >> 8) & 0xff,
			1168 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "l2_cntxt_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1169 >> 8) & 0xff,
			1169 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "meta",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1170 >> 8) & 0xff,
			1170 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "meta",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1171 >> 8) & 0xff,
			1171 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr2 = {
		(BNXT_ULP_CF_IDX_VF_META_FID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_VF_META_FID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "rcyc_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1172 >> 8) & 0xff,
			1172 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "rcyc_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1173 >> 8) & 0xff,
			1173 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_RECYCLE_CNT >> 8) & 0xff,
		BNXT_ULP_RF_IDX_RECYCLE_CNT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1174 >> 8) & 0xff,
			1174 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1178 >> 8) & 0xff,
			1178 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1182 >> 8) & 0xff,
			1182 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1185 >> 8) & 0xff,
			1185 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1188 >> 8) & 0xff,
			1188 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1192 >> 8) & 0xff,
			1192 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1196 >> 8) & 0xff,
			1196 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(252 >> 8) & 0xff,
		252 & 0xff}
		},
	.field_info_spec = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1204 >> 8) & 0xff,
			1204 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OI_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OI_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(253 >> 8) & 0xff,
		253 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1212 >> 8) & 0xff,
			1212 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1216 >> 8) & 0xff,
			1216 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1220 >> 8) & 0xff,
			1220 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1223 >> 8) & 0xff,
			1223 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1226 >> 8) & 0xff,
			1226 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1229 >> 8) & 0xff,
			1229 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1232 >> 8) & 0xff,
			1232 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1235 >> 8) & 0xff,
			1235 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1238 >> 8) & 0xff,
			1238 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1241 >> 8) & 0xff,
			1241 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1244 >> 8) & 0xff,
			1244 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(254 >> 8) & 0xff,
		254 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1250 >> 8) & 0xff,
			1250 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(255 >> 8) & 0xff,
		255 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1256 >> 8) & 0xff,
			1256 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(256 >> 8) & 0xff,
		256 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1262 >> 8) & 0xff,
			1262 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(257 >> 8) & 0xff,
		257 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1268 >> 8) & 0xff,
			1268 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(258 >> 8) & 0xff,
		258 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1274 >> 8) & 0xff,
			1274 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(259 >> 8) & 0xff,
		259 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1280 >> 8) & 0xff,
			1280 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(260 >> 8) & 0xff,
		260 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1286 >> 8) & 0xff,
			1286 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(261 >> 8) & 0xff,
		261 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1292 >> 8) & 0xff,
			1292 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(262 >> 8) & 0xff,
		262 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1298 >> 8) & 0xff,
			1298 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(263 >> 8) & 0xff,
		263 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1304 >> 8) & 0xff,
			1304 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(264 >> 8) & 0xff,
		264 & 0xff}
		},
	.field_info_spec = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1308 >> 8) & 0xff,
			1308 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(265 >> 8) & 0xff,
		265 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1312 >> 8) & 0xff,
			1312 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(266 >> 8) & 0xff,
		266 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1320 >> 8) & 0xff,
			1320 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(267 >> 8) & 0xff,
		267 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1328 >> 8) & 0xff,
			1328 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(268 >> 8) & 0xff,
		268 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1334 >> 8) & 0xff,
			1334 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(269 >> 8) & 0xff,
		269 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1340 >> 8) & 0xff,
			1340 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(270 >> 8) & 0xff,
		270 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1348 >> 8) & 0xff,
			1348 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_IO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_IO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(271 >> 8) & 0xff,
		271 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1356 >> 8) & 0xff,
			1356 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(272 >> 8) & 0xff,
		272 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1372 >> 8) & 0xff,
			1372 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_II_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_II_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(275 >> 8) & 0xff,
		275 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1388 >> 8) & 0xff,
			1388 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(278 >> 8) & 0xff,
		278 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1396 >> 8) & 0xff,
			1396 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(279 >> 8) & 0xff,
		279 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1404 >> 8) & 0xff,
			1404 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(280 >> 8) & 0xff,
		280 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1410 >> 8) & 0xff,
			1410 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(281 >> 8) & 0xff,
		281 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1416 >> 8) & 0xff,
			1416 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(282 >> 8) & 0xff,
		282 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1422 >> 8) & 0xff,
			1422 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(283 >> 8) & 0xff,
		283 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1428 >> 8) & 0xff,
			1428 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(284 >> 8) & 0xff,
		284 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1434 >> 8) & 0xff,
			1434 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(285 >> 8) & 0xff,
		285 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1440 >> 8) & 0xff,
			1440 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(286 >> 8) & 0xff,
		286 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1446 >> 8) & 0xff,
			1446 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(287 >> 8) & 0xff,
		287 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1452 >> 8) & 0xff,
			1452 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(288 >> 8) & 0xff,
		288 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1464 >> 8) & 0xff,
			1464 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(291 >> 8) & 0xff,
		291 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1476 >> 8) & 0xff,
			1476 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(294 >> 8) & 0xff,
		294 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1488 >> 8) & 0xff,
			1488 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(297 >> 8) & 0xff,
		297 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1500 >> 8) & 0xff,
			1500 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(300 >> 8) & 0xff,
		300 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1512 >> 8) & 0xff,
			1512 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(303 >> 8) & 0xff,
		303 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1524 >> 8) & 0xff,
			1524 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(306 >> 8) & 0xff,
		306 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1536 >> 8) & 0xff,
			1536 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(309 >> 8) & 0xff,
		309 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1548 >> 8) & 0xff,
			1548 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(312 >> 8) & 0xff,
		312 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1560 >> 8) & 0xff,
			1560 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(315 >> 8) & 0xff,
		315 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.flags",
		.field_bit_size = 9,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1_THEN_SRC2_ELSE_SRC3,
		.field_src1 = BNXT_ULP_FIELD_SRC_FIELD_BIT,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "l4.flags",
		.field_bit_size = 9,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1_THEN_SRC2_ELSE_SRC3,
		.field_src1 = BNXT_ULP_FIELD_SRC_FIELD_BIT,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	/* class_tid: 1, , table: em_flow_conflict_cache.wr */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PROFILE_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PROFILE_BITMAP & 0xff}
		}
	},
	/* class_tid: 2, , table: l2_cntxt_tcam_cache.rd */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	/* class_tid: 2, , table: proto_header_cache.rd */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PROFILE_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PROFILE_BITMAP & 0xff}
		}
	},
	/* class_tid: 2, , table: hdr_overlap_cache.overlap_check */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	/* class_tid: 2, , table: hdr_overlap_cache.overlap_check */
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_HDR_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_HDR_BITMAP & 0xff}
		}
	},
	/* class_tid: 2, , table: hdr_overlap_cache.overlap_wr */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	/* class_tid: 2, , table: hdr_overlap_cache.overlap_wr */
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_HDR_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_HDR_BITMAP & 0xff}
		}
	},
	/* class_tid: 2, , table: profile_tcam.gen_template */
	{
	.field_info_mask = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1843 >> 8) & 0xff,
			1843 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(368 >> 8) & 0xff,
		368 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1851 >> 8) & 0xff,
			1851 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(371 >> 8) & 0xff,
		371 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1859 >> 8) & 0xff,
			1859 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(374 >> 8) & 0xff,
		374 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1867 >> 8) & 0xff,
			1867 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(377 >> 8) & 0xff,
		377 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1875 >> 8) & 0xff,
			1875 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(380 >> 8) & 0xff,
		380 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1883 >> 8) & 0xff,
			1883 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(383 >> 8) & 0xff,
		383 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1891 >> 8) & 0xff,
			1891 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(386 >> 8) & 0xff,
		386 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1899 >> 8) & 0xff,
			1899 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(389 >> 8) & 0xff,
		389 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "ieh",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ieh",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1907 >> 8) & 0xff,
			1907 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(392 >> 8) & 0xff,
		392 & 0xff}
		},
	.field_info_spec = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1916 >> 8) & 0xff,
			1916 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(396 >> 8) & 0xff,
		396 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1925 >> 8) & 0xff,
			1925 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(400 >> 8) & 0xff,
		400 & 0xff}
		},
	.field_info_spec = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1933 >> 8) & 0xff,
			1933 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_TYPE_IPV6},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(403 >> 8) & 0xff,
		403 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1941 >> 8) & 0xff,
			1941 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(406 >> 8) & 0xff,
		406 & 0xff}
		},
	.field_info_spec = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1949 >> 8) & 0xff,
			1949 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(409 >> 8) & 0xff,
		409 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1957 >> 8) & 0xff,
			1957 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(412 >> 8) & 0xff,
		412 & 0xff}
		},
	.field_info_spec = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1965 >> 8) & 0xff,
			1965 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(415 >> 8) & 0xff,
		415 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1973 >> 8) & 0xff,
			1973 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L2_TWO_VTAGS_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(418 >> 8) & 0xff,
		418 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1979 >> 8) & 0xff,
			1979 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L2_VTAG_PRESENT_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(419 >> 8) & 0xff,
		419 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1985 >> 8) & 0xff,
			1985 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1986 >> 8) & 0xff,
			1986 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1987 >> 8) & 0xff,
			1987 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(420 >> 8) & 0xff,
		420 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1991 >> 8) & 0xff,
			1991 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(421 >> 8) & 0xff,
		421 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1995 >> 8) & 0xff,
			1995 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L2_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(422 >> 8) & 0xff,
		422 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_flags",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_flags",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2000 >> 8) & 0xff,
			2000 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(424 >> 8) & 0xff,
		424 & 0xff}
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2012 >> 8) & 0xff,
			2012 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(429 >> 8) & 0xff,
		429 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2024 >> 8) & 0xff,
			2024 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2025 >> 8) & 0xff,
			2025 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2026 >> 8) & 0xff,
			2026 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TUN_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2027 >> 8) & 0xff,
			2027 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(434 >> 8) & 0xff,
		434 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2031 >> 8) & 0xff,
			2031 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(435 >> 8) & 0xff,
		435 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2035 >> 8) & 0xff,
			2035 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(436 >> 8) & 0xff,
		436 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2039 >> 8) & 0xff,
			2039 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(437 >> 8) & 0xff,
		437 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2043 >> 8) & 0xff,
			2043 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(438 >> 8) & 0xff,
		438 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2047 >> 8) & 0xff,
			2047 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(439 >> 8) & 0xff,
		439 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2051 >> 8) & 0xff,
			2051 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(440 >> 8) & 0xff,
		440 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2056 >> 8) & 0xff,
			2056 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(442 >> 8) & 0xff,
		442 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2061 >> 8) & 0xff,
			2061 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL3_HDR_ISIP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(444 >> 8) & 0xff,
		444 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2065 >> 8) & 0xff,
			2065 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(445 >> 8) & 0xff,
		445 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2069 >> 8) & 0xff,
			2069 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL3_HDR_TYPE_IPV6},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(446 >> 8) & 0xff,
		446 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2073 >> 8) & 0xff,
			2073 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(447 >> 8) & 0xff,
		447 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2077 >> 8) & 0xff,
			2077 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(448 >> 8) & 0xff,
		448 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2081 >> 8) & 0xff,
			2081 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(449 >> 8) & 0xff,
		449 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2085 >> 8) & 0xff,
			2085 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL2_TWO_VTAGS_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2088 >> 8) & 0xff,
			2088 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL2_VTAG_PRESENT_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2091 >> 8) & 0xff,
			2091 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2092 >> 8) & 0xff,
			2092 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2093 >> 8) & 0xff,
			2093 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL2_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "hrec_next",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "hrec_next",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		(ULP_THOR_SYM_VF_2_VFR_META_MASK >> 8) & 0xff,
		ULP_THOR_SYM_VF_2_VFR_META_MASK & 0xff}
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2095 >> 8) & 0xff,
			2095 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		(ULP_THOR_SYM_CHAIN_META_VAL >> 8) & 0xff,
		ULP_THOR_SYM_CHAIN_META_VAL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type_0",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "pkt_type_0",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type_1",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "pkt_type_1",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 2, , table: wm_key_recipe.0 */
	{
	.field_info_mask = {
		.description = "wc_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "wc_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_WC_PROFILE_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_WC_PROFILE_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_cntxt_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2096 >> 8) & 0xff,
			2096 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "l2_cntxt_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2098 >> 8) & 0xff,
			2098 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2100 >> 8) & 0xff,
			2100 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2101 >> 8) & 0xff,
			2101 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "meta",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2102 >> 8) & 0xff,
			2102 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "meta",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2103 >> 8) & 0xff,
			2103 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr2 = {
		(BNXT_ULP_CF_IDX_CHAIN_ID_METADATA >> 8) & 0xff,
		BNXT_ULP_CF_IDX_CHAIN_ID_METADATA & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "rcyc_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2104 >> 8) & 0xff,
			2104 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "rcyc_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2105 >> 8) & 0xff,
			2105 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_RECYCLE_CNT >> 8) & 0xff,
		BNXT_ULP_RF_IDX_RECYCLE_CNT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2106 >> 8) & 0xff,
			2106 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2109 >> 8) & 0xff,
			2109 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2112 >> 8) & 0xff,
			2112 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr2 = {
		(450 >> 8) & 0xff,
		450 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2117 >> 8) & 0xff,
			2117 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr2 = {
		(451 >> 8) & 0xff,
		451 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2122 >> 8) & 0xff,
			2122 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2126 >> 8) & 0xff,
			2126 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2130 >> 8) & 0xff,
			2130 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OI_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OI_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(452 >> 8) & 0xff,
		452 & 0xff}
		},
	.field_info_spec = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2138 >> 8) & 0xff,
			2138 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OI_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OI_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(453 >> 8) & 0xff,
		453 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2146 >> 8) & 0xff,
			2146 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2150 >> 8) & 0xff,
			2150 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2154 >> 8) & 0xff,
			2154 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2157 >> 8) & 0xff,
			2157 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2160 >> 8) & 0xff,
			2160 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2163 >> 8) & 0xff,
			2163 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2166 >> 8) & 0xff,
			2166 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2169 >> 8) & 0xff,
			2169 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2172 >> 8) & 0xff,
			2172 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2175 >> 8) & 0xff,
			2175 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2178 >> 8) & 0xff,
			2178 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(454 >> 8) & 0xff,
		454 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2184 >> 8) & 0xff,
			2184 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(455 >> 8) & 0xff,
		455 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2190 >> 8) & 0xff,
			2190 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(456 >> 8) & 0xff,
		456 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2196 >> 8) & 0xff,
			2196 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(457 >> 8) & 0xff,
		457 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2202 >> 8) & 0xff,
			2202 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(458 >> 8) & 0xff,
		458 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2208 >> 8) & 0xff,
			2208 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(459 >> 8) & 0xff,
		459 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2214 >> 8) & 0xff,
			2214 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(460 >> 8) & 0xff,
		460 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2220 >> 8) & 0xff,
			2220 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(461 >> 8) & 0xff,
		461 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2226 >> 8) & 0xff,
			2226 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(462 >> 8) & 0xff,
		462 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2232 >> 8) & 0xff,
			2232 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(463 >> 8) & 0xff,
		463 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2238 >> 8) & 0xff,
			2238 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(464 >> 8) & 0xff,
		464 & 0xff}
		},
	.field_info_spec = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2242 >> 8) & 0xff,
			2242 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(465 >> 8) & 0xff,
		465 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2246 >> 8) & 0xff,
			2246 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(466 >> 8) & 0xff,
		466 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2252 >> 8) & 0xff,
			2252 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(467 >> 8) & 0xff,
		467 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2258 >> 8) & 0xff,
			2258 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(468 >> 8) & 0xff,
		468 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2264 >> 8) & 0xff,
			2264 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(469 >> 8) & 0xff,
		469 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2270 >> 8) & 0xff,
			2270 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_IO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_IO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(470 >> 8) & 0xff,
		470 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2278 >> 8) & 0xff,
			2278 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_IO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_IO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(471 >> 8) & 0xff,
		471 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2286 >> 8) & 0xff,
			2286 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_II_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_II_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(472 >> 8) & 0xff,
		472 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2302 >> 8) & 0xff,
			2302 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_II_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_II_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(475 >> 8) & 0xff,
		475 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2318 >> 8) & 0xff,
			2318 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(478 >> 8) & 0xff,
		478 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2326 >> 8) & 0xff,
			2326 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(479 >> 8) & 0xff,
		479 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2334 >> 8) & 0xff,
			2334 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(480 >> 8) & 0xff,
		480 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2340 >> 8) & 0xff,
			2340 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(481 >> 8) & 0xff,
		481 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2346 >> 8) & 0xff,
			2346 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(482 >> 8) & 0xff,
		482 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2352 >> 8) & 0xff,
			2352 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(483 >> 8) & 0xff,
		483 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2358 >> 8) & 0xff,
			2358 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(484 >> 8) & 0xff,
		484 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2364 >> 8) & 0xff,
			2364 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(485 >> 8) & 0xff,
		485 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2370 >> 8) & 0xff,
			2370 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(486 >> 8) & 0xff,
		486 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2376 >> 8) & 0xff,
			2376 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(487 >> 8) & 0xff,
		487 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2382 >> 8) & 0xff,
			2382 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(488 >> 8) & 0xff,
		488 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2394 >> 8) & 0xff,
			2394 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(491 >> 8) & 0xff,
		491 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2406 >> 8) & 0xff,
			2406 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(494 >> 8) & 0xff,
		494 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2426 >> 8) & 0xff,
			2426 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_IP_PROTO_TCP},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(501 >> 8) & 0xff,
		501 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2446 >> 8) & 0xff,
			2446 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(508 >> 8) & 0xff,
		508 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2458 >> 8) & 0xff,
			2458 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(511 >> 8) & 0xff,
		511 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2470 >> 8) & 0xff,
			2470 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(514 >> 8) & 0xff,
		514 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2483 >> 8) & 0xff,
			2483 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(518 >> 8) & 0xff,
		518 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2496 >> 8) & 0xff,
			2496 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(522 >> 8) & 0xff,
		522 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2509 >> 8) & 0xff,
			2509 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(526 >> 8) & 0xff,
		526 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.flags",
		.field_bit_size = 9,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1_THEN_SRC2_ELSE_SRC3,
		.field_src1 = BNXT_ULP_FIELD_SRC_FIELD_BIT,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4.flags",
		.field_bit_size = 9,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1_THEN_SRC2_ELSE_SRC3,
		.field_src1 = BNXT_ULP_FIELD_SRC_FIELD_BIT,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 2, , table: proto_header_cache.wr */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PROFILE_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PROFILE_BITMAP & 0xff}
		}
	},
	/* class_tid: 2, , table: em_flow_conflict_cache.rd */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PROFILE_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PROFILE_BITMAP & 0xff}
		}
	},
	/* class_tid: 2, , table: em_key_recipe.0 */
	{
	.field_info_mask = {
		.description = "em_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "em_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_EM_PROFILE_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_EM_PROFILE_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_cntxt_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2730 >> 8) & 0xff,
			2730 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "l2_cntxt_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2731 >> 8) & 0xff,
			2731 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "meta",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2732 >> 8) & 0xff,
			2732 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "meta",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2733 >> 8) & 0xff,
			2733 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr2 = {
		(BNXT_ULP_CF_IDX_VF_META_FID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_VF_META_FID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "rcyc_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2734 >> 8) & 0xff,
			2734 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "rcyc_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2735 >> 8) & 0xff,
			2735 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_RECYCLE_CNT >> 8) & 0xff,
		BNXT_ULP_RF_IDX_RECYCLE_CNT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2736 >> 8) & 0xff,
			2736 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2739 >> 8) & 0xff,
			2739 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2742 >> 8) & 0xff,
			2742 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2745 >> 8) & 0xff,
			2745 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2748 >> 8) & 0xff,
			2748 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2752 >> 8) & 0xff,
			2752 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2756 >> 8) & 0xff,
			2756 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(569 >> 8) & 0xff,
		569 & 0xff}
		},
	.field_info_spec = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2764 >> 8) & 0xff,
			2764 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OI_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OI_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(570 >> 8) & 0xff,
		570 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2772 >> 8) & 0xff,
			2772 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2776 >> 8) & 0xff,
			2776 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2780 >> 8) & 0xff,
			2780 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2783 >> 8) & 0xff,
			2783 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2786 >> 8) & 0xff,
			2786 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2789 >> 8) & 0xff,
			2789 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2792 >> 8) & 0xff,
			2792 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2795 >> 8) & 0xff,
			2795 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2798 >> 8) & 0xff,
			2798 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2801 >> 8) & 0xff,
			2801 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2804 >> 8) & 0xff,
			2804 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(571 >> 8) & 0xff,
		571 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2810 >> 8) & 0xff,
			2810 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(572 >> 8) & 0xff,
		572 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2816 >> 8) & 0xff,
			2816 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(573 >> 8) & 0xff,
		573 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2822 >> 8) & 0xff,
			2822 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(574 >> 8) & 0xff,
		574 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2828 >> 8) & 0xff,
			2828 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(575 >> 8) & 0xff,
		575 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2834 >> 8) & 0xff,
			2834 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(576 >> 8) & 0xff,
		576 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2840 >> 8) & 0xff,
			2840 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(577 >> 8) & 0xff,
		577 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2846 >> 8) & 0xff,
			2846 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(578 >> 8) & 0xff,
		578 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2852 >> 8) & 0xff,
			2852 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(579 >> 8) & 0xff,
		579 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2858 >> 8) & 0xff,
			2858 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(580 >> 8) & 0xff,
		580 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2864 >> 8) & 0xff,
			2864 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(581 >> 8) & 0xff,
		581 & 0xff}
		},
	.field_info_spec = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2868 >> 8) & 0xff,
			2868 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(582 >> 8) & 0xff,
		582 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2872 >> 8) & 0xff,
			2872 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(583 >> 8) & 0xff,
		583 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2878 >> 8) & 0xff,
			2878 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(584 >> 8) & 0xff,
		584 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2884 >> 8) & 0xff,
			2884 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(585 >> 8) & 0xff,
		585 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2890 >> 8) & 0xff,
			2890 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(586 >> 8) & 0xff,
		586 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2896 >> 8) & 0xff,
			2896 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(587 >> 8) & 0xff,
		587 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2904 >> 8) & 0xff,
			2904 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_IO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_IO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(588 >> 8) & 0xff,
		588 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2912 >> 8) & 0xff,
			2912 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(589 >> 8) & 0xff,
		589 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2928 >> 8) & 0xff,
			2928 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_II_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_II_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(592 >> 8) & 0xff,
		592 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2944 >> 8) & 0xff,
			2944 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(595 >> 8) & 0xff,
		595 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2952 >> 8) & 0xff,
			2952 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(596 >> 8) & 0xff,
		596 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2960 >> 8) & 0xff,
			2960 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(597 >> 8) & 0xff,
		597 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2966 >> 8) & 0xff,
			2966 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(598 >> 8) & 0xff,
		598 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2972 >> 8) & 0xff,
			2972 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(599 >> 8) & 0xff,
		599 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2978 >> 8) & 0xff,
			2978 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(600 >> 8) & 0xff,
		600 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2984 >> 8) & 0xff,
			2984 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(601 >> 8) & 0xff,
		601 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2990 >> 8) & 0xff,
			2990 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(602 >> 8) & 0xff,
		602 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2996 >> 8) & 0xff,
			2996 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(603 >> 8) & 0xff,
		603 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3002 >> 8) & 0xff,
			3002 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(604 >> 8) & 0xff,
		604 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3008 >> 8) & 0xff,
			3008 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(605 >> 8) & 0xff,
		605 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3020 >> 8) & 0xff,
			3020 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(608 >> 8) & 0xff,
		608 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3032 >> 8) & 0xff,
			3032 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(611 >> 8) & 0xff,
		611 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3044 >> 8) & 0xff,
			3044 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(614 >> 8) & 0xff,
		614 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3056 >> 8) & 0xff,
			3056 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(617 >> 8) & 0xff,
		617 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3068 >> 8) & 0xff,
			3068 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(620 >> 8) & 0xff,
		620 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3080 >> 8) & 0xff,
			3080 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(623 >> 8) & 0xff,
		623 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3092 >> 8) & 0xff,
			3092 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(626 >> 8) & 0xff,
		626 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3104 >> 8) & 0xff,
			3104 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(629 >> 8) & 0xff,
		629 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3116 >> 8) & 0xff,
			3116 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(632 >> 8) & 0xff,
		632 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.flags",
		.field_bit_size = 9,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1_THEN_SRC2_ELSE_SRC3,
		.field_src1 = BNXT_ULP_FIELD_SRC_FIELD_BIT,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "l4.flags",
		.field_bit_size = 9,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1_THEN_SRC2_ELSE_SRC3,
		.field_src1 = BNXT_ULP_FIELD_SRC_FIELD_BIT,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_TCP_FLAGS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	/* class_tid: 2, , table: em_flow_conflict_cache.wr */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PROFILE_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PROFILE_BITMAP & 0xff}
		}
	},
	/* class_tid: 3, , table: port_table.ing_wr_0 */
	{
	.field_info_mask = {
		.description = "dev.port_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "dev.port_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_DEV_PORT_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_DEV_PORT_ID & 0xff}
		}
	},
	/* class_tid: 3, , table: l2_cntxt_tcam_cache.ing_rd */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PHY_PORT_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PHY_PORT_SVIF & 0xff}
		}
	},
	/* class_tid: 3, , table: l2_cntxt_tcam.ing_0 */
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PHY_PORT_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PHY_PORT_SVIF & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 3, , table: l2_cntxt_tcam_cache.ing_wr */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PHY_PORT_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PHY_PORT_SVIF & 0xff}
		}
	},
	/* class_tid: 3, , table: profile_tcam.prof_func_catch_all */
	{
	.field_info_mask = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "ieh",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ieh",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_flags",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_flags",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "hrec_next",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "hrec_next",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type_0",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "pkt_type_0",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type_1",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "pkt_type_1",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 3, , table: port_table.egr_wr_0 */
	{
	.field_info_mask = {
		.description = "dev.port_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "dev.port_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_DEV_PORT_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_DEV_PORT_ID & 0xff}
		}
	},
	/* class_tid: 3, , table: l2_cntxt_tcam_cache.egr_rd_vfr */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_DRV_FUNC_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_DRV_FUNC_SVIF & 0xff}
		}
	},
	/* class_tid: 3, , table: l2_cntxt_tcam_cache.egr_wr_vfr */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_DRV_FUNC_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_DRV_FUNC_SVIF & 0xff}
		}
	},
	/* class_tid: 3, , table: l2_cntxt_tcam_cache.egr_rd */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_DRV_FUNC_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_DRV_FUNC_SVIF & 0xff}
		}
	},
	/* class_tid: 3, , table: l2_cntxt_tcam.egr_0 */
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_DRV_FUNC_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_DRV_FUNC_SVIF & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 3, , table: l2_cntxt_tcam_cache.egr_wr */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_DRV_FUNC_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_DRV_FUNC_SVIF & 0xff}
		}
	},
	/* class_tid: 4, , table: profile_tcam_cache.vfr_glb_act_rec_rd */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_GLB_RF,
		.field_opr1 = {
		(BNXT_ULP_GLB_RF_IDX_ANY_2_VF_PROF_FUNC_ID >> 8) & 0xff,
		BNXT_ULP_GLB_RF_IDX_ANY_2_VF_PROF_FUNC_ID & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_sig_id",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "hdr_sig_id",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 4, , table: profile_tcam_cache.vfr_glb_act_rec_wr */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_GLB_RF,
		.field_opr1 = {
		(BNXT_ULP_GLB_RF_IDX_ANY_2_VF_PROF_FUNC_ID >> 8) & 0xff,
		BNXT_ULP_GLB_RF_IDX_ANY_2_VF_PROF_FUNC_ID & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_sig_id",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "hdr_sig_id",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 4, , table: l2_cntxt_tcam_cache.vf_rd_egr */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_VF_FUNC_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_VF_FUNC_SVIF & 0xff}
		}
	},
	/* class_tid: 4, , table: l2_cntxt_tcam_cache.get_drv_func_prof_func */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_DRV_FUNC_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_DRV_FUNC_SVIF & 0xff}
		}
	},
	/* class_tid: 4, , table: l2_cntxt_tcam.vf_egr */
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_VF_FUNC_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_VF_FUNC_SVIF & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 4, , table: profile_tcam.prof_func_catch_all */
	{
	.field_info_mask = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "ieh",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ieh",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_flags",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_flags",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "hrec_next",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "hrec_next",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type_0",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "pkt_type_0",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type_1",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "pkt_type_1",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 4, , table: l2_cntxt_tcam_cache.vf_egr_wr */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_VF_FUNC_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_VF_FUNC_SVIF & 0xff}
		}
	},
	/* class_tid: 4, , table: profile_tcam_cache.vfr_rd */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_GLB_RF,
		.field_opr1 = {
		(BNXT_ULP_GLB_RF_IDX_VF_2_VFR_PROF_FUNC_ID >> 8) & 0xff,
		BNXT_ULP_GLB_RF_IDX_VF_2_VFR_PROF_FUNC_ID & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_sig_id",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "hdr_sig_id",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 4, , table: l2_cntxt_tcam.vf_2_vfr_ing.0 */
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		(ULP_THOR_SYM_VF_2_VFR_META_MASK >> 8) & 0xff,
		ULP_THOR_SYM_VF_2_VFR_META_MASK & 0xff}
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		(ULP_THOR_SYM_VF_2_VFR_META_VAL >> 8) & 0xff,
		ULP_THOR_SYM_VF_2_VFR_META_VAL & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 4, , table: l2_cntxt_tcam.vfr_2_vf_ing.0 */
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac1_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mac0_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		(ULP_THOR_SYM_VF_2_VFR_META_MASK >> 8) & 0xff,
		ULP_THOR_SYM_VF_2_VFR_META_MASK & 0xff}
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		(ULP_THOR_SYM_VF_2_VF_META_VAL >> 8) & 0xff,
		ULP_THOR_SYM_VF_2_VF_META_VAL & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "parif",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 4, , table: profile_tcam.vf_2_vfr.0 */
	{
	.field_info_mask = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "ieh",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ieh",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_flags",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_flags",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "hrec_next",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "hrec_next",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_GLB_RF,
		.field_opr1 = {
		(BNXT_ULP_GLB_RF_IDX_VF_2_VFR_PROF_FUNC_ID >> 8) & 0xff,
		BNXT_ULP_GLB_RF_IDX_VF_2_VFR_PROF_FUNC_ID & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type_0",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "pkt_type_0",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type_1",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "pkt_type_1",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 4, , table: profile_tcam.vfr_2_vf.0 */
	{
	.field_info_mask = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "ieh",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ieh",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_flags",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_flags",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_ipv6_cmp_dst",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_ipv6_cmp_src",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "hrec_next",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "hrec_next",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_GLB_RF,
		.field_opr1 = {
		(BNXT_ULP_GLB_RF_IDX_ANY_2_VF_PROF_FUNC_ID >> 8) & 0xff,
		BNXT_ULP_GLB_RF_IDX_ANY_2_VF_PROF_FUNC_ID & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type_0",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "pkt_type_0",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type_1",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "pkt_type_1",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 4, , table: profile_tcam_cache.vfr_wr */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 7,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_GLB_RF,
		.field_opr1 = {
		(BNXT_ULP_GLB_RF_IDX_VF_2_VFR_PROF_FUNC_ID >> 8) & 0xff,
		BNXT_ULP_GLB_RF_IDX_VF_2_VFR_PROF_FUNC_ID & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_sig_id",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "hdr_sig_id",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 4, , table: em.vf_2_vfr.0 */
	{
	.field_info_mask = {
		.description = "em_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "em_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_GLB_RF,
		.field_opr1 = {
		(BNXT_ULP_GLB_RF_IDX_GLB_VFR_EM_PROF_ID_0 >> 8) & 0xff,
		BNXT_ULP_GLB_RF_IDX_GLB_VFR_EM_PROF_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_VF_FUNC_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_VF_FUNC_SVIF & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "meta",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "meta",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		(ULP_THOR_SYM_VF_2_VFR_META_VAL >> 8) & 0xff,
		ULP_THOR_SYM_VF_2_VFR_META_VAL & 0xff}
		}
	},
	/* class_tid: 4, , table: l2_cntxt_tcam_cache.rd_egr0 */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_DRV_FUNC_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_DRV_FUNC_SVIF & 0xff}
		}
	},
	/* class_tid: 4, , table: l2_cntxt_tcam_cache.vfr_wr_egr0 */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_DRV_FUNC_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_DRV_FUNC_SVIF & 0xff}
		}
	},
	/* class_tid: 4, , table: em.vfr_2_vf.0 */
	{
	.field_info_mask = {
		.description = "em_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "em_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_GLB_RF,
		.field_opr1 = {
		(BNXT_ULP_GLB_RF_IDX_GLB_VFR_EM_PROF_ID_1 >> 8) & 0xff,
		BNXT_ULP_GLB_RF_IDX_GLB_VFR_EM_PROF_ID_1 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "meta",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "meta",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_VF_META_FID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_VF_META_FID & 0xff}
		}
	}
};

struct bnxt_ulp_mapper_field_info ulp_thor_class_key_ext_list[] = {
	/* class_tid: 1, , table: control.dmac_calculation */
	{
	.description = "",
	.field_bit_size = 48,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(6 >> 8) & 0xff,
		6 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_HF,
	.field_opr2 = {
	(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
	BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(1 >> 8) & 0xff,
	1 & 0xff}
	},
	{
		.description = "",
		.field_bit_size = 48,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(8 >> 8) & 0xff,
		8 & 0xff,
		(1 >> 8) & 0xff,
		1 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_PORT_TABLE,
	.field_opr2 = {
		(BNXT_ULP_CF_IDX_DEV_PORT_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_DEV_PORT_ID & 0xff,
		(BNXT_ULP_PORT_TABLE_DRV_FUNC_MAC >> 8) & 0xff,
		BNXT_ULP_PORT_TABLE_DRV_FUNC_MAC & 0xff},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(2 >> 8) & 0xff,
	2 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 48,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(9 >> 8) & 0xff,
		9 & 0xff,
		(1 >> 8) & 0xff,
		1 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_RF,
	.field_opr2 = {
	(BNXT_ULP_RF_IDX_DRV_FUNC_PARENT_MAC >> 8) & 0xff,
	BNXT_ULP_RF_IDX_DRV_FUNC_PARENT_MAC & 0xff},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	/* class_tid: 1, , table: control.terminating_flow */
	{
	.description = "",
	.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(37 >> 8) & 0xff,
		37 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(4 >> 8) & 0xff,
	4 & 0xff}
	},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(39 >> 8) & 0xff,
		39 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(5 >> 8) & 0xff,
	5 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(41 >> 8) & 0xff,
		41 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(6 >> 8) & 0xff,
	6 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(43 >> 8) & 0xff,
		43 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl2_ivv.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(66 >> 8) & 0xff,
		66 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_sip.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(77 >> 8) & 0xff,
		77 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_dip.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(83 >> 8) & 0xff,
		83 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_ttl.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(89 >> 8) & 0xff,
		89 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_prot.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(95 >> 8) & 0xff,
		95 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_qos.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(101 >> 8) & 0xff,
		101 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_src.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(107 >> 8) & 0xff,
		107 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_dst.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(113 >> 8) & 0xff,
		113 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tids.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(118 >> 8) & 0xff,
		118 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_dmac.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(123 >> 8) & 0xff,
		123 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_smac.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(129 >> 8) & 0xff,
		129 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_ovv.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(136 >> 8) & 0xff,
		136 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_ivv.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(144 >> 8) & 0xff,
		144 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(20 >> 8) & 0xff,
	20 & 0xff}
		},
	{
		.description = "l2_ivv.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(148 >> 8) & 0xff,
		148 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(21 >> 8) & 0xff,
	21 & 0xff}
		},
	{
		.description = "l2_ivv.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(152 >> 8) & 0xff,
		152 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_etype.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(160 >> 8) & 0xff,
		160 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_sip.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(168 >> 8) & 0xff,
		168 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(24 >> 8) & 0xff,
	24 & 0xff}
		},
	{
		.description = "l3_sip.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(172 >> 8) & 0xff,
		172 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(25 >> 8) & 0xff,
	25 & 0xff}
		},
	{
		.description = "l3_sip.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(176 >> 8) & 0xff,
		176 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_dip.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(184 >> 8) & 0xff,
		184 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(27 >> 8) & 0xff,
	27 & 0xff}
		},
	{
		.description = "l3_dip.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(188 >> 8) & 0xff,
		188 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(28 >> 8) & 0xff,
	28 & 0xff}
		},
	{
		.description = "l3_dip.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(192 >> 8) & 0xff,
		192 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_ttl.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(200 >> 8) & 0xff,
		200 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(30 >> 8) & 0xff,
	30 & 0xff}
		},
	{
		.description = "l3_ttl.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(204 >> 8) & 0xff,
		204 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(31 >> 8) & 0xff,
	31 & 0xff}
		},
	{
		.description = "l3_ttl.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(208 >> 8) & 0xff,
		208 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_prot.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(216 >> 8) & 0xff,
		216 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(33 >> 8) & 0xff,
	33 & 0xff}
		},
	{
		.description = "l3_prot.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(220 >> 8) & 0xff,
		220 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(34 >> 8) & 0xff,
	34 & 0xff}
		},
	{
		.description = "l3_prot.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(224 >> 8) & 0xff,
		224 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_qos.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(232 >> 8) & 0xff,
		232 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(36 >> 8) & 0xff,
	36 & 0xff}
		},
	{
		.description = "l3_qos.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(236 >> 8) & 0xff,
		236 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(37 >> 8) & 0xff,
	37 & 0xff}
		},
	{
		.description = "l3_qos.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(240 >> 8) & 0xff,
		240 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_src.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
	.field_opr1 = {
		(245 >> 8) & 0xff,
		245 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_src.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
	.field_opr1 = {
		(248 >> 8) & 0xff,
		248 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_dst.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
	.field_opr1 = {
		(252 >> 8) & 0xff,
		252 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_dst.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
	.field_opr1 = {
		(255 >> 8) & 0xff,
		255 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_flags.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(259 >> 8) & 0xff,
		259 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_flags.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(261 >> 8) & 0xff,
		261 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	/* class_tid: 1, , table: control.profile_tcam_priority */
	{
	.description = "",
	.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(264 >> 8) & 0xff,
		264 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(45 >> 8) & 0xff,
	45 & 0xff}
	},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(266 >> 8) & 0xff,
		266 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(46 >> 8) & 0xff,
	46 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(268 >> 8) & 0xff,
		268 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(47 >> 8) & 0xff,
	47 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(270 >> 8) & 0xff,
		270 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(48 >> 8) & 0xff,
	48 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(272 >> 8) & 0xff,
		272 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(49 >> 8) & 0xff,
	49 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(274 >> 8) & 0xff,
		274 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(50 >> 8) & 0xff,
	50 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(276 >> 8) & 0xff,
		276 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(51 >> 8) & 0xff,
	51 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(278 >> 8) & 0xff,
		278 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr3 = {
	2}
		},
	{
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(282 >> 8) & 0xff,
			282 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(53 >> 8) & 0xff,
		53 & 0xff}
		},
	{
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(284 >> 8) & 0xff,
			284 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(54 >> 8) & 0xff,
		54 & 0xff}
		},
	{
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(286 >> 8) & 0xff,
			286 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(290 >> 8) & 0xff,
			290 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(56 >> 8) & 0xff,
		56 & 0xff}
		},
	{
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(292 >> 8) & 0xff,
			292 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(57 >> 8) & 0xff,
		57 & 0xff}
		},
	{
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(294 >> 8) & 0xff,
			294 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(298 >> 8) & 0xff,
			298 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(59 >> 8) & 0xff,
		59 & 0xff}
		},
	{
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(300 >> 8) & 0xff,
			300 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(60 >> 8) & 0xff,
		60 & 0xff}
		},
	{
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(302 >> 8) & 0xff,
			302 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(306 >> 8) & 0xff,
			306 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(62 >> 8) & 0xff,
		62 & 0xff}
		},
	{
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(308 >> 8) & 0xff,
			308 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L4_HDR_TYPE_UDP},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(63 >> 8) & 0xff,
		63 & 0xff}
		},
	{
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(310 >> 8) & 0xff,
			310 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L4_HDR_TYPE_UDP},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(314 >> 8) & 0xff,
			314 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(65 >> 8) & 0xff,
		65 & 0xff}
		},
	{
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(316 >> 8) & 0xff,
			316 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(66 >> 8) & 0xff,
		66 & 0xff}
		},
	{
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(318 >> 8) & 0xff,
			318 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(322 >> 8) & 0xff,
			322 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(68 >> 8) & 0xff,
		68 & 0xff}
		},
	{
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(324 >> 8) & 0xff,
			324 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(69 >> 8) & 0xff,
		69 & 0xff}
		},
	{
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(326 >> 8) & 0xff,
			326 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(330 >> 8) & 0xff,
			330 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(71 >> 8) & 0xff,
		71 & 0xff}
		},
	{
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(332 >> 8) & 0xff,
			332 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(72 >> 8) & 0xff,
		72 & 0xff}
		},
	{
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(334 >> 8) & 0xff,
			334 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(338 >> 8) & 0xff,
			338 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(74 >> 8) & 0xff,
		74 & 0xff}
		},
	{
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(340 >> 8) & 0xff,
			340 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(75 >> 8) & 0xff,
		75 & 0xff}
		},
	{
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(342 >> 8) & 0xff,
			342 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(345 >> 8) & 0xff,
			345 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(77 >> 8) & 0xff,
		77 & 0xff}
		},
	{
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(347 >> 8) & 0xff,
			347 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(78 >> 8) & 0xff,
		78 & 0xff}
		},
	{
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(349 >> 8) & 0xff,
			349 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(79 >> 8) & 0xff,
		79 & 0xff}
		},
	{
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(351 >> 8) & 0xff,
			351 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ONES
		},
	{
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(354 >> 8) & 0xff,
			354 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_ISIP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(81 >> 8) & 0xff,
		81 & 0xff}
		},
	{
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(356 >> 8) & 0xff,
			356 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_ISIP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(82 >> 8) & 0xff,
		82 & 0xff}
		},
	{
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(358 >> 8) & 0xff,
			358 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_ISIP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(83 >> 8) & 0xff,
		83 & 0xff}
		},
	{
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(360 >> 8) & 0xff,
			360 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_ISIP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(364 >> 8) & 0xff,
			364 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(85 >> 8) & 0xff,
		85 & 0xff}
		},
	{
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(366 >> 8) & 0xff,
			366 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(86 >> 8) & 0xff,
		86 & 0xff}
		},
	{
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(368 >> 8) & 0xff,
			368 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(372 >> 8) & 0xff,
			372 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_TYPE_IPV6},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(88 >> 8) & 0xff,
		88 & 0xff}
		},
	{
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(374 >> 8) & 0xff,
			374 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(89 >> 8) & 0xff,
		89 & 0xff}
		},
	{
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(376 >> 8) & 0xff,
			376 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(380 >> 8) & 0xff,
			380 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(91 >> 8) & 0xff,
		91 & 0xff}
		},
	{
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(382 >> 8) & 0xff,
			382 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(92 >> 8) & 0xff,
		92 & 0xff}
		},
	{
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(384 >> 8) & 0xff,
			384 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(388 >> 8) & 0xff,
			388 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(94 >> 8) & 0xff,
		94 & 0xff}
		},
	{
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(390 >> 8) & 0xff,
			390 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(95 >> 8) & 0xff,
		95 & 0xff}
		},
	{
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(392 >> 8) & 0xff,
			392 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(396 >> 8) & 0xff,
			396 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(97 >> 8) & 0xff,
		97 & 0xff}
		},
	{
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(398 >> 8) & 0xff,
			398 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(98 >> 8) & 0xff,
		98 & 0xff}
		},
	{
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(400 >> 8) & 0xff,
			400 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(404 >> 8) & 0xff,
			404 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(100 >> 8) & 0xff,
		100 & 0xff}
		},
	{
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(406 >> 8) & 0xff,
			406 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(101 >> 8) & 0xff,
		101 & 0xff}
		},
	{
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(408 >> 8) & 0xff,
			408 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(413 >> 8) & 0xff,
			413 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L2_TWO_VTAGS_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(419 >> 8) & 0xff,
			419 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L2_VTAG_PRESENT_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(426 >> 8) & 0xff,
			426 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(430 >> 8) & 0xff,
			430 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(433 >> 8) & 0xff,
			433 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L2_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(107 >> 8) & 0xff,
		107 & 0xff}
		},
	{
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(435 >> 8) & 0xff,
			435 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L2_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(439 >> 8) & 0xff,
			439 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(109 >> 8) & 0xff,
		109 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(441 >> 8) & 0xff,
			441 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(110 >> 8) & 0xff,
		110 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(443 >> 8) & 0xff,
			443 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(111 >> 8) & 0xff,
		111 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(445 >> 8) & 0xff,
			445 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(112 >> 8) & 0xff,
		112 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(447 >> 8) & 0xff,
			447 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(451 >> 8) & 0xff,
			451 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(114 >> 8) & 0xff,
		114 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(453 >> 8) & 0xff,
			453 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TUN_HDR_TYPE_GENEVE},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(115 >> 8) & 0xff,
		115 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(455 >> 8) & 0xff,
			455 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TUN_HDR_TYPE_GRE},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(116 >> 8) & 0xff,
		116 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(457 >> 8) & 0xff,
			457 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TUN_HDR_TYPE_UPAR1},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(117 >> 8) & 0xff,
		117 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(459 >> 8) & 0xff,
			459 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TUN_HDR_TYPE_UPAR2},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(466 >> 8) & 0xff,
			466 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(470 >> 8) & 0xff,
			470 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(474 >> 8) & 0xff,
			474 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(478 >> 8) & 0xff,
			478 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL4_HDR_TYPE_UDP},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(482 >> 8) & 0xff,
			482 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(486 >> 8) & 0xff,
			486 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(490 >> 8) & 0xff,
			490 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(125 >> 8) & 0xff,
		125 & 0xff}
		},
	{
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(492 >> 8) & 0xff,
			492 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ONES
		},
	{
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(495 >> 8) & 0xff,
			495 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(127 >> 8) & 0xff,
		127 & 0xff}
		},
	{
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(497 >> 8) & 0xff,
			497 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(500 >> 8) & 0xff,
			500 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL3_HDR_ISIP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(504 >> 8) & 0xff,
			504 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(508 >> 8) & 0xff,
			508 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(512 >> 8) & 0xff,
			512 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(516 >> 8) & 0xff,
			516 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(520 >> 8) & 0xff,
			520 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(532 >> 8) & 0xff,
			532 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL2_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(569 >> 8) & 0xff,
			569 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(577 >> 8) & 0xff,
			577 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(616 >> 8) & 0xff,
			616 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(622 >> 8) & 0xff,
			622 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(628 >> 8) & 0xff,
			628 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(634 >> 8) & 0xff,
			634 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(640 >> 8) & 0xff,
			640 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(646 >> 8) & 0xff,
			646 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(652 >> 8) & 0xff,
			652 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(658 >> 8) & 0xff,
			658 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(664 >> 8) & 0xff,
			664 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(670 >> 8) & 0xff,
			670 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(675 >> 8) & 0xff,
			675 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(679 >> 8) & 0xff,
			679 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(684 >> 8) & 0xff,
			684 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(690 >> 8) & 0xff,
			690 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(696 >> 8) & 0xff,
			696 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(702 >> 8) & 0xff,
			702 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(709 >> 8) & 0xff,
			709 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(717 >> 8) & 0xff,
			717 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(725 >> 8) & 0xff,
			725 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_IO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_IO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(156 >> 8) & 0xff,
		156 & 0xff}
		},
	{
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(729 >> 8) & 0xff,
			729 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OI_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OI_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(157 >> 8) & 0xff,
		157 & 0xff}
		},
	{
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(733 >> 8) & 0xff,
			733 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(741 >> 8) & 0xff,
			741 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_IO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_IO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(159 >> 8) & 0xff,
		159 & 0xff}
		},
	{
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(745 >> 8) & 0xff,
			745 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OI_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OI_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(160 >> 8) & 0xff,
		160 & 0xff}
		},
	{
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(749 >> 8) & 0xff,
			749 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(757 >> 8) & 0xff,
			757 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(765 >> 8) & 0xff,
			765 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(772 >> 8) & 0xff,
			772 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(778 >> 8) & 0xff,
			778 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(784 >> 8) & 0xff,
			784 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(790 >> 8) & 0xff,
			790 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(796 >> 8) & 0xff,
			796 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(802 >> 8) & 0xff,
			802 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(808 >> 8) & 0xff,
			808 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(814 >> 8) & 0xff,
			814 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(820 >> 8) & 0xff,
			820 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(172 >> 8) & 0xff,
		172 & 0xff}
		},
	{
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(823 >> 8) & 0xff,
			823 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(173 >> 8) & 0xff,
		173 & 0xff}
		},
	{
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(826 >> 8) & 0xff,
			826 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(832 >> 8) & 0xff,
			832 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(175 >> 8) & 0xff,
		175 & 0xff}
		},
	{
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(835 >> 8) & 0xff,
			835 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(176 >> 8) & 0xff,
		176 & 0xff}
		},
	{
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(838 >> 8) & 0xff,
			838 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(843 >> 8) & 0xff,
			843 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(178 >> 8) & 0xff,
		178 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(845 >> 8) & 0xff,
			845 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(179 >> 8) & 0xff,
		179 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(847 >> 8) & 0xff,
			847 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(180 >> 8) & 0xff,
		180 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(849 >> 8) & 0xff,
			849 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(181 >> 8) & 0xff,
		181 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(852 >> 8) & 0xff,
			852 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(182 >> 8) & 0xff,
		182 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(855 >> 8) & 0xff,
			855 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(183 >> 8) & 0xff,
		183 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(858 >> 8) & 0xff,
			858 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(863 >> 8) & 0xff,
			863 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_IP_PROTO_UDP},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(185 >> 8) & 0xff,
		185 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(865 >> 8) & 0xff,
			865 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_IP_PROTO_TCP},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(186 >> 8) & 0xff,
		186 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(867 >> 8) & 0xff,
			867 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_IP_PROTO_UDP},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(187 >> 8) & 0xff,
		187 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(869 >> 8) & 0xff,
			869 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(188 >> 8) & 0xff,
		188 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(872 >> 8) & 0xff,
			872 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(189 >> 8) & 0xff,
		189 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(875 >> 8) & 0xff,
			875 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(190 >> 8) & 0xff,
		190 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(878 >> 8) & 0xff,
			878 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(884 >> 8) & 0xff,
			884 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(192 >> 8) & 0xff,
		192 & 0xff}
		},
	{
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(887 >> 8) & 0xff,
			887 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(193 >> 8) & 0xff,
		193 & 0xff}
		},
	{
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(890 >> 8) & 0xff,
			890 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(896 >> 8) & 0xff,
			896 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(195 >> 8) & 0xff,
		195 & 0xff}
		},
	{
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(899 >> 8) & 0xff,
			899 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(196 >> 8) & 0xff,
		196 & 0xff}
		},
	{
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(902 >> 8) & 0xff,
			902 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(908 >> 8) & 0xff,
			908 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(198 >> 8) & 0xff,
		198 & 0xff}
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(911 >> 8) & 0xff,
			911 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(199 >> 8) & 0xff,
		199 & 0xff}
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(914 >> 8) & 0xff,
			914 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(200 >> 8) & 0xff,
		200 & 0xff}
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(917 >> 8) & 0xff,
			917 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_SKIP,
		.field_src3 = BNXT_ULP_FIELD_SRC_CONST
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(921 >> 8) & 0xff,
			921 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(202 >> 8) & 0xff,
		202 & 0xff}
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(924 >> 8) & 0xff,
			924 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(203 >> 8) & 0xff,
		203 & 0xff}
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(927 >> 8) & 0xff,
			927 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(204 >> 8) & 0xff,
		204 & 0xff}
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(930 >> 8) & 0xff,
			930 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_SKIP,
		.field_src3 = BNXT_ULP_FIELD_SRC_CONST
		},
	{
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(934 >> 8) & 0xff,
			934 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(206 >> 8) & 0xff,
		206 & 0xff}
		},
	{
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(937 >> 8) & 0xff,
			937 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(207 >> 8) & 0xff,
		207 & 0xff}
		},
	{
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(940 >> 8) & 0xff,
			940 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(208 >> 8) & 0xff,
		208 & 0xff}
		},
	{
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(943 >> 8) & 0xff,
			943 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_SKIP,
		.field_src3 = BNXT_ULP_FIELD_SRC_CONST
		},
	{
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(947 >> 8) & 0xff,
			947 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(210 >> 8) & 0xff,
		210 & 0xff}
		},
	{
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(950 >> 8) & 0xff,
			950 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(211 >> 8) & 0xff,
		211 & 0xff}
		},
	{
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(953 >> 8) & 0xff,
			953 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(212 >> 8) & 0xff,
		212 & 0xff}
		},
	{
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(956 >> 8) & 0xff,
			956 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_SKIP,
		.field_src3 = BNXT_ULP_FIELD_SRC_CONST
		},
	{
		.description = "tl2_ivv.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(979 >> 8) & 0xff,
		979 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_sip.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(990 >> 8) & 0xff,
		990 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_dip.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(996 >> 8) & 0xff,
		996 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_ttl.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1002 >> 8) & 0xff,
		1002 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_prot.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1008 >> 8) & 0xff,
		1008 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_qos.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1014 >> 8) & 0xff,
		1014 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_src.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1020 >> 8) & 0xff,
		1020 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_dst.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1026 >> 8) & 0xff,
		1026 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tids.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1031 >> 8) & 0xff,
		1031 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_dmac.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1037 >> 8) & 0xff,
		1037 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_smac.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1044 >> 8) & 0xff,
		1044 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_ovv.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1051 >> 8) & 0xff,
		1051 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_ivv.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1059 >> 8) & 0xff,
		1059 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(226 >> 8) & 0xff,
	226 & 0xff}
		},
	{
		.description = "l2_ivv.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1063 >> 8) & 0xff,
		1063 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(227 >> 8) & 0xff,
	227 & 0xff}
		},
	{
		.description = "l2_ivv.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1067 >> 8) & 0xff,
		1067 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_etype.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1075 >> 8) & 0xff,
		1075 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_sip.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1082 >> 8) & 0xff,
		1082 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(230 >> 8) & 0xff,
	230 & 0xff}
		},
	{
		.description = "l3_sip.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1085 >> 8) & 0xff,
		1085 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(231 >> 8) & 0xff,
	231 & 0xff}
		},
	{
		.description = "l3_sip.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1088 >> 8) & 0xff,
		1088 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_dip.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1094 >> 8) & 0xff,
		1094 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(233 >> 8) & 0xff,
	233 & 0xff}
		},
	{
		.description = "l3_dip.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1097 >> 8) & 0xff,
		1097 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(234 >> 8) & 0xff,
	234 & 0xff}
		},
	{
		.description = "l3_dip.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1100 >> 8) & 0xff,
		1100 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_ttl.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1106 >> 8) & 0xff,
		1106 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(236 >> 8) & 0xff,
	236 & 0xff}
		},
	{
		.description = "l3_ttl.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1109 >> 8) & 0xff,
		1109 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(237 >> 8) & 0xff,
	237 & 0xff}
		},
	{
		.description = "l3_ttl.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1112 >> 8) & 0xff,
		1112 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_prot.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1118 >> 8) & 0xff,
		1118 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(239 >> 8) & 0xff,
	239 & 0xff}
		},
	{
		.description = "l3_prot.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1121 >> 8) & 0xff,
		1121 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(240 >> 8) & 0xff,
	240 & 0xff}
		},
	{
		.description = "l3_prot.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1124 >> 8) & 0xff,
		1124 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_qos.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1130 >> 8) & 0xff,
		1130 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(242 >> 8) & 0xff,
	242 & 0xff}
		},
	{
		.description = "l3_qos.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1133 >> 8) & 0xff,
		1133 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(243 >> 8) & 0xff,
	243 & 0xff}
		},
	{
		.description = "l3_qos.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1136 >> 8) & 0xff,
		1136 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_src.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1142 >> 8) & 0xff,
		1142 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(245 >> 8) & 0xff,
	245 & 0xff}
		},
	{
		.description = "l4_src.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1145 >> 8) & 0xff,
		1145 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(246 >> 8) & 0xff,
	246 & 0xff}
		},
	{
		.description = "l4_src.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1148 >> 8) & 0xff,
		1148 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_dst.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1154 >> 8) & 0xff,
		1154 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(248 >> 8) & 0xff,
	248 & 0xff}
		},
	{
		.description = "l4_dst.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1157 >> 8) & 0xff,
		1157 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(249 >> 8) & 0xff,
	249 & 0xff}
		},
	{
		.description = "l4_dst.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1160 >> 8) & 0xff,
		1160 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_flags.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1164 >> 8) & 0xff,
		1164 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_flags.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1166 >> 8) & 0xff,
		1166 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1200 >> 8) & 0xff,
			1200 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1208 >> 8) & 0xff,
			1208 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1247 >> 8) & 0xff,
			1247 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1253 >> 8) & 0xff,
			1253 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1259 >> 8) & 0xff,
			1259 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1265 >> 8) & 0xff,
			1265 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1271 >> 8) & 0xff,
			1271 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1277 >> 8) & 0xff,
			1277 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1283 >> 8) & 0xff,
			1283 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1289 >> 8) & 0xff,
			1289 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1295 >> 8) & 0xff,
			1295 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1301 >> 8) & 0xff,
			1301 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1306 >> 8) & 0xff,
			1306 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1310 >> 8) & 0xff,
			1310 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1316 >> 8) & 0xff,
			1316 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1324 >> 8) & 0xff,
			1324 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1331 >> 8) & 0xff,
			1331 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1337 >> 8) & 0xff,
			1337 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1344 >> 8) & 0xff,
			1344 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1352 >> 8) & 0xff,
			1352 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1360 >> 8) & 0xff,
			1360 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(273 >> 8) & 0xff,
		273 & 0xff}
		},
	{
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1364 >> 8) & 0xff,
			1364 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(274 >> 8) & 0xff,
		274 & 0xff}
		},
	{
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1368 >> 8) & 0xff,
			1368 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1376 >> 8) & 0xff,
			1376 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_IO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_IO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(276 >> 8) & 0xff,
		276 & 0xff}
		},
	{
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1380 >> 8) & 0xff,
			1380 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OI_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OI_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(277 >> 8) & 0xff,
		277 & 0xff}
		},
	{
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1384 >> 8) & 0xff,
			1384 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1392 >> 8) & 0xff,
			1392 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1400 >> 8) & 0xff,
			1400 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1407 >> 8) & 0xff,
			1407 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1413 >> 8) & 0xff,
			1413 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1419 >> 8) & 0xff,
			1419 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1425 >> 8) & 0xff,
			1425 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1431 >> 8) & 0xff,
			1431 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1437 >> 8) & 0xff,
			1437 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1443 >> 8) & 0xff,
			1443 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1449 >> 8) & 0xff,
			1449 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1455 >> 8) & 0xff,
			1455 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(289 >> 8) & 0xff,
		289 & 0xff}
		},
	{
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1458 >> 8) & 0xff,
			1458 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(290 >> 8) & 0xff,
		290 & 0xff}
		},
	{
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1461 >> 8) & 0xff,
			1461 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1467 >> 8) & 0xff,
			1467 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(292 >> 8) & 0xff,
		292 & 0xff}
		},
	{
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1470 >> 8) & 0xff,
			1470 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(293 >> 8) & 0xff,
		293 & 0xff}
		},
	{
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1473 >> 8) & 0xff,
			1473 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1479 >> 8) & 0xff,
			1479 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(295 >> 8) & 0xff,
		295 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1482 >> 8) & 0xff,
			1482 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(296 >> 8) & 0xff,
		296 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1485 >> 8) & 0xff,
			1485 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1491 >> 8) & 0xff,
			1491 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(298 >> 8) & 0xff,
		298 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1494 >> 8) & 0xff,
			1494 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(299 >> 8) & 0xff,
		299 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1497 >> 8) & 0xff,
			1497 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1503 >> 8) & 0xff,
			1503 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(301 >> 8) & 0xff,
		301 & 0xff}
		},
	{
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1506 >> 8) & 0xff,
			1506 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(302 >> 8) & 0xff,
		302 & 0xff}
		},
	{
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1509 >> 8) & 0xff,
			1509 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1515 >> 8) & 0xff,
			1515 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(304 >> 8) & 0xff,
		304 & 0xff}
		},
	{
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1518 >> 8) & 0xff,
			1518 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(305 >> 8) & 0xff,
		305 & 0xff}
		},
	{
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1521 >> 8) & 0xff,
			1521 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1527 >> 8) & 0xff,
			1527 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(307 >> 8) & 0xff,
		307 & 0xff}
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1530 >> 8) & 0xff,
			1530 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(308 >> 8) & 0xff,
		308 & 0xff}
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1533 >> 8) & 0xff,
			1533 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1539 >> 8) & 0xff,
			1539 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(310 >> 8) & 0xff,
		310 & 0xff}
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1542 >> 8) & 0xff,
			1542 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(311 >> 8) & 0xff,
		311 & 0xff}
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1545 >> 8) & 0xff,
			1545 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1551 >> 8) & 0xff,
			1551 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(313 >> 8) & 0xff,
		313 & 0xff}
		},
	{
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1554 >> 8) & 0xff,
			1554 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(314 >> 8) & 0xff,
		314 & 0xff}
		},
	{
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1557 >> 8) & 0xff,
			1557 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1563 >> 8) & 0xff,
			1563 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(316 >> 8) & 0xff,
		316 & 0xff}
		},
	{
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1566 >> 8) & 0xff,
			1566 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(317 >> 8) & 0xff,
		317 & 0xff}
		},
	{
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1569 >> 8) & 0xff,
			1569 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	/* class_tid: 2, , table: control.terminating_flow */
	{
	.description = "",
	.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1598 >> 8) & 0xff,
		1598 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(319 >> 8) & 0xff,
	319 & 0xff}
	},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1600 >> 8) & 0xff,
		1600 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(320 >> 8) & 0xff,
	320 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1602 >> 8) & 0xff,
		1602 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(321 >> 8) & 0xff,
	321 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1604 >> 8) & 0xff,
		1604 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl2_smac.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1619 >> 8) & 0xff,
		1619 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
	.field_src3 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr3 = {
	1}
		},
	{
		.description = "tl2_ivv.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1629 >> 8) & 0xff,
		1629 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_sip.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1640 >> 8) & 0xff,
		1640 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_dip.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1646 >> 8) & 0xff,
		1646 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_ttl.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1652 >> 8) & 0xff,
		1652 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_prot.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1658 >> 8) & 0xff,
		1658 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_qos.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1664 >> 8) & 0xff,
		1664 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_src.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1670 >> 8) & 0xff,
		1670 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_dst.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1676 >> 8) & 0xff,
		1676 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tids.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1681 >> 8) & 0xff,
		1681 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_dmac.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1686 >> 8) & 0xff,
		1686 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_smac.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1692 >> 8) & 0xff,
		1692 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_ovv.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1699 >> 8) & 0xff,
		1699 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_ivv.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1707 >> 8) & 0xff,
		1707 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(336 >> 8) & 0xff,
	336 & 0xff}
		},
	{
		.description = "l2_ivv.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1711 >> 8) & 0xff,
		1711 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(337 >> 8) & 0xff,
	337 & 0xff}
		},
	{
		.description = "l2_ivv.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1715 >> 8) & 0xff,
		1715 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_etype.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1723 >> 8) & 0xff,
		1723 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_sip.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1731 >> 8) & 0xff,
		1731 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(340 >> 8) & 0xff,
	340 & 0xff}
		},
	{
		.description = "l3_sip.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1735 >> 8) & 0xff,
		1735 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(341 >> 8) & 0xff,
	341 & 0xff}
		},
	{
		.description = "l3_sip.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1739 >> 8) & 0xff,
		1739 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_dip.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1747 >> 8) & 0xff,
		1747 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(343 >> 8) & 0xff,
	343 & 0xff}
		},
	{
		.description = "l3_dip.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1751 >> 8) & 0xff,
		1751 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(344 >> 8) & 0xff,
	344 & 0xff}
		},
	{
		.description = "l3_dip.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1755 >> 8) & 0xff,
		1755 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_ttl.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1763 >> 8) & 0xff,
		1763 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(346 >> 8) & 0xff,
	346 & 0xff}
		},
	{
		.description = "l3_ttl.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1767 >> 8) & 0xff,
		1767 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(347 >> 8) & 0xff,
	347 & 0xff}
		},
	{
		.description = "l3_ttl.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1771 >> 8) & 0xff,
		1771 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_prot.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1779 >> 8) & 0xff,
		1779 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(349 >> 8) & 0xff,
	349 & 0xff}
		},
	{
		.description = "l3_prot.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1783 >> 8) & 0xff,
		1783 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(350 >> 8) & 0xff,
	350 & 0xff}
		},
	{
		.description = "l3_prot.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1787 >> 8) & 0xff,
		1787 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_qos.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1795 >> 8) & 0xff,
		1795 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(352 >> 8) & 0xff,
	352 & 0xff}
		},
	{
		.description = "l3_qos.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1799 >> 8) & 0xff,
		1799 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(353 >> 8) & 0xff,
	353 & 0xff}
		},
	{
		.description = "l3_qos.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1803 >> 8) & 0xff,
		1803 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_src.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
	.field_opr1 = {
		(1808 >> 8) & 0xff,
		1808 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_src.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
	.field_opr1 = {
		(1811 >> 8) & 0xff,
		1811 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_dst.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
	.field_opr1 = {
		(1815 >> 8) & 0xff,
		1815 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_dst.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
	.field_opr1 = {
		(1818 >> 8) & 0xff,
		1818 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_flags.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1822 >> 8) & 0xff,
		1822 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_flags.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1824 >> 8) & 0xff,
		1824 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	/* class_tid: 2, , table: control.profile_tcam_priority */
	{
	.description = "",
	.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1827 >> 8) & 0xff,
		1827 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(361 >> 8) & 0xff,
	361 & 0xff}
	},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1829 >> 8) & 0xff,
		1829 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(362 >> 8) & 0xff,
	362 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1831 >> 8) & 0xff,
		1831 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(363 >> 8) & 0xff,
	363 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1833 >> 8) & 0xff,
		1833 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(364 >> 8) & 0xff,
	364 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1835 >> 8) & 0xff,
		1835 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(365 >> 8) & 0xff,
	365 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1837 >> 8) & 0xff,
		1837 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(366 >> 8) & 0xff,
	366 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1839 >> 8) & 0xff,
		1839 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(367 >> 8) & 0xff,
	367 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1841 >> 8) & 0xff,
		1841 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr3 = {
	2}
		},
	{
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1845 >> 8) & 0xff,
			1845 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(369 >> 8) & 0xff,
		369 & 0xff}
		},
	{
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1847 >> 8) & 0xff,
			1847 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(370 >> 8) & 0xff,
		370 & 0xff}
		},
	{
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1849 >> 8) & 0xff,
			1849 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1853 >> 8) & 0xff,
			1853 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(372 >> 8) & 0xff,
		372 & 0xff}
		},
	{
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1855 >> 8) & 0xff,
			1855 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(373 >> 8) & 0xff,
		373 & 0xff}
		},
	{
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1857 >> 8) & 0xff,
			1857 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1861 >> 8) & 0xff,
			1861 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(375 >> 8) & 0xff,
		375 & 0xff}
		},
	{
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1863 >> 8) & 0xff,
			1863 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(376 >> 8) & 0xff,
		376 & 0xff}
		},
	{
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1865 >> 8) & 0xff,
			1865 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1869 >> 8) & 0xff,
			1869 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(378 >> 8) & 0xff,
		378 & 0xff}
		},
	{
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1871 >> 8) & 0xff,
			1871 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L4_HDR_TYPE_UDP},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(379 >> 8) & 0xff,
		379 & 0xff}
		},
	{
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1873 >> 8) & 0xff,
			1873 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L4_HDR_TYPE_UDP},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1877 >> 8) & 0xff,
			1877 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(381 >> 8) & 0xff,
		381 & 0xff}
		},
	{
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1879 >> 8) & 0xff,
			1879 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(382 >> 8) & 0xff,
		382 & 0xff}
		},
	{
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1881 >> 8) & 0xff,
			1881 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1885 >> 8) & 0xff,
			1885 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(384 >> 8) & 0xff,
		384 & 0xff}
		},
	{
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1887 >> 8) & 0xff,
			1887 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(385 >> 8) & 0xff,
		385 & 0xff}
		},
	{
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1889 >> 8) & 0xff,
			1889 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1893 >> 8) & 0xff,
			1893 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(387 >> 8) & 0xff,
		387 & 0xff}
		},
	{
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1895 >> 8) & 0xff,
			1895 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(388 >> 8) & 0xff,
		388 & 0xff}
		},
	{
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1897 >> 8) & 0xff,
			1897 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1901 >> 8) & 0xff,
			1901 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(390 >> 8) & 0xff,
		390 & 0xff}
		},
	{
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1903 >> 8) & 0xff,
			1903 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(391 >> 8) & 0xff,
		391 & 0xff}
		},
	{
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1905 >> 8) & 0xff,
			1905 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1908 >> 8) & 0xff,
			1908 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(393 >> 8) & 0xff,
		393 & 0xff}
		},
	{
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1910 >> 8) & 0xff,
			1910 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(394 >> 8) & 0xff,
		394 & 0xff}
		},
	{
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1912 >> 8) & 0xff,
			1912 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(395 >> 8) & 0xff,
		395 & 0xff}
		},
	{
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1914 >> 8) & 0xff,
			1914 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ONES
		},
	{
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1917 >> 8) & 0xff,
			1917 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_ISIP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(397 >> 8) & 0xff,
		397 & 0xff}
		},
	{
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1919 >> 8) & 0xff,
			1919 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_ISIP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(398 >> 8) & 0xff,
		398 & 0xff}
		},
	{
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1921 >> 8) & 0xff,
			1921 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_ISIP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(399 >> 8) & 0xff,
		399 & 0xff}
		},
	{
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1923 >> 8) & 0xff,
			1923 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_ISIP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1927 >> 8) & 0xff,
			1927 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(401 >> 8) & 0xff,
		401 & 0xff}
		},
	{
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1929 >> 8) & 0xff,
			1929 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(402 >> 8) & 0xff,
		402 & 0xff}
		},
	{
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1931 >> 8) & 0xff,
			1931 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1935 >> 8) & 0xff,
			1935 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_TYPE_IPV6},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(404 >> 8) & 0xff,
		404 & 0xff}
		},
	{
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1937 >> 8) & 0xff,
			1937 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(405 >> 8) & 0xff,
		405 & 0xff}
		},
	{
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1939 >> 8) & 0xff,
			1939 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1943 >> 8) & 0xff,
			1943 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(407 >> 8) & 0xff,
		407 & 0xff}
		},
	{
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1945 >> 8) & 0xff,
			1945 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(408 >> 8) & 0xff,
		408 & 0xff}
		},
	{
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1947 >> 8) & 0xff,
			1947 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1951 >> 8) & 0xff,
			1951 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(410 >> 8) & 0xff,
		410 & 0xff}
		},
	{
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1953 >> 8) & 0xff,
			1953 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(411 >> 8) & 0xff,
		411 & 0xff}
		},
	{
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1955 >> 8) & 0xff,
			1955 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1959 >> 8) & 0xff,
			1959 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(413 >> 8) & 0xff,
		413 & 0xff}
		},
	{
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1961 >> 8) & 0xff,
			1961 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(414 >> 8) & 0xff,
		414 & 0xff}
		},
	{
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1963 >> 8) & 0xff,
			1963 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1967 >> 8) & 0xff,
			1967 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(416 >> 8) & 0xff,
		416 & 0xff}
		},
	{
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1969 >> 8) & 0xff,
			1969 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(417 >> 8) & 0xff,
		417 & 0xff}
		},
	{
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1971 >> 8) & 0xff,
			1971 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1976 >> 8) & 0xff,
			1976 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L2_TWO_VTAGS_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1982 >> 8) & 0xff,
			1982 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L2_VTAG_PRESENT_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1989 >> 8) & 0xff,
			1989 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1993 >> 8) & 0xff,
			1993 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1996 >> 8) & 0xff,
			1996 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L2_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(423 >> 8) & 0xff,
		423 & 0xff}
		},
	{
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1998 >> 8) & 0xff,
			1998 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_L2_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2002 >> 8) & 0xff,
			2002 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(425 >> 8) & 0xff,
		425 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2004 >> 8) & 0xff,
			2004 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(426 >> 8) & 0xff,
		426 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2006 >> 8) & 0xff,
			2006 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(427 >> 8) & 0xff,
		427 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2008 >> 8) & 0xff,
			2008 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(428 >> 8) & 0xff,
		428 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2010 >> 8) & 0xff,
			2010 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2014 >> 8) & 0xff,
			2014 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(430 >> 8) & 0xff,
		430 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2016 >> 8) & 0xff,
			2016 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TUN_HDR_TYPE_GENEVE},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(431 >> 8) & 0xff,
		431 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2018 >> 8) & 0xff,
			2018 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TUN_HDR_TYPE_GRE},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(432 >> 8) & 0xff,
		432 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2020 >> 8) & 0xff,
			2020 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TUN_HDR_TYPE_UPAR1},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(433 >> 8) & 0xff,
		433 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2022 >> 8) & 0xff,
			2022 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TUN_HDR_TYPE_UPAR2},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2029 >> 8) & 0xff,
			2029 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2033 >> 8) & 0xff,
			2033 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2037 >> 8) & 0xff,
			2037 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2041 >> 8) & 0xff,
			2041 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL4_HDR_TYPE_UDP},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2045 >> 8) & 0xff,
			2045 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2049 >> 8) & 0xff,
			2049 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2053 >> 8) & 0xff,
			2053 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(441 >> 8) & 0xff,
		441 & 0xff}
		},
	{
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2055 >> 8) & 0xff,
			2055 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ONES
		},
	{
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2058 >> 8) & 0xff,
			2058 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(443 >> 8) & 0xff,
		443 & 0xff}
		},
	{
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2060 >> 8) & 0xff,
			2060 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2063 >> 8) & 0xff,
			2063 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL3_HDR_ISIP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2067 >> 8) & 0xff,
			2067 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2071 >> 8) & 0xff,
			2071 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2075 >> 8) & 0xff,
			2075 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2079 >> 8) & 0xff,
			2079 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2083 >> 8) & 0xff,
			2083 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_TL3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2115 >> 8) & 0xff,
			2115 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_SKIP,
		.field_src3 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr3 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff}
		},
	{
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2120 >> 8) & 0xff,
			2120 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_SKIP,
		.field_src3 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr3 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff}
		},
	{
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2134 >> 8) & 0xff,
			2134 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2142 >> 8) & 0xff,
			2142 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2181 >> 8) & 0xff,
			2181 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2187 >> 8) & 0xff,
			2187 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2193 >> 8) & 0xff,
			2193 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2199 >> 8) & 0xff,
			2199 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2205 >> 8) & 0xff,
			2205 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2211 >> 8) & 0xff,
			2211 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2217 >> 8) & 0xff,
			2217 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2223 >> 8) & 0xff,
			2223 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2229 >> 8) & 0xff,
			2229 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2235 >> 8) & 0xff,
			2235 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2240 >> 8) & 0xff,
			2240 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2244 >> 8) & 0xff,
			2244 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2249 >> 8) & 0xff,
			2249 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2255 >> 8) & 0xff,
			2255 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2261 >> 8) & 0xff,
			2261 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2267 >> 8) & 0xff,
			2267 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2274 >> 8) & 0xff,
			2274 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2282 >> 8) & 0xff,
			2282 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2290 >> 8) & 0xff,
			2290 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_IO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_IO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(473 >> 8) & 0xff,
		473 & 0xff}
		},
	{
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2294 >> 8) & 0xff,
			2294 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OI_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OI_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(474 >> 8) & 0xff,
		474 & 0xff}
		},
	{
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2298 >> 8) & 0xff,
			2298 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2306 >> 8) & 0xff,
			2306 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_IO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_IO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(476 >> 8) & 0xff,
		476 & 0xff}
		},
	{
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2310 >> 8) & 0xff,
			2310 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OI_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OI_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(477 >> 8) & 0xff,
		477 & 0xff}
		},
	{
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2314 >> 8) & 0xff,
			2314 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2322 >> 8) & 0xff,
			2322 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2330 >> 8) & 0xff,
			2330 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2337 >> 8) & 0xff,
			2337 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2343 >> 8) & 0xff,
			2343 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2349 >> 8) & 0xff,
			2349 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2355 >> 8) & 0xff,
			2355 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2361 >> 8) & 0xff,
			2361 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2367 >> 8) & 0xff,
			2367 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2373 >> 8) & 0xff,
			2373 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2379 >> 8) & 0xff,
			2379 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2385 >> 8) & 0xff,
			2385 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(489 >> 8) & 0xff,
		489 & 0xff}
		},
	{
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2388 >> 8) & 0xff,
			2388 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(490 >> 8) & 0xff,
		490 & 0xff}
		},
	{
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2391 >> 8) & 0xff,
			2391 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2397 >> 8) & 0xff,
			2397 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(492 >> 8) & 0xff,
		492 & 0xff}
		},
	{
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2400 >> 8) & 0xff,
			2400 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(493 >> 8) & 0xff,
		493 & 0xff}
		},
	{
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2403 >> 8) & 0xff,
			2403 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2408 >> 8) & 0xff,
			2408 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(495 >> 8) & 0xff,
		495 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2410 >> 8) & 0xff,
			2410 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(496 >> 8) & 0xff,
		496 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2412 >> 8) & 0xff,
			2412 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(497 >> 8) & 0xff,
		497 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2414 >> 8) & 0xff,
			2414 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(498 >> 8) & 0xff,
		498 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2417 >> 8) & 0xff,
			2417 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(499 >> 8) & 0xff,
		499 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2420 >> 8) & 0xff,
			2420 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(500 >> 8) & 0xff,
		500 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2423 >> 8) & 0xff,
			2423 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2428 >> 8) & 0xff,
			2428 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_IP_PROTO_UDP},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(502 >> 8) & 0xff,
		502 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2430 >> 8) & 0xff,
			2430 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_IP_PROTO_TCP},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(503 >> 8) & 0xff,
		503 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2432 >> 8) & 0xff,
			2432 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR_SYM_IP_PROTO_UDP},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(504 >> 8) & 0xff,
		504 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2434 >> 8) & 0xff,
			2434 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(505 >> 8) & 0xff,
		505 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2437 >> 8) & 0xff,
			2437 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(506 >> 8) & 0xff,
		506 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2440 >> 8) & 0xff,
			2440 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(507 >> 8) & 0xff,
		507 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2443 >> 8) & 0xff,
			2443 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2449 >> 8) & 0xff,
			2449 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(509 >> 8) & 0xff,
		509 & 0xff}
		},
	{
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2452 >> 8) & 0xff,
			2452 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(510 >> 8) & 0xff,
		510 & 0xff}
		},
	{
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2455 >> 8) & 0xff,
			2455 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2461 >> 8) & 0xff,
			2461 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(512 >> 8) & 0xff,
		512 & 0xff}
		},
	{
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2464 >> 8) & 0xff,
			2464 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(513 >> 8) & 0xff,
		513 & 0xff}
		},
	{
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2467 >> 8) & 0xff,
			2467 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2473 >> 8) & 0xff,
			2473 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(515 >> 8) & 0xff,
		515 & 0xff}
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2476 >> 8) & 0xff,
			2476 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(516 >> 8) & 0xff,
		516 & 0xff}
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2479 >> 8) & 0xff,
			2479 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(517 >> 8) & 0xff,
		517 & 0xff}
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2482 >> 8) & 0xff,
			2482 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_S