// SPDX-License-Identifier: BSD-3-Clause
/* Copyright(c) 2014-2023 Broadcom
 * All rights reserved.
 */

#include "ulp_template_db_enum.h"
#include "ulp_template_db_field.h"
#include "ulp_template_struct.h"
#include "ulp_template_db_tbl.h"

/* Mapper templates for header class list */
struct bnxt_ulp_mapper_tmpl_info ulp_thor2_class_tmpl_list[] = {
	/* class_tid: 1, ingress */
	[1] = {
	.device_name = BNXT_ULP_DEVICE_ID_THOR2,
	.num_tbls = 43,
	.start_tbl_idx = 0,
	.reject_info = {
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_FALSE,
		.cond_start_idx = 0,
		.cond_nums = 0 }
	},
	/* class_tid: 2, egress */
	[2] = {
	.device_name = BNXT_ULP_DEVICE_ID_THOR2,
	.num_tbls = 28,
	.start_tbl_idx = 43,
	.reject_info = {
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_FALSE,
		.cond_start_idx = 1655,
		.cond_nums = 0 }
	},
	/* class_tid: 3, ingress */
	[3] = {
	.device_name = BNXT_ULP_DEVICE_ID_THOR2,
	.num_tbls = 35,
	.start_tbl_idx = 71,
	.reject_info = {
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_FALSE,
		.cond_start_idx = 3292,
		.cond_nums = 0 }
	},
	/* class_tid: 4, egress */
	[4] = {
	.device_name = BNXT_ULP_DEVICE_ID_THOR2,
	.num_tbls = 19,
	.start_tbl_idx = 106,
	.reject_info = {
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_FALSE,
		.cond_start_idx = 3296,
		.cond_nums = 0 }
	}
};

struct bnxt_ulp_mapper_tbl_info ulp_thor2_class_tbl_list[] = {
	{ /* class_tid: 1, , table: port_table.get_def_rd */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PORT_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 0,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.key_start_idx = 0,
	.blob_key_bit_size = 10,
	.key_bit_size = 10,
	.key_num_fields = 1,
	.ident_start_idx = 0,
	.ident_nums = 2
	},
	{ /* class_tid: 1, , table: l2_cntxt_tcam_cache.def_rd */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_LOW,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 0,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 1,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 2,
	.ident_nums = 3
	},
	{ /* class_tid: 1, , table: control.check_f1_f2_flow */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 7,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_OR,
		.cond_start_idx = 0,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: tunnel_cache.f1_f2_rd */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_TUNNEL_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 2,
	.blob_key_bit_size = 19,
	.key_bit_size = 19,
	.key_num_fields = 2,
	.ident_start_idx = 5,
	.ident_nums = 3
	},
	{ /* class_tid: 1, , table: control.tunnel_cache_check */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 1, , table: l2_cntxt_tcam.f1_f2_alloc_l2_cntxt */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = CFA_RSUBTYPE_TCAM_L2CTX,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_IDENT,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.ident_start_idx = 8,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: cmm_stat_record.add_stat_tunnel_cache */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CMM_STAT,
	.resource_type = CFA_RSUBTYPE_CMM_ACT,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_CMM_TABLE_ACT,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_NOP_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_CMM_STAT_HNDL_F1,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.result_start_idx = 0,
	.result_bit_size = 128,
	.result_num_fields = 2
	},
	{ /* class_tid: 1, , table: tunnel_cache.f1_f2_wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_TUNNEL_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 4,
	.blob_key_bit_size = 19,
	.key_bit_size = 19,
	.key_num_fields = 2,
	.result_start_idx = 2,
	.result_bit_size = 182,
	.result_num_fields = 5
	},
	{ /* class_tid: 1, , table: control.check_f2_flow */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 9,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: control.dmac_calculation */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 4,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COND_LIST,
		.func_oper_size = 48,
		.func_src1 = BNXT_ULP_FUNC_SRC_KEY_EXT_LIST,
		.func_opr1 = 0,
		.func_dst_opr = BNXT_ULP_RF_IDX_O_DMAC }
	},
	{ /* class_tid: 1, , table: mac_addr_cache.l2_table_rd */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_MAC_ADDR_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 5,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 8,
		.cond_nums = 1 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 6,
	.blob_key_bit_size = 131,
	.key_bit_size = 131,
	.key_num_fields = 9,
	.ident_start_idx = 9,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: control.mac_addr_cache_check */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 11,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 1, , table: l2_cntxt_tcam.allocate_l2_context */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = CFA_RSUBTYPE_TCAM_L2CTX,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 12,
		.cond_nums = 2 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_IDENT,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_APP_PRI_OR_CONST,
	.pri_operand = ULP_THOR2_SYM_L2_CTXT_PRI_APP,
	.ident_start_idx = 10,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: l2_cntxt_tcam.l2_table_create */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = CFA_RSUBTYPE_TCAM_L2CTX,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 14,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_APP_PRI_OR_CONST,
	.pri_operand = ULP_THOR2_SYM_L2_CTXT_PRI_APP,
	.key_start_idx = 15,
	.blob_key_bit_size = 256,
	.key_bit_size = 256,
	.key_num_fields = 24,
	.result_start_idx = 7,
	.result_bit_size = 127,
	.result_num_fields = 17,
	.ident_start_idx = 11,
	.ident_nums = 0
	},
	{ /* class_tid: 1, , table: mac_addr_cache.l2_table_wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_MAC_ADDR_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 18,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 39,
	.blob_key_bit_size = 131,
	.key_bit_size = 131,
	.key_num_fields = 9,
	.result_start_idx = 24,
	.result_bit_size = 94,
	.result_num_fields = 5
	},
	{ /* class_tid: 1, , table: control.check_f1_flow */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 2,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 20,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: cmm_stat_record.f1_flow */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CMM_STAT,
	.resource_type = CFA_RSUBTYPE_CMM_ACT,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_CMM_TABLE_ACT,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 0,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 21,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_NOP_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_CMM_STAT_HNDL_F1,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID_SW_ONLY,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.result_start_idx = 29,
	.result_bit_size = 128,
	.result_num_fields = 2
	},
	{ /* class_tid: 1, , table: control.tunnel_ipv6_sip_check */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.true_message = "reject ipv6 tunnel flow with tunnel source ip",
	.execute_info = {
		.cond_true_goto  = 1023,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_LIST_OR,
		.cond_start_idx = 0,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: control.l2_only_check */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.true_message = "Reject due to missing Ethertype for L2 flows",
	.execute_info = {
		.cond_true_goto  = 1023,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_LIST_OR,
		.cond_start_idx = 1,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: control.terminating_flow */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 34,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COND_LIST,
		.func_oper_size = 8,
		.func_src1 = BNXT_ULP_FUNC_SRC_KEY_EXT_LIST,
		.func_opr1 = 3,
		.func_dst_opr = BNXT_ULP_RF_IDX_TERM_FLOW }
	},
	{ /* class_tid: 1, , table: proto_header_cache.rd */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROTO_HEADER,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 42,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 48,
	.blob_key_bit_size = 74,
	.key_bit_size = 74,
	.key_num_fields = 3,
	.ident_start_idx = 11,
	.ident_nums = 7
	},
	{ /* class_tid: 1, , table: control.proto_header_cache_miss */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 13,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 42,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: hdr_overlap_cache.overlap_check */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_HDR_OVERLAP,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 43,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.key_start_idx = 51,
	.blob_key_bit_size = 10,
	.key_bit_size = 10,
	.key_num_fields = 2,
	.partial_key_start_idx = 53,
	.partial_key_num_fields = 1,
	.partial_key_bit_size = 64,
	.ident_start_idx = 18,
	.ident_nums = 2
	},
	{ /* class_tid: 1, , table: control.overlap_miss */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 43,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 1, , table: profile_tcam.allocate_wc_profile */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = CFA_RSUBTYPE_TCAM_PROF_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 44,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_IDENT,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_APP_PRI_OR_CONST,
	.pri_operand = ULP_THOR2_SYM_PROF_TCAM_PRI_APP,
	.ident_start_idx = 20,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: fkb_select.wc_gen_template */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = CFA_RSUBTYPE_IDX_TBL_WC_FKB,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 44,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_WC_KEY_ID_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 31,
	.result_bit_size = 256,
	.result_num_fields = 172
	},
	{ /* class_tid: 1, , table: hdr_overlap_cache.overlap_wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_HDR_OVERLAP,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 320,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 54,
	.blob_key_bit_size = 10,
	.key_bit_size = 10,
	.key_num_fields = 2,
	.partial_key_start_idx = 56,
	.partial_key_num_fields = 1,
	.partial_key_bit_size = 64,
	.result_start_idx = 203,
	.result_bit_size = 48,
	.result_num_fields = 3
	},
	{ /* class_tid: 1, , table: control.proto_header_rid_alloc */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 320,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 1, , table: fkb_select.em_gen_template_alloc */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = CFA_RSUBTYPE_IDX_TBL_EM_FKB,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 320,
		.cond_nums = 1 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_KEY_ID_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 206,
	.result_bit_size = 256,
	.result_num_fields = 172
	},
	{ /* class_tid: 1, , table: em_key_recipe.alloc_only */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_KEY_RECIPE_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_KEY_RECIPE_TABLE_EM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 321,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_KEY_RECIPE_TBL_OPC_ALLOC_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_RECIPE_ID,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 378,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 1, , table: control.profile_tcam_priority */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 321,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COND_LIST,
		.func_oper_size = 8,
		.func_src1 = BNXT_ULP_FUNC_SRC_KEY_EXT_LIST,
		.func_opr1 = 48,
		.func_dst_opr = BNXT_ULP_RF_IDX_PROF_TCAM_PRIORITY }
	},
	{ /* class_tid: 1, , table: profile_tcam.gen_template */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = CFA_RSUBTYPE_TCAM_PROF_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 337,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_REGFILE,
	.pri_operand  = BNXT_ULP_RF_IDX_PROF_TCAM_PRIORITY,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.key_start_idx = 57,
	.blob_key_bit_size = 256,
	.key_bit_size = 256,
	.key_num_fields = 66,
	.result_start_idx = 378,
	.result_bit_size = 64,
	.result_num_fields = 10,
	.ident_start_idx = 21,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: wm_key_recipe.0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_KEY_RECIPE_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_KEY_RECIPE_TABLE_WM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 568,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_KEY_RECIPE_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_WC_RECIPE_ID,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.key_start_idx = 123,
	.blob_key_bit_size = 0,
	.key_bit_size = 0,
	.key_num_fields = 33,
	.result_start_idx = 388,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 1, , table: proto_header_cache.wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROTO_HEADER,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 986,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 156,
	.blob_key_bit_size = 74,
	.key_bit_size = 74,
	.key_num_fields = 3,
	.result_start_idx = 388,
	.result_bit_size = 106,
	.result_num_fields = 8
	},
	{ /* class_tid: 1, , table: em_flow_conflict_cache.rd */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_EM_FLOW_CONFLICT,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 8,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 986,
		.cond_nums = 2 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 159,
	.blob_key_bit_size = 74,
	.key_bit_size = 74,
	.key_num_fields = 3,
	.ident_start_idx = 22,
	.ident_nums = 1
	},
	{ /* class_tid: 1, , table: control.em_flow_conflict_cache_miss */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 988,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 1, , table: fkb_select.em_gen_template */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = CFA_RSUBTYPE_IDX_TBL_EM_FKB,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 989,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_KEY_ID_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.result_start_idx = 396,
	.result_bit_size = 256,
	.result_num_fields = 172
	},
	{ /* class_tid: 1, , table: em_key_recipe.0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_KEY_RECIPE_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_KEY_RECIPE_TABLE_EM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1246,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_KEY_RECIPE_TBL_OPC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_RECIPE_ID,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.key_start_idx = 162,
	.blob_key_bit_size = 0,
	.key_bit_size = 0,
	.key_num_fields = 33,
	.result_start_idx = 568,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 1, , table: em_flow_conflict_cache.wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_EM_FLOW_CONFLICT,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 2,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1650,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 195,
	.blob_key_bit_size = 74,
	.key_bit_size = 74,
	.key_num_fields = 3,
	.result_start_idx = 568,
	.result_bit_size = 96,
	.result_num_fields = 2
	},
	{ /* class_tid: 1, , table: control.field_sig_validation */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 3,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 1650,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_EQ,
		.func_src1 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr1 = BNXT_ULP_RF_IDX_FLOW_SIG_ID,
		.func_src2 = BNXT_ULP_FUNC_SRC_COMP_FIELD,
		.func_opr2 = BNXT_ULP_CF_IDX_FLOW_SIG_ID,
		.func_dst_opr = BNXT_ULP_RF_IDX_CC }
	},
	{ /* class_tid: 1, , table: em_normal.ingress_generic_template */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_EM_TABLE,
	.resource_type = TF_MEM_INTERNAL,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 2,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 1652,
		.cond_nums = 2 },
	.tbl_opcode = BNXT_ULP_EM_TBL_OPC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_INSERT_FAIL,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_DYN_KEY,
	.key_recipe_operand = BNXT_ULP_RF_IDX_EM_RECIPE_ID,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_YES,
	.result_start_idx = 570,
	.result_bit_size = 0,
	.result_num_fields = 17
	},
	{ /* class_tid: 1, , table: control.em_add_check */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 1654,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 1, , table: wm_normal.ingress_generic_template */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = CFA_RSUBTYPE_TCAM_WC,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 0,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1655,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_WC_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_DYN_KEY,
	.key_recipe_operand = BNXT_ULP_RF_IDX_WC_RECIPE_ID,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_YES,
	.result_start_idx = 587,
	.result_bit_size = 128,
	.result_num_fields = 15
	},
	{ /* class_tid: 2, , table: port_table.get_def_rd */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PORT_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1655,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.key_start_idx = 198,
	.blob_key_bit_size = 10,
	.key_bit_size = 10,
	.key_num_fields = 1,
	.ident_start_idx = 23,
	.ident_nums = 1
	},
	{ /* class_tid: 2, , table: l2_cntxt_tcam_cache.def_rd */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_LOW,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1655,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 199,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 24,
	.ident_nums = 2
	},
	{ /* class_tid: 2, , table: control.l2_only_check */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.true_message = "Reject due to missing Ethertype for L2 flows",
	.execute_info = {
		.cond_true_goto  = 1023,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_LIST_OR,
		.cond_start_idx = 3,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 2, , table: control.tunnel_ipv6_sip_check */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.true_message = "reject ipv6 tunnel flow with tunnel source ip or source mac",
	.execute_info = {
		.cond_true_goto  = 1023,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_LIST_OR,
		.cond_start_idx = 5,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 2, , table: control.terminating_flow */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1673,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COND_LIST,
		.func_oper_size = 8,
		.func_src1 = BNXT_ULP_FUNC_SRC_KEY_EXT_LIST,
		.func_opr1 = 316,
		.func_dst_opr = BNXT_ULP_RF_IDX_TERM_FLOW }
	},
	{ /* class_tid: 2, , table: proto_header_cache.rd */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROTO_HEADER,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1681,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 200,
	.blob_key_bit_size = 74,
	.key_bit_size = 74,
	.key_num_fields = 3,
	.ident_start_idx = 26,
	.ident_nums = 7
	},
	{ /* class_tid: 2, , table: control.proto_header_cache_miss */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 13,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 1681,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 2, , table: hdr_overlap_cache.overlap_check */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_HDR_OVERLAP,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1682,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.key_start_idx = 203,
	.blob_key_bit_size = 10,
	.key_bit_size = 10,
	.key_num_fields = 2,
	.partial_key_start_idx = 205,
	.partial_key_num_fields = 1,
	.partial_key_bit_size = 64,
	.ident_start_idx = 33,
	.ident_nums = 2
	},
	{ /* class_tid: 2, , table: control.overlap_miss */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 1682,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 2, , table: profile_tcam.allocate_wc_profile */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_PROF_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1683,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_IDENT,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.ident_start_idx = 35,
	.ident_nums = 1
	},
	{ /* class_tid: 2, , table: fkb_select.wc_gen_template */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = CFA_RSUBTYPE_IDX_TBL_WC_FKB,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1683,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_WC_KEY_ID_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 602,
	.result_bit_size = 256,
	.result_num_fields = 172
	},
	{ /* class_tid: 2, , table: hdr_overlap_cache.overlap_wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_HDR_OVERLAP,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1961,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 206,
	.blob_key_bit_size = 10,
	.key_bit_size = 10,
	.key_num_fields = 2,
	.partial_key_start_idx = 208,
	.partial_key_num_fields = 1,
	.partial_key_bit_size = 64,
	.result_start_idx = 774,
	.result_bit_size = 48,
	.result_num_fields = 3
	},
	{ /* class_tid: 2, , table: control.proto_header_rid_alloc */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1961,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 2, , table: fkb_select.em_gen_template_alloc */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = CFA_RSUBTYPE_IDX_TBL_EM_FKB,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 1961,
		.cond_nums = 1 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_KEY_ID_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 777,
	.result_bit_size = 256,
	.result_num_fields = 172
	},
	{ /* class_tid: 2, , table: em_key_recipe.alloc_only */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_KEY_RECIPE_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_KEY_RECIPE_TABLE_EM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1962,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_KEY_RECIPE_TBL_OPC_ALLOC_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_RECIPE_ID,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 949,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 2, , table: control.profile_tcam_priority */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1962,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_COND_LIST,
		.func_oper_size = 8,
		.func_src1 = BNXT_ULP_FUNC_SRC_KEY_EXT_LIST,
		.func_opr1 = 362,
		.func_dst_opr = BNXT_ULP_RF_IDX_PROF_TCAM_PRIORITY }
	},
	{ /* class_tid: 2, , table: profile_tcam.gen_template */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = CFA_RSUBTYPE_TCAM_PROF_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 1978,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_REGFILE,
	.pri_operand  = BNXT_ULP_RF_IDX_PROF_TCAM_PRIORITY,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_NO,
	.key_start_idx = 209,
	.blob_key_bit_size = 256,
	.key_bit_size = 256,
	.key_num_fields = 66,
	.result_start_idx = 949,
	.result_bit_size = 64,
	.result_num_fields = 10,
	.ident_start_idx = 36,
	.ident_nums = 1
	},
	{ /* class_tid: 2, , table: wm_key_recipe.0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_KEY_RECIPE_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_KEY_RECIPE_TABLE_WM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2201,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_KEY_RECIPE_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_WC_RECIPE_ID,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.key_start_idx = 275,
	.blob_key_bit_size = 0,
	.key_bit_size = 0,
	.key_num_fields = 33,
	.result_start_idx = 959,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 2, , table: proto_header_cache.wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROTO_HEADER,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2623,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 308,
	.blob_key_bit_size = 74,
	.key_bit_size = 74,
	.key_num_fields = 3,
	.result_start_idx = 959,
	.result_bit_size = 106,
	.result_num_fields = 8
	},
	{ /* class_tid: 2, , table: em_flow_conflict_cache.rd */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_EM_FLOW_CONFLICT,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 8,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2623,
		.cond_nums = 2 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 311,
	.blob_key_bit_size = 74,
	.key_bit_size = 74,
	.key_num_fields = 3,
	.ident_start_idx = 37,
	.ident_nums = 1
	},
	{ /* class_tid: 2, , table: control.em_flow_conflict_cache_miss */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 2625,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 2, , table: fkb_select.em_gen_template */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = CFA_RSUBTYPE_IDX_TBL_EM_FKB,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2626,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_KEY_ID_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.result_start_idx = 967,
	.result_bit_size = 256,
	.result_num_fields = 172
	},
	{ /* class_tid: 2, , table: em_key_recipe.0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_KEY_RECIPE_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_KEY_RECIPE_TABLE_EM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 2883,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_KEY_RECIPE_TBL_OPC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_RECIPE_ID,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.key_start_idx = 314,
	.blob_key_bit_size = 0,
	.key_bit_size = 0,
	.key_num_fields = 33,
	.result_start_idx = 1139,
	.result_bit_size = 0,
	.result_num_fields = 0
	},
	{ /* class_tid: 2, , table: em_flow_conflict_cache.wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_EM_FLOW_CONFLICT,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 2,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3287,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 347,
	.blob_key_bit_size = 74,
	.key_bit_size = 74,
	.key_num_fields = 3,
	.result_start_idx = 1139,
	.result_bit_size = 96,
	.result_num_fields = 2
	},
	{ /* class_tid: 2, , table: control.field_sig_validation */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 3,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3287,
		.cond_nums = 2 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_EQ,
		.func_src1 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr1 = BNXT_ULP_RF_IDX_FLOW_SIG_ID,
		.func_src2 = BNXT_ULP_FUNC_SRC_COMP_FIELD,
		.func_opr2 = BNXT_ULP_CF_IDX_FLOW_SIG_ID,
		.func_dst_opr = BNXT_ULP_RF_IDX_CC }
	},
	{ /* class_tid: 2, , table: em_normal.egress_generic_template */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_EM_TABLE,
	.resource_type = TF_MEM_INTERNAL,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 2,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3289,
		.cond_nums = 2 },
	.tbl_opcode = BNXT_ULP_EM_TBL_OPC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_EM_INSERT_FAIL,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_DYN_KEY,
	.key_recipe_operand = BNXT_ULP_RF_IDX_EM_RECIPE_ID,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_YES,
	.result_start_idx = 1141,
	.result_bit_size = 0,
	.result_num_fields = 17
	},
	{ /* class_tid: 2, , table: control.em_add_check */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3291,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP
	},
	{ /* class_tid: 2, , table: wm_normal.egress_generic_template */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = CFA_RSUBTYPE_TCAM_WC,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 0,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3292,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_WC_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_DYN_KEY,
	.key_recipe_operand = BNXT_ULP_RF_IDX_WC_RECIPE_ID,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_CONST,
	.pri_operand = 0,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.critical_resource = BNXT_ULP_CRITICAL_RESOURCE_YES,
	.result_start_idx = 1158,
	.result_bit_size = 128,
	.result_num_fields = 15
	},
	{ /* class_tid: 3, , table: metadata_record.act_rx_wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = CFA_RSUBTYPE_IDX_TBL_METADATA_ACT,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_CFA_TBLS,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3292,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_WR_GLB_REGFILE,
	.tbl_operand = BNXT_ULP_GLB_RF_IDX_GLB_METADATA_RX_ACT_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.result_start_idx = 1173,
	.result_bit_size = 32,
	.result_num_fields = 1
	},
	{ /* class_tid: 3, , table: metadata_record.prof_rx_wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = CFA_RSUBTYPE_IDX_TBL_METADATA_PROF,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_CFA_TBLS,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3292,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_WR_GLB_REGFILE,
	.tbl_operand = BNXT_ULP_GLB_RF_IDX_GLB_METADATA_RX_PROF_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.result_start_idx = 1174,
	.result_bit_size = 32,
	.result_num_fields = 1
	},
	{ /* class_tid: 3, , table: metadata_record.lkup_rx_wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = CFA_RSUBTYPE_IDX_TBL_METADATA_LKUP,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_CFA_TBLS,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3292,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_WR_GLB_REGFILE,
	.tbl_operand = BNXT_ULP_GLB_RF_IDX_GLB_METADATA_RX_LKUP_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.result_start_idx = 1175,
	.result_bit_size = 32,
	.result_num_fields = 1
	},
	{ /* class_tid: 3, , table: metadata_record.act_tx_wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = CFA_RSUBTYPE_IDX_TBL_METADATA_ACT,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_CFA_TBLS,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3292,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_WR_GLB_REGFILE,
	.tbl_operand = BNXT_ULP_GLB_RF_IDX_GLB_METADATA_TX_ACT_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.result_start_idx = 1176,
	.result_bit_size = 32,
	.result_num_fields = 1
	},
	{ /* class_tid: 3, , table: metadata_record.prof_tx_wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = CFA_RSUBTYPE_IDX_TBL_METADATA_PROF,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_CFA_TBLS,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3292,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_WR_GLB_REGFILE,
	.tbl_operand = BNXT_ULP_GLB_RF_IDX_GLB_METADATA_TX_PROF_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.result_start_idx = 1177,
	.result_bit_size = 32,
	.result_num_fields = 1
	},
	{ /* class_tid: 3, , table: metadata_record.lkup_tx_wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE,
	.resource_type = CFA_RSUBTYPE_IDX_TBL_METADATA_LKUP,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_CFA_TBLS,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3292,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_WR_GLB_REGFILE,
	.tbl_operand = BNXT_ULP_GLB_RF_IDX_GLB_METADATA_TX_LKUP_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.result_start_idx = 1178,
	.result_bit_size = 32,
	.result_num_fields = 1
	},
	{ /* class_tid: 3, , table: table_scope_cache.tsid_ing_rd */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_TABLE_SCOPE_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3292,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 350,
	.blob_key_bit_size = 6,
	.key_bit_size = 6,
	.key_num_fields = 2,
	.ident_start_idx = 38,
	.ident_nums = 2
	},
	{ /* class_tid: 3, , table: control.ts_ing_rd_check */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 6,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3292,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 3, , table: cmm_full_act_record.ing_default_0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CMM_TABLE,
	.resource_type = CFA_RSUBTYPE_CMM_ACT,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_CMM_TABLE_ACT,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3293,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_CMM_ACT_HNDL,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.result_start_idx = 1179,
	.result_bit_size = 192,
	.result_num_fields = 18
	},
	{ /* class_tid: 3, , table: cmm_full_act_record.ing_default_1 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CMM_TABLE,
	.resource_type = CFA_RSUBTYPE_CMM_ACT,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_CMM_TABLE_ACT,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3293,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_CMM_ACT_HNDL,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.result_start_idx = 1197,
	.result_bit_size = 192,
	.result_num_fields = 18
	},
	{ /* class_tid: 3, , table: control.act_handle_to_offset */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3293,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_HANDLE_TO_OFFSET,
		.func_src1 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr1 = BNXT_ULP_RF_IDX_CMM_ACT_HNDL,
		.func_src2 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr2 = 32,
		.func_dst_opr = BNXT_ULP_RF_IDX_DEFAULT_AREC_PTR }
	},
	{ /* class_tid: 3, , table: profile_tcam_bypass.ing_catch_all */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = CFA_RSUBTYPE_TCAM_PROF_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3293,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_APP_PRI_OR_CONST,
	.pri_operand = ULP_THOR2_SYM_PROF_TCAM_PRI_CATCHALL,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.key_start_idx = 352,
	.blob_key_bit_size = 256,
	.key_bit_size = 256,
	.key_num_fields = 66,
	.result_start_idx = 1215,
	.result_bit_size = 65,
	.result_num_fields = 7,
	.ident_start_idx = 40,
	.ident_nums = 1
	},
	{ /* class_tid: 3, , table: table_scope_cache.tsid_ing_wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_TABLE_SCOPE_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3293,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 418,
	.blob_key_bit_size = 6,
	.key_bit_size = 6,
	.key_num_fields = 2,
	.result_start_idx = 1222,
	.result_bit_size = 88,
	.result_num_fields = 5
	},
	{ /* class_tid: 3, , table: port_table.ing_wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PORT_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3293,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 420,
	.blob_key_bit_size = 10,
	.key_bit_size = 10,
	.key_num_fields = 1,
	.result_start_idx = 1227,
	.result_bit_size = 169,
	.result_num_fields = 6
	},
	{ /* class_tid: 3, , table: l2_cntxt_tcam_cache.ing_rd */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3293,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 421,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 41,
	.ident_nums = 1
	},
	{ /* class_tid: 3, , table: control.ing_rd_check */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3293,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 3, , table: l2_cntxt_tcam.svif_ing */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = CFA_RSUBTYPE_TCAM_L2CTX,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3294,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_APP_PRI_OR_CONST,
	.pri_operand = ULP_THOR2_SYM_L2_CTXT_PRI_CATCHALL,
	.key_start_idx = 422,
	.blob_key_bit_size = 256,
	.key_bit_size = 256,
	.key_num_fields = 24,
	.result_start_idx = 1233,
	.result_bit_size = 127,
	.result_num_fields = 17,
	.ident_start_idx = 42,
	.ident_nums = 1
	},
	{ /* class_tid: 3, , table: l2_cntxt_tcam_cache.ing_wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3294,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 446,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.result_start_idx = 1250,
	.result_bit_size = 94,
	.result_num_fields = 5
	},
	{ /* class_tid: 3, , table: cmm_full_act_record.throw_away_egr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CMM_TABLE,
	.resource_type = CFA_RSUBTYPE_CMM_ACT,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_CMM_TABLE_ACT,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3294,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_CMM_ACT_HNDL,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.result_start_idx = 1255,
	.result_bit_size = 192,
	.result_num_fields = 18,
	.encap_num_fields = 0
	},
	{ /* class_tid: 3, , table: cmm_full_act_record.egr_default_0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CMM_TABLE,
	.resource_type = CFA_RSUBTYPE_CMM_ACT,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_CMM_TABLE_ACT,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3294,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_CMM_ACT_HNDL,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.result_start_idx = 1273,
	.result_bit_size = 192,
	.result_num_fields = 18,
	.encap_num_fields = 0
	},
	{ /* class_tid: 3, , table: port_table.egr_wr_0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PORT_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3294,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_HANDLE_TO_OFFSET,
		.func_src1 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr1 = BNXT_ULP_RF_IDX_CMM_ACT_HNDL,
		.func_src2 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr2 = 32,
		.func_dst_opr = BNXT_ULP_RF_IDX_MAIN_ACTION_PTR },
	.key_start_idx = 447,
	.blob_key_bit_size = 10,
	.key_bit_size = 10,
	.key_num_fields = 1,
	.result_start_idx = 1291,
	.result_bit_size = 169,
	.result_num_fields = 6
	},
	{ /* class_tid: 3, , table: ilt_tbl.egr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_IF_TABLE,
	.resource_type = CFA_RSUBTYPE_IF_TBL_ILT,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3294,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_IF_TBL_OPC_WR_COMP_FIELD,
	.tbl_operand = BNXT_ULP_CF_IDX_DRV_FUNC_SVIF,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.result_start_idx = 1297,
	.result_bit_size = 128,
	.result_num_fields = 14
	},
	{ /* class_tid: 3, , table: l2_cntxt_tcam_cache.no_vfr_egr_rd */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3294,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 448,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 43,
	.ident_nums = 0
	},
	{ /* class_tid: 3, , table: control.non_vfr_egr_rd_check */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3294,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 3, , table: l2_cntxt_tcam.non_vfr_svif_egr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = CFA_RSUBTYPE_TCAM_L2CTX,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3295,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_APP_PRI_OR_CONST,
	.pri_operand = ULP_THOR2_SYM_L2_CTXT_PRI_APP,
	.key_start_idx = 449,
	.blob_key_bit_size = 256,
	.key_bit_size = 256,
	.key_num_fields = 24,
	.result_start_idx = 1311,
	.result_bit_size = 127,
	.result_num_fields = 17,
	.ident_start_idx = 43,
	.ident_nums = 2
	},
	{ /* class_tid: 3, , table: profile_tcam_bypass.non_vfr_egr_catch_all */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = CFA_RSUBTYPE_TCAM_PROF_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3295,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_APP_PRI_OR_CONST,
	.pri_operand = ULP_THOR2_SYM_PROF_TCAM_PRI_CATCHALL,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.key_start_idx = 473,
	.blob_key_bit_size = 256,
	.key_bit_size = 256,
	.key_num_fields = 66,
	.result_start_idx = 1328,
	.result_bit_size = 65,
	.result_num_fields = 7,
	.ident_start_idx = 45,
	.ident_nums = 0
	},
	{ /* class_tid: 3, , table: l2_cntxt_tcam_cache.non_vfr_egr_wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3295,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 539,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.result_start_idx = 1335,
	.result_bit_size = 94,
	.result_num_fields = 5
	},
	{ /* class_tid: 3, , table: table_scope_cache.tsid_vfr_rd */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_TABLE_SCOPE_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3295,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 540,
	.blob_key_bit_size = 6,
	.key_bit_size = 6,
	.key_num_fields = 2,
	.ident_start_idx = 45,
	.ident_nums = 1
	},
	{ /* class_tid: 3, , table: control.tsid_vfr_rd_check */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3295,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 3, , table: mod_record.svif2meta */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CMM_TABLE,
	.resource_type = CFA_RSUBTYPE_CMM_ACT,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_CMM_TABLE_ACT,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3296,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_CMM_MOD_HNDL,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.result_start_idx = 1340,
	.result_bit_size = 0,
	.result_num_fields = 0,
	.encap_num_fields = 20
	},
	{ /* class_tid: 3, , table: control.mod_handle_to_offset_svif2meta */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3296,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_HANDLE_TO_OFFSET,
		.func_src1 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr1 = BNXT_ULP_RF_IDX_CMM_MOD_HNDL,
		.func_src2 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr2 = 8,
		.func_dst_opr = BNXT_ULP_RF_IDX_MODIFY_PTR }
	},
	{ /* class_tid: 3, , table: cmm_full_act_record.ing_vf2vf */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CMM_TABLE,
	.resource_type = CFA_RSUBTYPE_CMM_ACT,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_CMM_TABLE_ACT,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3296,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_CMM_ACT_HNDL,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.result_start_idx = 1360,
	.result_bit_size = 192,
	.result_num_fields = 18
	},
	{ /* class_tid: 3, , table: control.act_handle_to_offset_ing_vf2vf */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3296,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_HANDLE_TO_OFFSET,
		.func_src1 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr1 = BNXT_ULP_RF_IDX_CMM_ACT_HNDL,
		.func_src2 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr2 = 32,
		.func_dst_opr = BNXT_ULP_RF_IDX_DEFAULT_AREC_PTR }
	},
	{ /* class_tid: 3, , table: l2_cntxt_tcam.vf2vf_ing */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = CFA_RSUBTYPE_TCAM_L2CTX,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3296,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_APP_PRI_OR_CONST,
	.pri_operand = ULP_THOR2_SYM_L2_CTXT_PRI_APP,
	.key_start_idx = 542,
	.blob_key_bit_size = 256,
	.key_bit_size = 256,
	.key_num_fields = 24,
	.result_start_idx = 1378,
	.result_bit_size = 127,
	.result_num_fields = 17,
	.ident_start_idx = 46,
	.ident_nums = 1
	},
	{ /* class_tid: 3, , table: table_scope_cache.tsid_vfr_wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_TABLE_SCOPE_CACHE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 0,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3296,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 566,
	.blob_key_bit_size = 6,
	.key_bit_size = 6,
	.key_num_fields = 2,
	.result_start_idx = 1395,
	.result_bit_size = 88,
	.result_num_fields = 5
	},
	{ /* class_tid: 4, , table: table_scope_cache.tsid_vfr_egr_rd */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_TABLE_SCOPE_CACHE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3296,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 568,
	.blob_key_bit_size = 6,
	.key_bit_size = 6,
	.key_num_fields = 2,
	.ident_start_idx = 47,
	.ident_nums = 3
	},
	{ /* class_tid: 4, , table: control.tsid_vfr_egr_check */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 7,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3296,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 4, , table: mod_record.meta2uplink */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CMM_TABLE,
	.resource_type = CFA_RSUBTYPE_CMM_ACT,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_CMM_TABLE_ACT,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3297,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_CMM_MOD_HNDL,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_BIT_OR,
		.func_src1 = BNXT_ULP_FUNC_SRC_COMP_FIELD,
		.func_opr1 = BNXT_ULP_CF_IDX_DRV_FUNC_VNIC,
		.func_src2 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr2 = ULP_THOR2_SYM_VF_2_VF_META_VAL,
		.func_dst_opr = BNXT_ULP_RF_IDX_RF_0 },
	.result_start_idx = 1400,
	.result_bit_size = 0,
	.result_num_fields = 0,
	.encap_num_fields = 20
	},
	{ /* class_tid: 4, , table: control.mod_handle_to_offset_meta2uplink */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3297,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_HANDLE_TO_OFFSET,
		.func_src1 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr1 = BNXT_ULP_RF_IDX_CMM_MOD_HNDL,
		.func_src2 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr2 = 8,
		.func_dst_opr = BNXT_ULP_RF_IDX_MODIFY_PTR }
	},
	{ /* class_tid: 4, , table: cmm_full_act_record.endpoint_def_act */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CMM_TABLE,
	.resource_type = CFA_RSUBTYPE_CMM_ACT,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_CMM_TABLE_ACT,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3297,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_CMM_ACT_HNDL,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.result_start_idx = 1420,
	.result_bit_size = 192,
	.result_num_fields = 18
	},
	{ /* class_tid: 4, , table: control.act_handle_to_offset_endpoint_def_act */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3297,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_HANDLE_TO_OFFSET,
		.func_src1 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr1 = BNXT_ULP_RF_IDX_CMM_ACT_HNDL,
		.func_src2 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr2 = 32,
		.func_dst_opr = BNXT_ULP_RF_IDX_DEFAULT_AREC_PTR }
	},
	{ /* class_tid: 4, , table: profile_tcam_bypass.tsid_vfr_egr_catch_all */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = CFA_RSUBTYPE_TCAM_PROF_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3297,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_APP_PRI_OR_CONST,
	.pri_operand = ULP_THOR2_SYM_PROF_TCAM_PRI_CATCHALL,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.key_start_idx = 570,
	.blob_key_bit_size = 256,
	.key_bit_size = 256,
	.key_num_fields = 66,
	.result_start_idx = 1438,
	.result_bit_size = 65,
	.result_num_fields = 7,
	.ident_start_idx = 50,
	.ident_nums = 1
	},
	{ /* class_tid: 4, , table: table_scope_cache.tsid_vfr_egr_wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_TABLE_SCOPE_CACHE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3297,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 636,
	.blob_key_bit_size = 6,
	.key_bit_size = 6,
	.key_num_fields = 2,
	.result_start_idx = 1445,
	.result_bit_size = 88,
	.result_num_fields = 5
	},
	{ /* class_tid: 4, , table: l2_cntxt_tcam_cache.endpoint_def_egr_rd */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_LOW,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3297,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 638,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 51,
	.ident_nums = 1
	},
	{ /* class_tid: 4, , table: control.endpoint_def_egr_rd_check */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 4,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 3297,
		.cond_nums = 1 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID
	},
	{ /* class_tid: 4, , table: l2_cntxt_tcam.vf2vf_egr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE,
	.resource_type = CFA_RSUBTYPE_TCAM_L2CTX,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3298,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE,
	.fdb_operand = BNXT_ULP_RF_IDX_RID,
	.pri_opcode  = BNXT_ULP_PRI_OPC_APP_PRI_OR_CONST,
	.pri_operand = ULP_THOR2_SYM_L2_CTXT_PRI_CATCHALL,
	.key_start_idx = 639,
	.blob_key_bit_size = 256,
	.key_bit_size = 256,
	.key_num_fields = 24,
	.result_start_idx = 1450,
	.result_bit_size = 127,
	.result_num_fields = 17,
	.ident_start_idx = 52,
	.ident_nums = 1
	},
	{ /* class_tid: 4, , table: l2_cntxt_tcam_cache.endpoint_def_egr_wr */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_type = TF_TCAM_TBL_TYPE_L2_CTXT_TCAM_LOW,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3298,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_READ,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 663,
	.blob_key_bit_size = 11,
	.key_bit_size = 11,
	.key_num_fields = 1,
	.ident_start_idx = 53,
	.ident_nums = 3
	},
	{ /* class_tid: 4, , table: port_table.egr_wr_0 */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PORT_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3298,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_GENERIC_TBL_OPC_WRITE,
	.gen_tbl_lkup_type = BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.key_start_idx = 664,
	.blob_key_bit_size = 10,
	.key_bit_size = 10,
	.key_num_fields = 1,
	.result_start_idx = 1467,
	.result_bit_size = 169,
	.result_num_fields = 6
	},
	{ /* class_tid: 4, , table: mod_record.vfr2vf */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CMM_TABLE,
	.resource_type = CFA_RSUBTYPE_CMM_ACT,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_CMM_TABLE_ACT,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3298,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_CMM_MOD_HNDL,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_BIT_OR,
		.func_src1 = BNXT_ULP_FUNC_SRC_COMP_FIELD,
		.func_opr1 = BNXT_ULP_CF_IDX_VF_FUNC_VNIC,
		.func_src2 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr2 = ULP_THOR2_SYM_VF_2_VF_META_VAL,
		.func_dst_opr = BNXT_ULP_RF_IDX_RF_0 },
	.result_start_idx = 1473,
	.result_bit_size = 0,
	.result_num_fields = 0,
	.encap_num_fields = 20
	},
	{ /* class_tid: 4, , table: control.mod_handle_to_offset_vfr2vf */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3298,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_HANDLE_TO_OFFSET,
		.func_src1 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr1 = BNXT_ULP_RF_IDX_CMM_MOD_HNDL,
		.func_src2 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr2 = 8,
		.func_dst_opr = BNXT_ULP_RF_IDX_MODIFY_PTR }
	},
	{ /* class_tid: 4, , table: cmm_full_act_record.vfr2vf_act */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CMM_TABLE,
	.resource_type = CFA_RSUBTYPE_CMM_ACT,
	.resource_sub_type =
		BNXT_ULP_RESOURCE_SUB_TYPE_CMM_TABLE_ACT,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3298,
		.cond_nums = 0 },
	.tbl_opcode = BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE,
	.tbl_operand = BNXT_ULP_RF_IDX_CMM_ACT_HNDL,
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_PUSH_FID,
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_NOP,
	.result_start_idx = 1493,
	.result_bit_size = 192,
	.result_num_fields = 18
	},
	{ /* class_tid: 4, , table: control.act_handle_to_offset_vfr2vf_act */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3298,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_HANDLE_TO_OFFSET,
		.func_src1 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr1 = BNXT_ULP_RF_IDX_CMM_ACT_HNDL,
		.func_src2 = BNXT_ULP_FUNC_SRC_CONST,
		.func_opr2 = 32,
		.func_dst_opr = BNXT_ULP_RF_IDX_MAIN_ACTION_PTR }
	},
	{ /* class_tid: 4, , table: control.bd_act_set */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_TX,
	.execute_info = {
		.cond_true_goto  = 1,
		.cond_false_goto = 1,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3298,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_BD_ACT_SET,
		.func_src1 = BNXT_ULP_FUNC_SRC_COMP_FIELD,
		.func_opr1 = BNXT_ULP_CF_IDX_DEV_PORT_ID,
		.func_src2 = BNXT_ULP_FUNC_SRC_REGFILE,
		.func_opr2 = BNXT_ULP_RF_IDX_MAIN_ACTION_PTR,
		.func_dst_opr = BNXT_ULP_RF_IDX_CC }
	},
	{ /* class_tid: 4, , table: control.vfr_mark_set */
	.resource_func = BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE,
	.direction = TF_DIR_RX,
	.execute_info = {
		.cond_true_goto  = 0,
		.cond_false_goto = 0,
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_TRUE,
		.cond_start_idx = 3298,
		.cond_nums = 0 },
	.key_recipe_opcode = BNXT_ULP_KEY_RECIPE_OPC_NOP,
	.fdb_opcode = BNXT_ULP_FDB_OPC_NOP,
	.func_info = {
		.func_opc = BNXT_ULP_FUNC_OPC_VFR_MARK_SET,
		.func_src1 = BNXT_ULP_FUNC_SRC_COMP_FIELD,
		.func_opr1 = BNXT_ULP_CF_IDX_VF_FUNC_SVIF,
		.func_src2 = BNXT_ULP_FUNC_SRC_COMP_FIELD,
		.func_opr2 = BNXT_ULP_CF_IDX_DEV_PORT_ID,
		.func_dst_opr = BNXT_ULP_RF_IDX_CC },
	.mark_db_opcode = BNXT_ULP_MARK_DB_OPC_PUSH_AND_SET_VFR_FLAG
	}
};

struct bnxt_ulp_mapper_cond_list_info ulp_thor2_class_cond_oper_list[] = {
	/* cond_execute: class_tid: 1, control.tunnel_ipv6_sip_check:21*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 21,
		.cond_nums = 3
	},
	/* cond_execute: class_tid: 1, control.l2_only_check:24*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 24,
		.cond_nums = 5
	},
	/* cond_execute: class_tid: 1, control.l2_only_check:24*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 29,
		.cond_nums = 5
	},
	/* cond_execute: class_tid: 2, control.l2_only_check:1655*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 1655,
		.cond_nums = 5
	},
	/* cond_execute: class_tid: 2, control.l2_only_check:1655*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 1660,
		.cond_nums = 5
	},
	/* cond_execute: class_tid: 2, control.tunnel_ipv6_sip_check:1665*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 1665,
		.cond_nums = 4
	},
	/* cond_execute: class_tid: 2, control.tunnel_ipv6_sip_check:1665*/
	{
		.cond_list_opcode = BNXT_ULP_COND_LIST_OPC_AND,
		.cond_start_idx = 1669,
		.cond_nums = 4
	}
};

struct bnxt_ulp_mapper_cond_info ulp_thor2_class_cond_list[] = {
	/* cond_execute: class_tid: 1, control.check_f1_f2_flow:0*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F1
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F2
	},
	/* cond_execute: class_tid: 1, control.tunnel_cache_check:2*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 1, control.check_f2_flow:3*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F2
	},
	/* field_cond: class_tid: 1, control.dmac_calculation:4*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, control.dmac_calculation:6*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_PORT_DMAC
	},
	/* field_cond: class_tid: 1, control.dmac_calculation:7*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET,
	.cond_operand = BNXT_ULP_FEATURE_BIT_PARENT_DMAC
	},
	/* cond_execute: class_tid: 1, mac_addr_cache.l2_table_rd:8*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_O_DMAC
	},
	/* field_cond: class_tid: 1, mac_addr_cache.l2_table_rd:9*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, mac_addr_cache.l2_table_rd:10*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	/* cond_execute: class_tid: 1, control.mac_addr_cache_check:11*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 1, l2_cntxt_tcam.allocate_l2_context:12*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F1
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F2
	},
	/* field_cond: class_tid: 1, l2_cntxt_tcam.l2_table_create:14*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	/* field_cond: class_tid: 1, l2_cntxt_tcam.l2_table_create:15*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	/* field_cond: class_tid: 1, l2_cntxt_tcam.l2_table_create:16*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, l2_cntxt_tcam.l2_table_create:17*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, mac_addr_cache.l2_table_wr:18*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, mac_addr_cache.l2_table_wr:19*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	/* cond_execute: class_tid: 1, control.check_f1_flow:20*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F1
	},
	/* cond_execute: class_tid: 1, control.tunnel_ipv6_sip_check:21*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* cond_execute: class_tid: 1, control.l2_only_check:24*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* cond_execute: class_tid: 1, control.l2_only_check:24*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 1, control.terminating_flow:34*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, control.terminating_flow:36*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, control.terminating_flow:38*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, control.terminating_flow:40*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* cond_execute: class_tid: 1, control.proto_header_cache_miss:42*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 1, control.overlap_miss:43*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:44*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:45*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:46*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:47*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:48*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:51*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:54*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:58*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:62*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:66*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:70*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:73*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:76*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:79*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:82*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:85*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:88*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:91*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:94*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:97*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:100*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:103*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:106*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:109*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:112*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:115*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:118*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:121*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:124*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:127*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:130*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:132*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:134*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:137*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:140*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:143*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:146*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:150*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:154*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:158*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:162*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:166*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:170*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:174*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:178*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:182*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:186*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:190*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:194*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:198*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:202*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:206*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:210*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:214*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:218*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:222*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:226*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:230*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:234*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:238*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:242*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:246*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:250*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:254*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:258*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:262*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:266*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:270*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:274*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:278*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:282*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:286*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:290*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:294*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:298*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:302*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:306*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:307*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ICMP
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:310*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ICMP
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:313*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:314*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ICMP
	},
	/* field_cond: class_tid: 1, fkb_select.wc_gen_template:317*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ICMP
	},
	/* cond_execute: class_tid: 1, fkb_select.em_gen_template_alloc:320*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_TERM_FLOW
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:321*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:323*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:325*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:327*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:329*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:331*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:333*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, control.profile_tcam_priority:335*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:337*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:339*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:341*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:343*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:345*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:347*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:349*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:351*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:353*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:355*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:357*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:359*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:361*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:363*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:365*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:367*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:369*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:371*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:373*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:375*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:377*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:379*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:381*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:383*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:385*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:387*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:389*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:391*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:393*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:395*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:397*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:399*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:401*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:403*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:405*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:407*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:409*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:411*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:413*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:415*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:417*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:419*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:421*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:423*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:425*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:427*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:429*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:431*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:433*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:435*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:437*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:439*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:441*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:443*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:445*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:447*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:449*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:452*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:455*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:458*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:461*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:462*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:463*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:465*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:467*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:469*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:471*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:473*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:475*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:477*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:479*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GENEVE
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:481*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GRE
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:483*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR1
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:485*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR2
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:487*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:489*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:491*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GENEVE
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:493*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GRE
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:495*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR1
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:497*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR2
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:499*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:500*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:501*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:502*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:504*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:506*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:508*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:510*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:512*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:514*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:516*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:518*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:520*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:522*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:524*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:526*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:528*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:530*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:531*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:533*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:535*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:536*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:538*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:540*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:542*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:544*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:546*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:548*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:550*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:552*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:554*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:556*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:559*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:562*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:563*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:564*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 1, profile_tcam.gen_template:566*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_F2
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:568*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:569*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:570*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:571*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:572*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:573*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:574*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:577*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:580*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:583*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:586*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:590*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:594*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:598*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:602*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:606*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:610*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:614*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:618*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:621*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:624*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:627*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:630*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:633*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:636*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:639*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:642*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:645*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:648*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:651*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:654*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:657*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:660*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:663*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:666*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:669*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:672*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:675*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:678*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:681*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:684*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:687*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:690*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:693*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:696*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:699*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:702*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:704*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:706*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:708*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:710*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:713*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:716*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:719*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:722*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:725*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:728*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:731*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:734*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:738*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:742*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:746*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:750*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:754*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:758*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:762*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:766*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:770*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:774*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:778*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:782*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:786*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:790*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:794*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:798*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:801*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:804*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:807*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:810*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:813*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:816*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:819*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:822*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:825*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:828*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:831*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:834*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:837*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:840*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:843*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:846*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:849*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:852*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:855*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:858*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:861*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:864*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:867*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:870*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:872*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:874*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:876*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:878*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:881*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:884*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:887*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:890*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:892*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:894*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:896*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:898*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:901*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:904*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:907*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:910*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:913*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:916*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:919*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:922*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:925*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:928*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:931*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:934*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:937*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:940*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:943*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:946*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:947*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:950*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:953*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:956*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:959*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:960*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:963*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:966*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:969*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:972*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:973*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:976*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:979*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:982*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, wm_key_recipe.0:985*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* cond_execute: class_tid: 1, em_flow_conflict_cache.rd:986*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_NOT_SET,
	.cond_operand = BNXT_ULP_CF_IDX_WC_MATCH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_TERM_FLOW
	},
	/* cond_execute: class_tid: 1, control.em_flow_conflict_cache_miss:988*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:989*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:990*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:991*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:992*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:993*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:997*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1000*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1004*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1008*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1012*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1016*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1019*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1022*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1025*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1028*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1031*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1034*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1037*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1040*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1043*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1046*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1049*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1052*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1055*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1058*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1061*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1064*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1067*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1070*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1073*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1076*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1078*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1080*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1084*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1088*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1091*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1094*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1098*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1102*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1106*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1110*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1114*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1118*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1122*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1126*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1129*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1132*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1135*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1138*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1141*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1144*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1147*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1150*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1153*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1156*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1159*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1162*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1165*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1168*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1171*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1174*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1177*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1180*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1183*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1186*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1189*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1192*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1195*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1198*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1201*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1204*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1207*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1210*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1213*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1216*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1219*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1222*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1225*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1228*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1231*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1234*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1237*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1240*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, fkb_select.em_gen_template:1243*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1246*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1247*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1248*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1249*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1250*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1251*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1252*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1256*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1260*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1263*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1266*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1270*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1274*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1278*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1282*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1286*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1290*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1294*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1298*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1301*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1304*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1307*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1310*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1313*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1316*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1319*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1322*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1325*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1328*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1331*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1334*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1337*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1340*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1343*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1346*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1349*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1352*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1355*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1358*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1361*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1364*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1367*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1370*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1373*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1376*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1379*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1382*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1384*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1386*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1388*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1390*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1394*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1398*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1402*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1406*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1409*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1412*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1415*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1418*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1422*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1426*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1430*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1434*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1438*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1442*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1446*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1450*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1454*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1458*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1462*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1466*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1470*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1474*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1478*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1482*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1485*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1488*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1491*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1494*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1497*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1500*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1503*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1506*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1509*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1512*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1515*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1518*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1521*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1524*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1527*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1530*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1533*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1536*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1539*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1542*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1545*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1548*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1551*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1554*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1557*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1560*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1563*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1566*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1569*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1572*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1575*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1578*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1581*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1584*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1587*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1590*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1593*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1596*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1599*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1602*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1605*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1608*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1611*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1614*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1617*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1620*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1623*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1626*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1629*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1632*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1635*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1638*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1641*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1644*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 1, em_key_recipe.0:1647*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* cond_execute: class_tid: 1, control.field_sig_validation:1650*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_CC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_FLOW_SIG_ID
	},
	/* cond_execute: class_tid: 1, em_normal.ingress_generic_template:1652*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_NOT_SET,
	.cond_operand = BNXT_ULP_CF_IDX_WC_MATCH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_TERM_FLOW
	},
	/* cond_execute: class_tid: 1, control.em_add_check:1654*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_EM_INSERT_FAIL
	},
	/* cond_execute: class_tid: 2, control.l2_only_check:1655*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* cond_execute: class_tid: 2, control.l2_only_check:1655*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* cond_execute: class_tid: 2, control.tunnel_ipv6_sip_check:1665*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* cond_execute: class_tid: 2, control.tunnel_ipv6_sip_check:1665*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, control.terminating_flow:1673*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, control.terminating_flow:1675*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, control.terminating_flow:1677*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, control.terminating_flow:1679*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* cond_execute: class_tid: 2, control.proto_header_cache_miss:1681*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 2, control.overlap_miss:1682*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1683*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1684*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1685*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1686*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1687*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1690*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1693*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1695*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1699*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1703*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1707*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1711*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1714*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1717*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1720*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1723*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1726*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1729*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1732*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1735*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1738*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1741*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1744*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1747*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1750*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1753*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1756*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1759*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1762*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1765*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1768*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1771*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1773*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1775*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1778*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1781*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1784*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1787*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1791*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1795*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1799*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1803*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1807*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1811*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1815*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1819*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1823*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1827*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1831*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1835*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1839*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1843*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1847*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1851*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1855*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1859*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1863*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1867*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1871*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1875*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1879*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1883*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1887*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1891*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1895*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1899*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1903*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1907*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1911*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1915*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1919*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1923*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1927*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1931*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1935*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1939*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1943*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1947*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1948*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ICMP
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1951*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ICMP
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1954*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1955*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ICMP
	},
	/* field_cond: class_tid: 2, fkb_select.wc_gen_template:1958*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ICMP
	},
	/* cond_execute: class_tid: 2, fkb_select.em_gen_template_alloc:1961*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_TERM_FLOW
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:1962*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:1964*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:1966*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:1968*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:1970*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:1972*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:1974*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, control.profile_tcam_priority:1976*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1978*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1980*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1982*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1984*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1986*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1988*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1990*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1992*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1994*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1996*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:1998*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2000*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2002*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2004*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2006*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2008*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2010*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2012*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2014*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2016*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2018*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2020*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2022*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2024*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2026*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2028*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2030*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2032*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2034*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2036*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2038*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2040*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2042*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2044*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2046*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2048*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2050*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2052*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2054*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2056*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2058*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2060*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2062*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2064*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2066*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2068*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2070*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2072*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2074*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2076*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2078*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2080*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2082*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2084*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2086*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2088*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2090*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2093*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2096*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2099*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2102*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2103*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2104*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2106*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2108*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2110*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2112*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2114*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2116*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2118*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2120*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GENEVE
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2122*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GRE
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2124*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR1
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2126*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR2
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2128*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2130*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2132*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GENEVE
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2134*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_GRE
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2136*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR1
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2138*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_UPAR2
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2140*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2141*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2142*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2143*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2145*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2147*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2149*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2151*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2153*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2155*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2157*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2159*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2161*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2163*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2165*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2167*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2169*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2171*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2173*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2175*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2177*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2179*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2181*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2183*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2185*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2187*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2189*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2191*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2194*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2197*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2198*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_DIX_TRAFFIC
	},
	/* field_cond: class_tid: 2, profile_tcam.gen_template:2199*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2201*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2202*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2203*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2204*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2205*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2206*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2207*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2210*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2213*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2216*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2218*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2221*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2223*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2227*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2231*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2235*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2239*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2243*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2247*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2251*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2255*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2258*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2261*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2264*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2267*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2270*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2273*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2276*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2279*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2282*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2285*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2288*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2291*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2294*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2297*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2300*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2303*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2306*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2309*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2312*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2315*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2318*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2321*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2324*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2327*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2330*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2333*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2336*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2339*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2341*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2343*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2345*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2347*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2350*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2353*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2356*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2359*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2362*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2365*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2368*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2371*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2375*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2379*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2383*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2387*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2391*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2395*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2399*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2403*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2407*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2411*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2415*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2419*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2423*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2427*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2431*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2435*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2438*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2441*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2444*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2447*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2450*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2453*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2456*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2459*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2462*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2465*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2468*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2471*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2474*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2477*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2480*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2483*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2486*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2489*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2492*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2495*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2498*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2501*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2504*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2507*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2509*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2511*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2513*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2515*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2518*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2521*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2524*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2527*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2529*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2531*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2533*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2535*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2538*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2541*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2544*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2547*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2550*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2553*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2556*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2559*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2562*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2565*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2568*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2571*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2574*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2577*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2580*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2583*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2584*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2587*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2590*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2593*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2596*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2597*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2600*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2603*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2606*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2609*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2610*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2613*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2616*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2619*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, wm_key_recipe.0:2622*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	/* cond_execute: class_tid: 2, em_flow_conflict_cache.rd:2623*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_NOT_SET,
	.cond_operand = BNXT_ULP_CF_IDX_WC_MATCH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_TERM_FLOW
	},
	/* cond_execute: class_tid: 2, control.em_flow_conflict_cache_miss:2625*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2626*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2627*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2628*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2629*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2630*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2634*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2637*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2641*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2645*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2649*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2653*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2656*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2659*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2662*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2665*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2668*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2671*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2674*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2677*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2680*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2683*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2686*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2689*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2692*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2695*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2698*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2701*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2704*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2707*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2710*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2713*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2715*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2717*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2721*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2725*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2728*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2731*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2735*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2739*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2743*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2747*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2751*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2755*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2759*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2763*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2766*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2769*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2772*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2775*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2778*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2781*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2784*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2787*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2790*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2793*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2796*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2799*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2802*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2805*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2808*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2811*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2814*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2817*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2820*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2823*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2826*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2829*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2832*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2835*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2838*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2841*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2844*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2847*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2850*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2853*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2856*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2859*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2862*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2865*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2868*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2871*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2874*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2877*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, fkb_select.em_gen_template:2880*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2883*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2884*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_CNTXT_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2885*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2886*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_METADATA
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2887*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2888*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_RECYCLE_CNT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2889*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2893*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2897*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2900*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2903*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2907*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2911*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2915*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2919*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2923*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2927*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2931*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2935*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2938*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2941*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2944*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2947*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2950*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2953*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2956*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2959*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2962*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2965*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2968*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2971*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2974*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2977*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2980*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2983*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2986*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2989*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2992*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2995*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:2998*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3001*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3004*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3007*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3010*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3013*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3016*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3019*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3021*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3023*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3025*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_T_VXLAN_GPE
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3027*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3031*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3035*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_DMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3039*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_DMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3043*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3046*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3049*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_SMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3052*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_SMAC
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3055*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3059*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3063*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3067*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3071*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3075*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3079*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3083*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3087*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_II_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3091*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_IO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_II_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_IO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3095*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OI_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3099*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OO_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_OI_VLAN
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_OO_VLAN_VID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3103*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3107*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3111*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_ETH_TYPE
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3115*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_L2_ONLY
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_ETH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_ETH_TYPE
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3119*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3122*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3125*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3128*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3131*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3134*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3137*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3140*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3143*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3146*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3149*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3152*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3155*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3158*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3161*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3164*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3167*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3170*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3173*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3176*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3179*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3182*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3185*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3188*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_TTL
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3191*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3194*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3197*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3200*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3203*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3206*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3209*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3212*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3215*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3218*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3221*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3224*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3227*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV6_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3230*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_IPV4_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3233*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV6
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV6_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3236*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_IPV4
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_IPV4_QOS
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3239*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3242*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3245*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3248*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3251*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3254*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3257*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3260*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3263*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3266*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3269*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3272*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3275*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3278*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_IS_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_I_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3281*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_UDP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT
	},
	/* field_cond: class_tid: 2, em_key_recipe.0:3284*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_BIT_NOT_SET,
	.cond_operand = BNXT_ULP_CF_BIT_IS_TUNNEL
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_HDR_BIT_IS_SET,
	.cond_operand = BNXT_ULP_HDR_BIT_O_TCP
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET,
	.cond_operand = BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT
	},
	/* cond_execute: class_tid: 2, control.field_sig_validation:3287*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_NOT_SET,
	.cond_operand = BNXT_ULP_RF_IDX_CC
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_FLOW_SIG_ID
	},
	/* cond_execute: class_tid: 2, em_normal.egress_generic_template:3289*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_CF_NOT_SET,
	.cond_operand = BNXT_ULP_CF_IDX_WC_MATCH
	},
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_TERM_FLOW
	},
	/* cond_execute: class_tid: 2, control.em_add_check:3291*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_EM_INSERT_FAIL
	},
	/* cond_execute: class_tid: 3, control.ts_ing_rd_check:3292*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 3, control.ing_rd_check:3293*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 3, control.non_vfr_egr_rd_check:3294*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 3, control.tsid_vfr_rd_check:3295*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 4, control.tsid_vfr_egr_check:3296*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	},
	/* cond_execute: class_tid: 4, control.endpoint_def_egr_rd_check:3297*/
	{
	.cond_opcode = BNXT_ULP_COND_OPC_RF_IS_SET,
	.cond_operand = BNXT_ULP_RF_IDX_GENERIC_TBL_MISS
	}
};

struct bnxt_ulp_mapper_key_info ulp_thor2_class_key_info_list[] = {
	/* class_tid: 1, , table: port_table.get_def_rd */
	{
	.field_info_mask = {
		.description = "dev.port_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "dev.port_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_DEV_PORT_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_DEV_PORT_ID & 0xff}
		}
	},
	/* class_tid: 1, , table: l2_cntxt_tcam_cache.def_rd */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	/* class_tid: 1, , table: tunnel_cache.f1_f2_rd */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_TUNNEL_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_TUNNEL_ID & 0xff}
		}
	},
	/* class_tid: 1, , table: tunnel_cache.f1_f2_wr */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_TUNNEL_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_TUNNEL_ID & 0xff}
		}
	},
	/* class_tid: 1, , table: mac_addr_cache.l2_table_rd */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tun_hdr",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "one_tag",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "one_tag",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "mac_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_O_DMAC >> 8) & 0xff,
		BNXT_ULP_RF_IDX_O_DMAC & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(9 >> 8) & 0xff,
			9 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(10 >> 8) & 0xff,
			10 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tbl_scope",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tbl_scope",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 1, , table: l2_cntxt_tcam.l2_table_create */
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "addr1",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "addr1",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "addr0",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "addr0",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_O_DMAC >> 8) & 0xff,
		BNXT_ULP_RF_IDX_O_DMAC & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "out_tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "out_tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2ip_func",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2ip_func",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(14 >> 8) & 0xff,
			14 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(15 >> 8) & 0xff,
			15 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_CONST
		}
	},
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "parif",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "parif",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(16 >> 8) & 0xff,
			16 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(17 >> 8) & 0xff,
			17 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_CONST
		}
	},
	{
	.field_info_mask = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		3}
		},
	.field_info_spec = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spare",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spare",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 1, , table: mac_addr_cache.l2_table_wr */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tun_hdr",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "one_tag",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "one_tag",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mac_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "mac_addr",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_O_DMAC >> 8) & 0xff,
		BNXT_ULP_RF_IDX_O_DMAC & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(18 >> 8) & 0xff,
			18 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(19 >> 8) & 0xff,
			19 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tbl_scope",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tbl_scope",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 1, , table: proto_header_cache.rd */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PROFILE_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PROFILE_BITMAP & 0xff}
		}
	},
	/* class_tid: 1, , table: hdr_overlap_cache.overlap_check */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	/* class_tid: 1, , table: hdr_overlap_cache.overlap_check */
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_HDR_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_HDR_BITMAP & 0xff}
		}
	},
	/* class_tid: 1, , table: hdr_overlap_cache.overlap_wr */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	/* class_tid: 1, , table: hdr_overlap_cache.overlap_wr */
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_HDR_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_HDR_BITMAP & 0xff}
		}
	},
	/* class_tid: 1, , table: profile_tcam.gen_template */
	{
	.field_info_mask = {
		.description = "l4_hdr_dcn_present",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_dcn_present",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_flags",
		.field_bit_size = 9,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_flags",
		.field_bit_size = 9,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_subtype",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_subtype",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(337 >> 8) & 0xff,
			337 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(56 >> 8) & 0xff,
		56 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(345 >> 8) & 0xff,
			345 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(59 >> 8) & 0xff,
		59 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(353 >> 8) & 0xff,
			353 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(62 >> 8) & 0xff,
		62 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(361 >> 8) & 0xff,
			361 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(65 >> 8) & 0xff,
		65 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(369 >> 8) & 0xff,
			369 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(68 >> 8) & 0xff,
		68 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(377 >> 8) & 0xff,
			377 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(71 >> 8) & 0xff,
		71 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(385 >> 8) & 0xff,
			385 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(74 >> 8) & 0xff,
		74 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(393 >> 8) & 0xff,
			393 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(77 >> 8) & 0xff,
		77 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3_protocol",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_protocol",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(401 >> 8) & 0xff,
			401 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(80 >> 8) & 0xff,
		80 & 0xff}
		},
	.field_info_spec = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(409 >> 8) & 0xff,
			409 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L3_HDR_TYPE_IPV6},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(83 >> 8) & 0xff,
		83 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(417 >> 8) & 0xff,
			417 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(86 >> 8) & 0xff,
		86 & 0xff}
		},
	.field_info_spec = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(425 >> 8) & 0xff,
			425 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(89 >> 8) & 0xff,
		89 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(433 >> 8) & 0xff,
			433 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(92 >> 8) & 0xff,
		92 & 0xff}
		},
	.field_info_spec = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(441 >> 8) & 0xff,
			441 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(95 >> 8) & 0xff,
		95 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(449 >> 8) & 0xff,
			449 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L2_TWO_VTAGS_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(98 >> 8) & 0xff,
		98 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(455 >> 8) & 0xff,
			455 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L2_VTAG_PRESENT_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(99 >> 8) & 0xff,
		99 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(461 >> 8) & 0xff,
			461 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(462 >> 8) & 0xff,
			462 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(463 >> 8) & 0xff,
			463 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(100 >> 8) & 0xff,
		100 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(467 >> 8) & 0xff,
			467 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(101 >> 8) & 0xff,
		101 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(471 >> 8) & 0xff,
			471 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L2_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(102 >> 8) & 0xff,
		102 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_flags",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_flags",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(475 >> 8) & 0xff,
			475 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(103 >> 8) & 0xff,
		103 & 0xff}
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(487 >> 8) & 0xff,
			487 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(108 >> 8) & 0xff,
		108 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(499 >> 8) & 0xff,
			499 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(500 >> 8) & 0xff,
			500 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(501 >> 8) & 0xff,
			501 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TUN_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(502 >> 8) & 0xff,
			502 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(113 >> 8) & 0xff,
		113 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(506 >> 8) & 0xff,
			506 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TL4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(114 >> 8) & 0xff,
		114 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(510 >> 8) & 0xff,
			510 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(115 >> 8) & 0xff,
		115 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(514 >> 8) & 0xff,
			514 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(116 >> 8) & 0xff,
		116 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(518 >> 8) & 0xff,
			518 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(117 >> 8) & 0xff,
		117 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(522 >> 8) & 0xff,
			522 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(118 >> 8) & 0xff,
		118 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(526 >> 8) & 0xff,
			526 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(119 >> 8) & 0xff,
		119 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(531 >> 8) & 0xff,
			531 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TL4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(121 >> 8) & 0xff,
		121 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(536 >> 8) & 0xff,
			536 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(123 >> 8) & 0xff,
		123 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(540 >> 8) & 0xff,
			540 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TL3_HDR_TYPE_IPV6},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(124 >> 8) & 0xff,
		124 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(544 >> 8) & 0xff,
			544 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(125 >> 8) & 0xff,
		125 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(548 >> 8) & 0xff,
			548 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(126 >> 8) & 0xff,
		126 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(552 >> 8) & 0xff,
			552 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TL3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(127 >> 8) & 0xff,
		127 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(556 >> 8) & 0xff,
			556 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TL2_TWO_VTAGS_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(559 >> 8) & 0xff,
			559 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TL2_VTAG_PRESENT_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(562 >> 8) & 0xff,
			562 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(563 >> 8) & 0xff,
			563 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(564 >> 8) & 0xff,
			564 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TL2_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(128 >> 8) & 0xff,
		128 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "ot_hdr_flags",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ot_hdr_flags",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "ot_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ot_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "ot_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ot_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "ot_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ot_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl4_hdr_is_tcp_udp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl4_hdr_is_tcp_udp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "int_ifa_tail",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "int_ifa_tail",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "int_hdr_group",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "int_hdr_group",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "int_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "int_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "hrec_next",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "hrec_next",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2ip_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2ip_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_count",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_count",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "pkt_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spare",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spare",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	{
	.field_info_mask = {
		.description = "padding",
		.field_bit_size = 72,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "padding",
		.field_bit_size = 72,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 1, , table: wm_key_recipe.0 */
	{
	.field_info_mask = {
		.description = "wc_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "wc_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_WC_PROFILE_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_WC_PROFILE_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_cntxt_id",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(568 >> 8) & 0xff,
			568 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "l2_cntxt_id",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(569 >> 8) & 0xff,
			569 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "meta",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(570 >> 8) & 0xff,
			570 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "meta",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(571 >> 8) & 0xff,
			571 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr2 = {
		(BNXT_ULP_CF_IDX_VF_META_FID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_VF_META_FID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "rcyc_cnt",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(572 >> 8) & 0xff,
			572 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "rcyc_cnt",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(573 >> 8) & 0xff,
			573 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_RECYCLE_CNT >> 8) & 0xff,
		BNXT_ULP_RF_IDX_RECYCLE_CNT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(574 >> 8) & 0xff,
			574 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(577 >> 8) & 0xff,
			577 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(580 >> 8) & 0xff,
			580 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(583 >> 8) & 0xff,
			583 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(586 >> 8) & 0xff,
			586 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(590 >> 8) & 0xff,
			590 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(594 >> 8) & 0xff,
			594 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OI_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OI_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(129 >> 8) & 0xff,
		129 & 0xff}
		},
	.field_info_spec = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(602 >> 8) & 0xff,
			602 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OI_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OI_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(130 >> 8) & 0xff,
		130 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(610 >> 8) & 0xff,
			610 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(614 >> 8) & 0xff,
			614 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(618 >> 8) & 0xff,
			618 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(621 >> 8) & 0xff,
			621 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(624 >> 8) & 0xff,
			624 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_SKIP,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(627 >> 8) & 0xff,
			627 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_SKIP,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(630 >> 8) & 0xff,
			630 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(633 >> 8) & 0xff,
			633 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(636 >> 8) & 0xff,
			636 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(639 >> 8) & 0xff,
			639 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(642 >> 8) & 0xff,
			642 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(131 >> 8) & 0xff,
		131 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(648 >> 8) & 0xff,
			648 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(132 >> 8) & 0xff,
		132 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(654 >> 8) & 0xff,
			654 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(133 >> 8) & 0xff,
		133 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(660 >> 8) & 0xff,
			660 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(134 >> 8) & 0xff,
		134 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(666 >> 8) & 0xff,
			666 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(135 >> 8) & 0xff,
		135 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(672 >> 8) & 0xff,
			672 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(136 >> 8) & 0xff,
		136 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(678 >> 8) & 0xff,
			678 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(137 >> 8) & 0xff,
		137 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(684 >> 8) & 0xff,
			684 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(138 >> 8) & 0xff,
		138 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(690 >> 8) & 0xff,
			690 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(139 >> 8) & 0xff,
		139 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(696 >> 8) & 0xff,
			696 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(140 >> 8) & 0xff,
		140 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(702 >> 8) & 0xff,
			702 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(141 >> 8) & 0xff,
		141 & 0xff}
		},
	.field_info_spec = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(706 >> 8) & 0xff,
			706 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(142 >> 8) & 0xff,
		142 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(710 >> 8) & 0xff,
			710 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(143 >> 8) & 0xff,
		143 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(716 >> 8) & 0xff,
			716 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(144 >> 8) & 0xff,
		144 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(722 >> 8) & 0xff,
			722 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(145 >> 8) & 0xff,
		145 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(728 >> 8) & 0xff,
			728 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(146 >> 8) & 0xff,
		146 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(734 >> 8) & 0xff,
			734 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_IO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_IO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(147 >> 8) & 0xff,
		147 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(742 >> 8) & 0xff,
			742 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_IO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_IO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(148 >> 8) & 0xff,
		148 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(750 >> 8) & 0xff,
			750 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_II_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_II_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(149 >> 8) & 0xff,
		149 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(766 >> 8) & 0xff,
			766 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_II_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_II_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(152 >> 8) & 0xff,
		152 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(782 >> 8) & 0xff,
			782 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(155 >> 8) & 0xff,
		155 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(790 >> 8) & 0xff,
			790 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(156 >> 8) & 0xff,
		156 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(798 >> 8) & 0xff,
			798 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(157 >> 8) & 0xff,
		157 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(804 >> 8) & 0xff,
			804 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(158 >> 8) & 0xff,
		158 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(810 >> 8) & 0xff,
			810 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(159 >> 8) & 0xff,
		159 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(816 >> 8) & 0xff,
			816 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(160 >> 8) & 0xff,
		160 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(822 >> 8) & 0xff,
			822 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(161 >> 8) & 0xff,
		161 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(828 >> 8) & 0xff,
			828 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(162 >> 8) & 0xff,
		162 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(834 >> 8) & 0xff,
			834 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(163 >> 8) & 0xff,
		163 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(840 >> 8) & 0xff,
			840 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(164 >> 8) & 0xff,
		164 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(846 >> 8) & 0xff,
			846 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(165 >> 8) & 0xff,
		165 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(858 >> 8) & 0xff,
			858 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(168 >> 8) & 0xff,
		168 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(870 >> 8) & 0xff,
			870 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(171 >> 8) & 0xff,
		171 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(890 >> 8) & 0xff,
			890 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_IP_PROTO_TCP},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(178 >> 8) & 0xff,
		178 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(910 >> 8) & 0xff,
			910 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(185 >> 8) & 0xff,
		185 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(922 >> 8) & 0xff,
			922 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(188 >> 8) & 0xff,
		188 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(934 >> 8) & 0xff,
			934 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(191 >> 8) & 0xff,
		191 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(947 >> 8) & 0xff,
			947 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(195 >> 8) & 0xff,
		195 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(960 >> 8) & 0xff,
			960 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(199 >> 8) & 0xff,
		199 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(973 >> 8) & 0xff,
			973 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(203 >> 8) & 0xff,
		203 & 0xff}
		}
	},
	/* class_tid: 1, , table: proto_header_cache.wr */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PROFILE_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PROFILE_BITMAP & 0xff}
		}
	},
	/* class_tid: 1, , table: em_flow_conflict_cache.rd */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PROFILE_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PROFILE_BITMAP & 0xff}
		}
	},
	/* class_tid: 1, , table: em_key_recipe.0 */
	{
	.field_info_mask = {
		.description = "em_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "em_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_EM_PROFILE_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_EM_PROFILE_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_cntxt_id",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1246 >> 8) & 0xff,
			1246 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "l2_cntxt_id",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1247 >> 8) & 0xff,
			1247 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "meta",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1248 >> 8) & 0xff,
			1248 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "meta",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1249 >> 8) & 0xff,
			1249 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr2 = {
		(BNXT_ULP_CF_IDX_VF_META_FID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_VF_META_FID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "rcyc_cnt",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1250 >> 8) & 0xff,
			1250 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "rcyc_cnt",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1251 >> 8) & 0xff,
			1251 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_RECYCLE_CNT >> 8) & 0xff,
		BNXT_ULP_RF_IDX_RECYCLE_CNT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1252 >> 8) & 0xff,
			1252 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1256 >> 8) & 0xff,
			1256 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1260 >> 8) & 0xff,
			1260 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1263 >> 8) & 0xff,
			1263 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1266 >> 8) & 0xff,
			1266 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1270 >> 8) & 0xff,
			1270 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1274 >> 8) & 0xff,
			1274 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(250 >> 8) & 0xff,
		250 & 0xff}
		},
	.field_info_spec = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1282 >> 8) & 0xff,
			1282 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OI_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OI_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(251 >> 8) & 0xff,
		251 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1290 >> 8) & 0xff,
			1290 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1294 >> 8) & 0xff,
			1294 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1298 >> 8) & 0xff,
			1298 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1301 >> 8) & 0xff,
			1301 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1304 >> 8) & 0xff,
			1304 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1307 >> 8) & 0xff,
			1307 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1310 >> 8) & 0xff,
			1310 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1313 >> 8) & 0xff,
			1313 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1316 >> 8) & 0xff,
			1316 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1319 >> 8) & 0xff,
			1319 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1322 >> 8) & 0xff,
			1322 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(252 >> 8) & 0xff,
		252 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1328 >> 8) & 0xff,
			1328 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(253 >> 8) & 0xff,
		253 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1334 >> 8) & 0xff,
			1334 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(254 >> 8) & 0xff,
		254 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1340 >> 8) & 0xff,
			1340 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(255 >> 8) & 0xff,
		255 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1346 >> 8) & 0xff,
			1346 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(256 >> 8) & 0xff,
		256 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1352 >> 8) & 0xff,
			1352 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(257 >> 8) & 0xff,
		257 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1358 >> 8) & 0xff,
			1358 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(258 >> 8) & 0xff,
		258 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1364 >> 8) & 0xff,
			1364 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(259 >> 8) & 0xff,
		259 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1370 >> 8) & 0xff,
			1370 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(260 >> 8) & 0xff,
		260 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1376 >> 8) & 0xff,
			1376 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(261 >> 8) & 0xff,
		261 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1382 >> 8) & 0xff,
			1382 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(262 >> 8) & 0xff,
		262 & 0xff}
		},
	.field_info_spec = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1386 >> 8) & 0xff,
			1386 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(263 >> 8) & 0xff,
		263 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1390 >> 8) & 0xff,
			1390 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(264 >> 8) & 0xff,
		264 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1398 >> 8) & 0xff,
			1398 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(265 >> 8) & 0xff,
		265 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1406 >> 8) & 0xff,
			1406 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(266 >> 8) & 0xff,
		266 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1412 >> 8) & 0xff,
			1412 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(267 >> 8) & 0xff,
		267 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1418 >> 8) & 0xff,
			1418 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(268 >> 8) & 0xff,
		268 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1426 >> 8) & 0xff,
			1426 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_IO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_IO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(269 >> 8) & 0xff,
		269 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1434 >> 8) & 0xff,
			1434 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(270 >> 8) & 0xff,
		270 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1450 >> 8) & 0xff,
			1450 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_II_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_II_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(273 >> 8) & 0xff,
		273 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1466 >> 8) & 0xff,
			1466 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(276 >> 8) & 0xff,
		276 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1474 >> 8) & 0xff,
			1474 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(277 >> 8) & 0xff,
		277 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1482 >> 8) & 0xff,
			1482 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(278 >> 8) & 0xff,
		278 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1488 >> 8) & 0xff,
			1488 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(279 >> 8) & 0xff,
		279 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1494 >> 8) & 0xff,
			1494 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(280 >> 8) & 0xff,
		280 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1500 >> 8) & 0xff,
			1500 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(281 >> 8) & 0xff,
		281 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1506 >> 8) & 0xff,
			1506 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(282 >> 8) & 0xff,
		282 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1512 >> 8) & 0xff,
			1512 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(283 >> 8) & 0xff,
		283 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1518 >> 8) & 0xff,
			1518 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(284 >> 8) & 0xff,
		284 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1524 >> 8) & 0xff,
			1524 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(285 >> 8) & 0xff,
		285 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1530 >> 8) & 0xff,
			1530 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(286 >> 8) & 0xff,
		286 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1542 >> 8) & 0xff,
			1542 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(289 >> 8) & 0xff,
		289 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1554 >> 8) & 0xff,
			1554 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(292 >> 8) & 0xff,
		292 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1566 >> 8) & 0xff,
			1566 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(295 >> 8) & 0xff,
		295 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1578 >> 8) & 0xff,
			1578 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(298 >> 8) & 0xff,
		298 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1590 >> 8) & 0xff,
			1590 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(301 >> 8) & 0xff,
		301 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1602 >> 8) & 0xff,
			1602 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(304 >> 8) & 0xff,
		304 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1614 >> 8) & 0xff,
			1614 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(307 >> 8) & 0xff,
		307 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1626 >> 8) & 0xff,
			1626 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(310 >> 8) & 0xff,
		310 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1638 >> 8) & 0xff,
			1638 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(313 >> 8) & 0xff,
		313 & 0xff}
		}
	},
	/* class_tid: 1, , table: em_flow_conflict_cache.wr */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PROFILE_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PROFILE_BITMAP & 0xff}
		}
	},
	/* class_tid: 2, , table: port_table.get_def_rd */
	{
	.field_info_mask = {
		.description = "dev.port_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "dev.port_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_DEV_PORT_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_DEV_PORT_ID & 0xff}
		}
	},
	/* class_tid: 2, , table: l2_cntxt_tcam_cache.def_rd */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr1 = {
		(BNXT_ULP_GLB_HF_ID_SVIF_INDEX >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_SVIF_INDEX & 0xff}
		}
	},
	/* class_tid: 2, , table: proto_header_cache.rd */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PROFILE_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PROFILE_BITMAP & 0xff}
		}
	},
	/* class_tid: 2, , table: hdr_overlap_cache.overlap_check */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	/* class_tid: 2, , table: hdr_overlap_cache.overlap_check */
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_HDR_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_HDR_BITMAP & 0xff}
		}
	},
	/* class_tid: 2, , table: hdr_overlap_cache.overlap_wr */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	/* class_tid: 2, , table: hdr_overlap_cache.overlap_wr */
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_HDR_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_HDR_BITMAP & 0xff}
		}
	},
	/* class_tid: 2, , table: profile_tcam.gen_template */
	{
	.field_info_mask = {
		.description = "l4_hdr_dcn_present",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_dcn_present",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_flags",
		.field_bit_size = 9,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_flags",
		.field_bit_size = 9,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_subtype",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_subtype",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1978 >> 8) & 0xff,
			1978 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(370 >> 8) & 0xff,
		370 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1986 >> 8) & 0xff,
			1986 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(373 >> 8) & 0xff,
		373 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1994 >> 8) & 0xff,
			1994 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(376 >> 8) & 0xff,
		376 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2002 >> 8) & 0xff,
			2002 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(379 >> 8) & 0xff,
		379 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2010 >> 8) & 0xff,
			2010 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(382 >> 8) & 0xff,
		382 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2018 >> 8) & 0xff,
			2018 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(385 >> 8) & 0xff,
		385 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2026 >> 8) & 0xff,
			2026 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(388 >> 8) & 0xff,
		388 & 0xff}
		},
	.field_info_spec = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2034 >> 8) & 0xff,
			2034 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(391 >> 8) & 0xff,
		391 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3_protocol",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_protocol",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2042 >> 8) & 0xff,
			2042 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(394 >> 8) & 0xff,
		394 & 0xff}
		},
	.field_info_spec = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2050 >> 8) & 0xff,
			2050 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L3_HDR_TYPE_IPV6},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(397 >> 8) & 0xff,
		397 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2058 >> 8) & 0xff,
			2058 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(400 >> 8) & 0xff,
		400 & 0xff}
		},
	.field_info_spec = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2066 >> 8) & 0xff,
			2066 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(403 >> 8) & 0xff,
		403 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2074 >> 8) & 0xff,
			2074 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(406 >> 8) & 0xff,
		406 & 0xff}
		},
	.field_info_spec = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2082 >> 8) & 0xff,
			2082 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(409 >> 8) & 0xff,
		409 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2090 >> 8) & 0xff,
			2090 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L2_TWO_VTAGS_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(412 >> 8) & 0xff,
		412 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2096 >> 8) & 0xff,
			2096 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L2_VTAG_PRESENT_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(413 >> 8) & 0xff,
		413 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2102 >> 8) & 0xff,
			2102 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2103 >> 8) & 0xff,
			2103 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2104 >> 8) & 0xff,
			2104 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(414 >> 8) & 0xff,
		414 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2108 >> 8) & 0xff,
			2108 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(415 >> 8) & 0xff,
		415 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2112 >> 8) & 0xff,
			2112 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L2_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(416 >> 8) & 0xff,
		416 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_flags",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_flags",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2116 >> 8) & 0xff,
			2116 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(417 >> 8) & 0xff,
		417 & 0xff}
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2128 >> 8) & 0xff,
			2128 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(422 >> 8) & 0xff,
		422 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2140 >> 8) & 0xff,
			2140 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2141 >> 8) & 0xff,
			2141 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2142 >> 8) & 0xff,
			2142 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TUN_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2143 >> 8) & 0xff,
			2143 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(427 >> 8) & 0xff,
		427 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2147 >> 8) & 0xff,
			2147 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TL4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(428 >> 8) & 0xff,
		428 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2151 >> 8) & 0xff,
			2151 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(429 >> 8) & 0xff,
		429 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2155 >> 8) & 0xff,
			2155 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(430 >> 8) & 0xff,
		430 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2159 >> 8) & 0xff,
			2159 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(431 >> 8) & 0xff,
		431 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2163 >> 8) & 0xff,
			2163 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(432 >> 8) & 0xff,
		432 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2167 >> 8) & 0xff,
			2167 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TL4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(433 >> 8) & 0xff,
		433 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2171 >> 8) & 0xff,
			2171 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(434 >> 8) & 0xff,
		434 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2175 >> 8) & 0xff,
			2175 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TL3_HDR_TYPE_IPV6},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(435 >> 8) & 0xff,
		435 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2179 >> 8) & 0xff,
			2179 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(436 >> 8) & 0xff,
		436 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2183 >> 8) & 0xff,
			2183 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(437 >> 8) & 0xff,
		437 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2187 >> 8) & 0xff,
			2187 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TL3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(438 >> 8) & 0xff,
		438 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2191 >> 8) & 0xff,
			2191 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TL2_TWO_VTAGS_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2194 >> 8) & 0xff,
			2194 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TL2_VTAG_PRESENT_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2197 >> 8) & 0xff,
			2197 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2198 >> 8) & 0xff,
			2198 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2199 >> 8) & 0xff,
			2199 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TL2_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "ot_hdr_flags",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ot_hdr_flags",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "ot_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ot_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "ot_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ot_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "ot_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ot_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl4_hdr_is_tcp_udp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl4_hdr_is_tcp_udp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "int_ifa_tail",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "int_ifa_tail",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "int_hdr_group",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "int_hdr_group",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "int_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "int_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "hrec_next",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "hrec_next",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2ip_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2ip_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_count",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_count",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "pkt_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spare",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spare",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	{
	.field_info_mask = {
		.description = "padding",
		.field_bit_size = 72,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "padding",
		.field_bit_size = 72,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 2, , table: wm_key_recipe.0 */
	{
	.field_info_mask = {
		.description = "wc_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "wc_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_WC_PROFILE_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_WC_PROFILE_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_cntxt_id",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2201 >> 8) & 0xff,
			2201 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "l2_cntxt_id",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2202 >> 8) & 0xff,
			2202 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "meta",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2203 >> 8) & 0xff,
			2203 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "meta",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2204 >> 8) & 0xff,
			2204 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr2 = {
		(BNXT_ULP_CF_IDX_VF_META_FID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_VF_META_FID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "rcyc_cnt",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2205 >> 8) & 0xff,
			2205 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "rcyc_cnt",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2206 >> 8) & 0xff,
			2206 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_RECYCLE_CNT >> 8) & 0xff,
		BNXT_ULP_RF_IDX_RECYCLE_CNT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2207 >> 8) & 0xff,
			2207 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2210 >> 8) & 0xff,
			2210 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2213 >> 8) & 0xff,
			2213 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr2 = {
		(439 >> 8) & 0xff,
		439 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2218 >> 8) & 0xff,
			2218 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr2 = {
		(440 >> 8) & 0xff,
		440 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2223 >> 8) & 0xff,
			2223 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2227 >> 8) & 0xff,
			2227 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2231 >> 8) & 0xff,
			2231 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OI_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OI_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(441 >> 8) & 0xff,
		441 & 0xff}
		},
	.field_info_spec = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2239 >> 8) & 0xff,
			2239 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OI_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OI_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(442 >> 8) & 0xff,
		442 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2247 >> 8) & 0xff,
			2247 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2251 >> 8) & 0xff,
			2251 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2255 >> 8) & 0xff,
			2255 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2258 >> 8) & 0xff,
			2258 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2261 >> 8) & 0xff,
			2261 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2264 >> 8) & 0xff,
			2264 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2267 >> 8) & 0xff,
			2267 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2270 >> 8) & 0xff,
			2270 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2273 >> 8) & 0xff,
			2273 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2276 >> 8) & 0xff,
			2276 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2279 >> 8) & 0xff,
			2279 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(443 >> 8) & 0xff,
		443 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2285 >> 8) & 0xff,
			2285 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(444 >> 8) & 0xff,
		444 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2291 >> 8) & 0xff,
			2291 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(445 >> 8) & 0xff,
		445 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2297 >> 8) & 0xff,
			2297 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(446 >> 8) & 0xff,
		446 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2303 >> 8) & 0xff,
			2303 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(447 >> 8) & 0xff,
		447 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2309 >> 8) & 0xff,
			2309 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(448 >> 8) & 0xff,
		448 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2315 >> 8) & 0xff,
			2315 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(449 >> 8) & 0xff,
		449 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2321 >> 8) & 0xff,
			2321 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(450 >> 8) & 0xff,
		450 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2327 >> 8) & 0xff,
			2327 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(451 >> 8) & 0xff,
		451 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2333 >> 8) & 0xff,
			2333 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(452 >> 8) & 0xff,
		452 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2339 >> 8) & 0xff,
			2339 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(453 >> 8) & 0xff,
		453 & 0xff}
		},
	.field_info_spec = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2343 >> 8) & 0xff,
			2343 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(454 >> 8) & 0xff,
		454 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2347 >> 8) & 0xff,
			2347 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(455 >> 8) & 0xff,
		455 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2353 >> 8) & 0xff,
			2353 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(456 >> 8) & 0xff,
		456 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2359 >> 8) & 0xff,
			2359 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(457 >> 8) & 0xff,
		457 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2365 >> 8) & 0xff,
			2365 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(458 >> 8) & 0xff,
		458 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2371 >> 8) & 0xff,
			2371 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_IO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_IO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(459 >> 8) & 0xff,
		459 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2379 >> 8) & 0xff,
			2379 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_IO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_IO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(460 >> 8) & 0xff,
		460 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2387 >> 8) & 0xff,
			2387 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_II_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_II_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(461 >> 8) & 0xff,
		461 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2403 >> 8) & 0xff,
			2403 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_II_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_II_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(464 >> 8) & 0xff,
		464 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2419 >> 8) & 0xff,
			2419 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(467 >> 8) & 0xff,
		467 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2427 >> 8) & 0xff,
			2427 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(468 >> 8) & 0xff,
		468 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2435 >> 8) & 0xff,
			2435 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(469 >> 8) & 0xff,
		469 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2441 >> 8) & 0xff,
			2441 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(470 >> 8) & 0xff,
		470 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2447 >> 8) & 0xff,
			2447 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(471 >> 8) & 0xff,
		471 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2453 >> 8) & 0xff,
			2453 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(472 >> 8) & 0xff,
		472 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2459 >> 8) & 0xff,
			2459 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(473 >> 8) & 0xff,
		473 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2465 >> 8) & 0xff,
			2465 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(474 >> 8) & 0xff,
		474 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2471 >> 8) & 0xff,
			2471 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(475 >> 8) & 0xff,
		475 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2477 >> 8) & 0xff,
			2477 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(476 >> 8) & 0xff,
		476 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2483 >> 8) & 0xff,
			2483 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(477 >> 8) & 0xff,
		477 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2495 >> 8) & 0xff,
			2495 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(480 >> 8) & 0xff,
		480 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2507 >> 8) & 0xff,
			2507 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(483 >> 8) & 0xff,
		483 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2527 >> 8) & 0xff,
			2527 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_IP_PROTO_TCP},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(490 >> 8) & 0xff,
		490 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2547 >> 8) & 0xff,
			2547 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(497 >> 8) & 0xff,
		497 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2559 >> 8) & 0xff,
			2559 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(500 >> 8) & 0xff,
		500 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2571 >> 8) & 0xff,
			2571 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(503 >> 8) & 0xff,
		503 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2584 >> 8) & 0xff,
			2584 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(507 >> 8) & 0xff,
		507 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2597 >> 8) & 0xff,
			2597 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(511 >> 8) & 0xff,
		511 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2610 >> 8) & 0xff,
			2610 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(515 >> 8) & 0xff,
		515 & 0xff}
		}
	},
	/* class_tid: 2, , table: proto_header_cache.wr */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PROFILE_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PROFILE_BITMAP & 0xff}
		}
	},
	/* class_tid: 2, , table: em_flow_conflict_cache.rd */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PROFILE_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PROFILE_BITMAP & 0xff}
		}
	},
	/* class_tid: 2, , table: em_key_recipe.0 */
	{
	.field_info_mask = {
		.description = "em_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "em_profile_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_EM_PROFILE_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_EM_PROFILE_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_cntxt_id",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2883 >> 8) & 0xff,
			2883 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "l2_cntxt_id",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2884 >> 8) & 0xff,
			2884 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "meta",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2885 >> 8) & 0xff,
			2885 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "meta",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2886 >> 8) & 0xff,
			2886 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr2 = {
		(BNXT_ULP_CF_IDX_VF_META_FID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_VF_META_FID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "rcyc_cnt",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2887 >> 8) & 0xff,
			2887 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "rcyc_cnt",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2888 >> 8) & 0xff,
			2888 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr2 = {
		(BNXT_ULP_RF_IDX_RECYCLE_CNT >> 8) & 0xff,
		BNXT_ULP_RF_IDX_RECYCLE_CNT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2889 >> 8) & 0xff,
			2889 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2893 >> 8) & 0xff,
			2893 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2897 >> 8) & 0xff,
			2897 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2900 >> 8) & 0xff,
			2900 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2903 >> 8) & 0xff,
			2903 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2907 >> 8) & 0xff,
			2907 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2911 >> 8) & 0xff,
			2911 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(562 >> 8) & 0xff,
		562 & 0xff}
		},
	.field_info_spec = {
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2919 >> 8) & 0xff,
			2919 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OI_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OI_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(563 >> 8) & 0xff,
		563 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2927 >> 8) & 0xff,
			2927 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2931 >> 8) & 0xff,
			2931 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2935 >> 8) & 0xff,
			2935 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2938 >> 8) & 0xff,
			2938 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2941 >> 8) & 0xff,
			2941 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2944 >> 8) & 0xff,
			2944 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2947 >> 8) & 0xff,
			2947 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2950 >> 8) & 0xff,
			2950 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2953 >> 8) & 0xff,
			2953 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	.field_info_spec = {
		.description = "tl3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2956 >> 8) & 0xff,
			2956 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2959 >> 8) & 0xff,
			2959 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(564 >> 8) & 0xff,
		564 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2965 >> 8) & 0xff,
			2965 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(565 >> 8) & 0xff,
		565 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2971 >> 8) & 0xff,
			2971 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(566 >> 8) & 0xff,
		566 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2977 >> 8) & 0xff,
			2977 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(567 >> 8) & 0xff,
		567 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2983 >> 8) & 0xff,
			2983 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(568 >> 8) & 0xff,
		568 & 0xff}
		},
	.field_info_spec = {
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2989 >> 8) & 0xff,
			2989 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(569 >> 8) & 0xff,
		569 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2995 >> 8) & 0xff,
			2995 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(570 >> 8) & 0xff,
		570 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3001 >> 8) & 0xff,
			3001 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(571 >> 8) & 0xff,
		571 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3007 >> 8) & 0xff,
			3007 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(572 >> 8) & 0xff,
		572 & 0xff}
		},
	.field_info_spec = {
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3013 >> 8) & 0xff,
			3013 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(573 >> 8) & 0xff,
		573 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3019 >> 8) & 0xff,
			3019 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(574 >> 8) & 0xff,
		574 & 0xff}
		},
	.field_info_spec = {
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3023 >> 8) & 0xff,
			3023 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_T_VXLAN_VNI & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(575 >> 8) & 0xff,
		575 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3027 >> 8) & 0xff,
			3027 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(576 >> 8) & 0xff,
		576 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3035 >> 8) & 0xff,
			3035 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(577 >> 8) & 0xff,
		577 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3043 >> 8) & 0xff,
			3043 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(578 >> 8) & 0xff,
		578 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3049 >> 8) & 0xff,
			3049 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(579 >> 8) & 0xff,
		579 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3055 >> 8) & 0xff,
			3055 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(580 >> 8) & 0xff,
		580 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3063 >> 8) & 0xff,
			3063 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_IO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_IO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(581 >> 8) & 0xff,
		581 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3071 >> 8) & 0xff,
			3071 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(582 >> 8) & 0xff,
		582 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3087 >> 8) & 0xff,
			3087 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_II_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_II_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(585 >> 8) & 0xff,
		585 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3103 >> 8) & 0xff,
			3103 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(588 >> 8) & 0xff,
		588 & 0xff}
		},
	.field_info_spec = {
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3111 >> 8) & 0xff,
			3111 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(589 >> 8) & 0xff,
		589 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3119 >> 8) & 0xff,
			3119 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(590 >> 8) & 0xff,
		590 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3125 >> 8) & 0xff,
			3125 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(591 >> 8) & 0xff,
		591 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3131 >> 8) & 0xff,
			3131 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(592 >> 8) & 0xff,
		592 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3137 >> 8) & 0xff,
			3137 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(593 >> 8) & 0xff,
		593 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3143 >> 8) & 0xff,
			3143 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(594 >> 8) & 0xff,
		594 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3149 >> 8) & 0xff,
			3149 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(595 >> 8) & 0xff,
		595 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3155 >> 8) & 0xff,
			3155 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(596 >> 8) & 0xff,
		596 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3161 >> 8) & 0xff,
			3161 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(597 >> 8) & 0xff,
		597 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3167 >> 8) & 0xff,
			3167 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(598 >> 8) & 0xff,
		598 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3179 >> 8) & 0xff,
			3179 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(601 >> 8) & 0xff,
		601 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3191 >> 8) & 0xff,
			3191 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(604 >> 8) & 0xff,
		604 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3203 >> 8) & 0xff,
			3203 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(607 >> 8) & 0xff,
		607 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3215 >> 8) & 0xff,
			3215 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(610 >> 8) & 0xff,
		610 & 0xff}
		},
	.field_info_spec = {
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3227 >> 8) & 0xff,
			3227 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(613 >> 8) & 0xff,
		613 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3239 >> 8) & 0xff,
			3239 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(616 >> 8) & 0xff,
		616 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3251 >> 8) & 0xff,
			3251 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(619 >> 8) & 0xff,
		619 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3263 >> 8) & 0xff,
			3263 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(622 >> 8) & 0xff,
		622 & 0xff}
		},
	.field_info_spec = {
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(3275 >> 8) & 0xff,
			3275 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(625 >> 8) & 0xff,
		625 & 0xff}
		}
	},
	/* class_tid: 2, , table: em_flow_conflict_cache.wr */
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "hdr_bitmap",
		.field_bit_size = 64,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PROFILE_BITMAP >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PROFILE_BITMAP & 0xff}
		}
	},
	/* class_tid: 3, , table: table_scope_cache.tsid_ing_rd */
	{
	.field_info_mask = {
		.description = "tbl_scope",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tbl_scope",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_PORT_TABLE,
		.field_opr1 = {
			(BNXT_ULP_CF_IDX_DEV_PORT_ID >> 8) & 0xff,
			BNXT_ULP_CF_IDX_DEV_PORT_ID & 0xff,
			(BNXT_ULP_PORT_TABLE_TABLE_SCOPE >> 8) & 0xff,
			BNXT_ULP_PORT_TABLE_TABLE_SCOPE & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 3, , table: profile_tcam_bypass.ing_catch_all */
	{
	.field_info_mask = {
		.description = "l4_hdr_dcn_present",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_dcn_present",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_flags",
		.field_bit_size = 9,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_flags",
		.field_bit_size = 9,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_subtype",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_subtype",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_protocol",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_protocol",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_flags",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_flags",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "ot_hdr_flags",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ot_hdr_flags",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "ot_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ot_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "ot_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ot_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "ot_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ot_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl4_hdr_is_tcp_udp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl4_hdr_is_tcp_udp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "int_ifa_tail",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "int_ifa_tail",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "int_hdr_group",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "int_hdr_group",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "int_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "int_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "hrec_next",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "hrec_next",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2ip_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2ip_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_count",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "recycle_count",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "pkt_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spare",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spare",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	{
	.field_info_mask = {
		.description = "padding",
		.field_bit_size = 72,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "padding",
		.field_bit_size = 72,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 3, , table: table_scope_cache.tsid_ing_wr */
	{
	.field_info_mask = {
		.description = "tbl_scope",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tbl_scope",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_PORT_TABLE,
		.field_opr1 = {
			(BNXT_ULP_CF_IDX_DEV_PORT_ID >> 8) & 0xff,
			BNXT_ULP_CF_IDX_DEV_PORT_ID & 0xff,
			(BNXT_ULP_PORT_TABLE_TABLE_SCOPE >> 8) & 0xff,
			BNXT_ULP_PORT_TABLE_TABLE_SCOPE & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 3, , table: port_table.ing_wr */
	{
	.field_info_mask = {
		.description = "dev.port_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "dev.port_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_DEV_PORT_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_DEV_PORT_ID & 0xff}
		}
	},
	/* class_tid: 3, , table: l2_cntxt_tcam_cache.ing_rd */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PHY_PORT_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PHY_PORT_SVIF & 0xff}
		}
	},
	/* class_tid: 3, , table: l2_cntxt_tcam.svif_ing */
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "addr1",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "addr1",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "addr0",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "addr0",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "out_tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "out_tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2ip_func",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2ip_func",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PHY_PORT_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PHY_PORT_SVIF & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "parif",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "parif",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spare",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spare",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 3, , table: l2_cntxt_tcam_cache.ing_wr */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_PHY_PORT_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_PHY_PORT_SVIF & 0xff}
		}
	},
	/* class_tid: 3, , table: port_table.egr_wr_0 */
	{
	.field_info_mask = {
		.description = "dev.port_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "dev.port_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_DEV_PORT_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_DEV_PORT_ID & 0xff}
		}
	},
	/* class_tid: 3, , table: l2_cntxt_tcam_cache.no_vfr_egr_rd */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_DRV_FUNC_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_DRV_FUNC_SVIF & 0xff}
		}
	},
	/* class_tid: 3, , table: l2_cntxt_tcam.non_vfr_svif_egr */
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "addr1",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "addr1",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "addr0",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "addr0",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "out_tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "out_tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2ip_func",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2ip_func",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_DRV_FUNC_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_DRV_FUNC_SVIF & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "parif",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "parif",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spare",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spare",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 3, , table: profile_tcam_bypass.non_vfr_egr_catch_all */
	{
	.field_info_mask = {
		.description = "l4_hdr_dcn_present",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_dcn_present",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_flags",
		.field_bit_size = 9,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_flags",
		.field_bit_size = 9,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_subtype",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_subtype",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_protocol",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_protocol",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_flags",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_flags",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "ot_hdr_flags",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ot_hdr_flags",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "ot_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ot_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "ot_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ot_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "ot_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ot_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl4_hdr_is_tcp_udp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl4_hdr_is_tcp_udp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "int_ifa_tail",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "int_ifa_tail",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "int_hdr_group",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "int_hdr_group",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "int_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "int_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "hrec_next",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "hrec_next",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2ip_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2ip_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_count",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_count",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "pkt_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spare",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spare",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	{
	.field_info_mask = {
		.description = "padding",
		.field_bit_size = 72,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "padding",
		.field_bit_size = 72,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 3, , table: l2_cntxt_tcam_cache.non_vfr_egr_wr */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_DRV_FUNC_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_DRV_FUNC_SVIF & 0xff}
		}
	},
	/* class_tid: 3, , table: table_scope_cache.tsid_vfr_rd */
	{
	.field_info_mask = {
		.description = "tbl_scope",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tbl_scope",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_PORT_TABLE,
		.field_opr1 = {
			(BNXT_ULP_CF_IDX_DEV_PORT_ID >> 8) & 0xff,
			BNXT_ULP_CF_IDX_DEV_PORT_ID & 0xff,
			(BNXT_ULP_PORT_TABLE_TABLE_SCOPE >> 8) & 0xff,
			BNXT_ULP_PORT_TABLE_TABLE_SCOPE & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 3, , table: l2_cntxt_tcam.vf2vf_ing */
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "addr1",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "addr1",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "addr0",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "addr0",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "out_tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "out_tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2ip_func",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2ip_func",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		(ULP_THOR2_SYM_VF_2_VFR_META_MASK >> 24) & 0xff,
		(ULP_THOR2_SYM_VF_2_VFR_META_MASK >> 16) & 0xff,
		(ULP_THOR2_SYM_VF_2_VFR_META_MASK >> 8) & 0xff,
		ULP_THOR2_SYM_VF_2_VFR_META_MASK & 0xff}
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		(ULP_THOR2_SYM_VF_2_VF_META_VAL >> 24) & 0xff,
		(ULP_THOR2_SYM_VF_2_VF_META_VAL >> 16) & 0xff,
		(ULP_THOR2_SYM_VF_2_VF_META_VAL >> 8) & 0xff,
		ULP_THOR2_SYM_VF_2_VF_META_VAL & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "parif",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "parif",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spare",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spare",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 3, , table: table_scope_cache.tsid_vfr_wr */
	{
	.field_info_mask = {
		.description = "tbl_scope",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tbl_scope",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_PORT_TABLE,
		.field_opr1 = {
			(BNXT_ULP_CF_IDX_DEV_PORT_ID >> 8) & 0xff,
			BNXT_ULP_CF_IDX_DEV_PORT_ID & 0xff,
			(BNXT_ULP_PORT_TABLE_TABLE_SCOPE >> 8) & 0xff,
			BNXT_ULP_PORT_TABLE_TABLE_SCOPE & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 4, , table: table_scope_cache.tsid_vfr_egr_rd */
	{
	.field_info_mask = {
		.description = "tbl_scope",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tbl_scope",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_PORT_TABLE,
		.field_opr1 = {
			(BNXT_ULP_CF_IDX_DEV_PORT_ID >> 8) & 0xff,
			BNXT_ULP_CF_IDX_DEV_PORT_ID & 0xff,
			(BNXT_ULP_PORT_TABLE_TABLE_SCOPE >> 8) & 0xff,
			BNXT_ULP_PORT_TABLE_TABLE_SCOPE & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 4, , table: profile_tcam_bypass.tsid_vfr_egr_catch_all */
	{
	.field_info_mask = {
		.description = "l4_hdr_dcn_present",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_dcn_present",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_flags",
		.field_bit_size = 9,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_flags",
		.field_bit_size = 9,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_subtype",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_subtype",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_protocol",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_protocol",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "l2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_flags",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_flags",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_err",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tun_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "ot_hdr_flags",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ot_hdr_flags",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "ot_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ot_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "ot_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ot_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "ot_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "ot_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl4_hdr_is_tcp_udp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl4_hdr_is_tcp_udp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl3_hdr_isIP",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl2_uc_mc_bc",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl2_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "otl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "otl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "int_ifa_tail",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "int_ifa_tail",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "int_hdr_group",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "int_hdr_group",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "int_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "int_hdr_type",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "hrec_next",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "hrec_next",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "prof_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_RF,
		.field_opr1 = {
		(BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 >> 8) & 0xff,
		BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "l2ip_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2ip_func_id",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "agg_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_count",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_count",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "pkt_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "pkt_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spare",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spare",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	{
	.field_info_mask = {
		.description = "padding",
		.field_bit_size = 72,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "padding",
		.field_bit_size = 72,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 4, , table: table_scope_cache.tsid_vfr_egr_wr */
	{
	.field_info_mask = {
		.description = "tbl_scope",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff}
		},
	.field_info_spec = {
		.description = "tbl_scope",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_PORT_TABLE,
		.field_opr1 = {
			(BNXT_ULP_CF_IDX_DEV_PORT_ID >> 8) & 0xff,
			BNXT_ULP_CF_IDX_DEV_PORT_ID & 0xff,
			(BNXT_ULP_PORT_TABLE_TABLE_SCOPE >> 8) & 0xff,
			BNXT_ULP_PORT_TABLE_TABLE_SCOPE & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	/* class_tid: 4, , table: l2_cntxt_tcam_cache.endpoint_def_egr_rd */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_VF_FUNC_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_VF_FUNC_SVIF & 0xff}
		}
	},
	/* class_tid: 4, , table: l2_cntxt_tcam.vf2vf_egr */
	{
	.field_info_mask = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ivlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_tpid_sel",
		.field_bit_size = 3,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2_ovlan_vid",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "addr1",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "addr1",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "addr0",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "addr0",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tunnel_id",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "tunnel_id",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		ULP_THOR2_SYM_TUN_HDR_TYPE_NONE}
		},
	.field_info_spec = {
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		ULP_THOR2_SYM_TUN_HDR_TYPE_NONE}
		}
	},
	{
	.field_info_mask = {
		.description = "out_tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		ULP_THOR2_SYM_TUN_HDR_TYPE_NONE}
		},
	.field_info_spec = {
		.description = "out_tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		ULP_THOR2_SYM_TUN_HDR_TYPE_NONE}
		}
	},
	{
	.field_info_mask = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "llc",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "roce",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "l2ip_func",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "l2ip_func",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "metadata",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "metadata",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_VF_FUNC_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_VF_FUNC_SVIF & 0xff}
		}
	},
	{
	.field_info_mask = {
		.description = "parif",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "parif",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spif",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "loopback",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "recycle_cnt",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "recycle_cnt",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "mpass_cnt",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "spare",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		},
	.field_info_spec = {
		.description = "spare",
		.field_bit_size = 2,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ZERO
		}
	},
	{
	.field_info_mask = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		},
	.field_info_spec = {
		.description = "valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr1 = {
		1}
		}
	},
	/* class_tid: 4, , table: l2_cntxt_tcam_cache.endpoint_def_egr_wr */
	{
	.field_info_mask = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "svif",
		.field_bit_size = 11,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_VF_FUNC_SVIF >> 8) & 0xff,
		BNXT_ULP_CF_IDX_VF_FUNC_SVIF & 0xff}
		}
	},
	/* class_tid: 4, , table: port_table.egr_wr_0 */
	{
	.field_info_mask = {
		.description = "dev.port_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_ONES,
		.field_opr1 = {
			0xff,
			0xff}
		},
	.field_info_spec = {
		.description = "dev.port_id",
		.field_bit_size = 10,
		.field_opc = BNXT_ULP_FIELD_OPC_SRC1,
		.field_src1 = BNXT_ULP_FIELD_SRC_CF,
		.field_opr1 = {
		(BNXT_ULP_CF_IDX_DEV_PORT_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_DEV_PORT_ID & 0xff}
		}
	}
};

struct bnxt_ulp_mapper_field_info ulp_thor2_class_key_ext_list[] = {
	/* class_tid: 1, , table: control.dmac_calculation */
	{
	.description = "",
	.field_bit_size = 48,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(4 >> 8) & 0xff,
		4 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_HF,
	.field_opr2 = {
	(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
	BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(1 >> 8) & 0xff,
	1 & 0xff}
	},
	{
		.description = "",
		.field_bit_size = 48,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(6 >> 8) & 0xff,
		6 & 0xff,
		(1 >> 8) & 0xff,
		1 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_PORT_TABLE,
	.field_opr2 = {
		(BNXT_ULP_CF_IDX_DEV_PORT_ID >> 8) & 0xff,
		BNXT_ULP_CF_IDX_DEV_PORT_ID & 0xff,
		(BNXT_ULP_PORT_TABLE_DRV_FUNC_MAC >> 8) & 0xff,
		BNXT_ULP_PORT_TABLE_DRV_FUNC_MAC & 0xff},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(2 >> 8) & 0xff,
	2 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 48,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(7 >> 8) & 0xff,
		7 & 0xff,
		(1 >> 8) & 0xff,
		1 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_RF,
	.field_opr2 = {
	(BNXT_ULP_RF_IDX_DRV_FUNC_PARENT_MAC >> 8) & 0xff,
	BNXT_ULP_RF_IDX_DRV_FUNC_PARENT_MAC & 0xff},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	/* class_tid: 1, , table: control.terminating_flow */
	{
	.description = "",
	.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(34 >> 8) & 0xff,
		34 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(4 >> 8) & 0xff,
	4 & 0xff}
	},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(36 >> 8) & 0xff,
		36 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(5 >> 8) & 0xff,
	5 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(38 >> 8) & 0xff,
		38 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(6 >> 8) & 0xff,
	6 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(40 >> 8) & 0xff,
		40 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl2_ivv.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(62 >> 8) & 0xff,
		62 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_sip0.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(82 >> 8) & 0xff,
		82 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_dip0.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(97 >> 8) & 0xff,
		97 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_ttl.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(103 >> 8) & 0xff,
		103 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_prot.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(109 >> 8) & 0xff,
		109 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_qos.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(115 >> 8) & 0xff,
		115 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_src.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(121 >> 8) & 0xff,
		121 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_dst.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(127 >> 8) & 0xff,
		127 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tids.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(132 >> 8) & 0xff,
		132 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_dmac.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(137 >> 8) & 0xff,
		137 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_smac.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(143 >> 8) & 0xff,
		143 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_ovv.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(150 >> 8) & 0xff,
		150 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_ivv.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(158 >> 8) & 0xff,
		158 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(20 >> 8) & 0xff,
	20 & 0xff}
		},
	{
		.description = "l2_ivv.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(162 >> 8) & 0xff,
		162 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(21 >> 8) & 0xff,
	21 & 0xff}
		},
	{
		.description = "l2_ivv.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(166 >> 8) & 0xff,
		166 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_etype.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(174 >> 8) & 0xff,
		174 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_sip3.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(182 >> 8) & 0xff,
		182 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_sip2.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(190 >> 8) & 0xff,
		190 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_sip1.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(198 >> 8) & 0xff,
		198 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_sip0.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(206 >> 8) & 0xff,
		206 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(27 >> 8) & 0xff,
	27 & 0xff}
		},
	{
		.description = "l3_sip0.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(210 >> 8) & 0xff,
		210 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(28 >> 8) & 0xff,
	28 & 0xff}
		},
	{
		.description = "l3_sip0.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(214 >> 8) & 0xff,
		214 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_dip3.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(222 >> 8) & 0xff,
		222 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_dip2.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(230 >> 8) & 0xff,
		230 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_dip1.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(238 >> 8) & 0xff,
		238 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_dip0.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(246 >> 8) & 0xff,
		246 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(33 >> 8) & 0xff,
	33 & 0xff}
		},
	{
		.description = "l3_dip0.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(250 >> 8) & 0xff,
		250 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(34 >> 8) & 0xff,
	34 & 0xff}
		},
	{
		.description = "l3_dip0.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(254 >> 8) & 0xff,
		254 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_ttl.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(262 >> 8) & 0xff,
		262 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(36 >> 8) & 0xff,
	36 & 0xff}
		},
	{
		.description = "l3_ttl.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(266 >> 8) & 0xff,
		266 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(37 >> 8) & 0xff,
	37 & 0xff}
		},
	{
		.description = "l3_ttl.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(270 >> 8) & 0xff,
		270 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_prot.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(278 >> 8) & 0xff,
		278 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(39 >> 8) & 0xff,
	39 & 0xff}
		},
	{
		.description = "l3_prot.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(282 >> 8) & 0xff,
		282 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(40 >> 8) & 0xff,
	40 & 0xff}
		},
	{
		.description = "l3_prot.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(286 >> 8) & 0xff,
		286 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_qos.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(294 >> 8) & 0xff,
		294 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(42 >> 8) & 0xff,
	42 & 0xff}
		},
	{
		.description = "l3_qos.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(298 >> 8) & 0xff,
		298 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(43 >> 8) & 0xff,
	43 & 0xff}
		},
	{
		.description = "l3_qos.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(302 >> 8) & 0xff,
		302 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_src.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
	.field_opr1 = {
		(307 >> 8) & 0xff,
		307 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_src.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
	.field_opr1 = {
		(310 >> 8) & 0xff,
		310 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_dst.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
	.field_opr1 = {
		(314 >> 8) & 0xff,
		314 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_dst.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
	.field_opr1 = {
		(317 >> 8) & 0xff,
		317 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	/* class_tid: 1, , table: control.profile_tcam_priority */
	{
	.description = "",
	.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(321 >> 8) & 0xff,
		321 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	ULP_THOR2_SYM_PROF_TCAM_PRI_L4},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(49 >> 8) & 0xff,
	49 & 0xff}
	},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(323 >> 8) & 0xff,
		323 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	ULP_THOR2_SYM_PROF_TCAM_PRI_L4},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(50 >> 8) & 0xff,
	50 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(325 >> 8) & 0xff,
		325 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	ULP_THOR2_SYM_PROF_TCAM_PRI_L4},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(51 >> 8) & 0xff,
	51 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(327 >> 8) & 0xff,
		327 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	ULP_THOR2_SYM_PROF_TCAM_PRI_L4},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(52 >> 8) & 0xff,
	52 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(329 >> 8) & 0xff,
		329 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	ULP_THOR2_SYM_PROF_TCAM_PRI_L3},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(53 >> 8) & 0xff,
	53 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(331 >> 8) & 0xff,
		331 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	ULP_THOR2_SYM_PROF_TCAM_PRI_L3},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(54 >> 8) & 0xff,
	54 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(333 >> 8) & 0xff,
		333 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	ULP_THOR2_SYM_PROF_TCAM_PRI_L3},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(55 >> 8) & 0xff,
	55 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(335 >> 8) & 0xff,
		335 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	ULP_THOR2_SYM_PROF_TCAM_PRI_L3},
	.field_src3 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr3 = {
	ULP_THOR2_SYM_PROF_TCAM_PRI_L2}
		},
	{
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(339 >> 8) & 0xff,
			339 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(57 >> 8) & 0xff,
		57 & 0xff}
		},
	{
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(341 >> 8) & 0xff,
			341 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(58 >> 8) & 0xff,
		58 & 0xff}
		},
	{
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(343 >> 8) & 0xff,
			343 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(347 >> 8) & 0xff,
			347 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(60 >> 8) & 0xff,
		60 & 0xff}
		},
	{
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(349 >> 8) & 0xff,
			349 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(61 >> 8) & 0xff,
		61 & 0xff}
		},
	{
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(351 >> 8) & 0xff,
			351 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(355 >> 8) & 0xff,
			355 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(63 >> 8) & 0xff,
		63 & 0xff}
		},
	{
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(357 >> 8) & 0xff,
			357 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(64 >> 8) & 0xff,
		64 & 0xff}
		},
	{
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(359 >> 8) & 0xff,
			359 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(363 >> 8) & 0xff,
			363 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(66 >> 8) & 0xff,
		66 & 0xff}
		},
	{
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(365 >> 8) & 0xff,
			365 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L4_HDR_TYPE_UDP},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(67 >> 8) & 0xff,
		67 & 0xff}
		},
	{
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(367 >> 8) & 0xff,
			367 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L4_HDR_TYPE_UDP},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(371 >> 8) & 0xff,
			371 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(69 >> 8) & 0xff,
		69 & 0xff}
		},
	{
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(373 >> 8) & 0xff,
			373 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(70 >> 8) & 0xff,
		70 & 0xff}
		},
	{
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(375 >> 8) & 0xff,
			375 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(379 >> 8) & 0xff,
			379 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(72 >> 8) & 0xff,
		72 & 0xff}
		},
	{
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(381 >> 8) & 0xff,
			381 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(73 >> 8) & 0xff,
		73 & 0xff}
		},
	{
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(383 >> 8) & 0xff,
			383 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(387 >> 8) & 0xff,
			387 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(75 >> 8) & 0xff,
		75 & 0xff}
		},
	{
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(389 >> 8) & 0xff,
			389 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(76 >> 8) & 0xff,
		76 & 0xff}
		},
	{
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(391 >> 8) & 0xff,
			391 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(395 >> 8) & 0xff,
			395 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(78 >> 8) & 0xff,
		78 & 0xff}
		},
	{
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(397 >> 8) & 0xff,
			397 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(79 >> 8) & 0xff,
		79 & 0xff}
		},
	{
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(399 >> 8) & 0xff,
			399 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(403 >> 8) & 0xff,
			403 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(81 >> 8) & 0xff,
		81 & 0xff}
		},
	{
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(405 >> 8) & 0xff,
			405 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(82 >> 8) & 0xff,
		82 & 0xff}
		},
	{
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(407 >> 8) & 0xff,
			407 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(411 >> 8) & 0xff,
			411 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L3_HDR_TYPE_IPV6},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(84 >> 8) & 0xff,
		84 & 0xff}
		},
	{
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(413 >> 8) & 0xff,
			413 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(85 >> 8) & 0xff,
		85 & 0xff}
		},
	{
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(415 >> 8) & 0xff,
			415 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(419 >> 8) & 0xff,
			419 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(87 >> 8) & 0xff,
		87 & 0xff}
		},
	{
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(421 >> 8) & 0xff,
			421 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(88 >> 8) & 0xff,
		88 & 0xff}
		},
	{
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(423 >> 8) & 0xff,
			423 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(427 >> 8) & 0xff,
			427 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(90 >> 8) & 0xff,
		90 & 0xff}
		},
	{
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(429 >> 8) & 0xff,
			429 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(91 >> 8) & 0xff,
		91 & 0xff}
		},
	{
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(431 >> 8) & 0xff,
			431 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(435 >> 8) & 0xff,
			435 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(93 >> 8) & 0xff,
		93 & 0xff}
		},
	{
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(437 >> 8) & 0xff,
			437 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(94 >> 8) & 0xff,
		94 & 0xff}
		},
	{
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(439 >> 8) & 0xff,
			439 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(443 >> 8) & 0xff,
			443 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(96 >> 8) & 0xff,
		96 & 0xff}
		},
	{
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(445 >> 8) & 0xff,
			445 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(97 >> 8) & 0xff,
		97 & 0xff}
		},
	{
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(447 >> 8) & 0xff,
			447 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(452 >> 8) & 0xff,
			452 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L2_TWO_VTAGS_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(458 >> 8) & 0xff,
			458 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L2_VTAG_PRESENT_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(465 >> 8) & 0xff,
			465 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(469 >> 8) & 0xff,
			469 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(473 >> 8) & 0xff,
			473 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L2_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(477 >> 8) & 0xff,
			477 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(104 >> 8) & 0xff,
		104 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(479 >> 8) & 0xff,
			479 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(105 >> 8) & 0xff,
		105 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(481 >> 8) & 0xff,
			481 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(106 >> 8) & 0xff,
		106 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(483 >> 8) & 0xff,
			483 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(107 >> 8) & 0xff,
		107 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(485 >> 8) & 0xff,
			485 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(489 >> 8) & 0xff,
			489 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TUN_HDR_TYPE_VXLAN_GPE},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(109 >> 8) & 0xff,
		109 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(491 >> 8) & 0xff,
			491 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TUN_HDR_TYPE_GENEVE},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(110 >> 8) & 0xff,
		110 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(493 >> 8) & 0xff,
			493 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TUN_HDR_TYPE_GRE},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(111 >> 8) & 0xff,
		111 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(495 >> 8) & 0xff,
			495 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TUN_HDR_TYPE_UPAR1},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(112 >> 8) & 0xff,
		112 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(497 >> 8) & 0xff,
			497 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TUN_HDR_TYPE_UPAR2},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(504 >> 8) & 0xff,
			504 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(508 >> 8) & 0xff,
			508 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TL4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(512 >> 8) & 0xff,
			512 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(516 >> 8) & 0xff,
			516 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TL4_HDR_TYPE_UDP},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(520 >> 8) & 0xff,
			520 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(524 >> 8) & 0xff,
			524 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(528 >> 8) & 0xff,
			528 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(120 >> 8) & 0xff,
		120 & 0xff}
		},
	{
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(530 >> 8) & 0xff,
			530 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ONES
		},
	{
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(533 >> 8) & 0xff,
			533 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TL4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(122 >> 8) & 0xff,
		122 & 0xff}
		},
	{
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(535 >> 8) & 0xff,
			535 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(538 >> 8) & 0xff,
			538 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(542 >> 8) & 0xff,
			542 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(546 >> 8) & 0xff,
			546 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(550 >> 8) & 0xff,
			550 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(554 >> 8) & 0xff,
			554 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TL3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(566 >> 8) & 0xff,
			566 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TL2_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(598 >> 8) & 0xff,
			598 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(606 >> 8) & 0xff,
			606 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(645 >> 8) & 0xff,
			645 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(651 >> 8) & 0xff,
			651 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(657 >> 8) & 0xff,
			657 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(663 >> 8) & 0xff,
			663 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(669 >> 8) & 0xff,
			669 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(675 >> 8) & 0xff,
			675 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(681 >> 8) & 0xff,
			681 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(687 >> 8) & 0xff,
			687 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(693 >> 8) & 0xff,
			693 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(699 >> 8) & 0xff,
			699 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(704 >> 8) & 0xff,
			704 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(708 >> 8) & 0xff,
			708 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(713 >> 8) & 0xff,
			713 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(719 >> 8) & 0xff,
			719 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(725 >> 8) & 0xff,
			725 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(731 >> 8) & 0xff,
			731 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(738 >> 8) & 0xff,
			738 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(746 >> 8) & 0xff,
			746 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(754 >> 8) & 0xff,
			754 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_IO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_IO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(150 >> 8) & 0xff,
		150 & 0xff}
		},
	{
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(758 >> 8) & 0xff,
			758 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OI_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OI_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(151 >> 8) & 0xff,
		151 & 0xff}
		},
	{
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(762 >> 8) & 0xff,
			762 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(770 >> 8) & 0xff,
			770 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_IO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_IO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(153 >> 8) & 0xff,
		153 & 0xff}
		},
	{
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(774 >> 8) & 0xff,
			774 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OI_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OI_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(154 >> 8) & 0xff,
		154 & 0xff}
		},
	{
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(778 >> 8) & 0xff,
			778 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(786 >> 8) & 0xff,
			786 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(794 >> 8) & 0xff,
			794 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(801 >> 8) & 0xff,
			801 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(807 >> 8) & 0xff,
			807 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(813 >> 8) & 0xff,
			813 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(819 >> 8) & 0xff,
			819 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(825 >> 8) & 0xff,
			825 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(831 >> 8) & 0xff,
			831 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(837 >> 8) & 0xff,
			837 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(843 >> 8) & 0xff,
			843 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(849 >> 8) & 0xff,
			849 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(166 >> 8) & 0xff,
		166 & 0xff}
		},
	{
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(852 >> 8) & 0xff,
			852 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(167 >> 8) & 0xff,
		167 & 0xff}
		},
	{
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(855 >> 8) & 0xff,
			855 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(861 >> 8) & 0xff,
			861 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(169 >> 8) & 0xff,
		169 & 0xff}
		},
	{
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(864 >> 8) & 0xff,
			864 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(170 >> 8) & 0xff,
		170 & 0xff}
		},
	{
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(867 >> 8) & 0xff,
			867 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(872 >> 8) & 0xff,
			872 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(172 >> 8) & 0xff,
		172 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(874 >> 8) & 0xff,
			874 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(173 >> 8) & 0xff,
		173 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(876 >> 8) & 0xff,
			876 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(174 >> 8) & 0xff,
		174 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(878 >> 8) & 0xff,
			878 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(175 >> 8) & 0xff,
		175 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(881 >> 8) & 0xff,
			881 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(176 >> 8) & 0xff,
		176 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(884 >> 8) & 0xff,
			884 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(177 >> 8) & 0xff,
		177 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(887 >> 8) & 0xff,
			887 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(892 >> 8) & 0xff,
			892 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_IP_PROTO_UDP},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(179 >> 8) & 0xff,
		179 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(894 >> 8) & 0xff,
			894 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_IP_PROTO_TCP},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(180 >> 8) & 0xff,
		180 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(896 >> 8) & 0xff,
			896 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_IP_PROTO_UDP},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(181 >> 8) & 0xff,
		181 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(898 >> 8) & 0xff,
			898 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(182 >> 8) & 0xff,
		182 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(901 >> 8) & 0xff,
			901 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(183 >> 8) & 0xff,
		183 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(904 >> 8) & 0xff,
			904 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(184 >> 8) & 0xff,
		184 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(907 >> 8) & 0xff,
			907 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(913 >> 8) & 0xff,
			913 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(186 >> 8) & 0xff,
		186 & 0xff}
		},
	{
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(916 >> 8) & 0xff,
			916 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(187 >> 8) & 0xff,
		187 & 0xff}
		},
	{
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(919 >> 8) & 0xff,
			919 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(925 >> 8) & 0xff,
			925 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(189 >> 8) & 0xff,
		189 & 0xff}
		},
	{
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(928 >> 8) & 0xff,
			928 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(190 >> 8) & 0xff,
		190 & 0xff}
		},
	{
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(931 >> 8) & 0xff,
			931 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(937 >> 8) & 0xff,
			937 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(192 >> 8) & 0xff,
		192 & 0xff}
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(940 >> 8) & 0xff,
			940 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(193 >> 8) & 0xff,
		193 & 0xff}
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(943 >> 8) & 0xff,
			943 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(194 >> 8) & 0xff,
		194 & 0xff}
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(946 >> 8) & 0xff,
			946 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_SKIP,
		.field_src3 = BNXT_ULP_FIELD_SRC_CONST
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(950 >> 8) & 0xff,
			950 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(196 >> 8) & 0xff,
		196 & 0xff}
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(953 >> 8) & 0xff,
			953 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(197 >> 8) & 0xff,
		197 & 0xff}
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(956 >> 8) & 0xff,
			956 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(198 >> 8) & 0xff,
		198 & 0xff}
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(959 >> 8) & 0xff,
			959 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_SKIP,
		.field_src3 = BNXT_ULP_FIELD_SRC_CONST
		},
	{
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(963 >> 8) & 0xff,
			963 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(200 >> 8) & 0xff,
		200 & 0xff}
		},
	{
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(966 >> 8) & 0xff,
			966 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(201 >> 8) & 0xff,
		201 & 0xff}
		},
	{
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(969 >> 8) & 0xff,
			969 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(202 >> 8) & 0xff,
		202 & 0xff}
		},
	{
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(972 >> 8) & 0xff,
			972 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_SKIP,
		.field_src3 = BNXT_ULP_FIELD_SRC_CONST
		},
	{
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(976 >> 8) & 0xff,
			976 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(204 >> 8) & 0xff,
		204 & 0xff}
		},
	{
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(979 >> 8) & 0xff,
			979 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(205 >> 8) & 0xff,
		205 & 0xff}
		},
	{
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(982 >> 8) & 0xff,
			982 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(206 >> 8) & 0xff,
		206 & 0xff}
		},
	{
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(985 >> 8) & 0xff,
			985 & 0xff,
			(1 >> 8) & 0xff,
			1 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_SKIP,
		.field_src3 = BNXT_ULP_FIELD_SRC_CONST
		},
	{
		.description = "tl2_ivv.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1008 >> 8) & 0xff,
		1008 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_sip0.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1028 >> 8) & 0xff,
		1028 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_dip0.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1043 >> 8) & 0xff,
		1043 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_ttl.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1049 >> 8) & 0xff,
		1049 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_prot.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1055 >> 8) & 0xff,
		1055 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_qos.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1061 >> 8) & 0xff,
		1061 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_src.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1067 >> 8) & 0xff,
		1067 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_dst.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1073 >> 8) & 0xff,
		1073 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tids.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1078 >> 8) & 0xff,
		1078 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_dmac.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1084 >> 8) & 0xff,
		1084 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_smac.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1091 >> 8) & 0xff,
		1091 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_ovv.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1098 >> 8) & 0xff,
		1098 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_ivv.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1106 >> 8) & 0xff,
		1106 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(220 >> 8) & 0xff,
	220 & 0xff}
		},
	{
		.description = "l2_ivv.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1110 >> 8) & 0xff,
		1110 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(221 >> 8) & 0xff,
	221 & 0xff}
		},
	{
		.description = "l2_ivv.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1114 >> 8) & 0xff,
		1114 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_etype.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1122 >> 8) & 0xff,
		1122 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_sip3.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1129 >> 8) & 0xff,
		1129 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_sip2.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1135 >> 8) & 0xff,
		1135 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_sip1.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1141 >> 8) & 0xff,
		1141 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_sip0.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1147 >> 8) & 0xff,
		1147 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(227 >> 8) & 0xff,
	227 & 0xff}
		},
	{
		.description = "l3_sip0.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1150 >> 8) & 0xff,
		1150 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(228 >> 8) & 0xff,
	228 & 0xff}
		},
	{
		.description = "l3_sip0.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1153 >> 8) & 0xff,
		1153 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_dip3.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1159 >> 8) & 0xff,
		1159 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_dip2.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1165 >> 8) & 0xff,
		1165 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_dip1.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1171 >> 8) & 0xff,
		1171 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_dip0.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1177 >> 8) & 0xff,
		1177 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(233 >> 8) & 0xff,
	233 & 0xff}
		},
	{
		.description = "l3_dip0.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1180 >> 8) & 0xff,
		1180 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(234 >> 8) & 0xff,
	234 & 0xff}
		},
	{
		.description = "l3_dip0.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1183 >> 8) & 0xff,
		1183 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_ttl.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1189 >> 8) & 0xff,
		1189 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(236 >> 8) & 0xff,
	236 & 0xff}
		},
	{
		.description = "l3_ttl.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1192 >> 8) & 0xff,
		1192 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(237 >> 8) & 0xff,
	237 & 0xff}
		},
	{
		.description = "l3_ttl.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1195 >> 8) & 0xff,
		1195 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_prot.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1201 >> 8) & 0xff,
		1201 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(239 >> 8) & 0xff,
	239 & 0xff}
		},
	{
		.description = "l3_prot.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1204 >> 8) & 0xff,
		1204 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(240 >> 8) & 0xff,
	240 & 0xff}
		},
	{
		.description = "l3_prot.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1207 >> 8) & 0xff,
		1207 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_qos.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1213 >> 8) & 0xff,
		1213 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(242 >> 8) & 0xff,
	242 & 0xff}
		},
	{
		.description = "l3_qos.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1216 >> 8) & 0xff,
		1216 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(243 >> 8) & 0xff,
	243 & 0xff}
		},
	{
		.description = "l3_qos.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1219 >> 8) & 0xff,
		1219 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_src.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1225 >> 8) & 0xff,
		1225 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(245 >> 8) & 0xff,
	245 & 0xff}
		},
	{
		.description = "l4_src.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1228 >> 8) & 0xff,
		1228 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(246 >> 8) & 0xff,
	246 & 0xff}
		},
	{
		.description = "l4_src.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1231 >> 8) & 0xff,
		1231 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_dst.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1237 >> 8) & 0xff,
		1237 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(248 >> 8) & 0xff,
	248 & 0xff}
		},
	{
		.description = "l4_dst.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1240 >> 8) & 0xff,
		1240 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(249 >> 8) & 0xff,
	249 & 0xff}
		},
	{
		.description = "l4_dst.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1243 >> 8) & 0xff,
		1243 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1278 >> 8) & 0xff,
			1278 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1286 >> 8) & 0xff,
			1286 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1325 >> 8) & 0xff,
			1325 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1331 >> 8) & 0xff,
			1331 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1337 >> 8) & 0xff,
			1337 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1343 >> 8) & 0xff,
			1343 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1349 >> 8) & 0xff,
			1349 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1355 >> 8) & 0xff,
			1355 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1361 >> 8) & 0xff,
			1361 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1367 >> 8) & 0xff,
			1367 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1373 >> 8) & 0xff,
			1373 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1379 >> 8) & 0xff,
			1379 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1384 >> 8) & 0xff,
			1384 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tids",
		.field_bit_size = 24,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1388 >> 8) & 0xff,
			1388 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_T_VXLAN_GPE_VNI & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1394 >> 8) & 0xff,
			1394 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_dmac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1402 >> 8) & 0xff,
			1402 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_DMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_DMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1409 >> 8) & 0xff,
			1409 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1415 >> 8) & 0xff,
			1415 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1422 >> 8) & 0xff,
			1422 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_ovv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1430 >> 8) & 0xff,
			1430 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1438 >> 8) & 0xff,
			1438 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(271 >> 8) & 0xff,
		271 & 0xff}
		},
	{
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1442 >> 8) & 0xff,
			1442 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(272 >> 8) & 0xff,
		272 & 0xff}
		},
	{
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1446 >> 8) & 0xff,
			1446 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1454 >> 8) & 0xff,
			1454 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_IO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_IO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(274 >> 8) & 0xff,
		274 & 0xff}
		},
	{
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1458 >> 8) & 0xff,
			1458 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OI_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OI_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(275 >> 8) & 0xff,
		275 & 0xff}
		},
	{
		.description = "l2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1462 >> 8) & 0xff,
			1462 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1470 >> 8) & 0xff,
			1470 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l2_etype",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1478 >> 8) & 0xff,
			1478 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_TYPE >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_TYPE & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1485 >> 8) & 0xff,
			1485 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.sip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1491 >> 8) & 0xff,
			1491 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1497 >> 8) & 0xff,
			1497 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.sip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1503 >> 8) & 0xff,
			1503 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_SRC_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1509 >> 8) & 0xff,
			1509 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.dip.ipv4",
		.field_bit_size = 32,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1515 >> 8) & 0xff,
			1515 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1521 >> 8) & 0xff,
			1521 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.dip.ipv6",
		.field_bit_size = 128,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1527 >> 8) & 0xff,
			1527 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_DST_ADDR & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1533 >> 8) & 0xff,
			1533 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(287 >> 8) & 0xff,
		287 & 0xff}
		},
	{
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1536 >> 8) & 0xff,
			1536 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(288 >> 8) & 0xff,
		288 & 0xff}
		},
	{
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1539 >> 8) & 0xff,
			1539 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1545 >> 8) & 0xff,
			1545 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(290 >> 8) & 0xff,
		290 & 0xff}
		},
	{
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1548 >> 8) & 0xff,
			1548 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(291 >> 8) & 0xff,
		291 & 0xff}
		},
	{
		.description = "l3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1551 >> 8) & 0xff,
			1551 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1557 >> 8) & 0xff,
			1557 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(293 >> 8) & 0xff,
		293 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1560 >> 8) & 0xff,
			1560 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(294 >> 8) & 0xff,
		294 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1563 >> 8) & 0xff,
			1563 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1569 >> 8) & 0xff,
			1569 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(296 >> 8) & 0xff,
		296 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1572 >> 8) & 0xff,
			1572 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(297 >> 8) & 0xff,
		297 & 0xff}
		},
	{
		.description = "l3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1575 >> 8) & 0xff,
			1575 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1581 >> 8) & 0xff,
			1581 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(299 >> 8) & 0xff,
		299 & 0xff}
		},
	{
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1584 >> 8) & 0xff,
			1584 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(300 >> 8) & 0xff,
		300 & 0xff}
		},
	{
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1587 >> 8) & 0xff,
			1587 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1593 >> 8) & 0xff,
			1593 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_IPV4_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_IPV4_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(302 >> 8) & 0xff,
		302 & 0xff}
		},
	{
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1596 >> 8) & 0xff,
			1596 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV6_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV6_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(303 >> 8) & 0xff,
		303 & 0xff}
		},
	{
		.description = "l3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1599 >> 8) & 0xff,
			1599 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_QOS >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_QOS & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1605 >> 8) & 0xff,
			1605 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(305 >> 8) & 0xff,
		305 & 0xff}
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1608 >> 8) & 0xff,
			1608 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(306 >> 8) & 0xff,
		306 & 0xff}
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1611 >> 8) & 0xff,
			1611 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1617 >> 8) & 0xff,
			1617 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_TCP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(308 >> 8) & 0xff,
		308 & 0xff}
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1620 >> 8) & 0xff,
			1620 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(309 >> 8) & 0xff,
		309 & 0xff}
		},
	{
		.description = "l4.src",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1623 >> 8) & 0xff,
			1623 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_SRC_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1629 >> 8) & 0xff,
			1629 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(311 >> 8) & 0xff,
		311 & 0xff}
		},
	{
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1632 >> 8) & 0xff,
			1632 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(312 >> 8) & 0xff,
		312 & 0xff}
		},
	{
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1635 >> 8) & 0xff,
			1635 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1641 >> 8) & 0xff,
			1641 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_I_TCP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(314 >> 8) & 0xff,
		314 & 0xff}
		},
	{
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1644 >> 8) & 0xff,
			1644 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_UDP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(315 >> 8) & 0xff,
		315 & 0xff}
		},
	{
		.description = "l4.dst",
		.field_bit_size = 16,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1647 >> 8) & 0xff,
			1647 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_TCP_DST_PORT & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	/* class_tid: 2, , table: control.terminating_flow */
	{
	.description = "",
	.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1673 >> 8) & 0xff,
		1673 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(317 >> 8) & 0xff,
	317 & 0xff}
	},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1675 >> 8) & 0xff,
		1675 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(318 >> 8) & 0xff,
	318 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1677 >> 8) & 0xff,
		1677 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(319 >> 8) & 0xff,
	319 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1679 >> 8) & 0xff,
		1679 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl2_smac.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1693 >> 8) & 0xff,
		1693 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
	.field_src3 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr3 = {
	1}
		},
	{
		.description = "tl2_ivv.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1703 >> 8) & 0xff,
		1703 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_sip0.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1723 >> 8) & 0xff,
		1723 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_dip0.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1738 >> 8) & 0xff,
		1738 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_ttl.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1744 >> 8) & 0xff,
		1744 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_prot.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1750 >> 8) & 0xff,
		1750 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_qos.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1756 >> 8) & 0xff,
		1756 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_src.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1762 >> 8) & 0xff,
		1762 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_dst.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1768 >> 8) & 0xff,
		1768 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tids.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1773 >> 8) & 0xff,
		1773 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_dmac.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1778 >> 8) & 0xff,
		1778 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_smac.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1784 >> 8) & 0xff,
		1784 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_ovv.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1791 >> 8) & 0xff,
		1791 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_ivv.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1799 >> 8) & 0xff,
		1799 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(334 >> 8) & 0xff,
	334 & 0xff}
		},
	{
		.description = "l2_ivv.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1803 >> 8) & 0xff,
		1803 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(335 >> 8) & 0xff,
	335 & 0xff}
		},
	{
		.description = "l2_ivv.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1807 >> 8) & 0xff,
		1807 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_etype.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1815 >> 8) & 0xff,
		1815 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_sip3.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1823 >> 8) & 0xff,
		1823 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_sip2.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1831 >> 8) & 0xff,
		1831 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_sip1.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1839 >> 8) & 0xff,
		1839 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_sip0.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1847 >> 8) & 0xff,
		1847 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(341 >> 8) & 0xff,
	341 & 0xff}
		},
	{
		.description = "l3_sip0.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1851 >> 8) & 0xff,
		1851 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(342 >> 8) & 0xff,
	342 & 0xff}
		},
	{
		.description = "l3_sip0.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1855 >> 8) & 0xff,
		1855 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_dip3.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1863 >> 8) & 0xff,
		1863 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_dip2.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1871 >> 8) & 0xff,
		1871 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_dip1.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1879 >> 8) & 0xff,
		1879 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_dip0.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1887 >> 8) & 0xff,
		1887 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(347 >> 8) & 0xff,
	347 & 0xff}
		},
	{
		.description = "l3_dip0.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1891 >> 8) & 0xff,
		1891 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(348 >> 8) & 0xff,
	348 & 0xff}
		},
	{
		.description = "l3_dip0.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1895 >> 8) & 0xff,
		1895 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_ttl.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1903 >> 8) & 0xff,
		1903 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(350 >> 8) & 0xff,
	350 & 0xff}
		},
	{
		.description = "l3_ttl.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1907 >> 8) & 0xff,
		1907 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(351 >> 8) & 0xff,
	351 & 0xff}
		},
	{
		.description = "l3_ttl.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1911 >> 8) & 0xff,
		1911 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_prot.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1919 >> 8) & 0xff,
		1919 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(353 >> 8) & 0xff,
	353 & 0xff}
		},
	{
		.description = "l3_prot.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1923 >> 8) & 0xff,
		1923 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(354 >> 8) & 0xff,
	354 & 0xff}
		},
	{
		.description = "l3_prot.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1927 >> 8) & 0xff,
		1927 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_qos.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1935 >> 8) & 0xff,
		1935 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(356 >> 8) & 0xff,
	356 & 0xff}
		},
	{
		.description = "l3_qos.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1939 >> 8) & 0xff,
		1939 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(357 >> 8) & 0xff,
	357 & 0xff}
		},
	{
		.description = "l3_qos.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1943 >> 8) & 0xff,
		1943 & 0xff,
		(4 >> 8) & 0xff,
		4 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_src.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
	.field_opr1 = {
		(1948 >> 8) & 0xff,
		1948 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_src.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
	.field_opr1 = {
		(1951 >> 8) & 0xff,
		1951 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_dst.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
	.field_opr1 = {
		(1955 >> 8) & 0xff,
		1955 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_dst.en",
		.field_bit_size = 1,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_OR,
	.field_opr1 = {
		(1958 >> 8) & 0xff,
		1958 & 0xff,
		(3 >> 8) & 0xff,
		3 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	1},
	.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	/* class_tid: 2, , table: control.profile_tcam_priority */
	{
	.description = "",
	.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1962 >> 8) & 0xff,
		1962 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	ULP_THOR2_SYM_PROF_TCAM_PRI_L4},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(363 >> 8) & 0xff,
	363 & 0xff}
	},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1964 >> 8) & 0xff,
		1964 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	ULP_THOR2_SYM_PROF_TCAM_PRI_L4},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(364 >> 8) & 0xff,
	364 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1966 >> 8) & 0xff,
		1966 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	ULP_THOR2_SYM_PROF_TCAM_PRI_L4},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(365 >> 8) & 0xff,
	365 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1968 >> 8) & 0xff,
		1968 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	ULP_THOR2_SYM_PROF_TCAM_PRI_L4},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(366 >> 8) & 0xff,
	366 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1970 >> 8) & 0xff,
		1970 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	ULP_THOR2_SYM_PROF_TCAM_PRI_L3},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(367 >> 8) & 0xff,
	367 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1972 >> 8) & 0xff,
		1972 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	ULP_THOR2_SYM_PROF_TCAM_PRI_L3},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(368 >> 8) & 0xff,
	368 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1974 >> 8) & 0xff,
		1974 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	ULP_THOR2_SYM_PROF_TCAM_PRI_L3},
	.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
	.field_opr3 = {
	(369 >> 8) & 0xff,
	369 & 0xff}
		},
	{
		.description = "",
		.field_bit_size = 8,
	.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
	.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
	.field_opr1 = {
		(1976 >> 8) & 0xff,
		1976 & 0xff,
		(2 >> 8) & 0xff,
		2 & 0xff},
	.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr2 = {
	ULP_THOR2_SYM_PROF_TCAM_PRI_L3},
	.field_src3 = BNXT_ULP_FIELD_SRC_CONST,
	.field_opr3 = {
	ULP_THOR2_SYM_PROF_TCAM_PRI_L2}
		},
	{
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1980 >> 8) & 0xff,
			1980 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(371 >> 8) & 0xff,
		371 & 0xff}
		},
	{
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1982 >> 8) & 0xff,
			1982 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(372 >> 8) & 0xff,
		372 & 0xff}
		},
	{
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1984 >> 8) & 0xff,
			1984 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1988 >> 8) & 0xff,
			1988 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(374 >> 8) & 0xff,
		374 & 0xff}
		},
	{
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1990 >> 8) & 0xff,
			1990 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(375 >> 8) & 0xff,
		375 & 0xff}
		},
	{
		.description = "l4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1992 >> 8) & 0xff,
			1992 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1996 >> 8) & 0xff,
			1996 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(377 >> 8) & 0xff,
		377 & 0xff}
		},
	{
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(1998 >> 8) & 0xff,
			1998 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(378 >> 8) & 0xff,
		378 & 0xff}
		},
	{
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2000 >> 8) & 0xff,
			2000 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2004 >> 8) & 0xff,
			2004 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(380 >> 8) & 0xff,
		380 & 0xff}
		},
	{
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2006 >> 8) & 0xff,
			2006 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L4_HDR_TYPE_UDP},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(381 >> 8) & 0xff,
		381 & 0xff}
		},
	{
		.description = "l4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2008 >> 8) & 0xff,
			2008 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L4_HDR_TYPE_UDP},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2012 >> 8) & 0xff,
			2012 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(383 >> 8) & 0xff,
		383 & 0xff}
		},
	{
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2014 >> 8) & 0xff,
			2014 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(384 >> 8) & 0xff,
		384 & 0xff}
		},
	{
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2016 >> 8) & 0xff,
			2016 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2020 >> 8) & 0xff,
			2020 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(386 >> 8) & 0xff,
		386 & 0xff}
		},
	{
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2022 >> 8) & 0xff,
			2022 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(387 >> 8) & 0xff,
		387 & 0xff}
		},
	{
		.description = "l4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2024 >> 8) & 0xff,
			2024 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2028 >> 8) & 0xff,
			2028 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(389 >> 8) & 0xff,
		389 & 0xff}
		},
	{
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2030 >> 8) & 0xff,
			2030 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(390 >> 8) & 0xff,
		390 & 0xff}
		},
	{
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2032 >> 8) & 0xff,
			2032 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2036 >> 8) & 0xff,
			2036 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(392 >> 8) & 0xff,
		392 & 0xff}
		},
	{
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2038 >> 8) & 0xff,
			2038 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(393 >> 8) & 0xff,
		393 & 0xff}
		},
	{
		.description = "l4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2040 >> 8) & 0xff,
			2040 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2044 >> 8) & 0xff,
			2044 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(395 >> 8) & 0xff,
		395 & 0xff}
		},
	{
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2046 >> 8) & 0xff,
			2046 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(396 >> 8) & 0xff,
		396 & 0xff}
		},
	{
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2048 >> 8) & 0xff,
			2048 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2052 >> 8) & 0xff,
			2052 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L3_HDR_TYPE_IPV6},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(398 >> 8) & 0xff,
		398 & 0xff}
		},
	{
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2054 >> 8) & 0xff,
			2054 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(399 >> 8) & 0xff,
		399 & 0xff}
		},
	{
		.description = "l3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2056 >> 8) & 0xff,
			2056 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2060 >> 8) & 0xff,
			2060 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(401 >> 8) & 0xff,
		401 & 0xff}
		},
	{
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2062 >> 8) & 0xff,
			2062 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(402 >> 8) & 0xff,
		402 & 0xff}
		},
	{
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2064 >> 8) & 0xff,
			2064 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2068 >> 8) & 0xff,
			2068 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(404 >> 8) & 0xff,
		404 & 0xff}
		},
	{
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2070 >> 8) & 0xff,
			2070 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(405 >> 8) & 0xff,
		405 & 0xff}
		},
	{
		.description = "l3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2072 >> 8) & 0xff,
			2072 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2076 >> 8) & 0xff,
			2076 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(407 >> 8) & 0xff,
		407 & 0xff}
		},
	{
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2078 >> 8) & 0xff,
			2078 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(408 >> 8) & 0xff,
		408 & 0xff}
		},
	{
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2080 >> 8) & 0xff,
			2080 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2084 >> 8) & 0xff,
			2084 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(410 >> 8) & 0xff,
		410 & 0xff}
		},
	{
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2086 >> 8) & 0xff,
			2086 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(411 >> 8) & 0xff,
		411 & 0xff}
		},
	{
		.description = "l3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2088 >> 8) & 0xff,
			2088 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_two_vtags",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2093 >> 8) & 0xff,
			2093 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L2_TWO_VTAGS_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_vtag_present",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2099 >> 8) & 0xff,
			2099 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L2_VTAG_PRESENT_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2106 >> 8) & 0xff,
			2106 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2110 >> 8) & 0xff,
			2110 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "l2_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2114 >> 8) & 0xff,
			2114 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_L2_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2118 >> 8) & 0xff,
			2118 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(418 >> 8) & 0xff,
		418 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2120 >> 8) & 0xff,
			2120 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(419 >> 8) & 0xff,
		419 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2122 >> 8) & 0xff,
			2122 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(420 >> 8) & 0xff,
		420 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2124 >> 8) & 0xff,
			2124 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(421 >> 8) & 0xff,
		421 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2126 >> 8) & 0xff,
			2126 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2130 >> 8) & 0xff,
			2130 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TUN_HDR_TYPE_VXLAN_GPE},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(423 >> 8) & 0xff,
		423 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2132 >> 8) & 0xff,
			2132 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TUN_HDR_TYPE_GENEVE},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(424 >> 8) & 0xff,
		424 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2134 >> 8) & 0xff,
			2134 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TUN_HDR_TYPE_GRE},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(425 >> 8) & 0xff,
		425 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2136 >> 8) & 0xff,
			2136 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TUN_HDR_TYPE_UPAR1},
		.field_src3 = BNXT_ULP_FIELD_SRC_NEXT,
		.field_opr3 = {
		(426 >> 8) & 0xff,
		426 & 0xff}
		},
	{
		.description = "tun_hdr_type",
		.field_bit_size = 5,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2138 >> 8) & 0xff,
			2138 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TUN_HDR_TYPE_UPAR2},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2145 >> 8) & 0xff,
			2145 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_hdr_is_udp_tcp",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2149 >> 8) & 0xff,
			2149 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TL4_HDR_IS_UDP_TCP_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2153 >> 8) & 0xff,
			2153 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2157 >> 8) & 0xff,
			2157 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TL4_HDR_TYPE_UDP},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2161 >> 8) & 0xff,
			2161 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2165 >> 8) & 0xff,
			2165 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl4_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2169 >> 8) & 0xff,
			2169 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TL4_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2173 >> 8) & 0xff,
			2173 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_hdr_type",
		.field_bit_size = 4,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2177 >> 8) & 0xff,
			2177 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2181 >> 8) & 0xff,
			2181 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ONES,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_hdr_error",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2185 >> 8) & 0xff,
			2185 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_ZERO,
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl3_hdr_valid",
		.field_bit_size = 1,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2189 >> 8) & 0xff,
			2189 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_CONST,
		.field_opr2 = {
		ULP_THOR2_SYM_TL3_HDR_VALID_YES},
		.field_src3 = BNXT_ULP_FIELD_SRC_ZERO
		},
	{
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2216 >> 8) & 0xff,
			2216 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_SKIP,
		.field_src3 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr3 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff}
		},
	{
		.description = "tl2_smac",
		.field_bit_size = 48,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2221 >> 8) & 0xff,
			2221 & 0xff,
			(2 >> 8) & 0xff,
			2 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_SKIP,
		.field_src3 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr3 = {
		(BNXT_ULP_GLB_HF_ID_O_ETH_SMAC >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_ETH_SMAC & 0xff}
		},
	{
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2235 >> 8) & 0xff,
			2235 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl2_ivv",
		.field_bit_size = 12,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2243 >> 8) & 0xff,
			2243 & 0xff,
			(4 >> 8) & 0xff,
			4 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_OO_VLAN_VID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_OO_VLAN_VID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2282 >> 8) & 0xff,
			2282 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.ttl",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2288 >> 8) & 0xff,
			2288 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_TTL >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_TTL & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2294 >> 8) & 0xff,
			2294 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.prot",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(2300 >> 8) & 0xff,
			2300 & 0xff,
			(3 >> 8) & 0xff,
			3 & 0xff},
		.field_src2 = BNXT_ULP_FIELD_SRC_HF,
		.field_opr2 = {
		(BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID >> 8) & 0xff,
		BNXT_ULP_GLB_HF_ID_O_IPV4_PROTO_ID & 0xff},
		.field_src3 = BNXT_ULP_FIELD_SRC_SKIP
		},
	{
		.description = "tl3.qos",
		.field_bit_size = 8,
		.field_opc = BNXT_ULP_FIELD_OPC_TERNARY_LIST,
		.field_src1 = BNXT_ULP_FIELD_SRC_LIST_AND,
		.field_opr1 = {
			(