/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright(c) 2014-2023 Broadcom
 * All rights reserved.
 */

#ifndef ULP_TEMPLATE_DB_H_
#define ULP_TEMPLATE_DB_H_

#define BNXT_ULP_REGFILE_MAX_SZ 85
#define BNXT_ULP_MAX_NUM_DEVICES 5
#define BNXT_ULP_LOG2_MAX_NUM_DEV 2.32192809488736
#define BNXT_ULP_GEN_TBL_MAX_SZ 50
#define BNXT_ULP_CLASS_MATCH_LIST_MAX_SZ 129
#define BNXT_ULP_ACT_MATCH_LIST_MAX_SZ 17
#define BNXT_ULP_APP_RESOURCE_RESV_LIST_MAX_SZ 0
#define BNXT_ULP_GLB_RESOURCE_TBL_MAX_SZ 64
#define BNXT_ULP_APP_GLB_RESOURCE_TBL_MAX_SZ 0
#define BNXT_ULP_RESOURCE_RESV_LIST_MAX_SZ 73
#define BNXT_ULP_APP_CAP_TBL_MAX_SZ 3
#define BNXT_ULP_COND_GOTO_REJECT 1023
#define BNXT_ULP_COND_GOTO_RF 0x10000
#define BNXT_ULP_APP_ID_CONFIG 0
#define BNXT_ULP_GLB_FIELD_TBL_SIZE 133
#define BNXT_ULP_GLB_SIG_TBL_SIZE 1
#define ULP_WH_PLUS_CLASS_TMPL_LIST_SIZE 5
#define ULP_WH_PLUS_CLASS_TBL_LIST_SIZE 74
#define ULP_WH_PLUS_CLASS_KEY_INFO_LIST_SIZE 503
#define ULP_WH_PLUS_CLASS_KEY_EXT_LIST_SIZE 0
#define ULP_WH_PLUS_CLASS_IDENT_LIST_SIZE 20
#define ULP_WH_PLUS_CLASS_RESULT_FIELD_LIST_SIZE 552
#define ULP_WH_PLUS_CLASS_COND_LIST_SIZE 43
#define ULP_WH_PLUS_CLASS_COND_OPER_LIST_SIZE 0
#define ULP_THOR_CLASS_TMPL_LIST_SIZE 5
#define ULP_THOR_CLASS_TBL_LIST_SIZE 126
#define ULP_THOR_CLASS_KEY_INFO_LIST_SIZE 611
#define ULP_THOR_CLASS_KEY_EXT_LIST_SIZE 635
#define ULP_THOR_CLASS_IDENT_LIST_SIZE 43
#define ULP_THOR_CLASS_RESULT_FIELD_LIST_SIZE 1252
#define ULP_THOR_CLASS_COND_LIST_SIZE 3142
#define ULP_THOR_CLASS_COND_OPER_LIST_SIZE 7
#define ULP_THOR2_CLASS_TMPL_LIST_SIZE 5
#define ULP_THOR2_CLASS_TBL_LIST_SIZE 125
#define ULP_THOR2_CLASS_KEY_INFO_LIST_SIZE 665
#define ULP_THOR2_CLASS_KEY_EXT_LIST_SIZE 628
#define ULP_THOR2_CLASS_IDENT_LIST_SIZE 56
#define ULP_THOR2_CLASS_RESULT_FIELD_LIST_SIZE 1511
#define ULP_THOR2_CLASS_COND_LIST_SIZE 3298
#define ULP_THOR2_CLASS_COND_OPER_LIST_SIZE 7
#define ULP_WH_PLUS_ACT_TMPL_LIST_SIZE 11
#define ULP_WH_PLUS_ACT_TBL_LIST_SIZE 46
#define ULP_WH_PLUS_ACT_KEY_INFO_LIST_SIZE 2
#define ULP_WH_PLUS_ACT_KEY_EXT_LIST_SIZE 0
#define ULP_WH_PLUS_ACT_IDENT_LIST_SIZE 1
#define ULP_WH_PLUS_ACT_RESULT_FIELD_LIST_SIZE 616
#define ULP_WH_PLUS_ACT_COND_LIST_SIZE 73
#define ULP_WH_PLUS_ACT_COND_OPER_LIST_SIZE 6
#define ULP_THOR_ACT_TMPL_LIST_SIZE 11
#define ULP_THOR_ACT_TBL_LIST_SIZE 158
#define ULP_THOR_ACT_KEY_INFO_LIST_SIZE 91
#define ULP_THOR_ACT_KEY_EXT_LIST_SIZE 0
#define ULP_THOR_ACT_IDENT_LIST_SIZE 22
#define ULP_THOR_ACT_RESULT_FIELD_LIST_SIZE 964
#define ULP_THOR_ACT_COND_LIST_SIZE 107
#define ULP_THOR_ACT_COND_OPER_LIST_SIZE 2
#define ULP_THOR2_ACT_TMPL_LIST_SIZE 11
#define ULP_THOR2_ACT_TBL_LIST_SIZE 76
#define ULP_THOR2_ACT_KEY_INFO_LIST_SIZE 55
#define ULP_THOR2_ACT_KEY_EXT_LIST_SIZE 0
#define ULP_THOR2_ACT_IDENT_LIST_SIZE 9
#define ULP_THOR2_ACT_RESULT_FIELD_LIST_SIZE 460
#define ULP_THOR2_ACT_COND_LIST_SIZE 62
#define ULP_THOR2_ACT_COND_OPER_LIST_SIZE 0

enum bnxt_ulp_act_bit {
	BNXT_ULP_ACT_BIT_MARK                = 0x0000000000000001,
	BNXT_ULP_ACT_BIT_DROP                = 0x0000000000000002,
	BNXT_ULP_ACT_BIT_COUNT               = 0x0000000000000004,
	BNXT_ULP_ACT_BIT_RSS                 = 0x0000000000000008,
	BNXT_ULP_ACT_BIT_METER               = 0x0000000000000010,
	BNXT_ULP_ACT_BIT_VXLAN_DECAP         = 0x0000000000000020,
	BNXT_ULP_ACT_BIT_POP_MPLS            = 0x0000000000000040,
	BNXT_ULP_ACT_BIT_PUSH_MPLS           = 0x0000000000000080,
	BNXT_ULP_ACT_BIT_MAC_SWAP            = 0x0000000000000100,
	BNXT_ULP_ACT_BIT_SET_MAC_SRC         = 0x0000000000000200,
	BNXT_ULP_ACT_BIT_SET_MAC_DST         = 0x0000000000000400,
	BNXT_ULP_ACT_BIT_POP_VLAN            = 0x0000000000000800,
	BNXT_ULP_ACT_BIT_PUSH_VLAN           = 0x0000000000001000,
	BNXT_ULP_ACT_BIT_SET_VLAN_PCP        = 0x0000000000002000,
	BNXT_ULP_ACT_BIT_SET_VLAN_VID        = 0x0000000000004000,
	BNXT_ULP_ACT_BIT_SET_IPV4_SRC        = 0x0000000000008000,
	BNXT_ULP_ACT_BIT_SET_IPV4_DST        = 0x0000000000010000,
	BNXT_ULP_ACT_BIT_SET_IPV6_SRC        = 0x0000000000020000,
	BNXT_ULP_ACT_BIT_SET_IPV6_DST        = 0x0000000000040000,
	BNXT_ULP_ACT_BIT_DEC_TTL             = 0x0000000000080000,
	BNXT_ULP_ACT_BIT_SET_TTL             = 0x0000000000100000,
	BNXT_ULP_ACT_BIT_SET_TP_SRC          = 0x0000000000200000,
	BNXT_ULP_ACT_BIT_SET_TP_DST          = 0x0000000000400000,
	BNXT_ULP_ACT_BIT_VXLAN_ENCAP         = 0x0000000000800000,
	BNXT_ULP_ACT_BIT_JUMP                = 0x0000000001000000,
	BNXT_ULP_ACT_BIT_SHARED              = 0x0000000002000000,
	BNXT_ULP_ACT_BIT_SAMPLE              = 0x0000000004000000,
	BNXT_ULP_ACT_BIT_SHARED_SAMPLE       = 0x0000000008000000,
	BNXT_ULP_ACT_BIT_QUEUE               = 0x0000000010000000,
	BNXT_ULP_ACT_BIT_DELETE              = 0x0000000020000000,
	BNXT_ULP_ACT_BIT_UPDATE              = 0x0000000040000000,
	BNXT_ULP_ACT_BIT_SHARED_METER        = 0x0000000080000000,
	BNXT_ULP_ACT_BIT_METER_PROFILE       = 0x0000000100000000,
	BNXT_ULP_ACT_BIT_GOTO_CHAIN          = 0x0000000200000000,
	BNXT_ULP_ACT_BIT_VF_TO_VF            = 0x0000000400000000,
	BNXT_ULP_ACT_BIT_IP_ENCAP            = 0x0000000800000000,
	BNXT_ULP_ACT_BIT_IP_DECAP            = 0x0000001000000000,
	BNXT_ULP_ACT_BIT_L2_ENCAP            = 0x0000002000000000,
	BNXT_ULP_ACT_BIT_L2_DECAP            = 0x0000004000000000,
	BNXT_ULP_ACT_BIT_GENEVE_DECAP        = 0x0000008000000000,
	BNXT_ULP_ACT_BIT_GENEVE_ENCAP        = 0x0000010000000000,
	BNXT_ULP_ACT_BIT_MULTIPLE_PORT       = 0x0000020000000000,
	BNXT_ULP_ACT_BIT_LAST                = 0x0000040000000000
};

enum bnxt_ulp_cf_bit {
	BNXT_ULP_CF_BIT_IS_TUNNEL            = 0x0000000000000001,
	BNXT_ULP_CF_BIT_UPAR1                = 0x0000000000000002,
	BNXT_ULP_CF_BIT_UPAR2                = 0x0000000000000004,
	BNXT_ULP_CF_BIT_L2_CNTXT_ID          = 0x0000000000000008,
	BNXT_ULP_CF_BIT_RECYCLE_CNT          = 0x0000000000000010,
	BNXT_ULP_CF_BIT_METADATA             = 0x0000000000000020,
	BNXT_ULP_CF_BIT_L2_ONLY              = 0x0000000000000040,
	BNXT_ULP_CF_BIT_DIX_TRAFFIC          = 0x0000000000000080,
	BNXT_ULP_CF_BIT_LAST                 = 0x0000000000000100
};

enum bnxt_ulp_dev_ft {
	BNXT_ULP_DEV_FT_STAT_SW_AGG          = 0x0000000000000001,
	BNXT_ULP_DEV_FT_STAT_PARENT_AGG      = 0x0000000000000002,
	BNXT_ULP_DEV_FT_LAST                 = 0x0000000000000004
};

enum bnxt_ulp_hdr_bit {
	BNXT_ULP_HDR_BIT_O_ETH               = 0x0000000000000001,
	BNXT_ULP_HDR_BIT_OO_VLAN             = 0x0000000000000002,
	BNXT_ULP_HDR_BIT_OI_VLAN             = 0x0000000000000004,
	BNXT_ULP_HDR_BIT_O_IPV4              = 0x0000000000000008,
	BNXT_ULP_HDR_BIT_O_IPV6              = 0x0000000000000010,
	BNXT_ULP_HDR_BIT_O_TCP               = 0x0000000000000020,
	BNXT_ULP_HDR_BIT_O_UDP               = 0x0000000000000040,
	BNXT_ULP_HDR_BIT_O_ICMP              = 0x0000000000000080,
	BNXT_ULP_HDR_BIT_T_VXLAN             = 0x0000000000000100,
	BNXT_ULP_HDR_BIT_T_GRE               = 0x0000000000000200,
	BNXT_ULP_HDR_BIT_I_ETH               = 0x0000000000000400,
	BNXT_ULP_HDR_BIT_IO_VLAN             = 0x0000000000000800,
	BNXT_ULP_HDR_BIT_II_VLAN             = 0x0000000000001000,
	BNXT_ULP_HDR_BIT_I_IPV4              = 0x0000000000002000,
	BNXT_ULP_HDR_BIT_I_IPV6              = 0x0000000000004000,
	BNXT_ULP_HDR_BIT_I_TCP               = 0x0000000000008000,
	BNXT_ULP_HDR_BIT_I_UDP               = 0x0000000000010000,
	BNXT_ULP_HDR_BIT_I_ICMP              = 0x0000000000020000,
	BNXT_ULP_HDR_BIT_O_ECPRI             = 0x0000000000040000,
	BNXT_ULP_HDR_BIT_O_ROE               = 0x0000000000080000,
	BNXT_ULP_HDR_BIT_F1                  = 0x0000000000100000,
	BNXT_ULP_HDR_BIT_F2                  = 0x0000000000200000,
	BNXT_ULP_HDR_BIT_SVIF_IGNORE         = 0x0000000000400000,
	BNXT_ULP_HDR_BIT_SVIF                = 0x0000000000800000,
	BNXT_ULP_HDR_BIT_O_SRV6              = 0x0000000001000000,
	BNXT_ULP_HDR_BIT_I_BTH               = 0x0000000002000000,
	BNXT_ULP_HDR_BIT_O_BTH               = 0x0000000004000000,
	BNXT_ULP_HDR_BIT_T_VXLAN_GPE         = 0x0000000008000000,
	BNXT_ULP_HDR_BIT_T_GENEVE            = 0x0000000010000000,
	BNXT_ULP_HDR_BIT_OO_UNTAGGED         = 0x0000000020000000,
	BNXT_ULP_HDR_BIT_OI_UNTAGGED         = 0x0000000040000000,
	BNXT_ULP_HDR_BIT_IO_UNTAGGED         = 0x0000000080000000,
	BNXT_ULP_HDR_BIT_II_UNTAGGED         = 0x0000000100000000,
	BNXT_ULP_HDR_BIT_NON_TUNNEL          = 0x0000000200000000,
	BNXT_ULP_HDR_BIT_L2_ONLY             = 0x0000000400000000,
	BNXT_ULP_HDR_BIT_O_L4_FLOW           = 0x0000000800000000,
	BNXT_ULP_HDR_BIT_I_L4_FLOW           = 0x0000001000000000,
	BNXT_ULP_HDR_BIT_LAST                = 0x0000002000000000
};

enum bnxt_ulp_accept_opc {
	BNXT_ULP_ACCEPT_OPC_ALWAYS = 0,
	BNXT_ULP_ACCEPT_OPC_FLOW_SIG_ID_MATCH = 1,
	BNXT_ULP_ACCEPT_OPC_LAST = 2
};

enum bnxt_ulp_act_type {
	BNXT_ULP_ACT_TYPE_NOT_SUPPORTED = 0,
	BNXT_ULP_ACT_TYPE_SUPPORTED = 1,
	BNXT_ULP_ACT_TYPE_END = 2,
	BNXT_ULP_ACT_TYPE_LAST = 3
};

enum bnxt_ulp_byte_order {
	BNXT_ULP_BYTE_ORDER_BE = 0,
	BNXT_ULP_BYTE_ORDER_LE = 1,
	BNXT_ULP_BYTE_ORDER_LAST = 2
};

enum bnxt_ulp_cf_idx {
	BNXT_ULP_CF_IDX_NOT_USED = 0,
	BNXT_ULP_CF_IDX_MPLS_TAG_NUM = 1,
	BNXT_ULP_CF_IDX_O_VTAG_NUM = 2,
	BNXT_ULP_CF_IDX_O_HAS_VTAG = 3,
	BNXT_ULP_CF_IDX_O_ONE_VTAG = 4,
	BNXT_ULP_CF_IDX_O_TWO_VTAGS = 5,
	BNXT_ULP_CF_IDX_I_VTAG_NUM = 6,
	BNXT_ULP_CF_IDX_I_HAS_VTAG = 7,
	BNXT_ULP_CF_IDX_I_ONE_VTAG = 8,
	BNXT_ULP_CF_IDX_I_TWO_VTAGS = 9,
	BNXT_ULP_CF_IDX_INCOMING_IF = 10,
	BNXT_ULP_CF_IDX_DIRECTION = 11,
	BNXT_ULP_CF_IDX_SVIF_FLAG = 12,
	BNXT_ULP_CF_IDX_O_L3 = 13,
	BNXT_ULP_CF_IDX_I_L3 = 14,
	BNXT_ULP_CF_IDX_O_L4 = 15,
	BNXT_ULP_CF_IDX_I_L4 = 16,
	BNXT_ULP_CF_IDX_O_L4_SRC_PORT = 17,
	BNXT_ULP_CF_IDX_O_L4_DST_PORT = 18,
	BNXT_ULP_CF_IDX_I_L4_SRC_PORT = 19,
	BNXT_ULP_CF_IDX_I_L4_DST_PORT = 20,
	BNXT_ULP_CF_IDX_O_L4_SRC_PORT_MASK = 21,
	BNXT_ULP_CF_IDX_O_L4_DST_PORT_MASK = 22,
	BNXT_ULP_CF_IDX_I_L4_SRC_PORT_MASK = 23,
	BNXT_ULP_CF_IDX_I_L4_DST_PORT_MASK = 24,
	BNXT_ULP_CF_IDX_O_L4_FB_SRC_PORT = 25,
	BNXT_ULP_CF_IDX_O_L4_FB_DST_PORT = 26,
	BNXT_ULP_CF_IDX_I_L4_FB_SRC_PORT = 27,
	BNXT_ULP_CF_IDX_I_L4_FB_DST_PORT = 28,
	BNXT_ULP_CF_IDX_O_L3_FB_PROTO_ID = 29,
	BNXT_ULP_CF_IDX_I_L3_FB_PROTO_ID = 30,
	BNXT_ULP_CF_IDX_O_L3_PROTO_ID = 31,
	BNXT_ULP_CF_IDX_I_L3_PROTO_ID = 32,
	BNXT_ULP_CF_IDX_O_L3_TTL = 33,
	BNXT_ULP_CF_IDX_DEV_PORT_ID = 34,
	BNXT_ULP_CF_IDX_DRV_FUNC_SVIF = 35,
	BNXT_ULP_CF_IDX_DRV_FUNC_SPIF = 36,
	BNXT_ULP_CF_IDX_DRV_FUNC_PARIF = 37,
	BNXT_ULP_CF_IDX_DRV_FUNC_VNIC = 38,
	BNXT_ULP_CF_IDX_DRV_FUNC_PHY_PORT = 39,
	BNXT_ULP_CF_IDX_VF_FUNC_SVIF = 40,
	BNXT_ULP_CF_IDX_VF_FUNC_SPIF = 41,
	BNXT_ULP_CF_IDX_VF_FUNC_PARIF = 42,
	BNXT_ULP_CF_IDX_VF_FUNC_VNIC = 43,
	BNXT_ULP_CF_IDX_VNIC = 44,
	BNXT_ULP_CF_IDX_PHY_PORT_SVIF = 45,
	BNXT_ULP_CF_IDX_PHY_PORT_SPIF = 46,
	BNXT_ULP_CF_IDX_PHY_PORT_PARIF = 47,
	BNXT_ULP_CF_IDX_PHY_PORT_VPORT = 48,
	BNXT_ULP_CF_IDX_ACT_ENCAP_IPV4_FLAG = 49,
	BNXT_ULP_CF_IDX_ACT_ENCAP_IPV6_FLAG = 50,
	BNXT_ULP_CF_IDX_ACT_DEC_TTL = 51,
	BNXT_ULP_CF_IDX_ACT_T_DEC_TTL = 52,
	BNXT_ULP_CF_IDX_ACT_PORT_IS_SET = 53,
	BNXT_ULP_CF_IDX_ACT_PORT_TYPE = 54,
	BNXT_ULP_CF_IDX_ACT_MIRR_PORT_IS_SET = 55,
	BNXT_ULP_CF_IDX_ACT_MIRR_PORT_TYPE = 56,
	BNXT_ULP_CF_IDX_MATCH_PORT_TYPE = 57,
	BNXT_ULP_CF_IDX_MATCH_PORT_IS_VFREP = 58,
	BNXT_ULP_CF_IDX_MATCH_PORT_IS_PF = 59,
	BNXT_ULP_CF_IDX_VF_TO_VF = 60,
	BNXT_ULP_CF_IDX_L3_HDR_CNT = 61,
	BNXT_ULP_CF_IDX_L4_HDR_CNT = 62,
	BNXT_ULP_CF_IDX_VFR_MODE = 63,
	BNXT_ULP_CF_IDX_L3_TUN = 64,
	BNXT_ULP_CF_IDX_L3_TUN_DECAP = 65,
	BNXT_ULP_CF_IDX_FID = 66,
	BNXT_ULP_CF_IDX_HDR_SIG_ID = 67,
	BNXT_ULP_CF_IDX_FLOW_SIG_ID = 68,
	BNXT_ULP_CF_IDX_WC_MATCH = 69,
	BNXT_ULP_CF_IDX_WC_IS_HA_HIGH_REG = 70,
	BNXT_ULP_CF_IDX_TUNNEL_ID = 71,
	BNXT_ULP_CF_IDX_TUN_OFF_DIP_ID = 72,
	BNXT_ULP_CF_IDX_TUN_OFF_DMAC_ID = 73,
	BNXT_ULP_CF_IDX_OO_VLAN_FB_VID = 74,
	BNXT_ULP_CF_IDX_OI_VLAN_FB_VID = 75,
	BNXT_ULP_CF_IDX_IO_VLAN_FB_VID = 76,
	BNXT_ULP_CF_IDX_II_VLAN_FB_VID = 77,
	BNXT_ULP_CF_IDX_SOCKET_DIRECT = 78,
	BNXT_ULP_CF_IDX_SOCKET_DIRECT_VPORT = 79,
	BNXT_ULP_CF_IDX_TUNNEL_SPORT = 80,
	BNXT_ULP_CF_IDX_VF_META_FID = 81,
	BNXT_ULP_CF_IDX_DEV_ACT_PORT_ID = 82,
	BNXT_ULP_CF_IDX_DEV_ACT_MIRR_PORT_ID = 83,
	BNXT_ULP_CF_IDX_O_VLAN_NO_IGNORE = 84,
	BNXT_ULP_CF_IDX_I_VLAN_NO_IGNORE = 85,
	BNXT_ULP_CF_IDX_HA_SUPPORT_DISABLED = 86,
	BNXT_ULP_CF_IDX_FUNCTION_ID = 87,
	BNXT_ULP_CF_IDX_CHAIN_ID_METADATA = 88,
	BNXT_ULP_CF_IDX_SRV6_UPAR_ID = 89,
	BNXT_ULP_CF_IDX_SRV6_T_ID = 90,
	BNXT_ULP_CF_IDX_GENERIC_SIZE = 91,
	BNXT_ULP_CF_IDX_APP_PRIORITY = 92,
	BNXT_ULP_CF_IDX_MIRROR_COPY_ING_OR_EGR = 93,
	BNXT_ULP_CF_IDX_EM_FOR_IPV6 = 94,
	BNXT_ULP_CF_IDX_VF_ROCE_EN = 95,
	BNXT_ULP_CF_IDX_EM_FOR_TC = 96,
	BNXT_ULP_CF_IDX_L2_CUSTOM_UPAR_ID = 97,
	BNXT_ULP_CF_IDX_CUSTOM_GRE_EN = 98,
	BNXT_ULP_CF_IDX_UPAR_HIGH_EN = 99,
	BNXT_ULP_CF_IDX_MP_NPORTS = 100,
	BNXT_ULP_CF_IDX_MP_PORT_A = 101,
	BNXT_ULP_CF_IDX_MP_VNIC_A = 102,
	BNXT_ULP_CF_IDX_MP_VPORT_A = 103,
	BNXT_ULP_CF_IDX_MP_MDATA_A = 104,
	BNXT_ULP_CF_IDX_MP_A_IS_VFREP = 105,
	BNXT_ULP_CF_IDX_MP_PORT_B = 106,
	BNXT_ULP_CF_IDX_MP_VNIC_B = 107,
	BNXT_ULP_CF_IDX_MP_VPORT_B = 108,
	BNXT_ULP_CF_IDX_MP_MDATA_B = 109,
	BNXT_ULP_CF_IDX_MP_B_IS_VFREP = 110,
	BNXT_ULP_CF_IDX_VXLAN_IP_UPAR_ID = 111,
	BNXT_ULP_CF_IDX_ACT_REJ_COND_EN = 112,
	BNXT_ULP_CF_IDX_HDR_BITMAP = 113,
	BNXT_ULP_CF_IDX_PROFILE_BITMAP = 114,
	BNXT_ULP_CF_IDX_DSCP_REMAP = 115,
	BNXT_ULP_CF_IDX_LAST = 116
};

enum bnxt_ulp_cond_list_opc {
	BNXT_ULP_COND_LIST_OPC_TRUE = 0,
	BNXT_ULP_COND_LIST_OPC_FALSE = 1,
	BNXT_ULP_COND_LIST_OPC_OR = 2,
	BNXT_ULP_COND_LIST_OPC_AND = 3,
	BNXT_ULP_COND_LIST_OPC_LIST_OR = 4,
	BNXT_ULP_COND_LIST_OPC_LIST_AND = 5,
	BNXT_ULP_COND_LIST_OPC_LAST = 6
};

enum bnxt_ulp_cond_opc {
	BNXT_ULP_COND_OPC_CF_IS_SET = 0,
	BNXT_ULP_COND_OPC_CF_NOT_SET = 1,
	BNXT_ULP_COND_OPC_ACT_BIT_IS_SET = 2,
	BNXT_ULP_COND_OPC_ACT_BIT_NOT_SET = 3,
	BNXT_ULP_COND_OPC_HDR_BIT_IS_SET = 4,
	BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET = 5,
	BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET = 6,
	BNXT_ULP_COND_OPC_FIELD_BIT_NOT_SET = 7,
	BNXT_ULP_COND_OPC_RF_IS_SET = 8,
	BNXT_ULP_COND_OPC_RF_NOT_SET = 9,
	BNXT_ULP_COND_OPC_FLOW_PAT_MATCH = 10,
	BNXT_ULP_COND_OPC_ACT_PAT_MATCH = 11,
	BNXT_ULP_COND_OPC_EXT_MEM_IS_SET = 12,
	BNXT_ULP_COND_OPC_EXT_MEM_NOT_SET = 13,
	BNXT_ULP_COND_OPC_ENC_HDR_BIT_IS_SET = 14,
	BNXT_ULP_COND_OPC_ENC_HDR_BIT_NOT_SET = 15,
	BNXT_ULP_COND_OPC_ACT_PROP_IS_SET = 16,
	BNXT_ULP_COND_OPC_ACT_PROP_NOT_SET = 17,
	BNXT_ULP_COND_OPC_CF_BIT_IS_SET = 18,
	BNXT_ULP_COND_OPC_CF_BIT_NOT_SET = 19,
	BNXT_ULP_COND_OPC_WC_FIELD_BIT_IS_SET = 20,
	BNXT_ULP_COND_OPC_WC_FIELD_BIT_NOT_SET = 21,
	BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_IS_SET = 22,
	BNXT_ULP_COND_OPC_EXCLUDE_FIELD_BIT_NOT_SET = 23,
	BNXT_ULP_COND_OPC_FEATURE_BIT_IS_SET = 24,
	BNXT_ULP_COND_OPC_FEATURE_BIT_NOT_SET = 25,
	BNXT_ULP_COND_OPC_LAST = 26
};

enum bnxt_ulp_critical_resource {
	BNXT_ULP_CRITICAL_RESOURCE_NO = 0,
	BNXT_ULP_CRITICAL_RESOURCE_YES = 1,
	BNXT_ULP_CRITICAL_RESOURCE_LAST = 2
};

enum bnxt_ulp_device_id {
	BNXT_ULP_DEVICE_ID_WH_PLUS = 0,
	BNXT_ULP_DEVICE_ID_THOR = 1,
	BNXT_ULP_DEVICE_ID_STINGRAY = 2,
	BNXT_ULP_DEVICE_ID_STINGRAY2 = 3,
	BNXT_ULP_DEVICE_ID_THOR2 = 4,
	BNXT_ULP_DEVICE_ID_LAST = 5
};

enum bnxt_ulp_df_param_type {
	BNXT_ULP_DF_PARAM_TYPE_DEV_PORT_ID = 0,
	BNXT_ULP_DF_PARAM_TYPE_LAST = 1
};

enum bnxt_ulp_direction {
	BNXT_ULP_DIRECTION_INGRESS = 0,
	BNXT_ULP_DIRECTION_EGRESS = 1,
	BNXT_ULP_DIRECTION_LAST = 2
};

enum bnxt_ulp_em_tbl_opc {
	BNXT_ULP_EM_TBL_OPC_NOT_USED = 0,
	BNXT_ULP_EM_TBL_OPC_WR_REGFILE = 1,
	BNXT_ULP_EM_TBL_OPC_LAST = 2
};

enum bnxt_ulp_enc_field {
	BNXT_ULP_ENC_FIELD_ETH_DMAC = 0,
	BNXT_ULP_ENC_FIELD_ETH_SMAC = 1,
	BNXT_ULP_ENC_FIELD_ETH_TYPE = 2,
	BNXT_ULP_ENC_FIELD_O_VLAN_TCI = 3,
	BNXT_ULP_ENC_FIELD_O_VLAN_TYPE = 4,
	BNXT_ULP_ENC_FIELD_I_VLAN_TCI = 5,
	BNXT_ULP_ENC_FIELD_I_VLAN_TYPE = 6,
	BNXT_ULP_ENC_FIELD_IPV4_IHL = 7,
	BNXT_ULP_ENC_FIELD_IPV4_TOS = 8,
	BNXT_ULP_ENC_FIELD_IPV4_PKT_ID = 9,
	BNXT_ULP_ENC_FIELD_IPV4_FRAG = 10,
	BNXT_ULP_ENC_FIELD_IPV4_TTL = 11,
	BNXT_ULP_ENC_FIELD_IPV4_PROTO = 12,
	BNXT_ULP_ENC_FIELD_IPV4_SADDR = 13,
	BNXT_ULP_ENC_FIELD_IPV4_DADDR = 14,
	BNXT_ULP_ENC_FIELD_IPV6_VTC_FLOW = 15,
	BNXT_ULP_ENC_FIELD_IPV6_PROTO = 16,
	BNXT_ULP_ENC_FIELD_IPV6_TTL = 17,
	BNXT_ULP_ENC_FIELD_IPV6_SADDR = 18,
	BNXT_ULP_ENC_FIELD_IPV6_DADDR = 19,
	BNXT_ULP_ENC_FIELD_UDP_SPORT = 20,
	BNXT_ULP_ENC_FIELD_UDP_DPORT = 21,
	BNXT_ULP_ENC_FIELD_VXLAN_FLAGS = 22,
	BNXT_ULP_ENC_FIELD_VXLAN_RSVD0 = 23,
	BNXT_ULP_ENC_FIELD_VXLAN_VNI = 24,
	BNXT_ULP_ENC_FIELD_VXLAN_RSVD1 = 25,
	BNXT_ULP_ENC_FIELD_SRV6_NEXT_HDR = 26,
	BNXT_ULP_ENC_FIELD_SRV6_HDR_LEN = 27,
	BNXT_ULP_ENC_FIELD_SRV6_ROUTING_TYPE = 28,
	BNXT_ULP_ENC_FIELD_SRV6_SEG_LEFT = 29,
	BNXT_ULP_ENC_FIELD_SRV6_LAST_ENTRY = 30,
	BNXT_ULP_ENC_FIELD_SRV6_FLAGS = 31,
	BNXT_ULP_ENC_FIELD_SRV6_TAG = 32,
	BNXT_ULP_ENC_FIELD_SRV6_SEG_LIST0 = 33,
	BNXT_ULP_ENC_FIELD_SRV6_SEG_LIST1 = 34,
	BNXT_ULP_ENC_FIELD_SRV6_SEG_LIST2 = 35,
	BNXT_ULP_ENC_FIELD_SRV6_SEG_LIST3 = 36,
	BNXT_ULP_ENC_FIELD_GENERIC_SIZE = 37,
	BNXT_ULP_ENC_FIELD_GENERIC_RSVD = 38,
	BNXT_ULP_ENC_FIELD_VXLAN_GPE_FLAGS = 39,
	BNXT_ULP_ENC_FIELD_VXLAN_GPE_RSVD0 = 40,
	BNXT_ULP_ENC_FIELD_VXLAN_GPE_NEXT_PROTO = 41,
	BNXT_ULP_ENC_FIELD_VXLAN_GPE_VNI = 42,
	BNXT_ULP_ENC_FIELD_VXLAN_GPE_RSVD1 = 43,
	BNXT_ULP_ENC_FIELD_GENEVE_VER_OPT_LEN_O_C_RSVD0 = 44,
	BNXT_ULP_ENC_FIELD_GENEVE_PROTO_TYPE = 45,
	BNXT_ULP_ENC_FIELD_GENEVE_VNI = 46,
	BNXT_ULP_ENC_FIELD_GENEVE_RSVD1 = 47,
	BNXT_ULP_ENC_FIELD_GENEVE_OPT_W0 = 48,
	BNXT_ULP_ENC_FIELD_GENEVE_OPT_W1 = 49,
	BNXT_ULP_ENC_FIELD_GENEVE_OPT_W2 = 50,
	BNXT_ULP_ENC_FIELD_GENEVE_OPT_W3 = 51,
	BNXT_ULP_ENC_FIELD_GENEVE_OPT_W4 = 52,
	BNXT_ULP_ENC_FIELD_GENEVE_OPT_W5 = 53,
	BNXT_ULP_ENC_FIELD_LAST = 54
};

enum bnxt_ulp_fdb_opc {
	BNXT_ULP_FDB_OPC_PUSH_FID = 0,
	BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE = 1,
	BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE = 2,
	BNXT_ULP_FDB_OPC_DELETE_RID_REGFILE = 3,
	BNXT_ULP_FDB_OPC_CLEAR_RID_REGFILE = 4,
	BNXT_ULP_FDB_OPC_NOP = 5,
	BNXT_ULP_FDB_OPC_PUSH_FID_SW_ONLY = 6,
	BNXT_ULP_FDB_OPC_LAST = 7
};

enum bnxt_ulp_fdb_type {
	BNXT_ULP_FDB_TYPE_REGULAR = 0,
	BNXT_ULP_FDB_TYPE_DEFAULT = 1,
	BNXT_ULP_FDB_TYPE_RID = 2,
	BNXT_ULP_FDB_TYPE_LAST = 3
};

enum bnxt_ulp_field_opc {
	BNXT_ULP_FIELD_OPC_SRC1 = 0,
	BNXT_ULP_FIELD_OPC_SRC1_THEN_SRC2_ELSE_SRC3 = 1,
	BNXT_ULP_FIELD_OPC_SRC1_PLUS_SRC2 = 2,
	BNXT_ULP_FIELD_OPC_SRC1_MINUS_SRC2 = 3,
	BNXT_ULP_FIELD_OPC_SRC1_PLUS_SRC2_POST = 4,
	BNXT_ULP_FIELD_OPC_SRC1_MINUS_SRC2_POST = 5,
	BNXT_ULP_FIELD_OPC_SRC1_OR_SRC2 = 6,
	BNXT_ULP_FIELD_OPC_SRC1_OR_SRC2_OR_SRC3 = 7,
	BNXT_ULP_FIELD_OPC_SRC1_AND_SRC2 = 8,
	BNXT_ULP_FIELD_OPC_SRC1_AND_SRC2_OR_SRC3 = 9,
	BNXT_ULP_FIELD_OPC_SKIP = 10,
	BNXT_ULP_FIELD_OPC_TERNARY_LIST = 11,
	BNXT_ULP_FIELD_OPC_LAST = 12
};

enum bnxt_ulp_field_src {
	BNXT_ULP_FIELD_SRC_ZERO = 0,
	BNXT_ULP_FIELD_SRC_ONES = 1,
	BNXT_ULP_FIELD_SRC_CONST = 2,
	BNXT_ULP_FIELD_SRC_CF = 3,
	BNXT_ULP_FIELD_SRC_RF = 4,
	BNXT_ULP_FIELD_SRC_ACT_PROP = 5,
	BNXT_ULP_FIELD_SRC_ACT_PROP_SZ = 6,
	BNXT_ULP_FIELD_SRC_GLB_RF = 7,
	BNXT_ULP_FIELD_SRC_HF = 8,
	BNXT_ULP_FIELD_SRC_SUB_HF = 9,
	BNXT_ULP_FIELD_SRC_HDR_BIT = 10,
	BNXT_ULP_FIELD_SRC_ACT_BIT = 11,
	BNXT_ULP_FIELD_SRC_FIELD_BIT = 12,
	BNXT_ULP_FIELD_SRC_SKIP = 13,
	BNXT_ULP_FIELD_SRC_REJECT = 14,
	BNXT_ULP_FIELD_SRC_PORT_TABLE = 15,
	BNXT_ULP_FIELD_SRC_ENC_HDR_BIT = 16,
	BNXT_ULP_FIELD_SRC_ENC_FIELD = 17,
	BNXT_ULP_FIELD_SRC_LIST_AND = 18,
	BNXT_ULP_FIELD_SRC_LIST_OR = 19,
	BNXT_ULP_FIELD_SRC_NEXT = 20,
	BNXT_ULP_FIELD_SRC_LAST = 21
};

enum bnxt_ulp_func_opc {
	BNXT_ULP_FUNC_OPC_NOP = 0,
	BNXT_ULP_FUNC_OPC_EQ = 1,
	BNXT_ULP_FUNC_OPC_NE = 2,
	BNXT_ULP_FUNC_OPC_GT = 3,
	BNXT_ULP_FUNC_OPC_GE = 4,
	BNXT_ULP_FUNC_OPC_LT = 5,
	BNXT_ULP_FUNC_OPC_LE = 6,
	BNXT_ULP_FUNC_OPC_COPY_SRC1_TO_RF = 7,
	BNXT_ULP_FUNC_OPC_RSS_CONFIG = 8,
	BNXT_ULP_FUNC_OPC_GET_PARENT_MAC_ADDR = 9,
	BNXT_ULP_FUNC_OPC_ALLOC_L2_CTX_ID = 10,
	BNXT_ULP_FUNC_OPC_TUNNEL_DST_PORT_ALLOC = 11,
	BNXT_ULP_FUNC_OPC_TUNNEL_DST_PORT_FREE = 12,
	BNXT_ULP_FUNC_OPC_HANDLE_TO_OFFSET = 13,
	BNXT_ULP_FUNC_OPC_VFR_MARK_SET = 14,
	BNXT_ULP_FUNC_OPC_BD_ACT_SET = 15,
	BNXT_ULP_FUNC_OPC_LEFT_SHIFT = 16,
	BNXT_ULP_FUNC_OPC_RIGHT_SHIFT = 17,
	BNXT_ULP_FUNC_OPC_BIT_OR = 18,
	BNXT_ULP_FUNC_OPC_BIT_AND = 19,
	BNXT_ULP_FUNC_OPC_BIT_XOR = 20,
	BNXT_ULP_FUNC_OPC_LOG_AND = 21,
	BNXT_ULP_FUNC_OPC_LOG_OR = 22,
	BNXT_ULP_FUNC_OPC_NOT_NOT = 23,
	BNXT_ULP_FUNC_OPC_ADD = 24,
	BNXT_ULP_FUNC_OPC_SUB = 25,
	BNXT_ULP_FUNC_OPC_COND_LIST = 26,
	BNXT_ULP_FUNC_OPC_LAST = 27
};

enum bnxt_ulp_func_src {
	BNXT_ULP_FUNC_SRC_REGFILE = 0,
	BNXT_ULP_FUNC_SRC_GLB_REGFILE = 1,
	BNXT_ULP_FUNC_SRC_COMP_FIELD = 2,
	BNXT_ULP_FUNC_SRC_CONST = 3,
	BNXT_ULP_FUNC_SRC_ACTION_BITMAP = 4,
	BNXT_ULP_FUNC_SRC_HEADER_BITMAP = 5,
	BNXT_ULP_FUNC_SRC_KEY_EXT_LIST = 6,
	BNXT_ULP_FUNC_SRC_LAST = 7
};

enum bnxt_ulp_gen_tbl_type {
	BNXT_ULP_GEN_TBL_TYPE_KEY_LIST = 0,
	BNXT_ULP_GEN_TBL_TYPE_HASH_LIST = 1,
	BNXT_ULP_GEN_TBL_TYPE_SIMPLE_LIST = 2,
	BNXT_ULP_GEN_TBL_TYPE_LAST = 3
};

enum bnxt_ulp_generic_tbl_lkup_type {
	BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX = 0,
	BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH = 1,
	BNXT_ULP_GENERIC_TBL_LKUP_TYPE_SEQ = 2,
	BNXT_ULP_GENERIC_TBL_LKUP_TYPE_LAST = 3
};

enum bnxt_ulp_generic_tbl_opc {
	BNXT_ULP_GENERIC_TBL_OPC_NOT_USED = 0,
	BNXT_ULP_GENERIC_TBL_OPC_READ = 1,
	BNXT_ULP_GENERIC_TBL_OPC_WRITE = 2,
	BNXT_ULP_GENERIC_TBL_OPC_LAST = 3
};

enum bnxt_ulp_glb_rf_idx {
	BNXT_ULP_GLB_RF_IDX_NOT_USED = 0,
	BNXT_ULP_GLB_RF_IDX_GLB_PROF_FUNC_ID = 1,
	BNXT_ULP_GLB_RF_IDX_GLB_PROF_FUNC_ID_0 = 2,
	BNXT_ULP_GLB_RF_IDX_GLB_PROF_FUNC_ID_1 = 3,
	BNXT_ULP_GLB_RF_IDX_GLB_PROF_FUNC_ID_2 = 4,
	BNXT_ULP_GLB_RF_IDX_GLB_LB_AREC_PTR = 5,
	BNXT_ULP_GLB_RF_IDX_L2_PROF_FUNC_ID = 6,
	BNXT_ULP_GLB_RF_IDX_GLB_L2_CNTXT_ID_0 = 7,
	BNXT_ULP_GLB_RF_IDX_GLB_L2_CNTXT_ID_1 = 8,
	BNXT_ULP_GLB_RF_IDX_VXLAN_PROF_FUNC_ID = 9,
	BNXT_ULP_GLB_RF_IDX_VF_2_VFR_PROF_FUNC_ID = 10,
	BNXT_ULP_GLB_RF_IDX_ANY_2_VF_PROF_FUNC_ID = 11,
	BNXT_ULP_GLB_RF_IDX_GLB_MODIFY_PTR = 12,
	BNXT_ULP_GLB_RF_IDX_GLB_DROP_AREC_PTR = 13,
	BNXT_ULP_GLB_RF_IDX_ENCAP_MAC_PTR = 14,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_PROFILE_ID_0 = 15,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_PROFILE_ID_1 = 16,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_PROFILE_ID_2 = 17,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_PROFILE_ID_3 = 18,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_PROFILE_ID_4 = 19,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_PROFILE_ID_5 = 20,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_PROFILE_ID_6 = 21,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_PROFILE_ID_7 = 22,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_PROFILE_ID_8 = 23,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_PROFILE_ID_9 = 24,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_KEY_ID_0 = 25,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_KEY_ID_1 = 26,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_KEY_ID_2 = 27,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_KEY_ID_3 = 28,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_KEY_ID_4 = 29,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_KEY_ID_5 = 30,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_KEY_ID_6 = 31,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_KEY_ID_7 = 32,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_KEY_ID_8 = 33,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_PROFILE_ID_0 = 34,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_PROFILE_ID_1 = 35,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_PROFILE_ID_2 = 36,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_PROFILE_ID_3 = 37,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_PROFILE_ID_4 = 38,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_PROFILE_ID_5 = 39,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_PROFILE_ID_6 = 40,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_PROFILE_ID_7 = 41,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_PROFILE_ID_8 = 42,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_PROFILE_ID_9 = 43,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_KEY_ID_0 = 44,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_KEY_ID_1 = 45,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_KEY_ID_2 = 46,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_KEY_ID_3 = 47,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_KEY_ID_4 = 48,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_KEY_ID_5 = 49,
	BNXT_ULP_GLB_RF_IDX_GLB_METADATA_PROF_0 = 50,
	BNXT_ULP_GLB_RF_IDX_GLB_METADATA_PROF_1 = 51,
	BNXT_ULP_GLB_RF_IDX_GLB_METADATA_RX_PROF_0 = 52,
	BNXT_ULP_GLB_RF_IDX_GLB_METADATA_RX_ACT_0 = 53,
	BNXT_ULP_GLB_RF_IDX_GLB_METADATA_RX_LKUP_0 = 54,
	BNXT_ULP_GLB_RF_IDX_GLB_METADATA_TX_PROF_0 = 55,
	BNXT_ULP_GLB_RF_IDX_GLB_METADATA_TX_ACT_0 = 56,
	BNXT_ULP_GLB_RF_IDX_GLB_METADATA_TX_LKUP_0 = 57,
	BNXT_ULP_GLB_RF_IDX_GLB_VFR_EM_KEY_ID_0 = 58,
	BNXT_ULP_GLB_RF_IDX_GLB_VFR_EM_KEY_ID_1 = 59,
	BNXT_ULP_GLB_RF_IDX_GLB_VFR_EM_PROF_ID_0 = 60,
	BNXT_ULP_GLB_RF_IDX_GLB_VFR_EM_PROF_ID_1 = 61,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_PROF_FUNC_ID_0 = 62,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_PROF_FUNC_ID_1 = 63,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_PROF_FUNC_ID_2 = 64,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_PROF_FUNC_ID_3 = 65,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_PROF_FUNC_ID_4 = 66,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_L2_CNTXT_ID_0 = 67,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_L2_CNTXT_ID_1 = 68,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_L2_CNTXT_ID_2 = 69,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_L2_CNTXT_ID_3 = 70,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_EM_PROFILE_ID_0 = 71,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_EM_PROFILE_ID_1 = 72,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_0 = 73,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_1 = 74,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_2 = 75,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_3 = 76,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_4 = 77,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_5 = 78,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_6 = 79,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_7 = 80,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_8 = 81,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_9 = 82,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_10 = 83,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_EM_KEY_ID_0 = 84,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_EM_KEY_ID_1 = 85,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_KEY_ID_0 = 86,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_KEY_ID_1 = 87,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_KEY_ID_2 = 88,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_KEY_ID_3 = 89,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_KEY_ID_4 = 90,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_KEY_ID_5 = 91,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_AREC_PTR_0 = 92,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_AREC_PTR_1 = 93,
	BNXT_ULP_GLB_RF_IDX_GRE_PROF_FUNC_ID = 94,
	BNXT_ULP_GLB_RF_IDX_RECYCLE_PROF_FUNC_ID = 95,
	BNXT_ULP_GLB_RF_IDX_GLB_ECPRI_UPAR_ID = 96,
	BNXT_ULP_GLB_RF_IDX_GLB_ECPRI_PROF_FUNC_ID = 97,
	BNXT_ULP_GLB_RF_IDX_LAST = 98
};

enum bnxt_ulp_global_register_tbl_opc {
	BNXT_ULP_GLOBAL_REGISTER_TBL_OPC_NOT_USED = 0,
	BNXT_ULP_GLOBAL_REGISTER_TBL_OPC_WR_REGFILE = 1,
	BNXT_ULP_GLOBAL_REGISTER_TBL_OPC_LAST = 2
};

enum bnxt_ulp_hdr_type {
	BNXT_ULP_HDR_TYPE_NOT_SUPPORTED = 0,
	BNXT_ULP_HDR_TYPE_SUPPORTED = 1,
	BNXT_ULP_HDR_TYPE_END = 2,
	BNXT_ULP_HDR_TYPE_LAST = 3
};

enum bnxt_ulp_if_tbl_opc {
	BNXT_ULP_IF_TBL_OPC_NOT_USED = 0,
	BNXT_ULP_IF_TBL_OPC_WR_COMP_FIELD = 1,
	BNXT_ULP_IF_TBL_OPC_WR_REGFILE = 2,
	BNXT_ULP_IF_TBL_OPC_WR_CONST = 3,
	BNXT_ULP_IF_TBL_OPC_RD_COMP_FIELD = 4,
	BNXT_ULP_IF_TBL_OPC_LAST = 5
};

enum bnxt_ulp_index_tbl_opc {
	BNXT_ULP_INDEX_TBL_OPC_NOT_USED = 0,
	BNXT_ULP_INDEX_TBL_OPC_ALLOC_REGFILE = 1,
	BNXT_ULP_INDEX_TBL_OPC_WR_REGFILE = 2,
	BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE = 3,
	BNXT_ULP_INDEX_TBL_OPC_RD_REGFILE = 4,
	BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_GLB_REGFILE = 5,
	BNXT_ULP_INDEX_TBL_OPC_WR_GLB_REGFILE = 6,
	BNXT_ULP_INDEX_TBL_OPC_UPDATE_REGFILE = 7,
	BNXT_ULP_INDEX_TBL_OPC_NOP_REGFILE = 8,
	BNXT_ULP_INDEX_TBL_OPC_LAST = 9
};

enum bnxt_ulp_key_recipe_opc {
	BNXT_ULP_KEY_RECIPE_OPC_NOP = 0,
	BNXT_ULP_KEY_RECIPE_OPC_DYN_KEY = 1,
	BNXT_ULP_KEY_RECIPE_OPC_LAST = 2
};

enum bnxt_ulp_key_recipe_tbl_opc {
	BNXT_ULP_KEY_RECIPE_TBL_OPC_NOT_USED = 0,
	BNXT_ULP_KEY_RECIPE_TBL_OPC_ALLOC_REGFILE = 1,
	BNXT_ULP_KEY_RECIPE_TBL_OPC_ALLOC_WR_REGFILE = 2,
	BNXT_ULP_KEY_RECIPE_TBL_OPC_WR_REGFILE = 3,
	BNXT_ULP_KEY_RECIPE_TBL_OPC_LAST = 4
};

enum bnxt_ulp_mark_db_opc {
	BNXT_ULP_MARK_DB_OPC_NOP = 0,
	BNXT_ULP_MARK_DB_OPC_PUSH_IF_MARK_ACTION = 1,
	BNXT_ULP_MARK_DB_OPC_PUSH_AND_SET_VFR_FLAG = 2,
	BNXT_ULP_MARK_DB_OPC_LAST = 3
};

enum bnxt_ulp_match_type {
	BNXT_ULP_MATCH_TYPE_EM = 0,
	BNXT_ULP_MATCH_TYPE_WM = 1,
	BNXT_ULP_MATCH_TYPE_LAST = 2
};

enum bnxt_ulp_port_table {
	BNXT_ULP_PORT_TABLE_DRV_FUNC_PARENT_MAC = 0,
	BNXT_ULP_PORT_TABLE_DRV_FUNC_PARENT_VNIC = 1,
	BNXT_ULP_PORT_TABLE_DRV_FUNC_SVIF = 2,
	BNXT_ULP_PORT_TABLE_DRV_FUNC_SPIF = 3,
	BNXT_ULP_PORT_TABLE_DRV_FUNC_PARIF = 4,
	BNXT_ULP_PORT_TABLE_DRV_FUNC_VNIC = 5,
	BNXT_ULP_PORT_TABLE_DRV_FUNC_PHY_PORT = 6,
	BNXT_ULP_PORT_TABLE_DRV_FUNC_MAC = 7,
	BNXT_ULP_PORT_TABLE_VF_FUNC_SVIF = 8,
	BNXT_ULP_PORT_TABLE_VF_FUNC_SPIF = 9,
	BNXT_ULP_PORT_TABLE_VF_FUNC_PARIF = 10,
	BNXT_ULP_PORT_TABLE_VF_FUNC_VNIC = 11,
	BNXT_ULP_PORT_TABLE_VF_FUNC_MAC = 12,
	BNXT_ULP_PORT_TABLE_PHY_PORT_SVIF = 13,
	BNXT_ULP_PORT_TABLE_PHY_PORT_SPIF = 14,
	BNXT_ULP_PORT_TABLE_PHY_PORT_PARIF = 15,
	BNXT_ULP_PORT_TABLE_PHY_PORT_VPORT = 16,
	BNXT_ULP_PORT_TABLE_PORT_IS_PF = 17,
	BNXT_ULP_PORT_TABLE_VF_FUNC_METADATA = 18,
	BNXT_ULP_PORT_TABLE_VF_FUNC_FID = 19,
	BNXT_ULP_PORT_TABLE_TABLE_SCOPE = 20,
	BNXT_ULP_PORT_TABLE_LAST = 21
};

enum bnxt_ulp_pri_opc {
	BNXT_ULP_PRI_OPC_NOT_USED = 0,
	BNXT_ULP_PRI_OPC_CONST = 1,
	BNXT_ULP_PRI_OPC_APP_PRI = 2,
	BNXT_ULP_PRI_OPC_APP_PRI_OR_CONST = 3,
	BNXT_ULP_PRI_OPC_REGFILE = 4,
	BNXT_ULP_PRI_OPC_COMP_FIELD = 5,
	BNXT_ULP_PRI_OPC_LAST = 6
};

enum bnxt_ulp_ref_cnt_opc {
	BNXT_ULP_REF_CNT_OPC_DEFAULT = 0,
	BNXT_ULP_REF_CNT_OPC_NOP = 1,
	BNXT_ULP_REF_CNT_OPC_DEC = 2,
	BNXT_ULP_REF_CNT_OPC_INC = 3,
	BNXT_ULP_REF_CNT_OPC_LAST = 4
};

enum bnxt_ulp_rf_idx {
	BNXT_ULP_RF_IDX_NOT_USED = 0,
	BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 = 1,
	BNXT_ULP_RF_IDX_L2_CNTXT_ID_1 = 2,
	BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 = 3,
	BNXT_ULP_RF_IDX_PROF_FUNC_ID_1 = 4,
	BNXT_ULP_RF_IDX_EM_PROFILE_ID_0 = 5,
	BNXT_ULP_RF_IDX_EM_PROFILE_ID_1 = 6,
	BNXT_ULP_RF_IDX_WC_PROFILE_ID_0 = 7,
	BNXT_ULP_RF_IDX_WC_PROFILE_ID_1 = 8,
	BNXT_ULP_RF_IDX_META_ACTION_PTR = 9,
	BNXT_ULP_RF_IDX_MIRR_ACTION_PTR = 10,
	BNXT_ULP_RF_IDX_MAIN_ACTION_PTR = 11,
	BNXT_ULP_RF_IDX_ACTION_PTR_0 = 12,
	BNXT_ULP_RF_IDX_ENCAP_PTR_0 = 13,
	BNXT_ULP_RF_IDX_ENCAP_PTR_1 = 14,
	BNXT_ULP_RF_IDX_MIRR_ENCAP_PTR_0 = 15,
	BNXT_ULP_RF_IDX_CRITICAL_RESOURCE = 16,
	BNXT_ULP_RF_IDX_FLOW_CNTR_PTR_0 = 17,
	BNXT_ULP_RF_IDX_FLOW_CNTR_PTR_1 = 18,
	BNXT_ULP_RF_IDX_MIRR_FLOW_CNTR_PTR_0 = 19,
	BNXT_ULP_RF_IDX_MAIN_SP_PTR = 20,
	BNXT_ULP_RF_IDX_MODIFY_IPV4_SRC_PTR_0 = 21,
	BNXT_ULP_RF_IDX_MODIFY_IPV4_DST_PTR_0 = 22,
	BNXT_ULP_RF_IDX_ACTION_REC_SIZE = 23,
	BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0 = 24,
	BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_1 = 25,
	BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0 = 26,
	BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_1 = 27,
	BNXT_ULP_RF_IDX_WC_TCAM_INDEX_0 = 28,
	BNXT_ULP_RF_IDX_WC_TCAM_INDEX_1 = 29,
	BNXT_ULP_RF_IDX_SRC_PROPERTY_PTR = 30,
	BNXT_ULP_RF_IDX_GENERIC_TBL_MISS = 31,
	BNXT_ULP_RF_IDX_MIRROR_PTR_0 = 32,
	BNXT_ULP_RF_IDX_MIRROR_ID_0 = 33,
	BNXT_ULP_RF_IDX_HDR_SIG_ID = 34,
	BNXT_ULP_RF_IDX_FLOW_SIG_ID = 35,
	BNXT_ULP_RF_IDX_RID = 36,
	BNXT_ULP_RF_IDX_WC_KEY_ID_0 = 37,
	BNXT_ULP_RF_IDX_EM_KEY_ID_0 = 38,
	BNXT_ULP_RF_IDX_DRV_FUNC_MAC = 39,
	BNXT_ULP_RF_IDX_DRV_FUNC_PARENT_MAC = 40,
	BNXT_ULP_RF_IDX_DEFAULT_AREC_PTR = 41,
	BNXT_ULP_RF_IDX_CC = 42,
	BNXT_ULP_RF_IDX_CF_FLOW_SIG_ID = 43,
	BNXT_ULP_RF_IDX_PHY_PORT = 44,
	BNXT_ULP_RF_IDX_METADATA_PROF = 45,
	BNXT_ULP_RF_IDX_MIRR_MODIFY_PTR = 46,
	BNXT_ULP_RF_IDX_MODIFY_PTR = 47,
	BNXT_ULP_RF_IDX_SOCK_DIR_SVIF = 48,
	BNXT_ULP_RF_IDX_SOCK_DIR_PARIF = 49,
	BNXT_ULP_RF_IDX_SOCK_DIR_ACT_PTR = 50,
	BNXT_ULP_RF_IDX_SOCK_DIR_PARENT_MAC = 51,
	BNXT_ULP_RF_IDX_RSS_VNIC = 52,
	BNXT_ULP_RF_IDX_PORT_IS_PF = 53,
	BNXT_ULP_RF_IDX_METER_PROFILE_PTR_0 = 54,
	BNXT_ULP_RF_IDX_METER_PTR_0 = 55,
	BNXT_ULP_RF_IDX_REF_CNT = 56,
	BNXT_ULP_RF_IDX_RF_0 = 57,
	BNXT_ULP_RF_IDX_RF_1 = 58,
	BNXT_ULP_RF_IDX_RF_2 = 59,
	BNXT_ULP_RF_IDX_RF_3 = 60,
	BNXT_ULP_RF_IDX_RF_4 = 61,
	BNXT_ULP_RF_IDX_RF_5 = 62,
	BNXT_ULP_RF_IDX_RF_6 = 63,
	BNXT_ULP_RF_IDX_RF_7 = 64,
	BNXT_ULP_RF_IDX_CMM_ACT_HNDL = 65,
	BNXT_ULP_RF_IDX_CMM_STAT_HNDL = 66,
	BNXT_ULP_RF_IDX_CMM_MOD_HNDL = 67,
	BNXT_ULP_RF_IDX_CMM_ENC_HNDL = 68,
	BNXT_ULP_RF_IDX_CMM_SRP_HNDL = 69,
	BNXT_ULP_RF_IDX_VF_FUNC_METADATA = 70,
	BNXT_ULP_RF_IDX_CHAIN_ID_METADATA = 71,
	BNXT_ULP_RF_IDX_RECYCLE_CNT = 72,
	BNXT_ULP_RF_IDX_DEST_VNIC = 73,
	BNXT_ULP_RF_IDX_DEST_VPORT = 74,
	BNXT_ULP_RF_IDX_DEST_METADATA = 75,
	BNXT_ULP_RF_IDX_PROF_TCAM_PRI = 76,
	BNXT_ULP_RF_IDX_EM_INSERT_FAIL = 77,
	BNXT_ULP_RF_IDX_PROF_TCAM_PRIORITY = 78,
	BNXT_ULP_RF_IDX_TERM_FLOW = 79,
	BNXT_ULP_RF_IDX_O_DMAC = 80,
	BNXT_ULP_RF_IDX_FLOW_CNTR_PTR_F1 = 81,
	BNXT_ULP_RF_IDX_CMM_STAT_HNDL_F1 = 82,
	BNXT_ULP_RF_IDX_WC_RECIPE_ID = 83,
	BNXT_ULP_RF_IDX_EM_RECIPE_ID = 84,
	BNXT_ULP_RF_IDX_LAST = 85
};

enum bnxt_ulp_tcam_tbl_opc {
	BNXT_ULP_TCAM_TBL_OPC_NOT_USED = 0,
	BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE = 1,
	BNXT_ULP_TCAM_TBL_OPC_SRCH_ALLOC_WR_REGFILE = 2,
	BNXT_ULP_TCAM_TBL_OPC_ALLOC_REGFILE = 3,
	BNXT_ULP_TCAM_TBL_OPC_WR_REGFILE = 4,
	BNXT_ULP_TCAM_TBL_OPC_ALLOC_IDENT = 5,
	BNXT_ULP_TCAM_TBL_OPC_LAST = 6
};

enum bnxt_ulp_template_type {
	BNXT_ULP_TEMPLATE_TYPE_CLASS = 0,
	BNXT_ULP_TEMPLATE_TYPE_ACTION = 1,
	BNXT_ULP_TEMPLATE_TYPE_LAST = 2
};

enum bnxt_ulp_vnic_tbl_opc {
	BNXT_ULP_VNIC_TBL_OPC_NOT_USED = 0,
	BNXT_ULP_VNIC_TBL_OPC_ALLOC_WR_REGFILE = 1,
	BNXT_ULP_VNIC_TBL_OPC_LAST = 2
};

enum bnxt_ulp_app_cap {
	BNXT_ULP_APP_CAP_SHARED_EN = 0x00000001,
	BNXT_ULP_APP_CAP_HOT_UPGRADE_EN = 0x00000002,
	BNXT_ULP_APP_CAP_UNICAST_ONLY = 0x00000004,
	BNXT_ULP_APP_CAP_SOCKET_DIRECT = 0x00000008,
	BNXT_ULP_APP_CAP_IP_TOS_PROTO_SUPPORT = 0x00000010,
	BNXT_ULP_APP_CAP_BC_MC_SUPPORT = 0x00000020,
	BNXT_ULP_APP_CAP_CUST_VXLAN = 0x00000040,
	BNXT_ULP_APP_CAP_HA_DYNAMIC = 0x00000080,
	BNXT_ULP_APP_CAP_SRV6 = 0x00000100,
	BNXT_ULP_APP_CAP_L2_ETYPE = 0x00000200,
	BNXT_ULP_APP_CAP_DSCP_REMAP = 0x00000400
};

enum bnxt_ulp_fdb_resource_flags {
	BNXT_ULP_FDB_RESOURCE_FLAGS_DIR_INGR = 0x00,
	BNXT_ULP_FDB_RESOURCE_FLAGS_DIR_EGR = 0x01
};

enum bnxt_ulp_feature_bit {
	BNXT_ULP_FEATURE_BIT_PARENT_DMAC = 0x00000001,
	BNXT_ULP_FEATURE_BIT_PORT_DMAC = 0x00000002
};

enum bnxt_ulp_flow_dir_bitmask {
	BNXT_ULP_FLOW_DIR_BITMASK_ING = 0x0000000000000000,
	BNXT_ULP_FLOW_DIR_BITMASK_EGR = 0x8000000000000000
};

enum bnxt_ulp_resource_func {
	BNXT_ULP_RESOURCE_FUNC_INVALID = 0x00,
	BNXT_ULP_RESOURCE_FUNC_EM_TABLE = 0x20,
	BNXT_ULP_RESOURCE_FUNC_CMM_TABLE = 0x40,
	BNXT_ULP_RESOURCE_FUNC_CMM_STAT = 0x60,
	BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE = 0x80,
	BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE = 0x81,
	BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE = 0x82,
	BNXT_ULP_RESOURCE_FUNC_IDENTIFIER = 0x83,
	BNXT_ULP_RESOURCE_FUNC_IF_TABLE = 0x84,
	BNXT_ULP_RESOURCE_FUNC_HW_FID = 0x85,
	BNXT_ULP_RESOURCE_FUNC_PARENT_FLOW = 0x86,
	BNXT_ULP_RESOURCE_FUNC_CHILD_FLOW = 0x87,
	BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE = 0x88,
	BNXT_ULP_RESOURCE_FUNC_VNIC_TABLE = 0x89,
	BNXT_ULP_RESOURCE_FUNC_GLOBAL_REGISTER_TABLE = 0x8a,
	BNXT_ULP_RESOURCE_FUNC_UDCC_V6SUBNET_TABLE = 0x8b,
	BNXT_ULP_RESOURCE_FUNC_KEY_RECIPE_TABLE = 0x8c
};

enum bnxt_ulp_resource_sub_type {
	BNXT_ULP_RESOURCE_SUB_TYPE_NOT_USED = 0,
	BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_NORMAL = 0,
	BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_VFR_CFA_ACTION = 1,
	BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_INT_COUNT = 2,
	BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_INT_COUNT_ACC = 3,
	BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_EXT_COUNT = 4,
	BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_CFA_TBLS = 5,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM = 0,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROFILE_TCAM = 1,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_SHARED_MIRROR = 2,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_MAC_ADDR_CACHE = 3,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PORT_TABLE = 4,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_TUNNEL_CACHE = 5,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_SOURCE_PROPERTY_CACHE = 6,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_VXLAN_ENCAP_REC_CACHE = 7,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_SOCKET_DIRECT_CACHE = 8,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_VXLAN_ENCAP_IPV6_REC_CACHE = 9,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_SOURCE_PROPERTY_IPV6_CACHE = 10,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_OUTER_TUNNEL_CACHE = 11,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_SHARED_METER_TBL_CACHE = 12,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_METER_PROFILE_TBL_CACHE = 13,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_GLOBAL_REGISTER_TBL = 14,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_CHAIN_ID_CACHE = 15,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_ENCAP_REC_CACHE = 16,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_SRV6_ENCAP_REC_CACHE = 17,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_RSS_PARAMS = 18,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_TABLE_SCOPE_CACHE = 19,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_GENEVE_ENCAP_REC_CACHE = 20,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROTO_HEADER = 21,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_EM_FLOW_CONFLICT = 22,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_HDR_OVERLAP = 23,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_MULTI_SHARED_MIRROR = 24,
	BNXT_ULP_RESOURCE_SUB_TYPE_VNIC_TABLE_RSS = 0,
	BNXT_ULP_RESOURCE_SUB_TYPE_VNIC_TABLE_QUEUE = 1,
	BNXT_ULP_RESOURCE_SUB_TYPE_GLOBAL_REGISTER_CUST_VXLAN = 0,
	BNXT_ULP_RESOURCE_SUB_TYPE_GLOBAL_REGISTER_CUST_ECPRI = 1,
	BNXT_ULP_RESOURCE_SUB_TYPE_GLOBAL_REGISTER_CUST_VXLAN_GPE = 2,
	BNXT_ULP_RESOURCE_SUB_TYPE_GLOBAL_REGISTER_CUST_VXLAN_GPE_V6 = 3,
	BNXT_ULP_RESOURCE_SUB_TYPE_CMM_TABLE_ACT = 4,
	BNXT_ULP_RESOURCE_SUB_TYPE_CMM_TABLE_LKUP = 5,
	BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_STAT_64 = 6,
	BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_CMM_MCG_ACT = 2,
	BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_CMM_MODIFY_REC = 3,
	BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_CMM_STAT_COUNTER = 4,
	BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_CMM_SRC_PROP = 5,
	BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_CMM_ENCAP_REC = 6,
	BNXT_ULP_RESOURCE_SUB_TYPE_KEY_RECIPE_TABLE_EM = 0,
	BNXT_ULP_RESOURCE_SUB_TYPE_KEY_RECIPE_TABLE_WM = 1
};

enum bnxt_ulp_session_type {
	BNXT_ULP_SESSION_TYPE_DEFAULT = 0x00,
	BNXT_ULP_SESSION_TYPE_SHARED = 0x01,
	BNXT_ULP_SESSION_TYPE_SHARED_WC = 0x02,
	BNXT_ULP_SESSION_TYPE_SHARED_OWC = 0x04,
	BNXT_ULP_SESSION_TYPE_DEFAULT_NON_HA = 0x08,
	BNXT_ULP_SESSION_TYPE_LAST = 0x10
};

enum bnxt_ulp_act_prop_sz {
	BNXT_ULP_ACT_PROP_SZ_ENCAP_TUN_SZ = 4,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_IP_SZ = 4,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_VTAG_SZ = 4,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_VTAG_TYPE = 4,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_VTAG_NUM = 4,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_L3_TYPE = 4,
	BNXT_ULP_ACT_PROP_SZ_MPLS_POP_NUM = 4,
	BNXT_ULP_ACT_PROP_SZ_MPLS_PUSH_NUM = 4,
	BNXT_ULP_ACT_PROP_SZ_PORT_ID = 4,
	BNXT_ULP_ACT_PROP_SZ_VNIC = 4,
	BNXT_ULP_ACT_PROP_SZ_VPORT = 4,
	BNXT_ULP_ACT_PROP_SZ_MIRR_VNIC = 4,
	BNXT_ULP_ACT_PROP_SZ_MIRR_VPORT = 4,
	BNXT_ULP_ACT_PROP_SZ_MARK = 4,
	BNXT_ULP_ACT_PROP_SZ_COUNT = 4,
	BNXT_ULP_ACT_PROP_SZ_METER = 4,
	BNXT_ULP_ACT_PROP_SZ_SET_MAC_SRC = 6,
	BNXT_ULP_ACT_PROP_SZ_SET_MAC_DST = 6,
	BNXT_ULP_ACT_PROP_SZ_PUSH_VLAN = 2,
	BNXT_ULP_ACT_PROP_SZ_SET_VLAN_PCP = 1,
	BNXT_ULP_ACT_PROP_SZ_SET_VLAN_VID = 2,
	BNXT_ULP_ACT_PROP_SZ_SET_IPV4_SRC = 4,
	BNXT_ULP_ACT_PROP_SZ_SET_IPV4_DST = 4,
	BNXT_ULP_ACT_PROP_SZ_SET_IPV6_SRC = 16,
	BNXT_ULP_ACT_PROP_SZ_SET_IPV6_DST = 16,
	BNXT_ULP_ACT_PROP_SZ_SET_TP_SRC = 2,
	BNXT_ULP_ACT_PROP_SZ_SET_TP_DST = 2,
	BNXT_ULP_ACT_PROP_SZ_OF_PUSH_MPLS_0 = 4,
	BNXT_ULP_ACT_PROP_SZ_OF_PUSH_MPLS_1 = 4,
	BNXT_ULP_ACT_PROP_SZ_OF_PUSH_MPLS_2 = 4,
	BNXT_ULP_ACT_PROP_SZ_OF_PUSH_MPLS_3 = 4,
	BNXT_ULP_ACT_PROP_SZ_OF_PUSH_MPLS_4 = 4,
	BNXT_ULP_ACT_PROP_SZ_OF_PUSH_MPLS_5 = 4,
	BNXT_ULP_ACT_PROP_SZ_OF_PUSH_MPLS_6 = 4,
	BNXT_ULP_ACT_PROP_SZ_OF_PUSH_MPLS_7 = 4,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_L2_DMAC = 6,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_L2_SMAC = 6,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_VTAG = 8,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_IP = 32,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_IP_SRC = 16,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_UDP = 4,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_TUN = 32,
	BNXT_ULP_ACT_PROP_SZ_JUMP = 4,
	BNXT_ULP_ACT_PROP_SZ_SHARED_HANDLE = 8,
	BNXT_ULP_ACT_PROP_SZ_RSS_FUNC = 1,
	BNXT_ULP_ACT_PROP_SZ_RSS_TYPES = 8,
	BNXT_ULP_ACT_PROP_SZ_RSS_LEVEL = 4,
	BNXT_ULP_ACT_PROP_SZ_RSS_KEY_LEN = 4,
	BNXT_ULP_ACT_PROP_SZ_RSS_KEY = 40,
	BNXT_ULP_ACT_PROP_SZ_RSS_QUEUE_NUM = 2,
	BNXT_ULP_ACT_PROP_SZ_RSS_QUEUE = 32,
	BNXT_ULP_ACT_PROP_SZ_QUEUE_INDEX = 2,
	BNXT_ULP_ACT_PROP_SZ_METER_PROF_ID_UPDATE = 1,
	BNXT_ULP_ACT_PROP_SZ_METER_PROF_ID = 4,
	BNXT_ULP_ACT_PROP_SZ_METER_PROF_CIR = 3,
	BNXT_ULP_ACT_PROP_SZ_METER_PROF_EIR = 3,
	BNXT_ULP_ACT_PROP_SZ_METER_PROF_CBS = 2,
	BNXT_ULP_ACT_PROP_SZ_METER_PROF_EBS = 2,
	BNXT_ULP_ACT_PROP_SZ_METER_PROF_RFC2698 = 1,
	BNXT_ULP_ACT_PROP_SZ_METER_PROF_PM = 1,
	BNXT_ULP_ACT_PROP_SZ_METER_PROF_EBND = 1,
	BNXT_ULP_ACT_PROP_SZ_METER_PROF_CBND = 1,
	BNXT_ULP_ACT_PROP_SZ_METER_PROF_EBSM = 1,
	BNXT_ULP_ACT_PROP_SZ_METER_PROF_CBSM = 1,
	BNXT_ULP_ACT_PROP_SZ_METER_PROF_CF = 1,
	BNXT_ULP_ACT_PROP_SZ_METER_INST_ID = 4,
	BNXT_ULP_ACT_PROP_SZ_METER_INST_ECN_RMP_EN_UPDATE = 1,
	BNXT_ULP_ACT_PROP_SZ_METER_INST_ECN_RMP_EN = 1,
	BNXT_ULP_ACT_PROP_SZ_METER_INST_MTR_VAL_UPDATE = 1,
	BNXT_ULP_ACT_PROP_SZ_METER_INST_MTR_VAL = 1,
	BNXT_ULP_ACT_PROP_SZ_GOTO_CHAINID = 2,
	BNXT_ULP_ACT_PROP_SZ_SET_TTL = 1,
	BNXT_ULP_ACT_PROP_SZ_LAST = 4
};

enum bnxt_ulp_act_prop_idx {
	BNXT_ULP_ACT_PROP_IDX_ENCAP_TUN_SZ = 0,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_IP_SZ = 4,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_VTAG_SZ = 8,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_VTAG_TYPE = 12,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_VTAG_NUM = 16,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_L3_TYPE = 20,
	BNXT_ULP_ACT_PROP_IDX_MPLS_POP_NUM = 24,
	BNXT_ULP_ACT_PROP_IDX_MPLS_PUSH_NUM = 28,
	BNXT_ULP_ACT_PROP_IDX_PORT_ID = 32,
	BNXT_ULP_ACT_PROP_IDX_VNIC = 36,
	BNXT_ULP_ACT_PROP_IDX_VPORT = 40,
	BNXT_ULP_ACT_PROP_IDX_MIRR_VNIC = 44,
	BNXT_ULP_ACT_PROP_IDX_MIRR_VPORT = 48,
	BNXT_ULP_ACT_PROP_IDX_MARK = 52,
	BNXT_ULP_ACT_PROP_IDX_COUNT = 56,
	BNXT_ULP_ACT_PROP_IDX_METER = 60,
	BNXT_ULP_ACT_PROP_IDX_SET_MAC_SRC = 64,
	BNXT_ULP_ACT_PROP_IDX_SET_MAC_DST = 70,
	BNXT_ULP_ACT_PROP_IDX_PUSH_VLAN = 76,
	BNXT_ULP_ACT_PROP_IDX_SET_VLAN_PCP = 78,
	BNXT_ULP_ACT_PROP_IDX_SET_VLAN_VID = 79,
	BNXT_ULP_ACT_PROP_IDX_SET_IPV4_SRC = 81,
	BNXT_ULP_ACT_PROP_IDX_SET_IPV4_DST = 85,
	BNXT_ULP_ACT_PROP_IDX_SET_IPV6_SRC = 89,
	BNXT_ULP_ACT_PROP_IDX_SET_IPV6_DST = 105,
	BNXT_ULP_ACT_PROP_IDX_SET_TP_SRC = 121,
	BNXT_ULP_ACT_PROP_IDX_SET_TP_DST = 123,
	BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_0 = 125,
	BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_1 = 129,
	BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_2 = 133,
	BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_3 = 137,
	BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_4 = 141,
	BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_5 = 145,
	BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_6 = 149,
	BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_7 = 153,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_L2_DMAC = 157,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_L2_SMAC = 163,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_VTAG = 169,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_IP = 177,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_IP_SRC = 209,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_UDP = 225,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_TUN = 229,
	BNXT_ULP_ACT_PROP_IDX_JUMP = 261,
	BNXT_ULP_ACT_PROP_IDX_SHARED_HANDLE = 265,
	BNXT_ULP_ACT_PROP_IDX_RSS_FUNC = 273,
	BNXT_ULP_ACT_PROP_IDX_RSS_TYPES = 274,
	BNXT_ULP_ACT_PROP_IDX_RSS_LEVEL = 282,
	BNXT_ULP_ACT_PROP_IDX_RSS_KEY_LEN = 286,
	BNXT_ULP_ACT_PROP_IDX_RSS_KEY = 290,
	BNXT_ULP_ACT_PROP_IDX_RSS_QUEUE_NUM = 330,
	BNXT_ULP_ACT_PROP_IDX_RSS_QUEUE = 332,
	BNXT_ULP_ACT_PROP_IDX_QUEUE_INDEX = 364,
	BNXT_ULP_ACT_PROP_IDX_METER_PROF_ID_UPDATE = 366,
	BNXT_ULP_ACT_PROP_IDX_METER_PROF_ID = 367,
	BNXT_ULP_ACT_PROP_IDX_METER_PROF_CIR = 371,
	BNXT_ULP_ACT_PROP_IDX_METER_PROF_EIR = 374,
	BNXT_ULP_ACT_PROP_IDX_METER_PROF_CBS = 377,
	BNXT_ULP_ACT_PROP_IDX_METER_PROF_EBS = 379,
	BNXT_ULP_ACT_PROP_IDX_METER_PROF_RFC2698 = 381,
	BNXT_ULP_ACT_PROP_IDX_METER_PROF_PM = 382,
	BNXT_ULP_ACT_PROP_IDX_METER_PROF_EBND = 383,
	BNXT_ULP_ACT_PROP_IDX_METER_PROF_CBND = 384,
	BNXT_ULP_ACT_PROP_IDX_METER_PROF_EBSM = 385,
	BNXT_ULP_ACT_PROP_IDX_METER_PROF_CBSM = 386,
	BNXT_ULP_ACT_PROP_IDX_METER_PROF_CF = 387,
	BNXT_ULP_ACT_PROP_IDX_METER_INST_ID = 388,
	BNXT_ULP_ACT_PROP_IDX_METER_INST_ECN_RMP_EN_UPDATE = 392,
	BNXT_ULP_ACT_PROP_IDX_METER_INST_ECN_RMP_EN = 393,
	BNXT_ULP_ACT_PROP_IDX_METER_INST_MTR_VAL_UPDATE = 394,
	BNXT_ULP_ACT_PROP_IDX_METER_INST_MTR_VAL = 395,
	BNXT_ULP_ACT_PROP_IDX_GOTO_CHAINID = 396,
	BNXT_ULP_ACT_PROP_IDX_SET_TTL = 398,
	BNXT_ULP_ACT_PROP_IDX_LAST = 399
};

enum ulp_wp_sym {
	ULP_WP_SYM_METADATA_OP_NORMAL = 0,
	ULP_WP_SYM_METADATA_OP_L2_HASH = 0,
	ULP_WP_SYM_METADATA_OP_L4_HASH = 0,
	ULP_WP_SYM_FWD_OP_BYPASS_CFA = 0,
	ULP_WP_SYM_FWD_OP_BYPASS_CFA_ROCE = 0,
	ULP_WP_SYM_FWD_OP_BYPASS_LKUP = 0,
	ULP_WP_SYM_FWD_OP_NORMAL_FLOW = 0,
	ULP_WP_SYM_FWD_OP_DROP = 0,
	ULP_WP_SYM_CTXT_OPCODE_BYPASS_CFA = 0,
	ULP_WP_SYM_CTXT_OPCODE_BYPASS_LKUP = 0,
	ULP_WP_SYM_CTXT_OPCODE_META_UPDATE = 0,
	ULP_WP_SYM_CTXT_OPCODE_NORMAL_FLOW = 0,
	ULP_WP_SYM_CTXT_OPCODE_DROP = 0,
	ULP_WP_SYM_L2_CTXT_PRI_CATCHALL = 0,
	ULP_WP_SYM_L2_CTXT_PRI_MC_BC = 0,
	ULP_WP_SYM_L2_CTXT_PRI_PORT = 0,
	ULP_WP_SYM_L2_CTXT_PRI_APP = 0,
	ULP_WP_SYM_PROF_TCAM_PRI_CATCHALL = 0,
	ULP_WP_SYM_PROF_TCAM_PRI_APP = 0,
	ULP_WP_SYM_PROF_TCAM_PRI_L4 = 0,
	ULP_WP_SYM_PROF_TCAM_PRI_L3 = 0,
	ULP_WP_SYM_PROF_TCAM_PRI_L2 = 0,
	ULP_WP_SYM_PKT_TYPE_IGNORE = 0,
	ULP_WP_SYM_PKT_TYPE_L2 = 0,
	ULP_WP_SYM_PKT_TYPE_0_IGNORE = 0,
	ULP_WP_SYM_PKT_TYPE_0_L2 = 0,
	ULP_WP_SYM_PKT_TYPE_1_IGNORE = 0,
	ULP_WP_SYM_PKT_TYPE_1_L2 = 0,
	ULP_WP_SYM_RECYCLE_CNT_IGNORE = 0,
	ULP_WP_SYM_RECYCLE_CNT_ZERO = 0,
	ULP_WP_SYM_RECYCLE_CNT_ONE = 1,
	ULP_WP_SYM_RECYCLE_CNT_TWO = 2,
	ULP_WP_SYM_RECYCLE_CNT_THREE = 3,
	ULP_WP_SYM_AGG_ERROR_IGNORE = 0,
	ULP_WP_SYM_AGG_ERROR_NO = 0,
	ULP_WP_SYM_AGG_ERROR_YES = 1,
	ULP_WP_SYM_RESERVED_IGNORE = 0,
	ULP_WP_SYM_HREC_NEXT_IGNORE = 0,
	ULP_WP_SYM_HREC_NEXT_NO = 0,
	ULP_WP_SYM_HREC_NEXT_YES = 1,
	ULP_WP_SYM_TL2_HDR_VALID_IGNORE = 0,
	ULP_WP_SYM_TL2_HDR_VALID_NO = 0,
	ULP_WP_SYM_TL2_HDR_VALID_YES = 1,
	ULP_WP_SYM_TL2_HDR_TYPE_IGNORE = 0,
	ULP_WP_SYM_TL2_HDR_TYPE_DIX = 0,
	ULP_WP_SYM_TL2_UC_MC_BC_IGNORE = 0,
	ULP_WP_SYM_TL2_UC_MC_BC_UC = 0,
	ULP_WP_SYM_TL2_UC_MC_BC_MC = 2,
	ULP_WP_SYM_TL2_UC_MC_BC_BC = 3,
	ULP_WP_SYM_TL2_VTAG_PRESENT_IGNORE = 0,
	ULP_WP_SYM_TL2_VTAG_PRESENT_NO = 0,
	ULP_WP_SYM_TL2_VTAG_PRESENT_YES = 1,
	ULP_WP_SYM_TL2_TWO_VTAGS_IGNORE = 0,
	ULP_WP_SYM_TL2_TWO_VTAGS_NO = 0,
	ULP_WP_SYM_TL2_TWO_VTAGS_YES = 1,
	ULP_WP_SYM_TL3_HDR_VALID_IGNORE = 0,
	ULP_WP_SYM_TL3_HDR_VALID_NO = 0,
	ULP_WP_SYM_TL3_HDR_VALID_YES = 1,
	ULP_WP_SYM_TL3_HDR_ERROR_IGNORE = 0,
	ULP_WP_SYM_TL3_HDR_ERROR_NO = 0,
	ULP_WP_SYM_TL3_HDR_ERROR_YES = 1,
	ULP_WP_SYM_TL3_HDR_TYPE_IGNORE = 0,
	ULP_WP_SYM_TL3_HDR_TYPE_IPV4 = 0,
	ULP_WP_SYM_TL3_HDR_TYPE_IPV6 = 1,
	ULP_WP_SYM_TL3_HDR_ISIP_IGNORE = 0,
	ULP_WP_SYM_TL3_HDR_ISIP_NO = 0,
	ULP_WP_SYM_TL3_HDR_ISIP_YES = 1,
	ULP_WP_SYM_TL3_IPV6_CMP_SRC_IGNORE = 0,
	ULP_WP_SYM_TL3_IPV6_CMP_SRC_NO = 0,
	ULP_WP_SYM_TL3_IPV6_CMP_SRC_YES = 1,
	ULP_WP_SYM_TL3_IPV6_CMP_DST_IGNORE = 0,
	ULP_WP_SYM_TL3_IPV6_CMP_DST_NO = 0,
	ULP_WP_SYM_TL3_IPV6_CMP_DST_YES = 1,
	ULP_WP_SYM_TL4_HDR_VALID_IGNORE = 0,
	ULP_WP_SYM_TL4_HDR_VALID_NO = 0,
	ULP_WP_SYM_TL4_HDR_VALID_YES = 1,
	ULP_WP_SYM_TL4_HDR_ERROR_IGNORE = 0,
	ULP_WP_SYM_TL4_HDR_ERROR_NO = 0,
	ULP_WP_SYM_TL4_HDR_ERROR_YES = 1,
	ULP_WP_SYM_TL4_HDR_IS_UDP_TCP_IGNORE = 0,
	ULP_WP_SYM_TL4_HDR_IS_UDP_TCP_NO = 0,
	ULP_WP_SYM_TL4_HDR_IS_UDP_TCP_YES = 1,
	ULP_WP_SYM_TL4_HDR_TYPE_IGNORE = 0,
	ULP_WP_SYM_TL4_HDR_TYPE_TCP = 0,
	ULP_WP_SYM_TL4_HDR_TYPE_UDP = 1,
	ULP_WP_SYM_TUN_HDR_VALID_IGNORE = 0,
	ULP_WP_SYM_TUN_HDR_VALID_NO = 0,
	ULP_WP_SYM_TUN_HDR_VALID_YES = 1,
	ULP_WP_SYM_TUN_HDR_ERROR_IGNORE = 0,
	ULP_WP_SYM_TUN_HDR_ERROR_NO = 0,
	ULP_WP_SYM_TUN_HDR_ERROR_YES = 1,
	ULP_WP_SYM_TUN_HDR_TYPE_IGNORE = 0,
	ULP_WP_SYM_TUN_HDR_TYPE_VXLAN = 0,
	ULP_WP_SYM_TUN_HDR_TYPE_VXLAN_GPE = 0,
	ULP_WP_SYM_TUN_HDR_TYPE_GENEVE = 1,
	ULP_WP_SYM_TUN_HDR_TYPE_NVGRE = 2,
	ULP_WP_SYM_TUN_HDR_TYPE_GRE = 3,
	ULP_WP_SYM_TUN_HDR_TYPE_IPV4 = 4,
	ULP_WP_SYM_TUN_HDR_TYPE_IPV6 = 5,
	ULP_WP_SYM_TUN_HDR_TYPE_PPPOE = 6,
	ULP_WP_SYM_TUN_HDR_TYPE_MPLS = 7,
	ULP_WP_SYM_TUN_HDR_TYPE_UPAR1 = 8,
	ULP_WP_SYM_TUN_HDR_TYPE_UPAR2 = 9,
	ULP_WP_SYM_TUN_HDR_TYPE_UPAR3 = 10,
	ULP_WP_SYM_TUN_HDR_TYPE_UPAR4 = 11,
	ULP_WP_SYM_TUN_HDR_TYPE_UPAR5 = 0,
	ULP_WP_SYM_TUN_HDR_TYPE_UPAR6 = 0,
	ULP_WP_SYM_TUN_HDR_TYPE_UPAR7 = 0,
	ULP_WP_SYM_TUN_HDR_TYPE_UPAR8 = 0,
	ULP_WP_SYM_TUN_HDR_TYPE_ROE = 0,
	ULP_WP_SYM_TUN_HDR_TYPE_ECPRI = 0,
	ULP_WP_SYM_TUN_HDR_TYPE_GTP_V1_U = 0,
	ULP_WP_SYM_TUN_HDR_TYPE_GTP_V2_C = 0,
	ULP_WP_SYM_TUN_HDR_TYPE_PFCP_SESS = 0,
	ULP_WP_SYM_TUN_HDR_TYPE_PFCP_NODE = 0,
	ULP_WP_SYM_TUN_HDR_TYPE_NSH = 0,
	ULP_WP_SYM_TUN_HDR_TYPE_VXLAN_IP = 0,
	ULP_WP_SYM_TUN_HDR_TYPE_GRE_TEN = 0,
	ULP_WP_SYM_TUN_HDR_TYPE_NONE = 15,
	ULP_WP_SYM_TUN_HDR_TYPE_UPAR_MASK = 14,
	ULP_WP_SYM_TUN_HDR_TYPE_TID_MASK = 0,
	ULP_WP_SYM_TUN_HDR_FLAGS_IGNORE = 0,
	ULP_WP_SYM_L2_HDR_VALID_IGNORE = 0,
	ULP_WP_SYM_L2_HDR_VALID_NO = 0,
	ULP_WP_SYM_L2_HDR_VALID_YES = 1,
	ULP_WP_SYM_L2_HDR_ERROR_IGNORE = 0,
	ULP_WP_SYM_L2_HDR_ERROR_NO = 0,
	ULP_WP_SYM_L2_HDR_ERROR_YES = 1,
	ULP_WP_SYM_L2_HDR_TYPE_IGNORE = 0,
	ULP_WP_SYM_L2_HDR_TYPE_DIX = 0,
	ULP_WP_SYM_L2_HDR_TYPE_LLC_SNAP = 1,
	ULP_WP_SYM_L2_HDR_TYPE_LLC = 2,
	ULP_WP_SYM_L2_UC_MC_BC_IGNORE = 0,
	ULP_WP_SYM_L2_UC_MC_BC_UC = 0,
	ULP_WP_SYM_L2_UC_MC_BC_MC = 2,
	ULP_WP_SYM_L2_UC_MC_BC_BC = 3,
	ULP_WP_SYM_L2_VTAG_PRESENT_IGNORE = 0,
	ULP_WP_SYM_L2_VTAG_PRESENT_NO = 0,
	ULP_WP_SYM_L2_VTAG_PRESENT_YES = 1,
	ULP_WP_SYM_L2_TWO_VTAGS_IGNORE = 0,
	ULP_WP_SYM_L2_TWO_VTAGS_NO = 0,
	ULP_WP_SYM_L2_TWO_VTAGS_YES = 1,
	ULP_WP_SYM_L2_CNTX_VLAN_SELECT_INNER = 0,
	ULP_WP_SYM_L2_CNTX_VLAN_SELECT_TUN = 0,
	ULP_WP_SYM_L2_CNTX_VLAN_SELECT_O_TUN = 0,
	ULP_WP_SYM_L2_CNTX_VLAN_SELECT_OM_TUN = 0,
	ULP_WP_SYM_L2_CNTX_TUN_SELECT_TUN_ID = 0,
	ULP_WP_SYM_L2_CNTX_TUN_SELECT_TUN_CNTX = 0,
	ULP_WP_SYM_L2_CNTX_TUN_SELECT_O_TUN_ID = 0,
	ULP_WP_SYM_L2_CNTX_TUN_SELECT_O_TUN_CNTX = 0,
	ULP_WP_SYM_L2_CNTX_TUN_SELECT_I_L4_PORTS = 0,
	ULP_WP_SYM_L2_CNTX_TUN_SELECT_O_L4_PORTS = 0,
	ULP_WP_SYM_L2_CNTX_TUN_SELECT_OM_TUN_ID = 0,
	ULP_WP_SYM_L2_CNTX_TUN_SELECT_OM_TUN_CNTX = 0,
	ULP_WP_SYM_L3_HDR_VALID_IGNORE = 0,
	ULP_WP_SYM_L3_HDR_VALID_NO = 0,
	ULP_WP_SYM_L3_HDR_VALID_YES = 1,
	ULP_WP_SYM_L3_HDR_ERROR_IGNORE = 0,
	ULP_WP_SYM_L3_HDR_ERROR_NO = 0,
	ULP_WP_SYM_L3_HDR_ERROR_YES = 1,
	ULP_WP_SYM_L3_HDR_TYPE_IGNORE = 0,
	ULP_WP_SYM_L3_HDR_TYPE_IPV4 = 0,
	ULP_WP_SYM_L3_HDR_TYPE_IPV6 = 1,
	ULP_WP_SYM_L3_HDR_TYPE_ARP = 2,
	ULP_WP_SYM_L3_HDR_TYPE_PTP = 3,
	ULP_WP_SYM_L3_HDR_TYPE_EAPOL = 4,
	ULP_WP_SYM_L3_HDR_TYPE_ROCE = 5,
	ULP_WP_SYM_L3_HDR_TYPE_FCOE = 6,
	ULP_WP_SYM_L3_HDR_TYPE_UPAR1 = 7,
	ULP_WP_SYM_L3_HDR_TYPE_UPAR2 = 8,
	ULP_WP_SYM_L3_HDR_ISIP_IGNORE = 0,
	ULP_WP_SYM_L3_HDR_ISIP_NO = 0,
	ULP_WP_SYM_L3_HDR_ISIP_YES = 1,
	ULP_WP_SYM_L3_IPV6_CMP_SRC_IGNORE = 0,
	ULP_WP_SYM_L3_IPV6_CMP_SRC_NO = 0,
	ULP_WP_SYM_L3_IPV6_CMP_SRC_YES = 1,
	ULP_WP_SYM_L3_IPV6_CMP_DST_IGNORE = 0,
	ULP_WP_SYM_L3_IPV6_CMP_DST_NO = 0,
	ULP_WP_SYM_L3_IPV6_CMP_DST_YES = 1,
	ULP_WP_SYM_L4_HDR_VALID_IGNORE = 0,
	ULP_WP_SYM_L4_HDR_VALID_NO = 0,
	ULP_WP_SYM_L4_HDR_VALID_YES = 1,
	ULP_WP_SYM_L4_HDR_ERROR_IGNORE = 0,
	ULP_WP_SYM_L4_HDR_ERROR_NO = 0,
	ULP_WP_SYM_L4_HDR_ERROR_YES = 1,
	ULP_WP_SYM_L4_HDR_TYPE_IGNORE = 0,
	ULP_WP_SYM_L4_HDR_TYPE_TCP = 0,
	ULP_WP_SYM_L4_HDR_TYPE_UDP = 1,
	ULP_WP_SYM_L4_HDR_TYPE_ICMP = 2,
	ULP_WP_SYM_L4_HDR_TYPE_UPAR1 = 3,
	ULP_WP_SYM_L4_HDR_TYPE_UPAR2 = 4,
	ULP_WP_SYM_L4_HDR_TYPE_BTH_V1 = 5,
	ULP_WP_SYM_L4_HDR_TYPE_IPSEC_AH = 0,
	ULP_WP_SYM_L4_HDR_TYPE_IPSEC_ESP = 0,
	ULP_WP_SYM_L4_HDR_IS_UDP_TCP_IGNORE = 0,
	ULP_WP_SYM_L4_HDR_IS_UDP_TCP_NO = 0,
	ULP_WP_SYM_L4_HDR_IS_UDP_TCP_YES = 1,
	ULP_WP_SYM_EM_WM_OPCODE_OP_NORMAL = 0,
	ULP_WP_SYM_EM_WM_OPCODE_OP_NORMAL_RFS = 0,
	ULP_WP_SYM_EM_WM_OPCODE_OP_RFS_FAST = 0,
	ULP_WP_SYM_EM_WM_OPCODE_OP_FAST = 0,
	ULP_WP_SYM_EM_WM_OPCODE_OP_RFS_ACT = 0,
	ULP_WP_SYM_EM_WM_OPCODE_OP_CT_MISS_DEF = 0,
	ULP_WP_SYM_EM_WM_OPCODE_OP_CT_HIT_DEF = 0,
	ULP_WP_SYM_EM_WM_OPCODE_OP_RECYCLE = 0,
	ULP_WP_SYM_POP_VLAN_NO = 0,
	ULP_WP_SYM_POP_VLAN_YES = 1,
	ULP_WP_SYM_VLAN_DEL_RPT_DISABLED = 0,
	ULP_WP_SYM_VLAN_DEL_RPT_STRIP_OUTER = 0,
	ULP_WP_SYM_VLAN_DEL_RPT_STRIP_BOTH = 0,
	ULP_WP_SYM_VLAN_DEL_RPT_DYN_STRIP = 0,
	ULP_WP_SYM_DECAP_FUNC_NONE = 0,
	ULP_WP_SYM_DECAP_FUNC_THRU_TL2 = 3,
	ULP_WP_SYM_DECAP_FUNC_THRU_TL3 = 8,
	ULP_WP_SYM_DECAP_FUNC_THRU_TL4 = 9,
	ULP_WP_SYM_DECAP_FUNC_THRU_TUN = 10,
	ULP_WP_SYM_DECAP_FUNC_THRU_L2 = 11,
	ULP_WP_SYM_DECAP_FUNC_THRU_L3 = 12,
	ULP_WP_SYM_DECAP_FUNC_THRU_L4 = 13,
	ULP_WP_SYM_ECV_VALID_NO = 0,
	ULP_WP_SYM_ECV_VALID_YES = 1,
	ULP_WP_SYM_ECV_CUSTOM_EN_NO = 0,
	ULP_WP_SYM_ECV_CUSTOM_EN_YES = 1,
	ULP_WP_SYM_ECV_L2_EN_NO = 0,
	ULP_WP_SYM_ECV_L2_EN_YES = 1,
	ULP_WP_SYM_ECV_VTAG_TYPE_NOP = 0,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_1_ENCAP_PRI = 1,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_1_IVLAN_PRI = 2,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_1_REMAP_DIFFSERV = 3,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_2_ENCAP_PRI = 4,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_2_REMAP_DIFFSERV = 5,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_0_ENCAP_PRI = 6,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_0_REMAP_DIFFSERV = 7,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_0_PRI_0 = 8,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_0_PRI_1 = 8,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_0_PRI_2 = 8,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_0_PRI_3 = 8,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_0_PRI_4 = 8,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_0_PRI_5 = 8,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_0_PRI_6 = 8,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_0_PRI_7 = 8,
	ULP_WP_SYM_ECV_L3_TYPE_NONE = 0,
	ULP_WP_SYM_ECV_L3_TYPE_IPV4 = 4,
	ULP_WP_SYM_ECV_L3_TYPE_IPV6 = 5,
	ULP_WP_SYM_ECV_L3_TYPE_MPLS_8847 = 6,
	ULP_WP_SYM_ECV_L3_TYPE_MPLS_8848 = 7,
	ULP_WP_SYM_ECV_L4_TYPE_NONE = 0,
	ULP_WP_SYM_ECV_L4_TYPE_UDP = 4,
	ULP_WP_SYM_ECV_L4_TYPE_UDP_CSUM = 5,
	ULP_WP_SYM_ECV_L4_TYPE_UDP_ENTROPY = 6,
	ULP_WP_SYM_ECV_L4_TYPE_UDP_ENTROPY_CSUM = 7,
	ULP_WP_SYM_ECV_TUN_TYPE_NONE = 0,
	ULP_WP_SYM_ECV_TUN_TYPE_GENERIC = 1,
	ULP_WP_SYM_ECV_TUN_TYPE_VXLAN = 2,
	ULP_WP_SYM_ECV_TUN_TYPE_NGE = 3,
	ULP_WP_SYM_ECV_TUN_TYPE_NVGRE = 4,
	ULP_WP_SYM_ECV_TUN_TYPE_GRE = 5,
	ULP_WP_SYM_EEM_ACT_REC_INT = 1,
	ULP_WP_SYM_EEM_EXT_FLOW_CNTR = 0,
	ULP_WP_SYM_UC_ACT_REC = 0,
	ULP_WP_SYM_MC_ACT_REC = 1,
	ULP_WP_SYM_ACT_REC_DROP_YES = 1,
	ULP_WP_SYM_ACT_REC_DROP_NO = 0,
	ULP_WP_SYM_ACT_REC_POP_VLAN_YES = 1,
	ULP_WP_SYM_ACT_REC_POP_VLAN_NO = 0,
	ULP_WP_SYM_ACT_REC_METER_EN_YES = 1,
	ULP_WP_SYM_ACT_REC_METER_EN_NO = 0,
	ULP_WP_SYM_LOOPBACK_PORT = 4,
	ULP_WP_SYM_LOOPBACK_PARIF = 15,
	ULP_WP_SYM_EXT_EM_MAX_KEY_SIZE = 448,
	ULP_WP_SYM_MATCH_TYPE_EM = 0,
	ULP_WP_SYM_MATCH_TYPE_WM = 1,
	ULP_WP_SYM_IP_PROTO_ICMP = 1,
	ULP_WP_SYM_IP_PROTO_IGMP = 2,
	ULP_WP_SYM_IP_PROTO_IP_IN_IP = 4,
	ULP_WP_SYM_IP_PROTO_TCP = 6,
	ULP_WP_SYM_IP_PROTO_UDP = 17,
	ULP_WP_SYM_VF_FUNC_PARIF = 15,
	ULP_WP_SYM_NO = 0,
	ULP_WP_SYM_YES = 1,
	ULP_WP_SYM_RECYCLE_DST = 0x800,
	ULP_WP_SYM_VF_2_VFR_META_VAL = 8192,
	ULP_WP_SYM_VF_2_VF_META_VAL = 0,
	ULP_WP_SYM_VF_2_VFR_META_MASK = 0,
	ULP_WP_SYM_META_PROFILE_0 = 0,
	ULP_WP_SYM_CHAIN_META_VAL = 0,
	ULP_WP_SYM_L2_ECPRI_ETYPE = 0,
	ULP_WP_SYM_L4_ECPRI_ETYPE = 0,
	ULP_WP_SYM_L2_ROE_ETYPE = 0
};

enum ulp_thor_sym {
	ULP_THOR_SYM_METADATA_OP_NORMAL = 0,
	ULP_THOR_SYM_METADATA_OP_L2_HASH = 1,
	ULP_THOR_SYM_METADATA_OP_L4_HASH = 2,
	ULP_THOR_SYM_FWD_OP_BYPASS_CFA = 0,
	ULP_THOR_SYM_FWD_OP_BYPASS_CFA_ROCE = 1,
	ULP_THOR_SYM_FWD_OP_BYPASS_LKUP = 2,
	ULP_THOR_SYM_FWD_OP_NORMAL_FLOW = 3,
	ULP_THOR_SYM_FWD_OP_DROP = 0,
	ULP_THOR_SYM_CTXT_OPCODE_BYPASS_CFA = 0,
	ULP_THOR_SYM_CTXT_OPCODE_BYPASS_LKUP = 1,
	ULP_THOR_SYM_CTXT_OPCODE_META_UPDATE = 2,
	ULP_THOR_SYM_CTXT_OPCODE_NORMAL_FLOW = 3,
	ULP_THOR_SYM_CTXT_OPCODE_DROP = 4,
	ULP_THOR_SYM_L2_CTXT_PRI_CATCHALL = 0,
	ULP_THOR_SYM_L2_CTXT_PRI_MC_BC = 0,
	ULP_THOR_SYM_L2_CTXT_PRI_PORT = 0,
	ULP_THOR_SYM_L2_CTXT_PRI_APP = 0,
	ULP_THOR_SYM_PROF_TCAM_PRI_CATCHALL = 0,
	ULP_THOR_SYM_PROF_TCAM_PRI_APP = 0,
	ULP_THOR_SYM_PROF_TCAM_PRI_L4 = 0,
	ULP_THOR_SYM_PROF_TCAM_PRI_L3 = 0,
	ULP_THOR_SYM_PROF_TCAM_PRI_L2 = 0,
	ULP_THOR_SYM_PKT_TYPE_IGNORE = 0,
	ULP_THOR_SYM_PKT_TYPE_L2 = 0,
	ULP_THOR_SYM_PKT_TYPE_0_IGNORE = 0,
	ULP_THOR_SYM_PKT_TYPE_0_L2 = 0,
	ULP_THOR_SYM_PKT_TYPE_1_IGNORE = 0,
	ULP_THOR_SYM_PKT_TYPE_1_L2 = 0,
	ULP_THOR_SYM_RECYCLE_CNT_IGNORE = 0,
	ULP_THOR_SYM_RECYCLE_CNT_ZERO = 0,
	ULP_THOR_SYM_RECYCLE_CNT_ONE = 1,
	ULP_THOR_SYM_RECYCLE_CNT_TWO = 2,
	ULP_THOR_SYM_RECYCLE_CNT_THREE = 3,
	ULP_THOR_SYM_AGG_ERROR_IGNORE = 0,
	ULP_THOR_SYM_AGG_ERROR_NO = 0,
	ULP_THOR_SYM_AGG_ERROR_YES = 1,
	ULP_THOR_SYM_RESERVED_IGNORE = 0,
	ULP_THOR_SYM_HREC_NEXT_IGNORE = 0,
	ULP_THOR_SYM_HREC_NEXT_NO = 0,
	ULP_THOR_SYM_HREC_NEXT_YES = 1,
	ULP_THOR_SYM_TL2_HDR_VALID_IGNORE = 0,
	ULP_THOR_SYM_TL2_HDR_VALID_NO = 0,
	ULP_THOR_SYM_TL2_HDR_VALID_YES = 1,
	ULP_THOR_SYM_TL2_HDR_TYPE_IGNORE = 0,
	ULP_THOR_SYM_TL2_HDR_TYPE_DIX = 0,
	ULP_THOR_SYM_TL2_UC_MC_BC_IGNORE = 0,
	ULP_THOR_SYM_TL2_UC_MC_BC_UC = 0,
	ULP_THOR_SYM_TL2_UC_MC_BC_MC = 2,
	ULP_THOR_SYM_TL2_UC_MC_BC_BC = 3,
	ULP_THOR_SYM_TL2_VTAG_PRESENT_IGNORE = 0,
	ULP_THOR_SYM_TL2_VTAG_PRESENT_NO = 0,
	ULP_THOR_SYM_TL2_VTAG_PRESENT_YES = 1,
	ULP_THOR_SYM_TL2_TWO_VTAGS_IGNORE = 0,
	ULP_THOR_SYM_TL2_TWO_VTAGS_NO = 0,
	ULP_THOR_SYM_TL2_TWO_VTAGS_YES = 1,
	ULP_THOR_SYM_TL3_HDR_VALID_IGNORE = 0,
	ULP_THOR_SYM_TL3_HDR_VALID_NO = 0,
	ULP_THOR_SYM_TL3_HDR_VALID_YES = 1,
	ULP_THOR_SYM_TL3_HDR_ERROR_IGNORE = 0,
	ULP_THOR_SYM_TL3_HDR_ERROR_NO = 0,
	ULP_THOR_SYM_TL3_HDR_ERROR_YES = 1,
	ULP_THOR_SYM_TL3_HDR_TYPE_IGNORE = 0,
	ULP_THOR_SYM_TL3_HDR_TYPE_IPV4 = 0,
	ULP_THOR_SYM_TL3_HDR_TYPE_IPV6 = 1,
	ULP_THOR_SYM_TL3_HDR_ISIP_IGNORE = 0,
	ULP_THOR_SYM_TL3_HDR_ISIP_NO = 0,
	ULP_THOR_SYM_TL3_HDR_ISIP_YES = 1,
	ULP_THOR_SYM_TL3_IPV6_CMP_SRC_IGNORE = 0,
	ULP_THOR_SYM_TL3_IPV6_CMP_SRC_NO = 0,
	ULP_THOR_SYM_TL3_IPV6_CMP_SRC_YES = 1,
	ULP_THOR_SYM_TL3_IPV6_CMP_DST_IGNORE = 0,
	ULP_THOR_SYM_TL3_IPV6_CMP_DST_NO = 0,
	ULP_THOR_SYM_TL3_IPV6_CMP_DST_YES = 1,
	ULP_THOR_SYM_TL4_HDR_VALID_IGNORE = 0,
	ULP_THOR_SYM_TL4_HDR_VALID_NO = 0,
	ULP_THOR_SYM_TL4_HDR_VALID_YES = 1,
	ULP_THOR_SYM_TL4_HDR_ERROR_IGNORE = 0,
	ULP_THOR_SYM_TL4_HDR_ERROR_NO = 0,
	ULP_THOR_SYM_TL4_HDR_ERROR_YES = 1,
	ULP_THOR_SYM_TL4_HDR_IS_UDP_TCP_IGNORE = 0,
	ULP_THOR_SYM_TL4_HDR_IS_UDP_TCP_NO = 0,
	ULP_THOR_SYM_TL4_HDR_IS_UDP_TCP_YES = 1,
	ULP_THOR_SYM_TL4_HDR_TYPE_IGNORE = 0,
	ULP_THOR_SYM_TL4_HDR_TYPE_TCP = 0,
	ULP_THOR_SYM_TL4_HDR_TYPE_UDP = 1,
	ULP_THOR_SYM_TUN_HDR_VALID_IGNORE = 0,
	ULP_THOR_SYM_TUN_HDR_VALID_NO = 0,
	ULP_THOR_SYM_TUN_HDR_VALID_YES = 1,
	ULP_THOR_SYM_TUN_HDR_ERROR_IGNORE = 0,
	ULP_THOR_SYM_TUN_HDR_ERROR_NO = 0,
	ULP_THOR_SYM_TUN_HDR_ERROR_YES = 1,
	ULP_THOR_SYM_TUN_HDR_TYPE_IGNORE = 0,
	ULP_THOR_SYM_TUN_HDR_TYPE_VXLAN = 0,
	ULP_THOR_SYM_TUN_HDR_TYPE_VXLAN_GPE = 0,
	ULP_THOR_SYM_TUN_HDR_TYPE_GENEVE = 1,
	ULP_THOR_SYM_TUN_HDR_TYPE_NVGRE = 2,
	ULP_THOR_SYM_TUN_HDR_TYPE_GRE = 3,
	ULP_THOR_SYM_TUN_HDR_TYPE_IPV4 = 4,
	ULP_THOR_SYM_TUN_HDR_TYPE_IPV6 = 5,
	ULP_THOR_SYM_TUN_HDR_TYPE_PPPOE = 6,
	ULP_THOR_SYM_TUN_HDR_TYPE_MPLS = 7,
	ULP_THOR_SYM_TUN_HDR_TYPE_UPAR1 = 8,
	ULP_THOR_SYM_TUN_HDR_TYPE_UPAR2 = 9,
	ULP_THOR_SYM_TUN_HDR_TYPE_UPAR3 = 10,
	ULP_THOR_SYM_TUN_HDR_TYPE_UPAR4 = 11,
	ULP_THOR_SYM_TUN_HDR_TYPE_UPAR5 = 0,
	ULP_THOR_SYM_TUN_HDR_TYPE_UPAR6 = 0,
	ULP_THOR_SYM_TUN_HDR_TYPE_UPAR7 = 0,
	ULP_THOR_SYM_TUN_HDR_TYPE_UPAR8 = 0,
	ULP_THOR_SYM_TUN_HDR_TYPE_ROE = 0,
	ULP_THOR_SYM_TUN_HDR_TYPE_ECPRI = 0,
	ULP_THOR_SYM_TUN_HDR_TYPE_GTP_V1_U = 0,
	ULP_THOR_SYM_TUN_HDR_TYPE_GTP_V2_C = 0,
	ULP_THOR_SYM_TUN_HDR_TYPE_PFCP_SESS = 0,
	ULP_THOR_SYM_TUN_HDR_TYPE_PFCP_NODE = 0,
	ULP_THOR_SYM_TUN_HDR_TYPE_NSH = 0,
	ULP_THOR_SYM_TUN_HDR_TYPE_VXLAN_IP = 0,
	ULP_THOR_SYM_TUN_HDR_TYPE_GRE_TEN = 0,
	ULP_THOR_SYM_TUN_HDR_TYPE_NONE = 15,
	ULP_THOR_SYM_TUN_HDR_TYPE_UPAR_MASK = 14,
	ULP_THOR_SYM_TUN_HDR_TYPE_TID_MASK = 3840,
	ULP_THOR_SYM_TUN_HDR_FLAGS_IGNORE = 0,
	ULP_THOR_SYM_L2_HDR_VALID_IGNORE = 0,
	ULP_THOR_SYM_L2_HDR_VALID_NO = 0,
	ULP_THOR_SYM_L2_HDR_VALID_YES = 1,
	ULP_THOR_SYM_L2_HDR_ERROR_IGNORE = 0,
	ULP_THOR_SYM_L2_HDR_ERROR_NO = 0,
	ULP_THOR_SYM_L2_HDR_ERROR_YES = 1,
	ULP_THOR_SYM_L2_HDR_TYPE_IGNORE = 0,
	ULP_THOR_SYM_L2_HDR_TYPE_DIX = 0,
	ULP_THOR_SYM_L2_HDR_TYPE_LLC_SNAP = 1,
	ULP_THOR_SYM_L2_HDR_TYPE_LLC = 2,
	ULP_THOR_SYM_L2_UC_MC_BC_IGNORE = 0,
	ULP_THOR_SYM_L2_UC_MC_BC_UC = 0,
	ULP_THOR_SYM_L2_UC_MC_BC_MC = 2,
	ULP_THOR_SYM_L2_UC_MC_BC_BC = 3,
	ULP_THOR_SYM_L2_VTAG_PRESENT_IGNORE = 0,
	ULP_THOR_SYM_L2_VTAG_PRESENT_NO = 0,
	ULP_THOR_SYM_L2_VTAG_PRESENT_YES = 1,
	ULP_THOR_SYM_L2_TWO_VTAGS_IGNORE = 0,
	ULP_THOR_SYM_L2_TWO_VTAGS_NO = 0,
	ULP_THOR_SYM_L2_TWO_VTAGS_YES = 1,
	ULP_THOR_SYM_L2_CNTX_VLAN_SELECT_INNER = 0,
	ULP_THOR_SYM_L2_CNTX_VLAN_SELECT_TUN = 0,
	ULP_THOR_SYM_L2_CNTX_VLAN_SELECT_O_TUN = 0,
	ULP_THOR_SYM_L2_CNTX_VLAN_SELECT_OM_TUN = 0,
	ULP_THOR_SYM_L2_CNTX_TUN_SELECT_TUN_ID = 0,
	ULP_THOR_SYM_L2_CNTX_TUN_SELECT_TUN_CNTX = 0,
	ULP_THOR_SYM_L2_CNTX_TUN_SELECT_O_TUN_ID = 0,
	ULP_THOR_SYM_L2_CNTX_TUN_SELECT_O_TUN_CNTX = 0,
	ULP_THOR_SYM_L2_CNTX_TUN_SELECT_I_L4_PORTS = 0,
	ULP_THOR_SYM_L2_CNTX_TUN_SELECT_O_L4_PORTS = 0,
	ULP_THOR_SYM_L2_CNTX_TUN_SELECT_OM_TUN_ID = 0,
	ULP_THOR_SYM_L2_CNTX_TUN_SELECT_OM_TUN_CNTX = 0,
	ULP_THOR_SYM_L3_HDR_VALID_IGNORE = 0,
	ULP_THOR_SYM_L3_HDR_VALID_NO = 0,
	ULP_THOR_SYM_L3_HDR_VALID_YES = 1,
	ULP_THOR_SYM_L3_HDR_ERROR_IGNORE = 0,
	ULP_THOR_SYM_L3_HDR_ERROR_NO = 0,
	ULP_THOR_SYM_L3_HDR_ERROR_YES = 1,
	ULP_THOR_SYM_L3_HDR_TYPE_IGNORE = 0,
	ULP_THOR_SYM_L3_HDR_TYPE_IPV4 = 0,
	ULP_THOR_SYM_L3_HDR_TYPE_IPV6 = 1,
	ULP_THOR_SYM_L3_HDR_TYPE_ARP = 2,
	ULP_THOR_SYM_L3_HDR_TYPE_PTP = 3,
	ULP_THOR_SYM_L3_HDR_TYPE_EAPOL = 4,
	ULP_THOR_SYM_L3_HDR_TYPE_ROCE = 5,
	ULP_THOR_SYM_L3_HDR_TYPE_FCOE = 6,
	ULP_THOR_SYM_L3_HDR_TYPE_UPAR1 = 7,
	ULP_THOR_SYM_L3_HDR_TYPE_UPAR2 = 8,
	ULP_THOR_SYM_L3_HDR_ISIP_IGNORE = 0,
	ULP_THOR_SYM_L3_HDR_ISIP_NO = 0,
	ULP_THOR_SYM_L3_HDR_ISIP_YES = 1,
	ULP_THOR_SYM_L3_IPV6_CMP_SRC_IGNORE = 0,
	ULP_THOR_SYM_L3_IPV6_CMP_SRC_NO = 0,
	ULP_THOR_SYM_L3_IPV6_CMP_SRC_YES = 1,
	ULP_THOR_SYM_L3_IPV6_CMP_DST_IGNORE = 0,
	ULP_THOR_SYM_L3_IPV6_CMP_DST_NO = 0,
	ULP_THOR_SYM_L3_IPV6_CMP_DST_YES = 1,
	ULP_THOR_SYM_L4_HDR_VALID_IGNORE = 0,
	ULP_THOR_SYM_L4_HDR_VALID_NO = 0,
	ULP_THOR_SYM_L4_HDR_VALID_YES = 1,
	ULP_THOR_SYM_L4_HDR_ERROR_IGNORE = 0,
	ULP_THOR_SYM_L4_HDR_ERROR_NO = 0,
	ULP_THOR_SYM_L4_HDR_ERROR_YES = 1,
	ULP_THOR_SYM_L4_HDR_TYPE_IGNORE = 0,
	ULP_THOR_SYM_L4_HDR_TYPE_TCP = 0,
	ULP_THOR_SYM_L4_HDR_TYPE_UDP = 1,
	ULP_THOR_SYM_L4_HDR_TYPE_ICMP = 2,
	ULP_THOR_SYM_L4_HDR_TYPE_UPAR1 = 3,
	ULP_THOR_SYM_L4_HDR_TYPE_UPAR2 = 4,
	ULP_THOR_SYM_L4_HDR_TYPE_BTH_V1 = 5,
	ULP_THOR_SYM_L4_HDR_TYPE_IPSEC_AH = 0,
	ULP_THOR_SYM_L4_HDR_TYPE_IPSEC_ESP = 0,
	ULP_THOR_SYM_L4_HDR_IS_UDP_TCP_IGNORE = 0,
	ULP_THOR_SYM_L4_HDR_IS_UDP_TCP_NO = 0,
	ULP_THOR_SYM_L4_HDR_IS_UDP_TCP_YES = 1,
	ULP_THOR_SYM_EM_WM_OPCODE_OP_NORMAL = 0,
	ULP_THOR_SYM_EM_WM_OPCODE_OP_NORMAL_RFS = 0,
	ULP_THOR_SYM_EM_WM_OPCODE_OP_RFS_FAST = 1,
	ULP_THOR_SYM_EM_WM_OPCODE_OP_FAST = 2,
	ULP_THOR_SYM_EM_WM_OPCODE_OP_RFS_ACT = 3,
	ULP_THOR_SYM_EM_WM_OPCODE_OP_CT_MISS_DEF = 0,
	ULP_THOR_SYM_EM_WM_OPCODE_OP_CT_HIT_DEF = 0,
	ULP_THOR_SYM_EM_WM_OPCODE_OP_RECYCLE = 4,
	ULP_THOR_SYM_POP_VLAN_NO = 0,
	ULP_THOR_SYM_POP_VLAN_YES = 1,
	ULP_THOR_SYM_VLAN_DEL_RPT_DISABLED = 0,
	ULP_THOR_SYM_VLAN_DEL_RPT_STRIP_OUTER = 1,
	ULP_THOR_SYM_VLAN_DEL_RPT_STRIP_BOTH = 2,
	ULP_THOR_SYM_VLAN_DEL_RPT_DYN_STRIP = 3,
	ULP_THOR_SYM_DECAP_FUNC_NONE = 0,
	ULP_THOR_SYM_DECAP_FUNC_THRU_TL2 = 3,
	ULP_THOR_SYM_DECAP_FUNC_THRU_TL3 = 8,
	ULP_THOR_SYM_DECAP_FUNC_THRU_TL4 = 9,
	ULP_THOR_SYM_DECAP_FUNC_THRU_TUN = 10,
	ULP_THOR_SYM_DECAP_FUNC_THRU_L2 = 11,
	ULP_THOR_SYM_DECAP_FUNC_THRU_L3 = 12,
	ULP_THOR_SYM_DECAP_FUNC_THRU_L4 = 13,
	ULP_THOR_SYM_ECV_VALID_NO = 0,
	ULP_THOR_SYM_ECV_VALID_YES = 1,
	ULP_THOR_SYM_ECV_CUSTOM_EN_NO = 0,
	ULP_THOR_SYM_ECV_CUSTOM_EN_YES = 1,
	ULP_THOR_SYM_ECV_L2_EN_NO = 0,
	ULP_THOR_SYM_ECV_L2_EN_YES = 1,
	ULP_THOR_SYM_ECV_VTAG_TYPE_NOP = 0,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_1_ENCAP_PRI = 1,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_1_IVLAN_PRI = 2,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_1_REMAP_DIFFSERV = 3,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_2_ENCAP_PRI = 4,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_2_REMAP_DIFFSERV = 5,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_0_ENCAP_PRI = 6,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_0_REMAP_DIFFSERV = 7,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_0_PRI_0 = 8,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_0_PRI_1 = 8,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_0_PRI_2 = 8,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_0_PRI_3 = 8,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_0_PRI_4 = 8,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_0_PRI_5 = 8,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_0_PRI_6 = 8,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_0_PRI_7 = 8,
	ULP_THOR_SYM_ECV_L3_TYPE_NONE = 0,
	ULP_THOR_SYM_ECV_L3_TYPE_IPV4 = 4,
	ULP_THOR_SYM_ECV_L3_TYPE_IPV6 = 5,
	ULP_THOR_SYM_ECV_L3_TYPE_MPLS_8847 = 6,
	ULP_THOR_SYM_ECV_L3_TYPE_MPLS_8848 = 7,
	ULP_THOR_SYM_ECV_L4_TYPE_NONE = 0,
	ULP_THOR_SYM_ECV_L4_TYPE_UDP = 4,
	ULP_THOR_SYM_ECV_L4_TYPE_UDP_CSUM = 5,
	ULP_THOR_SYM_ECV_L4_TYPE_UDP_ENTROPY = 6,
	ULP_THOR_SYM_ECV_L4_TYPE_UDP_ENTROPY_CSUM = 7,
	ULP_THOR_SYM_ECV_TUN_TYPE_NONE = 0,
	ULP_THOR_SYM_ECV_TUN_TYPE_GENERIC = 1,
	ULP_THOR_SYM_ECV_TUN_TYPE_VXLAN = 2,
	ULP_THOR_SYM_ECV_TUN_TYPE_NGE = 3,
	ULP_THOR_SYM_ECV_TUN_TYPE_NVGRE = 4,
	ULP_THOR_SYM_ECV_TUN_TYPE_GRE = 5,
	ULP_THOR_SYM_EEM_ACT_REC_INT = 0,
	ULP_THOR_SYM_EEM_EXT_FLOW_CNTR = 0,
	ULP_THOR_SYM_UC_ACT_REC = 0,
	ULP_THOR_SYM_MC_ACT_REC = 1,
	ULP_THOR_SYM_ACT_REC_DROP_YES = 1,
	ULP_THOR_SYM_ACT_REC_DROP_NO = 0,
	ULP_THOR_SYM_ACT_REC_POP_VLAN_YES = 1,
	ULP_THOR_SYM_ACT_REC_POP_VLAN_NO = 0,
	ULP_THOR_SYM_ACT_REC_METER_EN_YES = 1,
	ULP_THOR_SYM_ACT_REC_METER_EN_NO = 0,
	ULP_THOR_SYM_LOOPBACK_PORT = 16,
	ULP_THOR_SYM_LOOPBACK_PARIF = 15,
	ULP_THOR_SYM_EXT_EM_MAX_KEY_SIZE = 0,
	ULP_THOR_SYM_MATCH_TYPE_EM = 0,
	ULP_THOR_SYM_MATCH_TYPE_WM = 1,
	ULP_THOR_SYM_IP_PROTO_ICMP = 1,
	ULP_THOR_SYM_IP_PROTO_IGMP = 2,
	ULP_THOR_SYM_IP_PROTO_IP_IN_IP = 4,
	ULP_THOR_SYM_IP_PROTO_TCP = 6,
	ULP_THOR_SYM_IP_PROTO_UDP = 17,
	ULP_THOR_SYM_VF_FUNC_PARIF = 15,
	ULP_THOR_SYM_NO = 0,
	ULP_THOR_SYM_YES = 1,
	ULP_THOR_SYM_RECYCLE_DST = 1039,
	ULP_THOR_SYM_VF_2_VFR_META_VAL = 8192,
	ULP_THOR_SYM_VF_2_VF_META_VAL = 4096,
	ULP_THOR_SYM_VF_2_VFR_META_MASK = 61440,
	ULP_THOR_SYM_META_PROFILE_0 = 0,
	ULP_THOR_SYM_CHAIN_META_VAL = 12288,
	ULP_THOR_SYM_L2_ECPRI_ETYPE = 44798,
	ULP_THOR_SYM_L4_ECPRI_ETYPE = 2048,
	ULP_THOR_SYM_L2_ROE_ETYPE = 64573
};

enum ulp_thor2_sym {
	ULP_THOR2_SYM_METADATA_OP_NORMAL = 0,
	ULP_THOR2_SYM_METADATA_OP_L2_HASH = 1,
	ULP_THOR2_SYM_METADATA_OP_L4_HASH = 2,
	ULP_THOR2_SYM_FWD_OP_BYPASS_CFA = 0,
	ULP_THOR2_SYM_FWD_OP_BYPASS_CFA_ROCE = 1,
	ULP_THOR2_SYM_FWD_OP_BYPASS_LKUP = 2,
	ULP_THOR2_SYM_FWD_OP_NORMAL_FLOW = 3,
	ULP_THOR2_SYM_FWD_OP_DROP = 4,
	ULP_THOR2_SYM_CTXT_OPCODE_BYPASS_CFA = 0,
	ULP_THOR2_SYM_CTXT_OPCODE_BYPASS_LKUP = 1,
	ULP_THOR2_SYM_CTXT_OPCODE_META_UPDATE = 0,
	ULP_THOR2_SYM_CTXT_OPCODE_NORMAL_FLOW = 2,
	ULP_THOR2_SYM_CTXT_OPCODE_DROP = 3,
	ULP_THOR2_SYM_L2_CTXT_PRI_CATCHALL = 5,
	ULP_THOR2_SYM_L2_CTXT_PRI_MC_BC = 40,
	ULP_THOR2_SYM_L2_CTXT_PRI_PORT = 70,
	ULP_THOR2_SYM_L2_CTXT_PRI_APP = 140,
	ULP_THOR2_SYM_PROF_TCAM_PRI_CATCHALL = 1,
	ULP_THOR2_SYM_PROF_TCAM_PRI_APP = 10,
	ULP_THOR2_SYM_PROF_TCAM_PRI_L4 = 10,
	ULP_THOR2_SYM_PROF_TCAM_PRI_L3 = 8,
	ULP_THOR2_SYM_PROF_TCAM_PRI_L2 = 4,
	ULP_THOR2_SYM_PKT_TYPE_IGNORE = 0,
	ULP_THOR2_SYM_PKT_TYPE_L2 = 0,
	ULP_THOR2_SYM_PKT_TYPE_0_IGNORE = 0,
	ULP_THOR2_SYM_PKT_TYPE_0_L2 = 0,
	ULP_THOR2_SYM_PKT_TYPE_1_IGNORE = 0,
	ULP_THOR2_SYM_PKT_TYPE_1_L2 = 0,
	ULP_THOR2_SYM_RECYCLE_CNT_IGNORE = 0,
	ULP_THOR2_SYM_RECYCLE_CNT_ZERO = 0,
	ULP_THOR2_SYM_RECYCLE_CNT_ONE = 1,
	ULP_THOR2_SYM_RECYCLE_CNT_TWO = 2,
	ULP_THOR2_SYM_RECYCLE_CNT_THREE = 3,
	ULP_THOR2_SYM_AGG_ERROR_IGNORE = 0,
	ULP_THOR2_SYM_AGG_ERROR_NO = 0,
	ULP_THOR2_SYM_AGG_ERROR_YES = 1,
	ULP_THOR2_SYM_RESERVED_IGNORE = 0,
	ULP_THOR2_SYM_HREC_NEXT_IGNORE = 0,
	ULP_THOR2_SYM_HREC_NEXT_NO = 0,
	ULP_THOR2_SYM_HREC_NEXT_YES = 1,
	ULP_THOR2_SYM_TL2_HDR_VALID_IGNORE = 0,
	ULP_THOR2_SYM_TL2_HDR_VALID_NO = 0,
	ULP_THOR2_SYM_TL2_HDR_VALID_YES = 1,
	ULP_THOR2_SYM_TL2_HDR_TYPE_IGNORE = 0,
	ULP_THOR2_SYM_TL2_HDR_TYPE_DIX = 0,
	ULP_THOR2_SYM_TL2_UC_MC_BC_IGNORE = 0,
	ULP_THOR2_SYM_TL2_UC_MC_BC_UC = 0,
	ULP_THOR2_SYM_TL2_UC_MC_BC_MC = 2,
	ULP_THOR2_SYM_TL2_UC_MC_BC_BC = 3,
	ULP_THOR2_SYM_TL2_VTAG_PRESENT_IGNORE = 0,
	ULP_THOR2_SYM_TL2_VTAG_PRESENT_NO = 0,
	ULP_THOR2_SYM_TL2_VTAG_PRESENT_YES = 1,
	ULP_THOR2_SYM_TL2_TWO_VTAGS_IGNORE = 0,
	ULP_THOR2_SYM_TL2_TWO_VTAGS_NO = 0,
	ULP_THOR2_SYM_TL2_TWO_VTAGS_YES = 1,
	ULP_THOR2_SYM_TL3_HDR_VALID_IGNORE = 0,
	ULP_THOR2_SYM_TL3_HDR_VALID_NO = 0,
	ULP_THOR2_SYM_TL3_HDR_VALID_YES = 1,
	ULP_THOR2_SYM_TL3_HDR_ERROR_IGNORE = 0,
	ULP_THOR2_SYM_TL3_HDR_ERROR_NO = 0,
	ULP_THOR2_SYM_TL3_HDR_ERROR_YES = 1,
	ULP_THOR2_SYM_TL3_HDR_TYPE_IGNORE = 0,
	ULP_THOR2_SYM_TL3_HDR_TYPE_IPV4 = 0,
	ULP_THOR2_SYM_TL3_HDR_TYPE_IPV6 = 1,
	ULP_THOR2_SYM_TL3_HDR_ISIP_IGNORE = 0,
	ULP_THOR2_SYM_TL3_HDR_ISIP_NO = 0,
	ULP_THOR2_SYM_TL3_HDR_ISIP_YES = 1,
	ULP_THOR2_SYM_TL3_IPV6_CMP_SRC_IGNORE = 0,
	ULP_THOR2_SYM_TL3_IPV6_CMP_SRC_NO = 0,
	ULP_THOR2_SYM_TL3_IPV6_CMP_SRC_YES = 1,
	ULP_THOR2_SYM_TL3_IPV6_CMP_DST_IGNORE = 0,
	ULP_THOR2_SYM_TL3_IPV6_CMP_DST_NO = 0,
	ULP_THOR2_SYM_TL3_IPV6_CMP_DST_YES = 1,
	ULP_THOR2_SYM_TL4_HDR_VALID_IGNORE = 0,
	ULP_THOR2_SYM_TL4_HDR_VALID_NO = 0,
	ULP_THOR2_SYM_TL4_HDR_VALID_YES = 1,
	ULP_THOR2_SYM_TL4_HDR_ERROR_IGNORE = 0,
	ULP_THOR2_SYM_TL4_HDR_ERROR_NO = 0,
	ULP_THOR2_SYM_TL4_HDR_ERROR_YES = 1,
	ULP_THOR2_SYM_TL4_HDR_IS_UDP_TCP_IGNORE = 0,
	ULP_THOR2_SYM_TL4_HDR_IS_UDP_TCP_NO = 0,
	ULP_THOR2_SYM_TL4_HDR_IS_UDP_TCP_YES = 1,
	ULP_THOR2_SYM_TL4_HDR_TYPE_IGNORE = 0,
	ULP_THOR2_SYM_TL4_HDR_TYPE_TCP = 0,
	ULP_THOR2_SYM_TL4_HDR_TYPE_UDP = 1,
	ULP_THOR2_SYM_TUN_HDR_VALID_IGNORE = 0,
	ULP_THOR2_SYM_TUN_HDR_VALID_NO = 0,
	ULP_THOR2_SYM_TUN_HDR_VALID_YES = 1,
	ULP_THOR2_SYM_TUN_HDR_ERROR_IGNORE = 0,
	ULP_THOR2_SYM_TUN_HDR_ERROR_NO = 0,
	ULP_THOR2_SYM_TUN_HDR_ERROR_YES = 1,
	ULP_THOR2_SYM_TUN_HDR_TYPE_IGNORE = 0,
	ULP_THOR2_SYM_TUN_HDR_TYPE_VXLAN = 0,
	ULP_THOR2_SYM_TUN_HDR_TYPE_VXLAN_GPE = 27,
	ULP_THOR2_SYM_TUN_HDR_TYPE_GENEVE = 1,
	ULP_THOR2_SYM_TUN_HDR_TYPE_NVGRE = 2,
	ULP_THOR2_SYM_TUN_HDR_TYPE_GRE = 3,
	ULP_THOR2_SYM_TUN_HDR_TYPE_IPV4 = 4,
	ULP_THOR2_SYM_TUN_HDR_TYPE_IPV6 = 5,
	ULP_THOR2_SYM_TUN_HDR_TYPE_PPPOE = 6,
	ULP_THOR2_SYM_TUN_HDR_TYPE_MPLS = 7,
	ULP_THOR2_SYM_TUN_HDR_TYPE_UPAR1 = 8,
	ULP_THOR2_SYM_TUN_HDR_TYPE_UPAR2 = 9,
	ULP_THOR2_SYM_TUN_HDR_TYPE_UPAR3 = 10,
	ULP_THOR2_SYM_TUN_HDR_TYPE_UPAR4 = 11,
	ULP_THOR2_SYM_TUN_HDR_TYPE_UPAR5 = 12,
	ULP_THOR2_SYM_TUN_HDR_TYPE_UPAR6 = 13,
	ULP_THOR2_SYM_TUN_HDR_TYPE_UPAR7 = 14,
	ULP_THOR2_SYM_TUN_HDR_TYPE_UPAR8 = 15,
	ULP_THOR2_SYM_TUN_HDR_TYPE_ROE = 20,
	ULP_THOR2_SYM_TUN_HDR_TYPE_ECPRI = 21,
	ULP_THOR2_SYM_TUN_HDR_TYPE_GTP_V1_U = 22,
	ULP_THOR2_SYM_TUN_HDR_TYPE_GTP_V2_C = 23,
	ULP_THOR2_SYM_TUN_HDR_TYPE_PFCP_SESS = 24,
	ULP_THOR2_SYM_TUN_HDR_TYPE_PFCP_NODE = 25,
	ULP_THOR2_SYM_TUN_HDR_TYPE_NSH = 26,
	ULP_THOR2_SYM_TUN_HDR_TYPE_VXLAN_IP = 28,
	ULP_THOR2_SYM_TUN_HDR_TYPE_GRE_TEN = 29,
	ULP_THOR2_SYM_TUN_HDR_TYPE_NONE = 31,
	ULP_THOR2_SYM_TUN_HDR_TYPE_UPAR_MASK = 32,
	ULP_THOR2_SYM_TUN_HDR_TYPE_TID_MASK = 33,
	ULP_THOR2_SYM_TUN_HDR_FLAGS_IGNORE = 0,
	ULP_THOR2_SYM_L2_HDR_VALID_IGNORE = 0,
	ULP_THOR2_SYM_L2_HDR_VALID_NO = 0,
	ULP_THOR2_SYM_L2_HDR_VALID_YES = 1,
	ULP_THOR2_SYM_L2_HDR_ERROR_IGNORE = 0,
	ULP_THOR2_SYM_L2_HDR_ERROR_NO = 0,
	ULP_THOR2_SYM_L2_HDR_ERROR_YES = 1,
	ULP_THOR2_SYM_L2_HDR_TYPE_IGNORE = 0,
	ULP_THOR2_SYM_L2_HDR_TYPE_DIX = 0,
	ULP_THOR2_SYM_L2_HDR_TYPE_LLC_SNAP = 1,
	ULP_THOR2_SYM_L2_HDR_TYPE_LLC = 2,
	ULP_THOR2_SYM_L2_UC_MC_BC_IGNORE = 0,
	ULP_THOR2_SYM_L2_UC_MC_BC_UC = 0,
	ULP_THOR2_SYM_L2_UC_MC_BC_MC = 2,
	ULP_THOR2_SYM_L2_UC_MC_BC_BC = 3,
	ULP_THOR2_SYM_L2_VTAG_PRESENT_IGNORE = 0,
	ULP_THOR2_SYM_L2_VTAG_PRESENT_NO = 0,
	ULP_THOR2_SYM_L2_VTAG_PRESENT_YES = 1,
	ULP_THOR2_SYM_L2_TWO_VTAGS_IGNORE = 0,
	ULP_THOR2_SYM_L2_TWO_VTAGS_NO = 0,
	ULP_THOR2_SYM_L2_TWO_VTAGS_YES = 1,
	ULP_THOR2_SYM_L2_CNTX_VLAN_SELECT_INNER = 0,
	ULP_THOR2_SYM_L2_CNTX_VLAN_SELECT_TUN = 1,
	ULP_THOR2_SYM_L2_CNTX_VLAN_SELECT_O_TUN = 2,
	ULP_THOR2_SYM_L2_CNTX_VLAN_SELECT_OM_TUN = 3,
	ULP_THOR2_SYM_L2_CNTX_TUN_SELECT_TUN_ID = 0,
	ULP_THOR2_SYM_L2_CNTX_TUN_SELECT_TUN_CNTX = 1,
	ULP_THOR2_SYM_L2_CNTX_TUN_SELECT_O_TUN_ID = 2,
	ULP_THOR2_SYM_L2_CNTX_TUN_SELECT_O_TUN_CNTX = 3,
	ULP_THOR2_SYM_L2_CNTX_TUN_SELECT_I_L4_PORTS = 4,
	ULP_THOR2_SYM_L2_CNTX_TUN_SELECT_O_L4_PORTS = 5,
	ULP_THOR2_SYM_L2_CNTX_TUN_SELECT_OM_TUN_ID = 6,
	ULP_THOR2_SYM_L2_CNTX_TUN_SELECT_OM_TUN_CNTX = 7,
	ULP_THOR2_SYM_L3_HDR_VALID_IGNORE = 0,
	ULP_THOR2_SYM_L3_HDR_VALID_NO = 0,
	ULP_THOR2_SYM_L3_HDR_VALID_YES = 1,
	ULP_THOR2_SYM_L3_HDR_ERROR_IGNORE = 0,
	ULP_THOR2_SYM_L3_HDR_ERROR_NO = 0,
	ULP_THOR2_SYM_L3_HDR_ERROR_YES = 1,
	ULP_THOR2_SYM_L3_HDR_TYPE_IGNORE = 0,
	ULP_THOR2_SYM_L3_HDR_TYPE_IPV4 = 0,
	ULP_THOR2_SYM_L3_HDR_TYPE_IPV6 = 1,
	ULP_THOR2_SYM_L3_HDR_TYPE_ARP = 2,
	ULP_THOR2_SYM_L3_HDR_TYPE_PTP = 3,
	ULP_THOR2_SYM_L3_HDR_TYPE_EAPOL = 4,
	ULP_THOR2_SYM_L3_HDR_TYPE_ROCE = 5,
	ULP_THOR2_SYM_L3_HDR_TYPE_FCOE = 6,
	ULP_THOR2_SYM_L3_HDR_TYPE_UPAR1 = 7,
	ULP_THOR2_SYM_L3_HDR_TYPE_UPAR2 = 8,
	ULP_THOR2_SYM_L3_HDR_ISIP_IGNORE = 0,
	ULP_THOR2_SYM_L3_HDR_ISIP_NO = 0,
	ULP_THOR2_SYM_L3_HDR_ISIP_YES = 1,
	ULP_THOR2_SYM_L3_IPV6_CMP_SRC_IGNORE = 0,
	ULP_THOR2_SYM_L3_IPV6_CMP_SRC_NO = 0,
	ULP_THOR2_SYM_L3_IPV6_CMP_SRC_YES = 1,
	ULP_THOR2_SYM_L3_IPV6_CMP_DST_IGNORE = 0,
	ULP_THOR2_SYM_L3_IPV6_CMP_DST_NO = 0,
	ULP_THOR2_SYM_L3_IPV6_CMP_DST_YES = 1,
	ULP_THOR2_SYM_L4_HDR_VALID_IGNORE = 0,
	ULP_THOR2_SYM_L4_HDR_VALID_NO = 0,
	ULP_THOR2_SYM_L4_HDR_VALID_YES = 1,
	ULP_THOR2_SYM_L4_HDR_ERROR_IGNORE = 0,
	ULP_THOR2_SYM_L4_HDR_ERROR_NO = 0,
	ULP_THOR2_SYM_L4_HDR_ERROR_YES = 1,
	ULP_THOR2_SYM_L4_HDR_TYPE_IGNORE = 0,
	ULP_THOR2_SYM_L4_HDR_TYPE_TCP = 0,
	ULP_THOR2_SYM_L4_HDR_TYPE_UDP = 1,
	ULP_THOR2_SYM_L4_HDR_TYPE_ICMP = 2,
	ULP_THOR2_SYM_L4_HDR_TYPE_UPAR1 = 3,
	ULP_THOR2_SYM_L4_HDR_TYPE_UPAR2 = 4,
	ULP_THOR2_SYM_L4_HDR_TYPE_BTH_V1 = 0,
	ULP_THOR2_SYM_L4_HDR_TYPE_IPSEC_AH = 8,
	ULP_THOR2_SYM_L4_HDR_TYPE_IPSEC_ESP = 9,
	ULP_THOR2_SYM_L4_HDR_IS_UDP_TCP_IGNORE = 0,
	ULP_THOR2_SYM_L4_HDR_IS_UDP_TCP_NO = 0,
	ULP_THOR2_SYM_L4_HDR_IS_UDP_TCP_YES = 1,
	ULP_THOR2_SYM_EM_WM_OPCODE_OP_NORMAL = 0,
	ULP_THOR2_SYM_EM_WM_OPCODE_OP_NORMAL_RFS = 1,
	ULP_THOR2_SYM_EM_WM_OPCODE_OP_RFS_FAST = 3,
	ULP_THOR2_SYM_EM_WM_OPCODE_OP_FAST = 2,
	ULP_THOR2_SYM_EM_WM_OPCODE_OP_RFS_ACT = 0,
	ULP_THOR2_SYM_EM_WM_OPCODE_OP_CT_MISS_DEF = 4,
	ULP_THOR2_SYM_EM_WM_OPCODE_OP_CT_HIT_DEF = 6,
	ULP_THOR2_SYM_EM_WM_OPCODE_OP_RECYCLE = 8,
	ULP_THOR2_SYM_POP_VLAN_NO = 0,
	ULP_THOR2_SYM_POP_VLAN_YES = 1,
	ULP_THOR2_SYM_VLAN_DEL_RPT_DISABLED = 0,
	ULP_THOR2_SYM_VLAN_DEL_RPT_STRIP_OUTER = 1,
	ULP_THOR2_SYM_VLAN_DEL_RPT_STRIP_BOTH = 2,
	ULP_THOR2_SYM_VLAN_DEL_RPT_DYN_STRIP = 3,
	ULP_THOR2_SYM_DECAP_FUNC_NONE = 0,
	ULP_THOR2_SYM_DECAP_FUNC_THRU_TL2 = 3,
	ULP_THOR2_SYM_DECAP_FUNC_THRU_TL3 = 8,
	ULP_THOR2_SYM_DECAP_FUNC_THRU_TL4 = 9,
	ULP_THOR2_SYM_DECAP_FUNC_THRU_TUN = 10,
	ULP_THOR2_SYM_DECAP_FUNC_THRU_L2 = 11,
	ULP_THOR2_SYM_DECAP_FUNC_THRU_L3 = 12,
	ULP_THOR2_SYM_DECAP_FUNC_THRU_L4 = 13,
	ULP_THOR2_SYM_ECV_VALID_NO = 0,
	ULP_THOR2_SYM_ECV_VALID_YES = 1,
	ULP_THOR2_SYM_ECV_CUSTOM_EN_NO = 0,
	ULP_THOR2_SYM_ECV_CUSTOM_EN_YES = 1,
	ULP_THOR2_SYM_ECV_L2_EN_NO = 0,
	ULP_THOR2_SYM_ECV_L2_EN_YES = 1,
	ULP_THOR2_SYM_ECV_VTAG_TYPE_NOP = 0,
	ULP_THOR2_SYM_ECV_VTAG_TYPE_ADD_1_ENCAP_PRI = 1,
	ULP_THOR2_SYM_ECV_VTAG_TYPE_ADD_1_IVLAN_PRI = 2,
	ULP_THOR2_SYM_ECV_VTAG_TYPE_ADD_1_REMAP_DIFFSERV = 3,
	ULP_THOR2_SYM_ECV_VTAG_TYPE_ADD_2_ENCAP_PRI = 4,
	ULP_THOR2_SYM_ECV_VTAG_TYPE_ADD_2_REMAP_DIFFSERV = 5,
	ULP_THOR2_SYM_ECV_VTAG_TYPE_ADD_0_ENCAP_PRI = 6,
	ULP_THOR2_SYM_ECV_VTAG_TYPE_ADD_0_REMAP_DIFFSERV = 7,
	ULP_THOR2_SYM_ECV_VTAG_TYPE_ADD_0_PRI_0 = 8,
	ULP_THOR2_SYM_ECV_VTAG_TYPE_ADD_0_PRI_1 = 8,
	ULP_THOR2_SYM_ECV_VTAG_TYPE_ADD_0_PRI_2 = 8,
	ULP_THOR2_SYM_ECV_VTAG_TYPE_ADD_0_PRI_3 = 8,
	ULP_THOR2_SYM_ECV_VTAG_TYPE_ADD_0_PRI_4 = 8,
	ULP_THOR2_SYM_ECV_VTAG_TYPE_ADD_0_PRI_5 = 8,
	ULP_THOR2_SYM_ECV_VTAG_TYPE_ADD_0_PRI_6 = 8,
	ULP_THOR2_SYM_ECV_VTAG_TYPE_ADD_0_PRI_7 = 8,
	ULP_THOR2_SYM_ECV_L3_TYPE_NONE = 0,
	ULP_THOR2_SYM_ECV_L3_TYPE_IPV4 = 4,
	ULP_THOR2_SYM_ECV_L3_TYPE_IPV6 = 5,
	ULP_THOR2_SYM_ECV_L3_TYPE_MPLS_8847 = 6,
	ULP_THOR2_SYM_ECV_L3_TYPE_MPLS_8848 = 7,
	ULP_THOR2_SYM_ECV_L4_TYPE_NONE = 0,
	ULP_THOR2_SYM_ECV_L4_TYPE_UDP = 4,
	ULP_THOR2_SYM_ECV_L4_TYPE_UDP_CSUM = 5,
	ULP_THOR2_SYM_ECV_L4_TYPE_UDP_ENTROPY = 6,
	ULP_THOR2_SYM_ECV_L4_TYPE_UDP_ENTROPY_CSUM = 7,
	ULP_THOR2_SYM_ECV_TUN_TYPE_NONE = 0,
	ULP_THOR2_SYM_ECV_TUN_TYPE_GENERIC = 1,
	ULP_THOR2_SYM_ECV_TUN_TYPE_VXLAN = 2,
	ULP_THOR2_SYM_ECV_TUN_TYPE_NGE = 3,
	ULP_THOR2_SYM_ECV_TUN_TYPE_NVGRE = 4,
	ULP_THOR2_SYM_ECV_TUN_TYPE_GRE = 5,
	ULP_THOR2_SYM_EEM_ACT_REC_INT = 0,
	ULP_THOR2_SYM_EEM_EXT_FLOW_CNTR = 0,
	ULP_THOR2_SYM_UC_ACT_REC = 0,
	ULP_THOR2_SYM_MC_ACT_REC = 1,
	ULP_THOR2_SYM_ACT_REC_DROP_YES = 1,
	ULP_THOR2_SYM_ACT_REC_DROP_NO = 0,
	ULP_THOR2_SYM_ACT_REC_POP_VLAN_YES = 1,
	ULP_THOR2_SYM_ACT_REC_POP_VLAN_NO = 0,
	ULP_THOR2_SYM_ACT_REC_METER_EN_YES = 1,
	ULP_THOR2_SYM_ACT_REC_METER_EN_NO = 0,
	ULP_THOR2_SYM_LOOPBACK_PORT = 16,
	ULP_THOR2_SYM_LOOPBACK_PARIF = 15,
	ULP_THOR2_SYM_EXT_EM_MAX_KEY_SIZE = 0,
	ULP_THOR2_SYM_MATCH_TYPE_EM = 0,
	ULP_THOR2_SYM_MATCH_TYPE_WM = 1,
	ULP_THOR2_SYM_IP_PROTO_ICMP = 1,
	ULP_THOR2_SYM_IP_PROTO_IGMP = 2,
	ULP_THOR2_SYM_IP_PROTO_IP_IN_IP = 4,
	ULP_THOR2_SYM_IP_PROTO_TCP = 6,
	ULP_THOR2_SYM_IP_PROTO_UDP = 17,
	ULP_THOR2_SYM_VF_FUNC_PARIF = 15,
	ULP_THOR2_SYM_NO = 0,
	ULP_THOR2_SYM_YES = 1,
	ULP_THOR2_SYM_RECYCLE_DST = 0x800,
	ULP_THOR2_SYM_VF_2_VFR_META_VAL = 536870912,
	ULP_THOR2_SYM_VF_2_VF_META_VAL = 536870912,
	ULP_THOR2_SYM_VF_2_VFR_META_MASK = 4026531840,
	ULP_THOR2_SYM_META_PROFILE_0 = 0,
	ULP_THOR2_SYM_CHAIN_META_VAL = 0,
	ULP_THOR2_SYM_L2_ECPRI_ETYPE = 44798,
	ULP_THOR2_SYM_L4_ECPRI_ETYPE = 2048,
	ULP_THOR2_SYM_L2_ROE_ETYPE = 64573
};

enum bnxt_ulp_df_tpl {
	BNXT_ULP_DF_TPL_DEFAULT_UPLINK_PORT = 3,
	BNXT_ULP_DF_TPL_DEFAULT_VFR = 4
};

#endif

