// SPDX-License-Identifier: BSD-3-Clause
/* Copyright(c) 2014-2023 Broadcom
 * All rights reserved.
 */

#include "ulp_template_db_enum.h"
#include "ulp_template_db_field.h"
#include "ulp_template_struct.h"
#include "ulp_template_db_tbl.h"

/* Define the template match patterns */
/*
 * List of protocol matches
 */
struct bnxt_ulp_class_match_info ulp_class_match_list[] = {
	[1] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB800000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		},
	},
	[2] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA00000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[3] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA00000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[113] = 5,
		[117] = 6,
		[121] = 7,
		},
	},
	[4] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA40000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[112] = 5,
		[113] = 8,
		[116] = 6,
		[117] = 9,
		[120] = 7,
		[121] = 10,
		},
	},
	[5] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA78000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[56] = 5,
		[58] = 6,
		[60] = 7,
		[62] = 8,
		[64] = 9,
		[66] = 10,
		[68] = 11,
		[70] = 12,
		},
	},
	[6] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA36000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[36] = 5,
		[38] = 6,
		[40] = 7,
		[42] = 8,
		[44] = 9,
		[46] = 10,
		[48] = 11,
		[50] = 12,
		[52] = 13,
		[54] = 14,
		},
	},
	[7] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4F000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[56] = 8,
		[58] = 9,
		[60] = 10,
		[62] = 11,
		[64] = 12,
		[66] = 13,
		[68] = 14,
		[70] = 15,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[8] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46C00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[36] = 8,
		[38] = 9,
		[40] = 10,
		[42] = 11,
		[44] = 12,
		[46] = 13,
		[48] = 14,
		[50] = 15,
		[52] = 16,
		[54] = 17,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[9] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4F000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[56] = 8,
		[58] = 9,
		[60] = 10,
		[62] = 11,
		[64] = 12,
		[66] = 13,
		[68] = 14,
		[70] = 15,
		[113] = 5,
		[117] = 6,
		[121] = 7,
		},
	},
	[10] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46C00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[36] = 8,
		[38] = 9,
		[40] = 10,
		[42] = 11,
		[44] = 12,
		[46] = 13,
		[48] = 14,
		[50] = 15,
		[52] = 16,
		[54] = 17,
		[113] = 5,
		[117] = 6,
		[121] = 7,
		},
	},
	[11] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA49E00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[56] = 11,
		[58] = 12,
		[60] = 13,
		[62] = 14,
		[64] = 15,
		[66] = 16,
		[68] = 17,
		[70] = 18,
		[112] = 5,
		[113] = 8,
		[116] = 6,
		[117] = 9,
		[120] = 7,
		[121] = 10,
		},
	},
	[12] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA48D80000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[36] = 11,
		[38] = 12,
		[40] = 13,
		[42] = 14,
		[44] = 15,
		[46] = 16,
		[48] = 17,
		[50] = 18,
		[52] = 19,
		[54] = 20,
		[112] = 5,
		[113] = 8,
		[116] = 6,
		[117] = 9,
		[120] = 7,
		[121] = 10,
		},
	},
	[13] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBE20000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[86] = 5,
		[88] = 6,
		[90] = 7,
		[92] = 8,
		[94] = 9,
		[96] = 10,
		[98] = 11,
		[100] = 12,
		[102] = 13,
		},
	},
	[14] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBE00000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[104] = 5,
		[106] = 6,
		[108] = 7,
		[110] = 8,
		},
	},
	[15] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBAC4000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[86] = 8,
		[88] = 9,
		[90] = 10,
		[92] = 11,
		[94] = 12,
		[96] = 13,
		[98] = 14,
		[100] = 15,
		[102] = 16,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[16] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBAC0000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[104] = 8,
		[106] = 9,
		[108] = 10,
		[110] = 11,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[17] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBAC4000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[86] = 8,
		[88] = 9,
		[90] = 10,
		[92] = 11,
		[94] = 12,
		[96] = 13,
		[98] = 14,
		[100] = 15,
		[102] = 16,
		[113] = 5,
		[117] = 6,
		[121] = 7,
		},
	},
	[18] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBAC0000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[104] = 8,
		[106] = 9,
		[108] = 10,
		[110] = 11,
		[113] = 5,
		[117] = 6,
		[121] = 7,
		},
	},
	[19] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA58800000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[86] = 11,
		[88] = 12,
		[90] = 13,
		[92] = 14,
		[94] = 15,
		[96] = 16,
		[98] = 17,
		[100] = 18,
		[102] = 19,
		[112] = 5,
		[113] = 8,
		[116] = 6,
		[117] = 9,
		[120] = 7,
		[121] = 10,
		},
	},
	[20] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA58000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[104] = 11,
		[106] = 12,
		[108] = 13,
		[110] = 14,
		[112] = 5,
		[113] = 8,
		[116] = 6,
		[117] = 9,
		[120] = 7,
		[121] = 10,
		},
	},
	[21] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA7E200000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[56] = 5,
		[58] = 6,
		[60] = 7,
		[62] = 8,
		[64] = 9,
		[66] = 10,
		[68] = 11,
		[70] = 12,
		[86] = 13,
		[88] = 14,
		[90] = 15,
		[92] = 16,
		[94] = 17,
		[96] = 18,
		[98] = 19,
		[100] = 20,
		[102] = 21,
		},
	},
	[22] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA37880000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[36] = 5,
		[38] = 6,
		[40] = 7,
		[42] = 8,
		[44] = 9,
		[46] = 10,
		[48] = 11,
		[50] = 12,
		[52] = 13,
		[54] = 14,
		[86] = 15,
		[88] = 16,
		[90] = 17,
		[92] = 18,
		[94] = 19,
		[96] = 20,
		[98] = 21,
		[100] = 22,
		[102] = 23,
		},
	},
	[23] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA7E000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[56] = 5,
		[58] = 6,
		[60] = 7,
		[62] = 8,
		[64] = 9,
		[66] = 10,
		[68] = 11,
		[70] = 12,
		[104] = 13,
		[106] = 14,
		[108] = 15,
		[110] = 16,
		},
	},
	[24] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA37800000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[36] = 5,
		[38] = 6,
		[40] = 7,
		[42] = 8,
		[44] = 9,
		[46] = 10,
		[48] = 11,
		[50] = 12,
		[52] = 13,
		[54] = 14,
		[104] = 15,
		[106] = 16,
		[108] = 17,
		[110] = 18,
		},
	},
	[25] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4FC40000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[56] = 8,
		[58] = 9,
		[60] = 10,
		[62] = 11,
		[64] = 12,
		[66] = 13,
		[68] = 14,
		[70] = 15,
		[86] = 16,
		[88] = 17,
		[90] = 18,
		[92] = 19,
		[94] = 20,
		[96] = 21,
		[98] = 22,
		[100] = 23,
		[102] = 24,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[26] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46F10000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[36] = 8,
		[38] = 9,
		[40] = 10,
		[42] = 11,
		[44] = 12,
		[46] = 13,
		[48] = 14,
		[50] = 15,
		[52] = 16,
		[54] = 17,
		[86] = 18,
		[88] = 19,
		[90] = 20,
		[92] = 21,
		[94] = 22,
		[96] = 23,
		[98] = 24,
		[100] = 25,
		[102] = 26,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[27] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4FC00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[56] = 8,
		[58] = 9,
		[60] = 10,
		[62] = 11,
		[64] = 12,
		[66] = 13,
		[68] = 14,
		[70] = 15,
		[104] = 16,
		[106] = 17,
		[108] = 18,
		[110] = 19,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[28] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46F00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[36] = 8,
		[38] = 9,
		[40] = 10,
		[42] = 11,
		[44] = 12,
		[46] = 13,
		[48] = 14,
		[50] = 15,
		[52] = 16,
		[54] = 17,
		[104] = 18,
		[106] = 19,
		[108] = 20,
		[110] = 21,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[29] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4FC40000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[56] = 8,
		[58] = 9,
		[60] = 10,
		[62] = 11,
		[64] = 12,
		[66] = 13,
		[68] = 14,
		[70] = 15,
		[86] = 16,
		[88] = 17,
		[90] = 18,
		[92] = 19,
		[94] = 20,
		[96] = 21,
		[98] = 22,
		[100] = 23,
		[102] = 24,
		[113] = 5,
		[117] = 6,
		[121] = 7,
		},
	},
	[30] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46F10000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[36] = 8,
		[38] = 9,
		[40] = 10,
		[42] = 11,
		[44] = 12,
		[46] = 13,
		[48] = 14,
		[50] = 15,
		[52] = 16,
		[54] = 17,
		[86] = 18,
		[88] = 19,
		[90] = 20,
		[92] = 21,
		[94] = 22,
		[96] = 23,
		[98] = 24,
		[100] = 25,
		[102] = 26,
		[113] = 5,
		[117] = 6,
		[121] = 7,
		},
	},
	[31] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4FC00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[56] = 8,
		[58] = 9,
		[60] = 10,
		[62] = 11,
		[64] = 12,
		[66] = 13,
		[68] = 14,
		[70] = 15,
		[104] = 16,
		[106] = 17,
		[108] = 18,
		[110] = 19,
		[113] = 5,
		[117] = 6,
		[121] = 7,
		},
	},
	[32] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46F00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[36] = 8,
		[38] = 9,
		[40] = 10,
		[42] = 11,
		[44] = 12,
		[46] = 13,
		[48] = 14,
		[50] = 15,
		[52] = 16,
		[54] = 17,
		[104] = 18,
		[106] = 19,
		[108] = 20,
		[110] = 21,
		[113] = 5,
		[117] = 6,
		[121] = 7,
		},
	},
	[33] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA49F88000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[56] = 11,
		[58] = 12,
		[60] = 13,
		[62] = 14,
		[64] = 15,
		[66] = 16,
		[68] = 17,
		[70] = 18,
		[86] = 19,
		[88] = 20,
		[90] = 21,
		[92] = 22,
		[94] = 23,
		[96] = 24,
		[98] = 25,
		[100] = 26,
		[102] = 27,
		[112] = 5,
		[113] = 8,
		[116] = 6,
		[117] = 9,
		[120] = 7,
		[121] = 10,
		},
	},
	[34] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA48DE2000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[36] = 11,
		[38] = 12,
		[40] = 13,
		[42] = 14,
		[44] = 15,
		[46] = 16,
		[48] = 17,
		[50] = 18,
		[52] = 19,
		[54] = 20,
		[86] = 21,
		[88] = 22,
		[90] = 23,
		[92] = 24,
		[94] = 25,
		[96] = 26,
		[98] = 27,
		[100] = 28,
		[102] = 29,
		[112] = 5,
		[113] = 8,
		[116] = 6,
		[117] = 9,
		[120] = 7,
		[121] = 10,
		},
	},
	[35] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA49F80000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[56] = 11,
		[58] = 12,
		[60] = 13,
		[62] = 14,
		[64] = 15,
		[66] = 16,
		[68] = 17,
		[70] = 18,
		[104] = 19,
		[106] = 20,
		[108] = 21,
		[110] = 22,
		[112] = 5,
		[113] = 8,
		[116] = 6,
		[117] = 9,
		[120] = 7,
		[121] = 10,
		},
	},
	[36] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA48DE0000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[36] = 11,
		[38] = 12,
		[40] = 13,
		[42] = 14,
		[44] = 15,
		[46] = 16,
		[48] = 17,
		[50] = 18,
		[52] = 19,
		[54] = 20,
		[104] = 21,
		[106] = 22,
		[108] = 23,
		[110] = 24,
		[112] = 5,
		[113] = 8,
		[116] = 6,
		[117] = 9,
		[120] = 7,
		[121] = 10,
		},
	},
	[37] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A170000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 21,
		[12] = 3,
		[13] = 22,
		[14] = 4,
		[15] = 23,
		[56] = 5,
		[58] = 6,
		[60] = 7,
		[62] = 8,
		[64] = 9,
		[66] = 10,
		[68] = 11,
		[70] = 12,
		[104] = 13,
		[106] = 14,
		[108] = 15,
		[110] = 16,
		[124] = 17,
		[125] = 18,
		[126] = 19,
		[127] = 20,
		},
	},
	[38] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 23,
		[12] = 3,
		[13] = 24,
		[14] = 4,
		[15] = 25,
		[36] = 5,
		[38] = 6,
		[40] = 7,
		[42] = 8,
		[44] = 9,
		[46] = 10,
		[48] = 11,
		[50] = 12,
		[52] = 13,
		[54] = 14,
		[104] = 15,
		[106] = 16,
		[108] = 17,
		[110] = 18,
		[124] = 19,
		[125] = 20,
		[126] = 21,
		[127] = 22,
		},
	},
	[39] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A170B00000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 21,
		[12] = 3,
		[13] = 22,
		[14] = 4,
		[15] = 23,
		[56] = 5,
		[57] = 24,
		[58] = 6,
		[59] = 25,
		[60] = 7,
		[61] = 26,
		[62] = 8,
		[63] = 27,
		[64] = 9,
		[65] = 28,
		[66] = 10,
		[67] = 29,
		[68] = 11,
		[69] = 30,
		[70] = 12,
		[71] = 31,
		[104] = 13,
		[106] = 14,
		[108] = 15,
		[110] = 16,
		[124] = 17,
		[125] = 18,
		[126] = 19,
		[127] = 20,
		},
	},
	[40] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C2C0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 23,
		[12] = 3,
		[13] = 24,
		[14] = 4,
		[15] = 25,
		[36] = 5,
		[38] = 6,
		[40] = 7,
		[42] = 8,
		[44] = 9,
		[46] = 10,
		[48] = 11,
		[50] = 12,
		[52] = 13,
		[54] = 14,
		[57] = 26,
		[59] = 27,
		[61] = 28,
		[63] = 29,
		[65] = 30,
		[67] = 31,
		[69] = 32,
		[71] = 33,
		[104] = 15,
		[106] = 16,
		[108] = 17,
		[110] = 18,
		[124] = 19,
		[125] = 20,
		[126] = 21,
		[127] = 22,
		},
	},
	[41] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A1702C0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 21,
		[12] = 3,
		[13] = 22,
		[14] = 4,
		[15] = 23,
		[37] = 24,
		[39] = 25,
		[41] = 26,
		[43] = 27,
		[45] = 28,
		[47] = 29,
		[49] = 30,
		[51] = 31,
		[53] = 32,
		[55] = 33,
		[56] = 5,
		[58] = 6,
		[60] = 7,
		[62] = 8,
		[64] = 9,
		[66] = 10,
		[68] = 11,
		[70] = 12,
		[104] = 13,
		[106] = 14,
		[108] = 15,
		[110] = 16,
		[124] = 17,
		[125] = 18,
		[126] = 19,
		[127] = 20,
		},
	},
	[42] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C0B0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 23,
		[12] = 3,
		[13] = 24,
		[14] = 4,
		[15] = 25,
		[36] = 5,
		[37] = 26,
		[38] = 6,
		[39] = 27,
		[40] = 7,
		[41] = 28,
		[42] = 8,
		[43] = 29,
		[44] = 9,
		[45] = 30,
		[46] = 10,
		[47] = 31,
		[48] = 11,
		[49] = 32,
		[50] = 12,
		[51] = 33,
		[52] = 13,
		[53] = 34,
		[54] = 14,
		[55] = 35,
		[104] = 15,
		[106] = 16,
		[108] = 17,
		[110] = 18,
		[124] = 19,
		[125] = 20,
		[126] = 21,
		[127] = 22,
		},
	},
	[43] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A17C000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 21,
		[12] = 3,
		[13] = 22,
		[14] = 4,
		[15] = 23,
		[56] = 5,
		[58] = 6,
		[60] = 7,
		[62] = 8,
		[64] = 9,
		[66] = 10,
		[68] = 11,
		[70] = 12,
		[87] = 24,
		[89] = 25,
		[91] = 26,
		[93] = 27,
		[95] = 28,
		[97] = 29,
		[99] = 30,
		[101] = 31,
		[103] = 32,
		[104] = 13,
		[106] = 14,
		[108] = 15,
		[110] = 16,
		[124] = 17,
		[125] = 18,
		[126] = 19,
		[127] = 20,
		},
	},
	[44] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685F000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 23,
		[12] = 3,
		[13] = 24,
		[14] = 4,
		[15] = 25,
		[36] = 5,
		[38] = 6,
		[40] = 7,
		[42] = 8,
		[44] = 9,
		[46] = 10,
		[48] = 11,
		[50] = 12,
		[52] = 13,
		[54] = 14,
		[87] = 26,
		[89] = 27,
		[91] = 28,
		[93] = 29,
		[95] = 30,
		[97] = 31,
		[99] = 32,
		[101] = 33,
		[103] = 34,
		[104] = 15,
		[106] = 16,
		[108] = 17,
		[110] = 18,
		[124] = 19,
		[125] = 20,
		[126] = 21,
		[127] = 22,
		},
	},
	[45] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A17C000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 21,
		[12] = 3,
		[13] = 22,
		[14] = 4,
		[15] = 23,
		[56] = 5,
		[58] = 6,
		[60] = 7,
		[62] = 8,
		[64] = 9,
		[66] = 10,
		[68] = 11,
		[70] = 12,
		[104] = 13,
		[105] = 24,
		[106] = 14,
		[107] = 25,
		[108] = 15,
		[109] = 26,
		[110] = 16,
		[111] = 27,
		[124] = 17,
		[125] = 18,
		[126] = 19,
		[127] = 20,
		},
	},
	[46] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685F000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 23,
		[12] = 3,
		[13] = 24,
		[14] = 4,
		[15] = 25,
		[36] = 5,
		[38] = 6,
		[40] = 7,
		[42] = 8,
		[44] = 9,
		[46] = 10,
		[48] = 11,
		[50] = 12,
		[52] = 13,
		[54] = 14,
		[104] = 15,
		[105] = 26,
		[106] = 16,
		[107] = 27,
		[108] = 17,
		[109] = 28,
		[110] = 18,
		[111] = 29,
		[124] = 19,
		[125] = 20,
		[126] = 21,
		[127] = 22,
		},
	},
	[47] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A170BC0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 21,
		[12] = 3,
		[13] = 22,
		[14] = 4,
		[15] = 23,
		[56] = 5,
		[57] = 24,
		[58] = 6,
		[59] = 25,
		[60] = 7,
		[61] = 26,
		[62] = 8,
		[63] = 27,
		[64] = 9,
		[65] = 28,
		[66] = 10,
		[67] = 29,
		[68] = 11,
		[69] = 30,
		[70] = 12,
		[71] = 31,
		[87] = 32,
		[89] = 33,
		[91] = 34,
		[93] = 35,
		[95] = 36,
		[97] = 37,
		[99] = 38,
		[101] = 39,
		[103] = 40,
		[104] = 13,
		[106] = 14,
		[108] = 15,
		[110] = 16,
		[124] = 17,
		[125] = 18,
		[126] = 19,
		[127] = 20,
		},
	},
	[48] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C2F0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 23,
		[12] = 3,
		[13] = 24,
		[14] = 4,
		[15] = 25,
		[36] = 5,
		[38] = 6,
		[40] = 7,
		[42] = 8,
		[44] = 9,
		[46] = 10,
		[48] = 11,
		[50] = 12,
		[52] = 13,
		[54] = 14,
		[57] = 26,
		[59] = 27,
		[61] = 28,
		[63] = 29,
		[65] = 30,
		[67] = 31,
		[69] = 32,
		[71] = 33,
		[87] = 34,
		[89] = 35,
		[91] = 36,
		[93] = 37,
		[95] = 38,
		[97] = 39,
		[99] = 40,
		[101] = 41,
		[103] = 42,
		[104] = 15,
		[106] = 16,
		[108] = 17,
		[110] = 18,
		[124] = 19,
		[125] = 20,
		[126] = 21,
		[127] = 22,
		},
	},
	[49] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A1702F0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 21,
		[12] = 3,
		[13] = 22,
		[14] = 4,
		[15] = 23,
		[37] = 24,
		[39] = 25,
		[41] = 26,
		[43] = 27,
		[45] = 28,
		[47] = 29,
		[49] = 30,
		[51] = 31,
		[53] = 32,
		[55] = 33,
		[56] = 5,
		[58] = 6,
		[60] = 7,
		[62] = 8,
		[64] = 9,
		[66] = 10,
		[68] = 11,
		[70] = 12,
		[87] = 34,
		[89] = 35,
		[91] = 36,
		[93] = 37,
		[95] = 38,
		[97] = 39,
		[99] = 40,
		[101] = 41,
		[103] = 42,
		[104] = 13,
		[106] = 14,
		[108] = 15,
		[110] = 16,
		[124] = 17,
		[125] = 18,
		[126] = 19,
		[127] = 20,
		},
	},
	[50] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C0BC000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 23,
		[12] = 3,
		[13] = 24,
		[14] = 4,
		[15] = 25,
		[36] = 5,
		[37] = 26,
		[38] = 6,
		[39] = 27,
		[40] = 7,
		[41] = 28,
		[42] = 8,
		[43] = 29,
		[44] = 9,
		[45] = 30,
		[46] = 10,
		[47] = 31,
		[48] = 11,
		[49] = 32,
		[50] = 12,
		[51] = 33,
		[52] = 13,
		[53] = 34,
		[54] = 14,
		[55] = 35,
		[87] = 36,
		[89] = 37,
		[91] = 38,
		[93] = 39,
		[95] = 40,
		[97] = 41,
		[99] = 42,
		[101] = 43,
		[103] = 44,
		[104] = 15,
		[106] = 16,
		[108] = 17,
		[110] = 18,
		[124] = 19,
		[125] = 20,
		[126] = 21,
		[127] = 22,
		},
	},
	[51] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A170BC0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 21,
		[12] = 3,
		[13] = 22,
		[14] = 4,
		[15] = 23,
		[56] = 5,
		[57] = 24,
		[58] = 6,
		[59] = 25,
		[60] = 7,
		[61] = 26,
		[62] = 8,
		[63] = 27,
		[64] = 9,
		[65] = 28,
		[66] = 10,
		[67] = 29,
		[68] = 11,
		[69] = 30,
		[70] = 12,
		[71] = 31,
		[104] = 13,
		[105] = 32,
		[106] = 14,
		[107] = 33,
		[108] = 15,
		[109] = 34,
		[110] = 16,
		[111] = 35,
		[124] = 17,
		[125] = 18,
		[126] = 19,
		[127] = 20,
		},
	},
	[52] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C2F0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 23,
		[12] = 3,
		[13] = 24,
		[14] = 4,
		[15] = 25,
		[36] = 5,
		[38] = 6,
		[40] = 7,
		[42] = 8,
		[44] = 9,
		[46] = 10,
		[48] = 11,
		[50] = 12,
		[52] = 13,
		[54] = 14,
		[57] = 26,
		[59] = 27,
		[61] = 28,
		[63] = 29,
		[65] = 30,
		[67] = 31,
		[69] = 32,
		[71] = 33,
		[104] = 15,
		[105] = 34,
		[106] = 16,
		[107] = 35,
		[108] = 17,
		[109] = 36,
		[110] = 18,
		[111] = 37,
		[124] = 19,
		[125] = 20,
		[126] = 21,
		[127] = 22,
		},
	},
	[53] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A1702F0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 21,
		[12] = 3,
		[13] = 22,
		[14] = 4,
		[15] = 23,
		[37] = 24,
		[39] = 25,
		[41] = 26,
		[43] = 27,
		[45] = 28,
		[47] = 29,
		[49] = 30,
		[51] = 31,
		[53] = 32,
		[55] = 33,
		[56] = 5,
		[58] = 6,
		[60] = 7,
		[62] = 8,
		[64] = 9,
		[66] = 10,
		[68] = 11,
		[70] = 12,
		[104] = 13,
		[105] = 34,
		[106] = 14,
		[107] = 35,
		[108] = 15,
		[109] = 36,
		[110] = 16,
		[111] = 37,
		[124] = 17,
		[125] = 18,
		[126] = 19,
		[127] = 20,
		},
	},
	[54] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C0BC000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 23,
		[12] = 3,
		[13] = 24,
		[14] = 4,
		[15] = 25,
		[36] = 5,
		[37] = 26,
		[38] = 6,
		[39] = 27,
		[40] = 7,
		[41] = 28,
		[42] = 8,
		[43] = 29,
		[44] = 9,
		[45] = 30,
		[46] = 10,
		[47] = 31,
		[48] = 11,
		[49] = 32,
		[50] = 12,
		[51] = 33,
		[52] = 13,
		[53] = 34,
		[54] = 14,
		[55] = 35,
		[104] = 15,
		[105] = 36,
		[106] = 16,
		[107] = 37,
		[108] = 17,
		[109] = 38,
		[110] = 18,
		[111] = 39,
		[124] = 19,
		[125] = 20,
		[126] = 21,
		[127] = 22,
		},
	},
	[55] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F1 |
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x200A000000000000,
	.field_opt_bitmap = 0x9000000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 2,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[56] = 5,
		[58] = 6,
		[60] = 7,
		[62] = 8,
		[64] = 9,
		[66] = 10,
		[68] = 11,
		[70] = 12,
		[104] = 13,
		[106] = 14,
		[108] = 15,
		[110] = 16,
		[124] = 17,
		[125] = 18,
		[126] = 19,
		[127] = 20,
		},
	},
	[56] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F1 |
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x2002800000000000,
	.field_opt_bitmap = 0x9000000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 2,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[36] = 5,
		[38] = 6,
		[40] = 7,
		[42] = 8,
		[44] = 9,
		[46] = 10,
		[48] = 11,
		[50] = 12,
		[52] = 13,
		[54] = 14,
		[104] = 15,
		[106] = 16,
		[108] = 17,
		[110] = 18,
		[124] = 19,
		[125] = 20,
		[126] = 21,
		[127] = 22,
		},
	},
	[57] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0xC0800000000000,
	.field_opt_bitmap = 0x8010301800000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 3,
	.field_list = {
		[1] = 1,
		[11] = 18,
		[13] = 19,
		[15] = 20,
		[56] = 2,
		[57] = 21,
		[58] = 3,
		[59] = 22,
		[60] = 4,
		[61] = 23,
		[62] = 5,
		[63] = 24,
		[64] = 6,
		[65] = 25,
		[66] = 7,
		[67] = 26,
		[68] = 8,
		[69] = 27,
		[70] = 9,
		[71] = 28,
		[104] = 10,
		[106] = 11,
		[108] = 12,
		[110] = 13,
		[124] = 14,
		[125] = 15,
		[126] = 16,
		[127] = 17,
		},
	},
	[58] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x30200000000000,
	.field_opt_bitmap = 0x80040C0600000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 3,
	.field_list = {
		[1] = 1,
		[11] = 20,
		[13] = 21,
		[15] = 22,
		[36] = 2,
		[38] = 3,
		[40] = 4,
		[42] = 5,
		[44] = 6,
		[46] = 7,
		[48] = 8,
		[50] = 9,
		[52] = 10,
		[54] = 11,
		[57] = 23,
		[59] = 24,
		[61] = 25,
		[63] = 26,
		[65] = 27,
		[67] = 28,
		[69] = 29,
		[71] = 30,
		[104] = 12,
		[106] = 13,
		[108] = 14,
		[110] = 15,
		[124] = 16,
		[125] = 17,
		[126] = 18,
		[127] = 19,
		},
	},
	[59] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0xC0800000000000,
	.field_opt_bitmap = 0x8010300600000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 3,
	.field_list = {
		[1] = 1,
		[11] = 18,
		[13] = 19,
		[15] = 20,
		[37] = 21,
		[39] = 22,
		[41] = 23,
		[43] = 24,
		[45] = 25,
		[47] = 26,
		[49] = 27,
		[51] = 28,
		[53] = 29,
		[55] = 30,
		[56] = 2,
		[58] = 3,
		[60] = 4,
		[62] = 5,
		[64] = 6,
		[66] = 7,
		[68] = 8,
		[70] = 9,
		[104] = 10,
		[106] = 11,
		[108] = 12,
		[110] = 13,
		[124] = 14,
		[125] = 15,
		[126] = 16,
		[127] = 17,
		},
	},
	[60] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x30200000000000,
	.field_opt_bitmap = 0x80040C0180000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 3,
	.field_list = {
		[1] = 1,
		[11] = 20,
		[13] = 21,
		[15] = 22,
		[36] = 2,
		[37] = 23,
		[38] = 3,
		[39] = 24,
		[40] = 4,
		[41] = 25,
		[42] = 5,
		[43] = 26,
		[44] = 6,
		[45] = 27,
		[46] = 7,
		[47] = 28,
		[48] = 8,
		[49] = 29,
		[50] = 9,
		[51] = 30,
		[52] = 10,
		[53] = 31,
		[54] = 11,
		[55] = 32,
		[104] = 12,
		[106] = 13,
		[108] = 14,
		[110] = 15,
		[124] = 16,
		[125] = 17,
		[126] = 18,
		[127] = 19,
		},
	},
	[61] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0xC0800000000000,
	.field_opt_bitmap = 0x8010301E00000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 3,
	.field_list = {
		[1] = 1,
		[11] = 18,
		[13] = 19,
		[15] = 20,
		[56] = 2,
		[57] = 21,
		[58] = 3,
		[59] = 22,
		[60] = 4,
		[61] = 23,
		[62] = 5,
		[63] = 24,
		[64] = 6,
		[65] = 25,
		[66] = 7,
		[67] = 26,
		[68] = 8,
		[69] = 27,
		[70] = 9,
		[71] = 28,
		[87] = 29,
		[89] = 30,
		[91] = 31,
		[93] = 32,
		[95] = 33,
		[97] = 34,
		[99] = 35,
		[101] = 36,
		[103] = 37,
		[104] = 10,
		[106] = 11,
		[108] = 12,
		[110] = 13,
		[124] = 14,
		[125] = 15,
		[126] = 16,
		[127] = 17,
		},
	},
	[62] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x30200000000000,
	.field_opt_bitmap = 0x80040C0780000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 3,
	.field_list = {
		[1] = 1,
		[11] = 20,
		[13] = 21,
		[15] = 22,
		[36] = 2,
		[38] = 3,
		[40] = 4,
		[42] = 5,
		[44] = 6,
		[46] = 7,
		[48] = 8,
		[50] = 9,
		[52] = 10,
		[54] = 11,
		[57] = 23,
		[59] = 24,
		[61] = 25,
		[63] = 26,
		[65] = 27,
		[67] = 28,
		[69] = 29,
		[71] = 30,
		[87] = 31,
		[89] = 32,
		[91] = 33,
		[93] = 34,
		[95] = 35,
		[97] = 36,
		[99] = 37,
		[101] = 38,
		[103] = 39,
		[104] = 12,
		[106] = 13,
		[108] = 14,
		[110] = 15,
		[124] = 16,
		[125] = 17,
		[126] = 18,
		[127] = 19,
		},
	},
	[63] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0xC0800000000000,
	.field_opt_bitmap = 0x8010300780000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 3,
	.field_list = {
		[1] = 1,
		[11] = 18,
		[13] = 19,
		[15] = 20,
		[37] = 21,
		[39] = 22,
		[41] = 23,
		[43] = 24,
		[45] = 25,
		[47] = 26,
		[49] = 27,
		[51] = 28,
		[53] = 29,
		[55] = 30,
		[56] = 2,
		[58] = 3,
		[60] = 4,
		[62] = 5,
		[64] = 6,
		[66] = 7,
		[68] = 8,
		[70] = 9,
		[87] = 31,
		[89] = 32,
		[91] = 33,
		[93] = 34,
		[95] = 35,
		[97] = 36,
		[99] = 37,
		[101] = 38,
		[103] = 39,
		[104] = 10,
		[106] = 11,
		[108] = 12,
		[110] = 13,
		[124] = 14,
		[125] = 15,
		[126] = 16,
		[127] = 17,
		},
	},
	[64] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x30200000000000,
	.field_opt_bitmap = 0x80040C01E0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 3,
	.field_list = {
		[1] = 1,
		[11] = 20,
		[13] = 21,
		[15] = 22,
		[36] = 2,
		[37] = 23,
		[38] = 3,
		[39] = 24,
		[40] = 4,
		[41] = 25,
		[42] = 5,
		[43] = 26,
		[44] = 6,
		[45] = 27,
		[46] = 7,
		[47] = 28,
		[48] = 8,
		[49] = 29,
		[50] = 9,
		[51] = 30,
		[52] = 10,
		[53] = 31,
		[54] = 11,
		[55] = 32,
		[87] = 33,
		[89] = 34,
		[91] = 35,
		[93] = 36,
		[95] = 37,
		[97] = 38,
		[99] = 39,
		[101] = 40,
		[103] = 41,
		[104] = 12,
		[106] = 13,
		[108] = 14,
		[110] = 15,
		[124] = 16,
		[125] = 17,
		[126] = 18,
		[127] = 19,
		},
	},
	[65] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0xC0800000000000,
	.field_opt_bitmap = 0x8010301E00000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 3,
	.field_list = {
		[1] = 1,
		[11] = 18,
		[13] = 19,
		[15] = 20,
		[56] = 2,
		[57] = 21,
		[58] = 3,
		[59] = 22,
		[60] = 4,
		[61] = 23,
		[62] = 5,
		[63] = 24,
		[64] = 6,
		[65] = 25,
		[66] = 7,
		[67] = 26,
		[68] = 8,
		[69] = 27,
		[70] = 9,
		[71] = 28,
		[104] = 10,
		[105] = 29,
		[106] = 11,
		[107] = 30,
		[108] = 12,
		[109] = 31,
		[110] = 13,
		[111] = 32,
		[124] = 14,
		[125] = 15,
		[126] = 16,
		[127] = 17,
		},
	},
	[66] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x30200000000000,
	.field_opt_bitmap = 0x80040C0780000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 3,
	.field_list = {
		[1] = 1,
		[11] = 20,
		[13] = 21,
		[15] = 22,
		[36] = 2,
		[38] = 3,
		[40] = 4,
		[42] = 5,
		[44] = 6,
		[46] = 7,
		[48] = 8,
		[50] = 9,
		[52] = 10,
		[54] = 11,
		[57] = 23,
		[59] = 24,
		[61] = 25,
		[63] = 26,
		[65] = 27,
		[67] = 28,
		[69] = 29,
		[71] = 30,
		[104] = 12,
		[105] = 31,
		[106] = 13,
		[107] = 32,
		[108] = 14,
		[109] = 33,
		[110] = 15,
		[111] = 34,
		[124] = 16,
		[125] = 17,
		[126] = 18,
		[127] = 19,
		},
	},
	[67] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0xC0800000000000,
	.field_opt_bitmap = 0x8010300780000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 3,
	.field_list = {
		[1] = 1,
		[11] = 18,
		[13] = 19,
		[15] = 20,
		[37] = 21,
		[39] = 22,
		[41] = 23,
		[43] = 24,
		[45] = 25,
		[47] = 26,
		[49] = 27,
		[51] = 28,
		[53] = 29,
		[55] = 30,
		[56] = 2,
		[58] = 3,
		[60] = 4,
		[62] = 5,
		[64] = 6,
		[66] = 7,
		[68] = 8,
		[70] = 9,
		[104] = 10,
		[105] = 31,
		[106] = 11,
		[107] = 32,
		[108] = 12,
		[109] = 33,
		[110] = 13,
		[111] = 34,
		[124] = 14,
		[125] = 15,
		[126] = 16,
		[127] = 17,
		},
	},
	[68] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x30200000000000,
	.field_opt_bitmap = 0x80040C01E0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 3,
	.field_list = {
		[1] = 1,
		[11] = 20,
		[13] = 21,
		[15] = 22,
		[36] = 2,
		[37] = 23,
		[38] = 3,
		[39] = 24,
		[40] = 4,
		[41] = 25,
		[42] = 5,
		[43] = 26,
		[44] = 6,
		[45] = 27,
		[46] = 7,
		[47] = 28,
		[48] = 8,
		[49] = 29,
		[50] = 9,
		[51] = 30,
		[52] = 10,
		[53] = 31,
		[54] = 11,
		[55] = 32,
		[104] = 12,
		[105] = 33,
		[106] = 13,
		[107] = 34,
		[108] = 14,
		[109] = 35,
		[110] = 15,
		[111] = 36,
		[124] = 16,
		[125] = 17,
		[126] = 18,
		[127] = 19,
		},
	},
	[69] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_ICMP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0xC0800000000000,
	.field_opt_bitmap = 0x8010300600000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 4,
	.field_list = {
		[1] = 1,
		[11] = 18,
		[13] = 19,
		[15] = 20,
		[27] = 31,
		[29] = 32,
		[31] = 33,
		[33] = 34,
		[35] = 35,
		[37] = 21,
		[39] = 22,
		[41] = 23,
		[43] = 24,
		[45] = 25,
		[47] = 26,
		[49] = 27,
		[51] = 28,
		[53] = 29,
		[55] = 30,
		[56] = 2,
		[58] = 3,
		[60] = 4,
		[62] = 5,
		[64] = 6,
		[66] = 7,
		[68] = 8,
		[70] = 9,
		[104] = 10,
		[106] = 11,
		[108] = 12,
		[110] = 13,
		[124] = 14,
		[125] = 15,
		[126] = 16,
		[127] = 17,
		},
	},
	[70] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_ICMP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x30200000000000,
	.field_opt_bitmap = 0x80040C0180000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 4,
	.field_list = {
		[1] = 1,
		[11] = 20,
		[13] = 21,
		[15] = 22,
		[27] = 33,
		[29] = 34,
		[31] = 35,
		[33] = 36,
		[35] = 37,
		[36] = 2,
		[37] = 23,
		[38] = 3,
		[39] = 24,
		[40] = 4,
		[41] = 25,
		[42] = 5,
		[43] = 26,
		[44] = 6,
		[45] = 27,
		[46] = 7,
		[47] = 28,
		[48] = 8,
		[49] = 29,
		[50] = 9,
		[51] = 30,
		[52] = 10,
		[53] = 31,
		[54] = 11,
		[55] = 32,
		[104] = 12,
		[106] = 13,
		[108] = 14,
		[110] = 15,
		[124] = 16,
		[125] = 17,
		[126] = 18,
		[127] = 19,
		},
	},
	[71] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_GENEVE |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xA002800000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 5,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[36] = 5,
		[38] = 6,
		[40] = 7,
		[42] = 8,
		[44] = 9,
		[46] = 10,
		[48] = 11,
		[50] = 12,
		[52] = 13,
		[54] = 14,
		[104] = 15,
		[106] = 16,
		[108] = 17,
		[110] = 18,
		},
	},
	[72] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_SVIF |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0x8000000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 6,
	.field_list = {
		[1] = 1,
		},
	},
	[73] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB800000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		},
	},
	[74] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA00000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[75] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA00000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[113] = 5,
		[117] = 6,
		[121] = 7,
		},
	},
	[76] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA40000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[112] = 5,
		[113] = 8,
		[116] = 6,
		[117] = 9,
		[120] = 7,
		[121] = 10,
		},
	},
	[77] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA78000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[56] = 5,
		[58] = 6,
		[60] = 7,
		[62] = 8,
		[64] = 9,
		[66] = 10,
		[68] = 11,
		[70] = 12,
		},
	},
	[78] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA36000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[36] = 5,
		[38] = 6,
		[40] = 7,
		[42] = 8,
		[44] = 9,
		[46] = 10,
		[48] = 11,
		[50] = 12,
		[52] = 13,
		[54] = 14,
		},
	},
	[79] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4F000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[56] = 8,
		[58] = 9,
		[60] = 10,
		[62] = 11,
		[64] = 12,
		[66] = 13,
		[68] = 14,
		[70] = 15,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[80] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46C00000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[36] = 8,
		[38] = 9,
		[40] = 10,
		[42] = 11,
		[44] = 12,
		[46] = 13,
		[48] = 14,
		[50] = 15,
		[52] = 16,
		[54] = 17,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[81] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4F000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[56] = 8,
		[58] = 9,
		[60] = 10,
		[62] = 11,
		[64] = 12,
		[66] = 13,
		[68] = 14,
		[70] = 15,
		[113] = 5,
		[117] = 6,
		[121] = 7,
		},
	},
	[82] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46C00000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[36] = 8,
		[38] = 9,
		[40] = 10,
		[42] = 11,
		[44] = 12,
		[46] = 13,
		[48] = 14,
		[50] = 15,
		[52] = 16,
		[54] = 17,
		[113] = 5,
		[117] = 6,
		[121] = 7,
		},
	},
	[83] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA49E00000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[56] = 11,
		[58] = 12,
		[60] = 13,
		[62] = 14,
		[64] = 15,
		[66] = 16,
		[68] = 17,
		[70] = 18,
		[112] = 5,
		[113] = 8,
		[116] = 6,
		[117] = 9,
		[120] = 7,
		[121] = 10,
		},
	},
	[84] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA48D80000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[36] = 11,
		[38] = 12,
		[40] = 13,
		[42] = 14,
		[44] = 15,
		[46] = 16,
		[48] = 17,
		[50] = 18,
		[52] = 19,
		[54] = 20,
		[112] = 5,
		[113] = 8,
		[116] = 6,
		[117] = 9,
		[120] = 7,
		[121] = 10,
		},
	},
	[85] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBE20000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[86] = 5,
		[88] = 6,
		[90] = 7,
		[92] = 8,
		[94] = 9,
		[96] = 10,
		[98] = 11,
		[100] = 12,
		[102] = 13,
		},
	},
	[86] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBE00000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[104] = 5,
		[106] = 6,
		[108] = 7,
		[110] = 8,
		},
	},
	[87] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBAC4000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[86] = 8,
		[88] = 9,
		[90] = 10,
		[92] = 11,
		[94] = 12,
		[96] = 13,
		[98] = 14,
		[100] = 15,
		[102] = 16,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[88] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBAC0000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[104] = 8,
		[106] = 9,
		[108] = 10,
		[110] = 11,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[89] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBAC4000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[86] = 8,
		[88] = 9,
		[90] = 10,
		[92] = 11,
		[94] = 12,
		[96] = 13,
		[98] = 14,
		[100] = 15,
		[102] = 16,
		[113] = 5,
		[117] = 6,
		[121] = 7,
		},
	},
	[90] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBAC0000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[104] = 8,
		[106] = 9,
		[108] = 10,
		[110] = 11,
		[113] = 5,
		[117] = 6,
		[121] = 7,
		},
	},
	[91] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA58800000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[86] = 11,
		[88] = 12,
		[90] = 13,
		[92] = 14,
		[94] = 15,
		[96] = 16,
		[98] = 17,
		[100] = 18,
		[102] = 19,
		[112] = 5,
		[113] = 8,
		[116] = 6,
		[117] = 9,
		[120] = 7,
		[121] = 10,
		},
	},
	[92] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA58000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[104] = 11,
		[106] = 12,
		[108] = 13,
		[110] = 14,
		[112] = 5,
		[113] = 8,
		[116] = 6,
		[117] = 9,
		[120] = 7,
		[121] = 10,
		},
	},
	[93] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA7E200000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[56] = 5,
		[58] = 6,
		[60] = 7,
		[62] = 8,
		[64] = 9,
		[66] = 10,
		[68] = 11,
		[70] = 12,
		[86] = 13,
		[88] = 14,
		[90] = 15,
		[92] = 16,
		[94] = 17,
		[96] = 18,
		[98] = 19,
		[100] = 20,
		[102] = 21,
		},
	},
	[94] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA37880000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[36] = 5,
		[38] = 6,
		[40] = 7,
		[42] = 8,
		[44] = 9,
		[46] = 10,
		[48] = 11,
		[50] = 12,
		[52] = 13,
		[54] = 14,
		[86] = 15,
		[88] = 16,
		[90] = 17,
		[92] = 18,
		[94] = 19,
		[96] = 20,
		[98] = 21,
		[100] = 22,
		[102] = 23,
		},
	},
	[95] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA7E000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[56] = 5,
		[58] = 6,
		[60] = 7,
		[62] = 8,
		[64] = 9,
		[66] = 10,
		[68] = 11,
		[70] = 12,
		[104] = 13,
		[106] = 14,
		[108] = 15,
		[110] = 16,
		},
	},
	[96] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA37800000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[36] = 5,
		[38] = 6,
		[40] = 7,
		[42] = 8,
		[44] = 9,
		[46] = 10,
		[48] = 11,
		[50] = 12,
		[52] = 13,
		[54] = 14,
		[104] = 15,
		[106] = 16,
		[108] = 17,
		[110] = 18,
		},
	},
	[97] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4FC40000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[56] = 8,
		[58] = 9,
		[60] = 10,
		[62] = 11,
		[64] = 12,
		[66] = 13,
		[68] = 14,
		[70] = 15,
		[86] = 16,
		[88] = 17,
		[90] = 18,
		[92] = 19,
		[94] = 20,
		[96] = 21,
		[98] = 22,
		[100] = 23,
		[102] = 24,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[98] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46F10000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[36] = 8,
		[38] = 9,
		[40] = 10,
		[42] = 11,
		[44] = 12,
		[46] = 13,
		[48] = 14,
		[50] = 15,
		[52] = 16,
		[54] = 17,
		[86] = 18,
		[88] = 19,
		[90] = 20,
		[92] = 21,
		[94] = 22,
		[96] = 23,
		[98] = 24,
		[100] = 25,
		[102] = 26,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[99] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4FC00000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[56] = 8,
		[58] = 9,
		[60] = 10,
		[62] = 11,
		[64] = 12,
		[66] = 13,
		[68] = 14,
		[70] = 15,
		[104] = 16,
		[106] = 17,
		[108] = 18,
		[110] = 19,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[100] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46F00000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[36] = 8,
		[38] = 9,
		[40] = 10,
		[42] = 11,
		[44] = 12,
		[46] = 13,
		[48] = 14,
		[50] = 15,
		[52] = 16,
		[54] = 17,
		[104] = 18,
		[106] = 19,
		[108] = 20,
		[110] = 21,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[101] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4FC40000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[56] = 8,
		[58] = 9,
		[60] = 10,
		[62] = 11,
		[64] = 12,
		[66] = 13,
		[68] = 14,
		[70] = 15,
		[86] = 16,
		[88] = 17,
		[90] = 18,
		[92] = 19,
		[94] = 20,
		[96] = 21,
		[98] = 22,
		[100] = 23,
		[102] = 24,
		[113] = 5,
		[117] = 6,
		[121] = 7,
		},
	},
	[102] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46F10000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[36] = 8,
		[38] = 9,
		[40] = 10,
		[42] = 11,
		[44] = 12,
		[46] = 13,
		[48] = 14,
		[50] = 15,
		[52] = 16,
		[54] = 17,
		[86] = 18,
		[88] = 19,
		[90] = 20,
		[92] = 21,
		[94] = 22,
		[96] = 23,
		[98] = 24,
		[100] = 25,
		[102] = 26,
		[113] = 5,
		[117] = 6,
		[121] = 7,
		},
	},
	[103] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4FC00000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[56] = 8,
		[58] = 9,
		[60] = 10,
		[62] = 11,
		[64] = 12,
		[66] = 13,
		[68] = 14,
		[70] = 15,
		[104] = 16,
		[106] = 17,
		[108] = 18,
		[110] = 19,
		[113] = 5,
		[117] = 6,
		[121] = 7,
		},
	},
	[104] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46F00000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[36] = 8,
		[38] = 9,
		[40] = 10,
		[42] = 11,
		[44] = 12,
		[46] = 13,
		[48] = 14,
		[50] = 15,
		[52] = 16,
		[54] = 17,
		[104] = 18,
		[106] = 19,
		[108] = 20,
		[110] = 21,
		[113] = 5,
		[117] = 6,
		[121] = 7,
		},
	},
	[105] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA49F88000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[56] = 11,
		[58] = 12,
		[60] = 13,
		[62] = 14,
		[64] = 15,
		[66] = 16,
		[68] = 17,
		[70] = 18,
		[86] = 19,
		[88] = 20,
		[90] = 21,
		[92] = 22,
		[94] = 23,
		[96] = 24,
		[98] = 25,
		[100] = 26,
		[102] = 27,
		[112] = 5,
		[113] = 8,
		[116] = 6,
		[117] = 9,
		[120] = 7,
		[121] = 10,
		},
	},
	[106] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA48DE2000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[36] = 11,
		[38] = 12,
		[40] = 13,
		[42] = 14,
		[44] = 15,
		[46] = 16,
		[48] = 17,
		[50] = 18,
		[52] = 19,
		[54] = 20,
		[86] = 21,
		[88] = 22,
		[90] = 23,
		[92] = 24,
		[94] = 25,
		[96] = 26,
		[98] = 27,
		[100] = 28,
		[102] = 29,
		[112] = 5,
		[113] = 8,
		[116] = 6,
		[117] = 9,
		[120] = 7,
		[121] = 10,
		},
	},
	[107] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA49F80000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[56] = 11,
		[58] = 12,
		[60] = 13,
		[62] = 14,
		[64] = 15,
		[66] = 16,
		[68] = 17,
		[70] = 18,
		[104] = 19,
		[106] = 20,
		[108] = 21,
		[110] = 22,
		[112] = 5,
		[113] = 8,
		[116] = 6,
		[117] = 9,
		[120] = 7,
		[121] = 10,
		},
	},
	[108] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA48DE0000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[36] = 11,
		[38] = 12,
		[40] = 13,
		[42] = 14,
		[44] = 15,
		[46] = 16,
		[48] = 17,
		[50] = 18,
		[52] = 19,
		[54] = 20,
		[104] = 21,
		[106] = 22,
		[108] = 23,
		[110] = 24,
		[112] = 5,
		[113] = 8,
		[116] = 6,
		[117] = 9,
		[120] = 7,
		[121] = 10,
		},
	},
	[109] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00A170000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 21,
		[12] = 3,
		[13] = 22,
		[14] = 4,
		[15] = 23,
		[56] = 5,
		[58] = 6,
		[60] = 7,
		[62] = 8,
		[64] = 9,
		[66] = 10,
		[68] = 11,
		[70] = 12,
		[104] = 13,
		[106] = 14,
		[108] = 15,
		[110] = 16,
		[124] = 17,
		[125] = 18,
		[126] = 19,
		[127] = 20,
		},
	},
	[110] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00285C000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 23,
		[12] = 3,
		[13] = 24,
		[14] = 4,
		[15] = 25,
		[36] = 5,
		[38] = 6,
		[40] = 7,
		[42] = 8,
		[44] = 9,
		[46] = 10,
		[48] = 11,
		[50] = 12,
		[52] = 13,
		[54] = 14,
		[104] = 15,
		[106] = 16,
		[108] = 17,
		[110] = 18,
		[124] = 19,
		[125] = 20,
		[126] = 21,
		[127] = 22,
		},
	},
	[111] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00A170B00000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 21,
		[12] = 3,
		[13] = 22,
		[14] = 4,
		[15] = 23,
		[56] = 5,
		[57] = 24,
		[58] = 6,
		[59] = 25,
		[60] = 7,
		[61] = 26,
		[62] = 8,
		[63] = 27,
		[64] = 9,
		[65] = 28,
		[66] = 10,
		[67] = 29,
		[68] = 11,
		[69] = 30,
		[70] = 12,
		[71] = 31,
		[104] = 13,
		[106] = 14,
		[108] = 15,
		[110] = 16,
		[124] = 17,
		[125] = 18,
		[126] = 19,
		[127] = 20,
		},
	},
	[112] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00285C2C0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 23,
		[12] = 3,
		[13] = 24,
		[14] = 4,
		[15] = 25,
		[36] = 5,
		[38] = 6,
		[40] = 7,
		[42] = 8,
		[44] = 9,
		[46] = 10,
		[48] = 11,
		[50] = 12,
		[52] = 13,
		[54] = 14,
		[57] = 26,
		[59] = 27,
		[61] = 28,
		[63] = 29,
		[65] = 30,
		[67] = 31,
		[69] = 32,
		[71] = 33,
		[104] = 15,
		[106] = 16,
		[108] = 17,
		[110] = 18,
		[124] = 19,
		[125] = 20,
		[126] = 21,
		[127] = 22,
		},
	},
	[113] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00A1702C0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 21,
		[12] = 3,
		[13] = 22,
		[14] = 4,
		[15] = 23,
		[37] = 24,
		[39] = 25,
		[41] = 26,
		[43] = 27,
		[45] = 28,
		[47] = 29,
		[49] = 30,
		[51] = 31,
		[53] = 32,
		[55] = 33,
		[56] = 5,
		[58] = 6,
		[60] = 7,
		[62] = 8,
		[64] = 9,
		[66] = 10,
		[68] = 11,
		[70] = 12,
		[104] = 13,
		[106] = 14,
		[108] = 15,
		[110] = 16,
		[124] = 17,
		[125] = 18,
		[126] = 19,
		[127] = 20,
		},
	},
	[114] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00285C0B0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 23,
		[12] = 3,
		[13] = 24,
		[14] = 4,
		[15] = 25,
		[36] = 5,
		[37] = 26,
		[38] = 6,
		[39] = 27,
		[40] = 7,
		[41] = 28,
		[42] = 8,
		[43] = 29,
		[44] = 9,
		[45] = 30,
		[46] = 10,
		[47] = 31,
		[48] = 11,
		[49] = 32,
		[50] = 12,
		[51] = 33,
		[52] = 13,
		[53] = 34,
		[54] = 14,
		[55] = 35,
		[104] = 15,
		[106] = 16,
		[108] = 17,
		[110] = 18,
		[124] = 19,
		[125] = 20,
		[126] = 21,
		[127] = 22,
		},
	},
	[115] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00A17C000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 21,
		[12] = 3,
		[13] = 22,
		[14] = 4,
		[15] = 23,
		[56] = 5,
		[58] = 6,
		[60] = 7,
		[62] = 8,
		[64] = 9,
		[66] = 10,
		[68] = 11,
		[70] = 12,
		[87] = 24,
		[89] = 25,
		[91] = 26,
		[93] = 27,
		[95] = 28,
		[97] = 29,
		[99] = 30,
		[101] = 31,
		[103] = 32,
		[104] = 13,
		[106] = 14,
		[108] = 15,
		[110] = 16,
		[124] = 17,
		[125] = 18,
		[126] = 19,
		[127] = 20,
		},
	},
	[116] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00285F000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 23,
		[12] = 3,
		[13] = 24,
		[14] = 4,
		[15] = 25,
		[36] = 5,
		[38] = 6,
		[40] = 7,
		[42] = 8,
		[44] = 9,
		[46] = 10,
		[48] = 11,
		[50] = 12,
		[52] = 13,
		[54] = 14,
		[87] = 26,
		[89] = 27,
		[91] = 28,
		[93] = 29,
		[95] = 30,
		[97] = 31,
		[99] = 32,
		[101] = 33,
		[103] = 34,
		[104] = 15,
		[106] = 16,
		[108] = 17,
		[110] = 18,
		[124] = 19,
		[125] = 20,
		[126] = 21,
		[127] = 22,
		},
	},
	[117] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00A17C000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 21,
		[12] = 3,
		[13] = 22,
		[14] = 4,
		[15] = 23,
		[56] = 5,
		[58] = 6,
		[60] = 7,
		[62] = 8,
		[64] = 9,
		[66] = 10,
		[68] = 11,
		[70] = 12,
		[104] = 13,
		[105] = 24,
		[106] = 14,
		[107] = 25,
		[108] = 15,
		[109] = 26,
		[110] = 16,
		[111] = 27,
		[124] = 17,
		[125] = 18,
		[126] = 19,
		[127] = 20,
		},
	},
	[118] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00285F000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 23,
		[12] = 3,
		[13] = 24,
		[14] = 4,
		[15] = 25,
		[36] = 5,
		[38] = 6,
		[40] = 7,
		[42] = 8,
		[44] = 9,
		[46] = 10,
		[48] = 11,
		[50] = 12,
		[52] = 13,
		[54] = 14,
		[104] = 15,
		[105] = 26,
		[106] = 16,
		[107] = 27,
		[108] = 17,
		[109] = 28,
		[110] = 18,
		[111] = 29,
		[124] = 19,
		[125] = 20,
		[126] = 21,
		[127] = 22,
		},
	},
	[119] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00A170BC0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 21,
		[12] = 3,
		[13] = 22,
		[14] = 4,
		[15] = 23,
		[56] = 5,
		[57] = 24,
		[58] = 6,
		[59] = 25,
		[60] = 7,
		[61] = 26,
		[62] = 8,
		[63] = 27,
		[64] = 9,
		[65] = 28,
		[66] = 10,
		[67] = 29,
		[68] = 11,
		[69] = 30,
		[70] = 12,
		[71] = 31,
		[87] = 32,
		[89] = 33,
		[91] = 34,
		[93] = 35,
		[95] = 36,
		[97] = 37,
		[99] = 38,
		[101] = 39,
		[103] = 40,
		[104] = 13,
		[106] = 14,
		[108] = 15,
		[110] = 16,
		[124] = 17,
		[125] = 18,
		[126] = 19,
		[127] = 20,
		},
	},
	[120] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00285C2F0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 23,
		[12] = 3,
		[13] = 24,
		[14] = 4,
		[15] = 25,
		[36] = 5,
		[38] = 6,
		[40] = 7,
		[42] = 8,
		[44] = 9,
		[46] = 10,
		[48] = 11,
		[50] = 12,
		[52] = 13,
		[54] = 14,
		[57] = 26,
		[59] = 27,
		[61] = 28,
		[63] = 29,
		[65] = 30,
		[67] = 31,
		[69] = 32,
		[71] = 33,
		[87] = 34,
		[89] = 35,
		[91] = 36,
		[93] = 37,
		[95] = 38,
		[97] = 39,
		[99] = 40,
		[101] = 41,
		[103] = 42,
		[104] = 15,
		[106] = 16,
		[108] = 17,
		[110] = 18,
		[124] = 19,
		[125] = 20,
		[126] = 21,
		[127] = 22,
		},
	},
	[121] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00A1702F0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 21,
		[12] = 3,
		[13] = 22,
		[14] = 4,
		[15] = 23,
		[37] = 24,
		[39] = 25,
		[41] = 26,
		[43] = 27,
		[45] = 28,
		[47] = 29,
		[49] = 30,
		[51] = 31,
		[53] = 32,
		[55] = 33,
		[56] = 5,
		[58] = 6,
		[60] = 7,
		[62] = 8,
		[64] = 9,
		[66] = 10,
		[68] = 11,
		[70] = 12,
		[87] = 34,
		[89] = 35,
		[91] = 36,
		[93] = 37,
		[95] = 38,
		[97] = 39,
		[99] = 40,
		[101] = 41,
		[103] = 42,
		[104] = 13,
		[106] = 14,
		[108] = 15,
		[110] = 16,
		[124] = 17,
		[125] = 18,
		[126] = 19,
		[127] = 20,
		},
	},
	[122] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00285C0BC000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 23,
		[12] = 3,
		[13] = 24,
		[14] = 4,
		[15] = 25,
		[36] = 5,
		[37] = 26,
		[38] = 6,
		[39] = 27,
		[40] = 7,
		[41] = 28,
		[42] = 8,
		[43] = 29,
		[44] = 9,
		[45] = 30,
		[46] = 10,
		[47] = 31,
		[48] = 11,
		[49] = 32,
		[50] = 12,
		[51] = 33,
		[52] = 13,
		[53] = 34,
		[54] = 14,
		[55] = 35,
		[87] = 36,
		[89] = 37,
		[91] = 38,
		[93] = 39,
		[95] = 40,
		[97] = 41,
		[99] = 42,
		[101] = 43,
		[103] = 44,
		[104] = 15,
		[106] = 16,
		[108] = 17,
		[110] = 18,
		[124] = 19,
		[125] = 20,
		[126] = 21,
		[127] = 22,
		},
	},
	[123] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00A170BC0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 21,
		[12] = 3,
		[13] = 22,
		[14] = 4,
		[15] = 23,
		[56] = 5,
		[57] = 24,
		[58] = 6,
		[59] = 25,
		[60] = 7,
		[61] = 26,
		[62] = 8,
		[63] = 27,
		[64] = 9,
		[65] = 28,
		[66] = 10,
		[67] = 29,
		[68] = 11,
		[69] = 30,
		[70] = 12,
		[71] = 31,
		[104] = 13,
		[105] = 32,
		[106] = 14,
		[107] = 33,
		[108] = 15,
		[109] = 34,
		[110] = 16,
		[111] = 35,
		[124] = 17,
		[125] = 18,
		[126] = 19,
		[127] = 20,
		},
	},
	[124] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00285C2F0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 23,
		[12] = 3,
		[13] = 24,
		[14] = 4,
		[15] = 25,
		[36] = 5,
		[38] = 6,
		[40] = 7,
		[42] = 8,
		[44] = 9,
		[46] = 10,
		[48] = 11,
		[50] = 12,
		[52] = 13,
		[54] = 14,
		[57] = 26,
		[59] = 27,
		[61] = 28,
		[63] = 29,
		[65] = 30,
		[67] = 31,
		[69] = 32,
		[71] = 33,
		[104] = 15,
		[105] = 34,
		[106] = 16,
		[107] = 35,
		[108] = 17,
		[109] = 36,
		[110] = 18,
		[111] = 37,
		[124] = 19,
		[125] = 20,
		[126] = 21,
		[127] = 22,
		},
	},
	[125] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00A1702F0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 21,
		[12] = 3,
		[13] = 22,
		[14] = 4,
		[15] = 23,
		[37] = 24,
		[39] = 25,
		[41] = 26,
		[43] = 27,
		[45] = 28,
		[47] = 29,
		[49] = 30,
		[51] = 31,
		[53] = 32,
		[55] = 33,
		[56] = 5,
		[58] = 6,
		[60] = 7,
		[62] = 8,
		[64] = 9,
		[66] = 10,
		[68] = 11,
		[70] = 12,
		[104] = 13,
		[105] = 34,
		[106] = 14,
		[107] = 35,
		[108] = 15,
		[109] = 36,
		[110] = 16,
		[111] = 37,
		[124] = 17,
		[125] = 18,
		[126] = 19,
		[127] = 20,
		},
	},
	[126] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00285C0BC000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[11] = 23,
		[12] = 3,
		[13] = 24,
		[14] = 4,
		[15] = 25,
		[36] = 5,
		[37] = 26,
		[38] = 6,
		[39] = 27,
		[40] = 7,
		[41] = 28,
		[42] = 8,
		[43] = 29,
		[44] = 9,
		[45] = 30,
		[46] = 10,
		[47] = 31,
		[48] = 11,
		[49] = 32,
		[50] = 12,
		[51] = 33,
		[52] = 13,
		[53] = 34,
		[54] = 14,
		[55] = 35,
		[104] = 15,
		[105] = 36,
		[106] = 16,
		[107] = 37,
		[108] = 17,
		[109] = 38,
		[110] = 18,
		[111] = 39,
		[124] = 19,
		[125] = 20,
		[126] = 21,
		[127] = 22,
		},
	},
	[127] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_GENEVE |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB002800000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 2,
	.field_list = {
		[1] = 1,
		[10] = 2,
		[12] = 3,
		[14] = 4,
		[36] = 5,
		[38] = 6,
		[40] = 7,
		[42] = 8,
		[44] = 9,
		[46] = 10,
		[48] = 11,
		[50] = 12,
		[52] = 13,
		[54] = 14,
		[104] = 15,
		[106] = 16,
		[108] = 17,
		[110] = 18,
		},
	},
	[128] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_SVIF |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0x8000000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 3,
	.field_list = {
		[1] = 1,
		},
	}
};

