#ifndef BNXT_USR_REQ_H
#define BNXT_USR_REQ_H

/* To prevent mismatch between bnxtnvm user application and bnxt_mg
 * keeping the max. size as 512.
 */
#define MAX_DMA_MEM_SIZE			0x400000
#define DFLT_HWRM_CMD_TIMEOUT			12000
#define HWRM_RESET_TIMEOUT          ((DFLT_HWRM_CMD_TIMEOUT) * 4)
#define HWRM_PORT_DSC_DUMP_TIMEOUT  (180000)
#define HWRM_NVM_DEFRAG_TIMEOUT  (150000)
#define HWRM_SELFTEST_RETRIEVE_SERDES_DATA_TIMEOUT  (45000)
#define HWRM_NVM_INSTALL_UPDATE_TIMEOUT  (150000)
#define HWRM_FPGA_TIMEOUT (2400000)
#define HWRM_RECOVERY_TIMEOUT (3000)
#define HWRM_MAX_UNHEALTHY_TIMEOUT (40000)

#define HWRM_SHORT_TIMEOUT_COUNTER	5

#define HWRM_SHORT_MIN_TIMEOUT		3
#define HWRM_SHORT_MAX_TIMEOUT		10

#define HWRM_MIN_TIMEOUT		25
#define HWRM_MAX_TIMEOUT		40
#define HWRM_VALID_BIT_DELAY_USEC (150)

#define MAX_NUM_DMA_INDICATIONS			10

struct mg_dma_info {
	__u64 data;
	/* Based on read_or_write parameter
	 * driver will either fill or read the
	 * data to or from the user memory
	 */
	__u32 length;
	/* Length of the data for read/write */
	__u16 offset;
	/* Offset at which HWRM input structure needs DMA address*/
	__u8 read_or_write;
	/* It should be 0 for write and 1 for read */
	__u8 unused;
};

struct mg_fw_msg {
	__u64 usr_req;
	/* HWRM input structure */
	__u64 usr_resp;
	/* HWRM output structure */
	__u32 len_req;
	/* HWRM input structure length*/
	__u32 len_resp;
	/* HWRM output structure length*/
	__u32 timeout;
	/* HWRM Short Command */
	unsigned is_short_cmd;
	/* HWRM command timeout. If 0 then
	 * MG will provide default timeout
	 */
	__u32 num_dma_indications;
	/* Number of DMA addresses used in HWRM command */
	struct mg_dma_info *dma;
	/* User should allocate it with
	 * (sizeof(struct mg_dma_info) * num_dma_indications)
	 */
};

enum bnxt_mg_req_type {
	/*
	 * TBD: This enum need to be removed
	 */
	BNXT_NVM_GET_VAR_REQ = 1,
};

struct bnxt_mg_req_hdr {
	uint32_t ver;
	uint32_t seg;
	uint32_t bus;
	uint32_t devfn;
	uint32_t driverIndex;
	//enum bnxt_mg_req_type req_type;
};

struct bnxt_mg_req {
	struct bnxt_mg_req_hdr hdr;
	union {
		__u64 hreq; /* Pointer to "struct mg_fw_msg" */
	} req;
};

#define CHIP_NUM_57301		0x16c8
#define CHIP_NUM_57302		0x16c9
#define CHIP_NUM_57304		0x16ca
#define CHIP_NUM_58700		0x16cd
#define CHIP_NUM_57402		0x16d0
#define CHIP_NUM_57404		0x16d1
#define CHIP_NUM_57406		0x16d2
#define CHIP_NUM_57407		0x16d5

#define CHIP_NUM_57311		0x16ce
#define CHIP_NUM_57312		0x16cf
#define CHIP_NUM_57314		0x16df
#define CHIP_NUM_57317		0x16e0
#define CHIP_NUM_57412		0x16d6
#define CHIP_NUM_57414		0x16d7
#define CHIP_NUM_57416		0x16d8
#define CHIP_NUM_57417		0x16d9
#define CHIP_NUM_57412L		0x16da
#define CHIP_NUM_57414L		0x16db

#define CHIP_NUM_5745X		0xd730
#define CHIP_NUM_57452		0xc452
#define CHIP_NUM_57454		0xc454

#define CHIP_NUM_57508		0x1750
#define CHIP_NUM_57504		0x1751
#define CHIP_NUM_57502		0x1752

#define CHIP_NUM_57608		0x1760

#define CHIP_NUM_58802		0xd802
#define CHIP_NUM_58804		0xd804
#define CHIP_NUM_58808		0xd808

#define CHIP_NUM_58818		0xd818

#define BNXT_CHIP_NUM_5730X(chip_num)		\
	((chip_num) >= CHIP_NUM_57301 &&	\
	 (chip_num) <= CHIP_NUM_57304)

#define BNXT_CHIP_NUM_5740X(chip_num)		\
	(((chip_num) >= CHIP_NUM_57402 &&	\
	  (chip_num) <= CHIP_NUM_57406) ||	\
	 (chip_num) == CHIP_NUM_57407)

#define BNXT_CHIP_NUM_5731X(chip_num)		\
	((chip_num) == CHIP_NUM_57311 ||	\
	 (chip_num) == CHIP_NUM_57312 ||	\
	 (chip_num) == CHIP_NUM_57314 ||	\
	 (chip_num) == CHIP_NUM_57317)

#define BNXT_CHIP_NUM_5741X(chip_num)		\
	((chip_num) >= CHIP_NUM_57412 &&	\
	 (chip_num) <= CHIP_NUM_57414L)

#define BNXT_CHIP_NUM_58700(chip_num)		\
	 ((chip_num) == CHIP_NUM_58700)

#define BNXT_CHIP_NUM_5745X(chip_num)		\
	((chip_num) == CHIP_NUM_5745X ||	\
	 (chip_num) == CHIP_NUM_57452 ||	\
	 (chip_num) == CHIP_NUM_57454)


#define BNXT_CHIP_NUM_57X0X(chip_num)		\
	(BNXT_CHIP_NUM_5730X(chip_num) || BNXT_CHIP_NUM_5740X(chip_num))

#define BNXT_CHIP_NUM_57X1X(chip_num)		\
	(BNXT_CHIP_NUM_5731X(chip_num) || BNXT_CHIP_NUM_5741X(chip_num))

#define BNXT_CHIP_NUM_588XX(chip_num)		\
	((chip_num) == CHIP_NUM_58802 ||	\
	 (chip_num) == CHIP_NUM_58804 ||        \
	 (chip_num) == CHIP_NUM_58808)

#define	BNXT_USR_IOCTL_MAGIC	0x98
#define	IOCTL_CMD_BNXT_HWRM_REQ	_IOW(BNXT_USR_IOCTL_MAGIC, 1, struct bnxt_mg_req)
#endif
