echo -off

if %1 == "" then
   echo **************************************************************************
   echo *
   echo *  Usage:
   echo *         flash.nsh romfile
   echo *
   echo **************************************************************************
endif

if not exist %1 then 
   echo **************************************************************************
   echo *
   echo *  %1 doesn't exist and please double check.
   echo *
   echo **************************************************************************
endif

if exist fdt.smc then 
   cp -q fdt.smc fdtx64.efi
   rm -q fdt.smc
endif

if exist afuefi.smc then 
   cp -q afuefi.smc afuefix64.efi
   rm -q afuefi.smc
endif

###Read CMOS50 value
fdtx64.efi -r 50

if %lasterror% == 5A then 
   if not %lasterror% == 5B then 
      goto FDT_Different
   endif
endif

echo **************************************************************************
echo *
echo *  Compare Flash Descriptor Table(FDT). Please wait...
echo *
echo **************************************************************************

# echo afuefix64.efi %1 /ME
fdtx64.efi -w 50 A5
afuefix64.efi %1 /ME
fdtx64.efi -r 50

if %lasterror% == A5 then 
   if not %lasterror% == A6 then 
      echo flash BIOS
      goto Flash_BIOS
   endif
endif

if %lasterror% == 5A then 
   if not %lasterror% == 5B then 
      echo FDT different
      goto FDT_Different
   endif
endif

:Flash_BIOS
echo **************************************************************************
echo *
echo *  FDT is same. Program BIOS and ME (excluding FDT) regions...
echo *
echo **************************************************************************

# echo afuefix64.efi %1 /P /B /N /K /R /L0
fdtx64.efi -w 50 A5
afuefix64.efi %1 /P /B /N /K /R /L0 /ME
fdtx64.efi -w 50 00
fdtx64.efi -c
goto END

:FDT_Different
fdtx64.efi -r 51

if %lasterror% == 18 then 
   if not %lasterror% == 19 then 
      goto Update_BIOS_ME
   endif
endif

if %lasterror% == 0 then 
   if not %lasterror% == 1 then 
      goto Modify_Autoexec
   endif
endif

# echo CMOS51 doesn't equal 00h or 18h !
# echo ManufacturingMode is Disabled.
echo **************************************************************************
echo *
echo *  Current BIOS or hardware does not support software controllable
echo *  ME Manufactuing mode.
echo *
echo **************************************************************************

# copy original Startup.nsh back
if exist \a.nsh then 
   echo **************************************************************************
   echo *
   echo *  Please ignore this "'Shell: Cannot read from file - Device Error'" 
   echo *  warning message due to it does not impact flashing process.
   echo *
   echo **************************************************************************
   cp -q \a.nsh \Startup.nsh
   rm -q \a.nsh
endif
goto END

:Modify_Autoexec
echo **************************************************************************
echo *
echo *  FDT is different. Creating new Startup.nsh file...
echo *
echo **************************************************************************

fdtx64.efi -mauto %1

:Reboot_System
echo **************************************************************************
echo *
echo *   System will reboot to change the operating mode in 10 seconds....
echo *   
echo *   Please also ensure to boot system from "'UEFI: Built-in EFI Shell'"  
echo *   boot device by pressing F11 hot key later for continuing process 
echo *   of programming BIOS.
echo *
echo **************************************************************************

#choice /C:Y /T:Y,10
echo 
Stall 10000000
fdtx64.efi -reset

:Update_BIOS_ME
echo **************************************************************************
echo *
echo *  Program BIOS and ME (including FDT) regions...
echo *
echo **************************************************************************

# copy original Startup.nsh back
if exist \a.nsh then 
   echo **************************************************************************
   echo *
   echo *  Please ignore this "'Shell: Cannot read from file - Device Error'" 
   echo *  warning message due to it does not impact flashing process.
   echo *
   echo **************************************************************************
   cp -q \a.nsh \Startup.nsh
   rm -q \a.nsh
endif

# echo afuefix64.efi %1 /P /B /N /K /R /L0 /ME
fdtx64.efi -w 50 A5
afuefix64.efi %1 /P /B /N /K /R /L0 /ME
fdtx64.efi -c

:END