#!/bin/bash

defusername=admin
defpassword=admin
imagepath=Image/
yafuflashpath=Linux/Yafuflash
checksumpath=Linux/checksum/FW_SUM.sh

echo "===================================================="
echo "=            BMC firmware update tool              ="
echo "===================================================="
check_ipaddr()
{
    echo $1|grep "^[0-9]\{1,3\}\.\([0-9]\{1,3\}\.\)\{2\}[0-9]\{1,3\}$" > /dev/null;
    if [ $? -ne 0 ]
    then
        echo "\"IP\" are numbers" 
        return 1
    fi
    ipaddr=$1
    a=`echo $ipaddr|awk -F . '{print $1}'`
    b=`echo $ipaddr|awk -F . '{print $2}'`
    c=`echo $ipaddr|awk -F . '{print $3}'`
    d=`echo $ipaddr|awk -F . '{print $4}'`
    for num in $a $b $c $d
    do
        if [ $num -gt 255 ] || [ $num -lt 0 ]
        then
            echo $ipaddr " the "$num" is illegal" 
            return 1
        fi
   done
   echo $ipaddr ". . . legitimate"
   return 0
}

imageFile=$(find $imagepath -type f -name "*.ima")

image=$(echo $imageFile | cut -d' ' -f 1);

echo "Image file name: $image";

if [ $# -lt 1 ];then 
        echo "Usage: $0 [ipaddress]" 
        exit
else
	if [ $1 == "-cd" ];then 
		sudo chmod 755 Linux/Yafuflash
		sudo $yafuflashpath -cd $image
		exit
	else
		if [ $1 == "-local" ];then 
			if [ $# -ge 2 ];then 
				username=$2
			else
				username=$defusername
			fi

			if [ $# -ge 3 ];then 
				password=$3
			else
				password=$defpassword
			fi
			sudo chmod 755 Linux/Yafuflash
			if [ $# -ge 4 ];then 
				if [ $4 == "-preserve" ];then 
					sudo $yafuflashpath -nw -ip 169.254.0.17 -U $username -P $password $image -preserve-config
				elif [ $4 == "-preserve-config" ];then
					sudo $yafuflashpath -nw -ip 169.254.0.17 -U $username -P $password $image -preserve-config
				elif [ $4 == "-p" ];then
					sudo $yafuflashpath -nw -ip 169.254.0.17 -U $username -P $password $image -preserve-config
				elif [ $4 == "-f" ];then
					sudo $yafuflashpath -nw -ip 169.254.0.17 -U $username -P $password $image -force-boot
				elif [ $4 == "-force" ];then
					sudo $yafuflashpath -nw -ip 169.254.0.17 -U $username -P $password $image -force-boot
				elif [ $4 == "-force-boot" ];then
					sudo $yafuflashpath -nw -ip 169.254.0.17 -U $username -P $password $image -force-boot
				else
					echo "Not support function : $4"
				fi
			else
				sudo $yafuflashpath -nw -ip 169.254.0.17 -U $username -P $password $image
			fi
			exit
		else
			check_ipaddr $1
		fi
	fi
fi


if [ $# -ge 2 ];then 
        username=$2
else
	username=$defusername
fi

if [ $# -ge 3 ];then 
        password=$3
else
	password=$defpassword
fi


sudo chmod 755 Linux/Yafuflash
if [ $# -ge 4 ];then 
	if [ $4 == "-preserve" ];then 
		sudo $yafuflashpath -nw -ip $1 -U $username -P $password $image -preserve-config
	elif [ $4 == "-preserve-config" ];then
		sudo $yafuflashpath -nw -ip $1 -U $username -P $password $image -preserve-config
	elif [ $4 == "-p" ];then
		sudo $yafuflashpath -nw -ip $1 -U $username -P $password $image -preserve-config
	elif [ $4 == "-f" ];then
		sudo $yafuflashpath -nw -ip $1 -U $username -P $password $image -force-boot
	elif [ $4 == "-force" ];then
		sudo $yafuflashpath -nw -ip $1 -U $username -P $password $image -force-boot
	elif [ $4 == "-force-boot" ];then
		sudo $yafuflashpath -nw -ip $1 -U $username -P $password $image -force-boot
	else
		echo "Not support function : $4"
	fi
else
	sudo $yafuflashpath -nw -ip $1 -U $username -P $password $image
fi



